/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls.comm;

import com.tridium.basicdriver.comm.CommReceiver;
import com.tridium.basicdriver.message.Message;
import com.tridium.basicdriver.message.ReceivedMessage;
import com.tridium.tls.comm.TlsTcpIpComm;
import com.tridium.tls.consoles.BTlsTcpIpConsole;
import com.tridium.tls.messages.TlsReceivedMessage;
import java.io.IOException;
import java.net.SocketException;
import javax.baja.io.ByteBuffer;
import javax.baja.util.ByteArrayUtil;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public class TlsTcpIpCommReceiver
extends CommReceiver {
    private static final int WAIT_FOR_START = 0;
    private static final int READ_FIRST_CHAR = 1;
    private static final int READ_UNTIL_APMERSAND1 = 2;
    private static final int READ_UNTIL_APMERSAND2 = 3;
    private static final int READ_CKSUM1 = 4;
    private static final int READ_CKSUM2 = 5;
    private static final int READ_CKSUM3 = 6;
    private static final int READ_CKSUM4 = 7;
    private static final int READ_ETX = 9;
    protected ByteBuffer rcv;
    protected int state;

    public void initReceiveState(byte[] byArray) {
        this.initRxState();
    }

    public void initReceiveState(Message message) {
        this.initRxState();
    }

    public void initRxState() {
        this.setDriverState(0);
    }

    public void setDriverState(int n) {
        this.state = n;
    }

    public int getDriverState() {
        return this.state;
    }

    protected ReceivedMessage receive() throws Exception {
        TlsTcpIpComm tlsTcpIpComm = (TlsTcpIpComm)this.getComm();
        if (tlsTcpIpComm == null) {
            return null;
        }
        BTlsTcpIpConsole bTlsTcpIpConsole = (BTlsTcpIpConsole)tlsTcpIpComm.getNetwork();
        if (bTlsTcpIpConsole == null) {
            return null;
        }
        if (this.getInputStream() == null) {
            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- inputStream==null");
            try {
                Thread.sleep(5000L);
            }
            catch (Exception exception) {}
            return null;
        }
        boolean bl = false;
        this.rcv.reset();
        block18: while (!bl) {
            boolean bl2 = false;
            try {
                int n = this.getInputStream().read();
                boolean bl3 = false;
                if (n != -1) {
                    bl3 = true;
                }
                bl2 = bl3;
                byte by = (byte)(n & 0xFF);
                if (bl2) {
                    int n2 = n & 0xFF;
                    bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- charValue=" + Integer.toHexString(n2) + " state=" + this.state);
                    switch (this.state) {
                        case 0: {
                            if (n2 != 1) continue block18;
                            this.state = 1;
                            this.rcv.reset();
                            this.rcv.write(n2);
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- detected start character, charValue=" + Integer.toHexString(n2));
                            break;
                        }
                        case 1: {
                            this.state = Character.isLowerCase((char)n2) ? 2 : 9;
                            this.rcv.write(n2);
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- reading first byte of message data, charValue=" + Integer.toHexString(n2));
                            break;
                        }
                        case 2: {
                            if (n2 == 38) {
                                this.state = 3;
                            }
                            this.rcv.write(n2);
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- reading nth byte of message data, charValue=" + Integer.toHexString(n2));
                            break;
                        }
                        case 3: {
                            this.state = n2 == 38 ? 4 : 2;
                            this.rcv.write(n2);
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "reading 2nd ampersand, charValue=" + Integer.toHexString(n2));
                            break;
                        }
                        case 4: {
                            this.rcv.write(n2);
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- reading cs1 ampersand, charValue=" + Integer.toHexString(n2));
                            this.state = 5;
                            break;
                        }
                        case 5: {
                            this.rcv.write(n2);
                            this.state = 6;
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- reading cs2 ampersand, charValue=" + Integer.toHexString(n2));
                            break;
                        }
                        case 6: {
                            this.rcv.write(n2);
                            this.state = 7;
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- reading cs3 ampersand, charValue=" + Integer.toHexString(n2));
                            break;
                        }
                        case 7: {
                            this.rcv.write(n2);
                            this.state = 9;
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- reading cs4 ampersand, charValue=" + Integer.toHexString(n2));
                            break;
                        }
                        case 9: {
                            if (n2 == 3) {
                                this.rcv.write(n2);
                                bl = true;
                                bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- finished read from rcvLength=" + this.rcv.getLength());
                                break;
                            }
                            bl = true;
                            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- response received without ETX char... lastChar=" + n2 + " rcvLength=" + this.rcv.getLength());
                            break;
                        }
                    }
                    continue;
                }
                bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- sleep");
                try {
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {}
            }
            catch (SocketException socketException) {
                bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- SOCKET connection lost !!!!!!");
                return null;
            }
            catch (IOException iOException) {
                bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)- ........Received IOException.............");
                return null;
            }
        }
        if (this.rcv.getLength() <= 0) {
            return null;
        }
        byte[] byArray = this.rcv.toByteArray();
        if (bTlsTcpIpConsole.getLog().isTraceOn() && bTlsTcpIpConsole.getUserData().indexOf("comm") != -1) {
            bTlsTcpIpConsole.getLog().trace(bTlsTcpIpConsole.getName() + "(TlsTcpIpCommReceiver)-  read entire ba=" + ByteArrayUtil.toHexString((byte[])byArray, (int)0, (int)byArray.length));
        }
        TlsReceivedMessage tlsReceivedMessage = new TlsReceivedMessage(byArray);
        return tlsReceivedMessage;
    }

    private final /* synthetic */ void this() {
        this.rcv = new ByteBuffer();
        this.state = 0;
    }

    public TlsTcpIpCommReceiver() {
        this.this();
    }
}

