/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.tls;

import com.tridium.basicdriver.BBasicNetwork;
import com.tridium.csmgrbase.datatypes.BCsReqCmd;
import com.tridium.csmgrbase.datatypes.BCsRspValue;
import com.tridium.fox.sys.BFoxClientConnection;
import com.tridium.nd.BNiagaraNetwork;
import com.tridium.nd.BNiagaraStation;
import com.tridium.nd.point.BNiagaraProxyExt;
import com.tridium.tls.BTlsDevice;
import com.tridium.tls.BTlsDeviceFolder;
import com.tridium.tls.datatypes.BBirAdjustedDeliveryTable;
import com.tridium.tls.datatypes.BFuelDataUpdateParams;
import com.tridium.tls.datatypes.BInTankInventoryTable;
import com.tridium.tls.datatypes.BInTankStatusTable;
import com.tridium.tls.datatypes.BPriorityAlarmHistoryTable;
import com.tridium.tls.messages.TlsMessageConst;
import javax.baja.control.BControlPoint;
import javax.baja.control.BPointExtension;
import javax.baja.license.Feature;
import javax.baja.sys.Action;
import javax.baja.sys.BAction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.IFuture;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class BTlsConsole
extends BBasicNetwork
implements TlsMessageConst {
    public static final Property stationNameWebSupervisor = BTlsConsole.newProperty((int)64, (String)"", null);
    public static final Property lastCsMgrCommFailureCause = BTlsConsole.newProperty((int)1, (String)"", null);
    public static final Property staleDataTime = BTlsConsole.newProperty((int)0, (BValue)BRelTime.makeHours((int)24), null);
    public static final Property userData = BTlsConsole.newProperty((int)0, (String)"", null);
    public static final Type TYPE;
    BFoxClientConnection.Interest tlsInterest;
    private BNiagaraNetwork nn;
    private BNiagaraStation ns;
    static /* synthetic */ Class class$com$tridium$tls$BTlsConsole;

    public String getStationNameWebSupervisor() {
        return this.getString(stationNameWebSupervisor);
    }

    public void setStationNameWebSupervisor(String string) {
        this.setString(stationNameWebSupervisor, string, null);
    }

    public String getLastCsMgrCommFailureCause() {
        return this.getString(lastCsMgrCommFailureCause);
    }

    public void setLastCsMgrCommFailureCause(String string) {
        this.setString(lastCsMgrCommFailureCause, string, null);
    }

    public BRelTime getStaleDataTime() {
        return (BRelTime)this.get(staleDataTime);
    }

    public void setStaleDataTime(BRelTime bRelTime) {
        this.set(staleDataTime, (BValue)bRelTime, null);
    }

    public String getUserData() {
        return this.getString(userData);
    }

    public void setUserData(String string) {
        this.setString(userData, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public final Feature getLicenseFeature() {
        return Sys.getLicenseManager().getFeature("tridium", "tls");
    }

    public IFuture post(Action action, BValue bValue, Context context) {
        return super.post(action, bValue, context);
    }

    public void started() throws Exception {
        super.started();
    }

    public void stopped() throws Exception {
        super.stopped();
    }

    public Type getDeviceType() {
        return BTlsDevice.TYPE;
    }

    public Type getDeviceFolderType() {
        return BTlsDeviceFolder.TYPE;
    }

    public boolean isParentLegal(BComponent bComponent) {
        return super.isParentLegal(bComponent);
    }

    public boolean isChildLegal(BComponent bComponent) {
        return super.isParentLegal(bComponent);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BCsRspValue sendFuelDataUpdate(BFuelDataUpdateParams bFuelDataUpdateParams) {
        BFuelDataUpdateParams bFuelDataUpdateParams2 = (BFuelDataUpdateParams)bFuelDataUpdateParams.newCopy();
        BCsRspValue bCsRspValue = new BCsRspValue();
        String string = this.getStationNameWebSupervisor();
        if (string != null && string.length() > 0) {
            BFoxClientConnection bFoxClientConnection;
            block31: {
                BCsRspValue bCsRspValue2;
                block32: {
                    BCsRspValue bCsRspValue3;
                    block30: {
                        if (!this.getNiagaraStation(string)) {
                            if (!this.getLog().isTraceOn()) return bCsRspValue;
                            if (this.getUserData().indexOf("action") == -1) return bCsRspValue;
                            this.getLog().trace("TlsConsole sendFuelDataUpdate... Web Supervisor NiagaraStation not configured");
                            return bCsRspValue;
                        }
                        BControlPoint bControlPoint = this.getControlPointWithNiagaraProxyExtWithPointId("CsMgrNetwork/fuelCentral");
                        if (bControlPoint == null) {
                            if (!this.getLog().isTraceOn()) return bCsRspValue;
                            if (this.getUserData().indexOf("action") == -1) return bCsRspValue;
                            this.getLog().trace("TlsConsole sendFuelDataUpdate... NiagaraStation point not configured");
                            return bCsRspValue;
                        }
                        bControlPoint = (BControlPoint)bControlPoint.loadSlots();
                        bFoxClientConnection = new BFoxClientConnection();
                        try {
                            try {
                                BCsReqCmd bCsReqCmd = new BCsReqCmd();
                                bCsReqCmd.setReqComp((BComponent)bFuelDataUpdateParams2);
                                if (bFuelDataUpdateParams.getUpdateList().getType() == BPriorityAlarmHistoryTable.TYPE) {
                                    bCsReqCmd.setReqCode("PRI_ALM_HIS_STATUS");
                                } else if (bFuelDataUpdateParams.getUpdateList().getType() == BBirAdjustedDeliveryTable.TYPE) {
                                    bCsReqCmd.setReqCode("BIR_ADJ_DEL_STATUS");
                                } else if (bFuelDataUpdateParams.getUpdateList().getType() == BInTankInventoryTable.TYPE) {
                                    bCsReqCmd.setReqCode("IN_TANK_INV_STATUS");
                                } else {
                                    if (bFuelDataUpdateParams.getUpdateList().getType() != BInTankStatusTable.TYPE) {
                                        String string2 = "data type match for " + bFuelDataUpdateParams2.getType() + " not found... cannot process update";
                                        if (this.getLog().isTraceOn()) {
                                            this.getLog().trace("TlsConsole sendFuelDataUpdate... " + string2);
                                        }
                                        bCsRspValue3 = new BCsRspValue("NOT_OK_DATA_ERROR", string2);
                                        Object var8_13 = null;
                                        break block30;
                                    }
                                    bCsReqCmd.setReqCode("IN_TANK_STA_STATUS");
                                }
                                bFoxClientConnection = this.makeRemoteStationConnection();
                                Slot slot = bControlPoint.getSlot("submitTlsReqCmd");
                                int n = 0;
                                while (true) {
                                    if (slot != null) {
                                        BAction bAction = (BAction)bControlPoint.get("submitTlsReqCmd");
                                        if (this.getLog().isTraceOn() && this.getUserData().indexOf("action") != -1) {
                                            this.getLog().trace("TlsConsole sendFuelDataUpdate... cpt=" + bControlPoint);
                                            this.getLog().trace("TlsConsole sendFuelDataUpdate... cmd=" + bCsReqCmd);
                                            this.getLog().trace("TlsConsole sendFuelDataUpdate... pnAction=" + bAction);
                                        }
                                        bCsRspValue = (BCsRspValue)bAction.invoke((BComponent)bControlPoint, (BValue)bCsReqCmd);
                                        if (this.getLog().isTraceOn() && this.getUserData().indexOf("action") != -1) {
                                            this.getLog().trace("TlsConsole sendFuelDataUpdate... status update sent to WS... rv=" + bCsRspValue.getRspCode());
                                        }
                                        if (!bCsRspValue.getRspCode().equals("OK")) break;
                                        this.setLastCsMgrCommFailureCause("");
                                        break block31;
                                    }
                                    try {
                                        Thread.sleep(10000L);
                                    }
                                    catch (InterruptedException interruptedException) {}
                                    if (++n > 5) {
                                        String string3 = " abort action...  ProxyPoint " + bControlPoint.getName() + " submitTlsReqCmd slot ==null";
                                        this.setLastCsMgrCommFailureCause(string3);
                                        if (this.getLog().isTraceOn() && this.getUserData().indexOf("action") != -1) {
                                            this.getLog().trace("TlsConsole sendFuelDataUpdate... " + string3);
                                        }
                                        bCsRspValue2 = bCsRspValue;
                                        break block32;
                                    }
                                    slot = bControlPoint.getSlot("submitTlsReqCmd");
                                    if (!this.getLog().isTraceOn() || this.getUserData().indexOf("action") == -1) continue;
                                    this.getLog().trace("TlsConsole sendFuelDataUpdate... slrc=" + n);
                                }
                                String string4 = bCsRspValue.getSimpleResponseData();
                                this.setLastCsMgrCommFailureCause(string4);
                                if (this.getLog().isTraceOn() && this.getUserData().indexOf("action") != -1) {
                                    this.getLog().trace("!cc! " + this.getName() + " sendOvenRecipesDlStatusUpdate response from CsMgr=" + string4);
                                }
                                break block31;
                            }
                            catch (Exception exception) {
                                this.getLog().error("e=" + exception);
                                exception.printStackTrace();
                            }
                            break block31;
                        }
                        catch (Throwable throwable) {
                            Object var8_15 = null;
                            try {
                                this.endRemoteStationConnection(bFoxClientConnection);
                                throw throwable;
                            }
                            catch (Exception exception) {}
                            throw throwable;
                        }
                    }
                    try {}
                    catch (Exception exception) {}
                    this.endRemoteStationConnection(bFoxClientConnection);
                    return bCsRspValue3;
                }
                Object var8_14 = null;
                try {}
                catch (Exception exception) {}
                this.endRemoteStationConnection(bFoxClientConnection);
                return bCsRspValue2;
            }
            Object var8_16 = null;
            try {}
            catch (Exception exception) {
                return bCsRspValue;
            }
            this.endRemoteStationConnection(bFoxClientConnection);
            return bCsRspValue;
        }
        if (!this.getLog().isTraceOn()) return bCsRspValue;
        if (this.getUserData().indexOf("action") == -1) return bCsRspValue;
        this.getLog().trace("TlsConsole sendFuelDataUpdate... Web Supervisor Station Name property not configured");
        return bCsRspValue;
    }

    private final BControlPoint getControlPointWithNiagaraProxyExtWithPointId(String string) {
        BControlPoint[] bControlPointArray;
        if (this.getNiagaraStation(this.getStationNameWebSupervisor()) && (bControlPointArray = this.ns.getPoints().getPoints()) != null && bControlPointArray.length > 0) {
            int n = 0;
            while (n < bControlPointArray.length) {
                BPointExtension[] bPointExtensionArray = bControlPointArray[n].getExtensions();
                if (bPointExtensionArray != null && bPointExtensionArray.length > 0) {
                    int n2 = 0;
                    while (n2 < bPointExtensionArray.length) {
                        BNiagaraProxyExt bNiagaraProxyExt;
                        if (bPointExtensionArray[n2] instanceof BNiagaraProxyExt && (bNiagaraProxyExt = (BNiagaraProxyExt)bPointExtensionArray[n2]).getPointId().endsWith(string)) {
                            bNiagaraProxyExt.forceUpdate();
                            return bControlPointArray[n];
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return null;
    }

    public BNiagaraNetwork getNiagaraNetwork() {
        if (this.nn == null) {
            this.nn = (BNiagaraNetwork)Sys.getService((Type)BNiagaraNetwork.TYPE);
        }
        return this.nn;
    }

    public boolean getNiagaraStation(String string) {
        if (this.ns == null) {
            this.ns = (BNiagaraStation)this.getNiagaraNetwork().getStation(string);
            if (this.ns == null) {
                if (this.getLog().isTraceOn()) {
                    this.getLog().trace("getNiagaraStation for <" + this + "> not found for stationName=" + string);
                }
                return false;
            }
            if (this.getLog().isTraceOn()) {
                this.getLog().trace("getNiagaraStation for <" + this + "> ns=" + this.ns);
            }
            return true;
        }
        return true;
    }

    private final BFoxClientConnection makeRemoteStationConnection() throws Exception {
        if (this.getLog().isTraceOn()) {
            this.getLog().trace("makeRemoteStationConnection for <" + this + "> find stationName=" + this.getStationNameWebSupervisor());
        }
        BFoxClientConnection bFoxClientConnection = new BFoxClientConnection();
        if (this.getNiagaraNetwork() != null) {
            if (this.getNiagaraStation(this.getStationNameWebSupervisor())) {
                bFoxClientConnection = this.ns.getClientConnection();
                try {
                    bFoxClientConnection.engageNoRetry(this.tlsInterest, 60000L);
                    return bFoxClientConnection;
                }
                catch (Exception exception) {
                    this.getLog().error("makeRemoteStationConnection for <" + this + "> ns=" + this.ns.getName() + " attempt engage connection failed... Exception e=" + exception);
                    this.getLog().error("makeRemoteStationConnection for <" + this + "> ns=" + this.ns.getName() + " attempt engage connection failed... abort operation");
                }
            }
        } else if (this.getLog().isTraceOn()) {
            this.getLog().trace("makeRemoteStationConnection for <" + this + "> nn==null... abort operation");
        }
        return null;
    }

    private final void endRemoteStationConnection(BFoxClientConnection bFoxClientConnection) throws Exception {
        bFoxClientConnection.disengage(this.tlsInterest);
    }

    static /* synthetic */ Class class(String string, boolean bl) {
        try {
            Class<?> clazz = Class.forName(string);
            if (!bl) {
                clazz = clazz.getComponentType();
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private final /* synthetic */ void this() {
        this.tlsInterest = new TlsInterest();
    }

    public BTlsConsole() {
        this.this();
    }

    static {
        Class clazz = class$com$tridium$tls$BTlsConsole;
        if (clazz == null) {
            clazz = class$com$tridium$tls$BTlsConsole = BTlsConsole.class("[Lcom.tridium.tls.BTlsConsole;", false);
        }
        TYPE = Sys.loadType((Class)clazz);
    }

    static class TlsInterest
    implements BFoxClientConnection.Interest {
        public String toString() {
            return "TlsInterest";
        }

        TlsInterest() {
        }
    }
}

