/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.raster.viewer.BPicture;
import com.tridium.raster.viewer.ImageUtil;
import com.tridium.raster.viewer.PxUtil;
import com.tridium.sys.Nre;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.Comparator;
import java.util.HashMap;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.SortUtil;
import javax.baja.spy.Spy;
import javax.baja.spy.SpyDir;
import javax.baja.spy.SpyWriter;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Clock;

public class Thumb {
    static Log log = Log.getLog((String)"thumbs");
    static final double imagew = 96.0;
    static final double imageh = BPicture.imageh;
    static final HashMap cache = new HashMap();
    static final BImage errorImage = BImage.make((String)"module://icons/x32/error.png");
    static final Thread thread;
    static final Object dibsLock;
    static Thumb dibs;
    BIFile file;
    boolean loaded;
    BImage image;
    double origw;
    double origh;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Thumb make(BIFile bIFile) {
        if (!bIFile.getType().is(ImageUtil.imageFileType) && !bIFile.getType().is(ImageUtil.pxFileType)) {
            return new Thumb(BImage.make((BIcon)((BObject)bIFile).getIcon()));
        }
        Thumb thumb = null;
        HashMap hashMap = cache;
        synchronized (hashMap) {
            BOrd bOrd = bIFile.getNavOrd();
            thumb = (Thumb)cache.get(bOrd);
            if (thumb != null) {
                return thumb;
            }
            thumb = new Thumb(bIFile);
            cache.put(bOrd, thumb);
        }
        return thumb;
    }

    public static void clearCache() {
        cache.clear();
    }

    private Thumb(BImage bImage) {
        this.image = bImage;
        this.loaded = true;
    }

    private Thumb(BIFile bIFile) {
        this.file = bIFile;
    }

    public boolean isLoaded() {
        return this.loaded && this.image.isLoaded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dibs() {
        if (this.loaded) {
            return;
        }
        Object object = dibsLock;
        synchronized (object) {
            dibs = this;
            dibsLock.notifyAll();
        }
    }

    public BImage getImage() {
        return this.image;
    }

    public double getOrigWidth() {
        if (this.file == null) {
            return this.image.getWidth();
        }
        return this.origw;
    }

    public double getOrigHeight() {
        if (this.file == null) {
            return this.image.getHeight();
        }
        return this.origh;
    }

    public void unload() {
        if (this.file == null) {
            return;
        }
        this.image = null;
        this.loaded = false;
    }

    void load() throws IOException {
        double d;
        double d2;
        long l = Clock.ticks();
        BufferedImage bufferedImage = null;
        try {
            bufferedImage = this.file.getType().is(ImageUtil.pxFileType) ? PxUtil.read(this.file) : ImageUtil.read(this.file);
            d2 = this.origw = (double)bufferedImage.getWidth();
            d = this.origh = (double)bufferedImage.getHeight();
        }
        catch (Exception exception) {
            System.out.println("ERROR: Cannot load " + this.file);
            this.image = errorImage;
            this.loaded = true;
            return;
        }
        long l2 = Clock.ticks();
        if (d2 <= 96.0 && d <= imageh) {
            this.image = ImageUtil.toBImage(bufferedImage);
            this.loaded = true;
            return;
        }
        double d3 = 96.0 / d2;
        double d4 = imageh / d;
        double d5 = Math.min(d3, d4);
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d5, d5), null);
        BufferedImage bufferedImage2 = affineTransformOp.filter(bufferedImage, null);
        this.image = ImageUtil.toBImage(bufferedImage2);
        bufferedImage.flush();
        bufferedImage = null;
        this.loaded = true;
        long l3 = Clock.ticks();
        if (log.isTraceOn()) {
            log.trace(this.file.getFileName() + ": load=" + (l2 - l) + "ms scale=" + (l3 - l2) + "ms");
        }
    }

    static {
        dibsLock = new Object();
        thread = new ThumbManagerThread();
        thread.start();
        Spy.ROOT.add("thumbManager", (Spy)new ThumbManagerSpy());
    }

    static class ThumbManagerSpy
    extends SpyDir
    implements Comparator {
        ThumbManagerSpy() {
        }

        public void write(SpyWriter spyWriter) throws Exception {
            int n;
            Object[] objectArray = cache.values().toArray(new Thumb[cache.size()]);
            SortUtil.sort((Object[])objectArray, (Object[])objectArray, (Comparator)this);
            int n2 = 0;
            for (n = 0; n < objectArray.length; ++n) {
                if (!((Thumb)objectArray[n]).loaded) continue;
                ++n2;
            }
            spyWriter.startTable(true);
            spyWriter.trTitle((Object)("Thumb Cache [total=" + objectArray.length + "; loaded=" + n2 + "]"), 3);
            spyWriter.w((Object)"<tr>").th((Object)"<b>File</b>").th((Object)"<b>Loaded</b>").th((Object)"<b>Orig Size</b>").w((Object)"</tr>\n");
            for (n = 0; n < objectArray.length; ++n) {
                Object object = objectArray[n];
                String string = ((Thumb)object).loaded ? "" + ((Thumb)object).origw + "," + ((Thumb)object).origh : "-";
                spyWriter.tr((Object)((Thumb)object).file.getFilePath(), (Object)("" + ((Thumb)object).loaded), (Object)string);
            }
            spyWriter.endTable();
        }

        public int compare(Object object, Object object2) {
            return SortUtil.compare((Object)((Thumb)object).file.getFileName(), (Object)((Thumb)object2).file.getFileName());
        }
    }

    static class ThumbManagerThread
    extends Thread {
        ThumbManagerThread() {
            super(Nre.mainThreadGroup, "Ui:ThumbManager");
            this.setDaemon(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Object object = null;
                        Object object2 = dibsLock;
                        synchronized (object2) {
                            if (dibs == null) {
                                // MONITOREXIT @DISABLED, blocks:[0, 3, 6, 7, 8] lbl8 : MonitorExitStatement: MONITOREXIT : var2_3
                                object = dibsLock;
                                synchronized (object) {
                                    dibsLock.wait(10000L);
                                    continue;
                                }
                            }
                            object = dibs;
                            dibs = null;
                        }
                        ((Thumb)object).load();
                    }
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

