/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.gx.awt.AwtEnv;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Property;
import javax.baja.ui.BWidget;
import javax.baja.ui.px.PxDecoder;

public class PxUtil {
    public static BufferedImage read(BIFile bIFile) {
        try {
            int n;
            BWidget bWidget = new PxDecoder(bIFile).decodeDocument();
            PxUtil.syncImg(bWidget);
            bWidget.computePreferredSize();
            int n2 = (int)bWidget.getPreferredWidth();
            if (n2 <= 0) {
                n2 = 100;
            }
            if ((n = (int)bWidget.getPreferredHeight()) <= 0) {
                n = 100;
            }
            bWidget.setBounds(0.0, 0.0, (double)n2, (double)n);
            bWidget.layout();
            BufferedImage bufferedImage = new BufferedImage(n2, n, 2);
            Graphics2D graphics2D = bufferedImage.createGraphics();
            graphics2D.setClip(0, 0, n2, n);
            Graphics graphics = ((AwtEnv)AwtEnv.get()).makeGraphics(graphics2D);
            bWidget.paint(graphics);
            graphics.dispose();
            return bufferedImage;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static void syncImg(BWidget bWidget) throws Exception {
        Property[] propertyArray = bWidget.getPropertiesArray();
        for (int i = 0; i < propertyArray.length; ++i) {
            if (!propertyArray[i].getType().is(BImage.TYPE)) continue;
            ((BImage)bWidget.get(propertyArray[i])).sync();
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            PxUtil.syncImg(bWidgetArray[i]);
        }
    }
}

