/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.sun.image.codec.jpeg.JPEGCodec;
import com.tridium.gx.GxEnv;
import com.tridium.gx.awt.AwtEnv;
import com.tridium.gx.awt.ImageManager;
import com.tridium.raster.codec.png.PNGImageDecoder;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.InputStream;
import java.io.OutputStream;
import javax.baja.file.BIFile;
import javax.baja.gx.BImage;
import javax.baja.sys.BValue;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BCheckBox;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BProgressDialog;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.text.TextController;
import javax.imageio.ImageIO;

public class ImageUtil {
    public static final Type imageFileType = Sys.getType((String)"file:ImageFile");
    public static final Type gifFileType = Sys.getType((String)"file:GifFile");
    public static final Type jpegFileType = Sys.getType((String)"file:JpegFile");
    public static final Type pngFileType = Sys.getType((String)"file:PngFile");
    public static final Type pxFileType = Sys.getType((String)"file:PxFile");
    public static final RenderingHints highQuality = new RenderingHints(null);

    public static BufferedImage read(BIFile bIFile) throws Exception {
        InputStream inputStream = bIFile.getInputStream();
        try {
            if (bIFile.getType().is(jpegFileType)) {
                BufferedImage bufferedImage = JPEGCodec.createJPEGDecoder((InputStream)inputStream).decodeAsBufferedImage();
                return bufferedImage;
            }
            if (bIFile.getType().is(pngFileType)) {
                BufferedImage bufferedImage = new PNGImageDecoder(inputStream).decode();
                return bufferedImage;
            }
            BufferedImage bufferedImage = ImageIO.read(inputStream);
            return bufferedImage;
        }
        catch (Exception exception) {
        }
        finally {
            inputStream.close();
        }
        byte[] byArray = bIFile.read();
        Image image = Toolkit.getDefaultToolkit().createImage(byArray);
        ImageManager.sync((Image)image);
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        return bufferedImage;
    }

    public static boolean canWrite(BIFile bIFile) {
        return bIFile.getType().is(jpegFileType) || bIFile.getType().is(pngFileType);
    }

    public static void write(BIFile bIFile, BufferedImage bufferedImage, BufferedImage bufferedImage2) throws Exception {
        if (bIFile.getType().is(jpegFileType)) {
            OutputStream outputStream = bIFile.getOutputStream();
            ImageIO.write((RenderedImage)bufferedImage2, "jpg", outputStream);
            outputStream.close();
        } else if (bIFile.getType().is(pngFileType)) {
            OutputStream outputStream = bIFile.getOutputStream();
            ImageIO.write((RenderedImage)bufferedImage2, "png", outputStream);
            outputStream.close();
        } else {
            throw new Exception("Cannot write file type: " + bIFile.getType());
        }
    }

    public static BImage toBImage(Image image) {
        return ((AwtEnv)GxEnv.get()).makeImage(image, false);
    }

    public static void process(BWidget bWidget, BIFile[] bIFileArray, Processor processor) {
        for (int i = 0; i < bIFileArray.length; ++i) {
            BIFile bIFile = bIFileArray[i];
            if (ImageUtil.canWrite(bIFile)) continue;
            BDialog.error((BWidget)bWidget, (Object)("No support for writing \"" + bIFile.getMimeType() + "\" files (" + bIFile.getFileName() + ")"));
            return;
        }
        BProgressDialog.open((BWidget)bWidget, (String)"Processing Files", (BProgressDialog.Worker)new Worker(bIFileArray, processor), (BImage)BImage.make((String)"module://icons/x32/clock.png"));
    }

    static {
        highQuality.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        highQuality.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        highQuality.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
    }

    static class Worker
    extends BProgressDialog.Worker {
        BIFile[] files;
        Processor proc;
        boolean canceled;

        Worker(BIFile[] bIFileArray, Processor processor) {
            this.files = bIFileArray;
            this.proc = processor;
        }

        public void doCancel() {
            this.canceled = true;
        }

        public void doRun() {
            double d = 0.0;
            double d2 = this.files.length * 3;
            for (int i = 0; i < this.files.length && !this.canceled; ++i) {
                Object object;
                BIFile bIFile = this.files[i];
                String string = bIFile.getFileName();
                try {
                    double d3 = d;
                    d = d3 + 1.0;
                    this.updateProgress((int)(d3 / d2 * 100.0), "Reading " + string);
                    BufferedImage bufferedImage = ImageUtil.read(bIFile);
                    double d4 = d;
                    d = d4 + 1.0;
                    this.updateProgress((int)(d4 / d2 * 100.0), "Processing " + string);
                    object = this.proc.process(bufferedImage);
                    double d5 = d;
                    d = d5 + 1.0;
                    this.updateProgress((int)(d5 / d2 * 100.0), "Writing " + string);
                    ImageUtil.write(bIFile, bufferedImage, (BufferedImage)object);
                    continue;
                }
                catch (Exception exception) {
                    object = "Cannot process: " + string;
                    int n = BDialog.open((BWidget)this.getDialog(), (String)BDialog.TITLE_ERROR, (Object)object, (int)3, (BImage)BDialog.ERROR_ICON, (Throwable)exception);
                    if (n != 2) continue;
                    this.canceled = true;
                }
            }
        }
    }

    public static class ResizeInput {
        BWidget content;
        BTextField w = new BTextField("", 8);
        BTextField h = new BTextField("", 8);
        BCheckBox aspect = new BCheckBox("Maintain aspect ratio");
        double ratio;

        public ResizeInput(int n, int n2) {
            this.ratio = (double)n / (double)n2;
            this.aspect.setCommand((Command)new AspectToggle(), false, false);
            this.aspect.setSelected(true);
            this.w.setController((TextController)new Controller());
            this.h.setController((TextController)new Controller());
            this.setWidth(n);
            this.setHeight(n2);
            BGridPane bGridPane = new BGridPane(2);
            bGridPane.add(null, (BValue)new BLabel("Width"));
            bGridPane.add(null, (BValue)this.w);
            bGridPane.add(null, (BValue)new BLabel("Height"));
            bGridPane.add(null, (BValue)this.h);
            BGridPane bGridPane2 = new BGridPane(1);
            bGridPane2.add(null, (BValue)bGridPane);
            bGridPane2.add(null, (BValue)this.aspect);
            this.content = new BBorderPane((BWidget)bGridPane2);
        }

        public BWidget getContent() {
            return this.content;
        }

        public int getWidth() {
            return Integer.parseInt(this.w.getText());
        }

        public int getHeight() {
            return Integer.parseInt(this.h.getText());
        }

        void checkAspect(BTextField bTextField) {
            try {
                if (!this.aspect.isSelected()) {
                    return;
                }
                if (bTextField == this.w) {
                    this.setHeight((int)((double)this.getWidth() / this.ratio));
                } else {
                    this.setWidth((int)((double)this.getHeight() * this.ratio));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void setWidth(int n) {
            this.w.setText(String.valueOf(n));
        }

        void setHeight(int n) {
            this.h.setText(String.valueOf(n));
        }

        class Controller
        extends TextController {
            Controller() {
            }

            public void keyPressed(BKeyEvent bKeyEvent) {
                super.keyPressed(bKeyEvent);
                ResizeInput.this.checkAspect((BTextField)this.getEditor());
            }

            public void keyReleased(BKeyEvent bKeyEvent) {
                super.keyReleased(bKeyEvent);
                ResizeInput.this.checkAspect((BTextField)this.getEditor());
            }

            public void keyTyped(BKeyEvent bKeyEvent) {
                super.keyTyped(bKeyEvent);
                ResizeInput.this.checkAspect((BTextField)this.getEditor());
            }
        }

        class AspectToggle
        extends ToggleCommand {
            AspectToggle() {
                super((BWidget)ResizeInput.this.aspect, "aspect");
            }

            public void setSelected(boolean bl) {
                super.setSelected(bl);
                ResizeInput.this.checkAspect(ResizeInput.this.w);
            }
        }
    }

    public static class Resize
    extends Processor {
        int dw;
        int dh;

        public Resize(int n, int n2) {
            this.dw = n;
            this.dh = n2;
        }

        public BufferedImage process(BufferedImage bufferedImage) {
            BufferedImage bufferedImage2 = new BufferedImage(this.dw, this.dh, bufferedImage.getType());
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.setRenderingHints(highQuality);
            graphics2D.drawImage(bufferedImage, 0, 0, this.dw, this.dh, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
    }

    public static class Rotate
    extends Processor {
        int angle;

        public Rotate(int n) {
            if (n != 90 && n != 270) {
                throw new IllegalArgumentException("" + n);
            }
            this.angle = n;
        }

        public BufferedImage process(BufferedImage bufferedImage) {
            int n = bufferedImage.getWidth();
            int n2 = bufferedImage.getHeight();
            int n3 = (n - n2) / 2;
            double d = 0.5 * (double)n;
            double d2 = 0.5 * (double)n2;
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.rotate(Math.toRadians(this.angle), d, d2);
            if (this.angle == 90) {
                affineTransform.translate(n3, n3);
            } else if (this.angle == 270) {
                affineTransform.translate(-n3, -n3);
            }
            BufferedImage bufferedImage2 = new BufferedImage(n2, n, bufferedImage.getType());
            Graphics2D graphics2D = (Graphics2D)bufferedImage2.getGraphics();
            graphics2D.setRenderingHints(highQuality);
            graphics2D.transform(affineTransform);
            graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
            graphics2D.dispose();
            return bufferedImage2;
        }
    }

    public static abstract class Processor {
        public abstract BufferedImage process(BufferedImage var1);
    }
}

