/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.raster.viewer.BDirectoryThumbnails;
import com.tridium.raster.viewer.BPicture;
import com.tridium.raster.viewer.ImageUtil;
import com.tridium.raster.viewer.Thumb;
import com.tridium.workbench.file.BDirTable;
import com.tridium.workbench.transfer.TransferUtil;
import javax.baja.file.BDirectory;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BInsets;
import javax.baja.naming.BOrd;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BValign;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.event.WidgetSubscriber;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.util.BTitlePane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;

public class BPictureGrid
extends BTransferWidget
implements NavListener {
    public static final Property content = BPictureGrid.newProperty((int)0, (BValue)new BNullWidget(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$raster$viewer$BPictureGrid == null ? (class$com$tridium$raster$viewer$BPictureGrid = BPictureGrid.class$("com.tridium.raster.viewer.BPictureGrid")) : class$com$tridium$raster$viewer$BPictureGrid));
    static Lexicon lex = Lexicon.make((String)"raster");
    BTitlePane titlePane;
    BGridPane gridPane;
    BScrollPane scroll;
    BIDirectory dir;
    BOrd dirOrd;
    BIFile[] files;
    BPicture[] pictures = new BPicture[0];
    boolean enableEdits = false;
    Selection sel = new Selection();
    boolean checkSelectionOnRelease;
    Command clearCache = new ClearThumbCache((BWidget)this);
    Command refresh = new Refresh((BWidget)this);
    Command rotateLeft = new RotateLeft((BWidget)this);
    Command rotateRight = new RotateRight((BWidget)this);
    Command resize = new Resize((BWidget)this);
    static /* synthetic */ Class class$com$tridium$raster$viewer$BPictureGrid;
    static /* synthetic */ Class class$com$tridium$raster$viewer$BPicture;
    static /* synthetic */ Class class$javax$baja$file$BIFile;

    public BWidget getContent() {
        return (BWidget)this.get(content);
    }

    public void setContent(BWidget bWidget) {
        this.set(content, (BValue)bWidget, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BPictureGrid() {
        this.gridPane = new BGridPane(5);
        this.gridPane.setValign(BValign.top);
        this.gridPane.setHalign(BHalign.left);
        this.gridPane.setRowGap(10.0);
        this.gridPane.setColumnGap(10.0);
        new WidgetSubscriber(){

            public void mousePressed(BMouseEvent bMouseEvent) {
                BPictureGrid.this.backgroundPressed(bMouseEvent);
            }

            public void mouseReleased(BMouseEvent bMouseEvent) {
                BPictureGrid.this.backgroundReleased(bMouseEvent);
            }
        }.subscribe((BComponent)this.gridPane);
        BBorderPane bBorderPane = new BBorderPane((BWidget)this.gridPane, BBorder.inset, BInsets.DEFAULT);
        bBorderPane.setPadding(BInsets.make((double)10.0, (double)10.0, (double)10.0, (double)10.0));
        this.scroll = new BScrollPane((BWidget)bBorderPane);
        this.titlePane = new BTitlePane("", (BWidget)this.scroll);
        this.titlePane.setTypeName("files");
        this.setContent((BWidget)this.titlePane);
    }

    public void computePreferredSize() {
        BWidget bWidget = this.getContent();
        bWidget.computePreferredSize();
        this.setPreferredSize(bWidget.getPreferredWidth(), bWidget.getPreferredHeight());
    }

    public void doLayout(BWidget[] bWidgetArray) {
        if (this.gridPane != null) {
            int n = (int)((this.getWidth() - 20.0) / 100.0) - 1;
            if (n < 5) {
                n = 5;
            }
            this.gridPane.setColumnCount(n);
        }
        BWidget bWidget = this.getContent();
        bWidget.setBounds(0.0, 0.0, this.getWidth(), this.getHeight());
    }

    public void load(BIDirectory bIDirectory) {
        this.dir = bIDirectory;
        this.dirOrd = bIDirectory.getNavOrd();
        this.files = bIDirectory.listFiles();
        this.titlePane.setTitle(bIDirectory.getNavName());
        this.titlePane.setCount(this.files.length);
        this.enableEdits = false;
        if (bIDirectory instanceof BDirectory) {
            this.enableEdits = !((BDirectory)bIDirectory).isReadonly();
        }
        for (int i = 0; i < this.pictures.length; ++i) {
            this.pictures[i].grid = null;
        }
        BPicture[] bPictureArray = new BPicture[this.files.length];
        for (int i = 0; i < bPictureArray.length; ++i) {
            bPictureArray[i] = new BPicture(this, this.files[i]);
        }
        this.rebuildGrid(bPictureArray);
        this.updateTransferCommands();
    }

    public void refresh() {
        int n;
        BIFile[] bIFileArray = this.dir.listFiles();
        BPicture[] bPictureArray = new BPicture[bIFileArray.length];
        BPicture[] bPictureArray2 = this.pictures;
        int n2 = 0;
        this.titlePane.setCount(bIFileArray.length);
        block0: for (n = 0; n < bIFileArray.length; ++n) {
            String string = bIFileArray[n].getFileName();
            for (int i = 0; i < bPictureArray2.length; ++i) {
                if (!string.equals(bPictureArray2[i].file.getFileName())) continue;
                bIFileArray[n] = null;
                bPictureArray[n2++] = bPictureArray2[i];
                continue block0;
            }
        }
        n = n2;
        for (int i = 0; i < bIFileArray.length; ++i) {
            if (bIFileArray[i] == null) continue;
            bPictureArray[n2++] = new BPicture(this, bIFileArray[i]);
        }
        this.rebuildGrid(bPictureArray);
        this.sel.deselectAll();
        if (n < bPictureArray.length) {
            this.sel.select(n, this.pictures.length - 1);
        }
    }

    void rebuildGrid(BPicture[] bPictureArray) {
        int n;
        for (n = 0; n < bPictureArray.length; ++n) {
            bPictureArray[n].index = n;
        }
        this.pictures = bPictureArray;
        this.gridPane.removeAll();
        for (n = 0; n < bPictureArray.length; ++n) {
            this.gridPane.add("p" + n, (BValue)bPictureArray[n]);
        }
        this.relayout();
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void navEvent(NavEvent navEvent) {
        if (this.dirOrd != null && this.dirOrd.equals((Object)navEvent.getParentOrd())) {
            this.refresh();
        }
    }

    public void backgroundPressed(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(null, bMouseEvent);
        } else if (!bMouseEvent.isButton3Down()) {
            this.sel.deselectAll();
        }
    }

    public void backgroundReleased(BMouseEvent bMouseEvent) {
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(null, bMouseEvent);
        }
    }

    public void mouseEntered(BPicture bPicture, BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            bWidgetShell.showStatus(bPicture.toStatusString());
        }
    }

    public void mouseExited(BPicture bPicture, BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell != null) {
            bWidgetShell.showStatus("");
        }
    }

    public void mousePressed(BPicture bPicture, BMouseEvent bMouseEvent) {
        if (bMouseEvent.isButton2Down()) {
            return;
        }
        if (bPicture.selected) {
            this.checkSelectionOnRelease = true;
        } else {
            this.checkSelectionOnRelease = false;
            this.checkSelection(bPicture, bMouseEvent);
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(bPicture, bMouseEvent);
        }
        if (bMouseEvent.isButton1Down() && bMouseEvent.getClickCount() == 2) {
            this.checkSelectionOnRelease = false;
            this.doubleClicked(bPicture, bMouseEvent);
        }
    }

    public void mouseReleased(BPicture bPicture, BMouseEvent bMouseEvent) {
        if (bMouseEvent.isButton2Down()) {
            return;
        }
        if (this.checkSelectionOnRelease) {
            this.checkSelectionOnRelease = false;
            if (!bMouseEvent.isPopupTrigger()) {
                this.checkSelection(bPicture, bMouseEvent);
            }
        }
        if (bMouseEvent.isPopupTrigger()) {
            this.popup(bPicture, bMouseEvent);
        }
    }

    void checkSelection(BPicture bPicture, BMouseEvent bMouseEvent) {
        int n = bPicture.index;
        if (bMouseEvent.isShiftDown() && bMouseEvent.isButton1Down()) {
            if (this.sel.getAnchor() == -1) {
                this.sel.select(0);
            }
            this.sel.select(this.sel.getAnchor(), n, !bMouseEvent.isControlDown());
        } else if (bMouseEvent.isControlDown()) {
            if (this.sel.isSelected(n)) {
                this.sel.deselect(n);
            } else {
                this.sel.select(n);
            }
        } else {
            this.sel.select(n, true);
        }
    }

    void popup(BPicture bPicture, BMouseEvent bMouseEvent) {
        Subject subject = this.getSubject(bPicture != null ? bPicture.file : null);
        BMenu bMenu = BDirTable.makeDirPopup((BTransferWidget)this, (BIDirectory)this.dir, (Subject)subject, (boolean)this.enableEdits);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, this.refresh);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, this.rotateLeft);
        bMenu.add(null, this.rotateRight);
        bMenu.add(null, this.resize);
        bMenu.removeConsecutiveSeparators();
        bMenu.open(bMouseEvent);
    }

    void doubleClicked(BPicture bPicture, BMouseEvent bMouseEvent) {
        BWidgetShell bWidgetShell = this.getShell();
        if (bWidgetShell instanceof BWbShell) {
            BIFile bIFile = bPicture.file;
            BOrd bOrd = bIFile.getNavOrd();
            if (bIFile instanceof BIDirectory) {
                bOrd = BOrd.make((BOrd)bOrd, (String)("view:" + BDirectoryThumbnails.TYPE.toString()));
            }
            ((BWbShell)bWidgetShell).hyperlink(new HyperlinkInfo(bOrd, (BInputEvent)bMouseEvent));
        }
    }

    public void updateTransferCommands() {
        BIFile[] bIFileArray = this.getSelectedFiles();
        int n = bIFileArray.length;
        boolean bl = true;
        for (int i = 0; i < n; ++i) {
            if (!bIFileArray[i].isReadonly()) continue;
            bl = false;
            break;
        }
        this.setCutEnabled(n > 0 && bl && this.enableEdits);
        this.setCopyEnabled(n > 0);
        this.setPasteEnabled(this.enableEdits);
        this.setDuplicateEnabled(n > 0 && this.enableEdits);
        this.setDeleteEnabled(n > 0 && bl && this.enableEdits);
        this.setRenameEnabled(n > 0 && bl && this.enableEdits);
        this.rotateLeft.setEnabled(n > 0 && bl && this.enableEdits);
        this.rotateRight.setEnabled(n > 0 && bl && this.enableEdits);
        this.resize.setEnabled(n > 0 && bl && this.enableEdits);
        this.refresh.setEnabled(n > 0);
    }

    public TransferEnvelope getTransferData() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return TransferUtil.insert((BWidget)this, (TransferContext)transferContext, (BObject)((BObject)this.dir), null);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.delete((BWidget)this, (Mark)mark);
    }

    public CommandArtifact doRename() throws Exception {
        Mark mark = this.getSelectedFilesAsMark();
        if (mark == null) {
            return null;
        }
        return TransferUtil.rename((BWidget)this, (Mark)mark);
    }

    void refreshSelection() {
        BPicture[] bPictureArray = this.getSelectedPictures();
        for (int i = 0; i < bPictureArray.length; ++i) {
            bPictureArray[i].refresh();
        }
        this.repaint();
    }

    void rotateSelection(int n) {
        BIFile[] bIFileArray = this.getSelectedFiles();
        if (bIFileArray.length == 0) {
            return;
        }
        ImageUtil.process((BWidget)this, bIFileArray, new ImageUtil.Rotate(n));
        this.refreshSelection();
    }

    void resizeSelection() {
        BIFile[] bIFileArray = this.getSelectedFiles();
        BPicture[] bPictureArray = this.getSelectedPictures();
        if (bIFileArray.length == 0) {
            return;
        }
        for (int i = 0; i < bPictureArray.length; ++i) {
            Thumb thumb = bPictureArray[i].thumb;
            if (thumb.isLoaded()) continue;
            BDialog.error((BWidget)this, (Object)"Not all selected images have been loaded yet");
            return;
        }
        double d = bPictureArray[0].thumb.getOrigWidth();
        double d2 = bPictureArray[0].thumb.getOrigHeight();
        for (int i = 0; i < bPictureArray.length; ++i) {
            Thumb thumb = bPictureArray[i].thumb;
            if (thumb.getOrigWidth() == d && thumb.getOrigHeight() == d2) continue;
            BDialog.error((BWidget)this, (Object)("All images must be same size as first (" + thumb.file.getFileName() + ")"));
            return;
        }
        ImageUtil.ResizeInput resizeInput = new ImageUtil.ResizeInput((int)d, (int)d2);
        int n = BDialog.open((BWidget)this, (String)"Resize", (Object)resizeInput.getContent(), (int)3);
        if (n != 1) {
            return;
        }
        int n2 = resizeInput.getWidth();
        int n3 = resizeInput.getHeight();
        ImageUtil.process((BWidget)this, bIFileArray, new ImageUtil.Resize(n2, n3));
        this.refreshSelection();
    }

    public BPicture[] getSelectedPictures() {
        Array array = new Array(class$com$tridium$raster$viewer$BPicture == null ? (class$com$tridium$raster$viewer$BPicture = BPictureGrid.class$("com.tridium.raster.viewer.BPicture")) : class$com$tridium$raster$viewer$BPicture);
        for (int i = 0; i < this.pictures.length; ++i) {
            if (!this.pictures[i].selected) continue;
            array.add((Object)this.pictures[i]);
        }
        return (BPicture[])array.trim();
    }

    public BIFile[] getSelectedFiles() {
        Array array = new Array(class$javax$baja$file$BIFile == null ? (class$javax$baja$file$BIFile = BPictureGrid.class$("javax.baja.file.BIFile")) : class$javax$baja$file$BIFile);
        for (int i = 0; i < this.pictures.length; ++i) {
            if (!this.pictures[i].selected) continue;
            array.add((Object)this.pictures[i].file);
        }
        return (BIFile[])array.trim();
    }

    public Mark getSelectedFilesAsMark() {
        if (this.dir == null) {
            return null;
        }
        BIFile[] bIFileArray = this.getSelectedFiles();
        if (bIFileArray.length == 0) {
            return null;
        }
        String[] stringArray = new String[bIFileArray.length];
        BObject[] bObjectArray = new BObject[bIFileArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray[i] = bIFileArray[i].getFileName();
            bObjectArray[i] = (BObject)bIFileArray[i];
        }
        return new Mark(bObjectArray, stringArray);
    }

    public Subject getSubject(BIFile bIFile) {
        return new Subject((Object[])this.getSelectedFiles(), (Object)bIFile);
    }

    public BMenu getViewMenu() {
        BMenu bMenu = new BMenu(BDirectoryThumbnails.TYPE.getDisplayName(null));
        bMenu.add(null, this.clearCache);
        bMenu.add(null, this.refresh);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, this.rotateLeft);
        bMenu.add(null, this.rotateRight);
        bMenu.add(null, this.resize);
        return bMenu;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Resize
    extends Command {
        public Resize(BWidget bWidget) {
            super(bWidget, lex, "resize");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.resizeSelection();
            return null;
        }
    }

    class RotateRight
    extends Command {
        public RotateRight(BWidget bWidget) {
            super(bWidget, lex, "rotateRight");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.rotateSelection(90);
            return null;
        }
    }

    class RotateLeft
    extends Command {
        public RotateLeft(BWidget bWidget) {
            super(bWidget, lex, "rotateLeft");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.rotateSelection(270);
            return null;
        }
    }

    class Refresh
    extends Command {
        public Refresh(BWidget bWidget) {
            super(bWidget, lex, "refresh");
        }

        public CommandArtifact doInvoke() {
            BPictureGrid.this.refreshSelection();
            return null;
        }
    }

    class ClearThumbCache
    extends Command {
        public ClearThumbCache(BWidget bWidget) {
            super(bWidget, lex, "clearThumbCache");
        }

        public CommandArtifact doInvoke() {
            int n = BDialog.confirm((BWidget)this.getOwner(), (String)this.getLabel(), (Object)"Clear thumbnail cache?");
            if (n != 4) {
                return null;
            }
            Thumb.clearCache();
            BPictureGrid.this.repaint();
            return null;
        }
    }

    class Selection
    extends TableSelection {
        Selection() {
        }

        public void updateTable() {
            for (int i = 0; i < BPictureGrid.this.pictures.length; ++i) {
                BPictureGrid.this.pictures[i].selected = this.isSelected(i);
            }
            BPictureGrid.this.updateTransferCommands();
            BPictureGrid.this.repaint();
        }
    }
}

