/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.raster.viewer.BPictureGrid;
import com.tridium.raster.viewer.Thumb;
import com.tridium.ui.theme.Theme;
import javax.baja.file.BIFile;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;

public class BPicture
extends BWidget {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$raster$viewer$BPicture == null ? (class$com$tridium$raster$viewer$BPicture = BPicture.class$("com.tridium.raster.viewer.BPicture")) : class$com$tridium$raster$viewer$BPicture));
    static final int size = 100;
    static final BFont font = Theme.widget().getTextFont();
    static final BBrush normalFg = BColor.black.toBrush();
    static final BBrush cutFg = BColor.make((int)100, (int)100, (int)100).toBrush();
    static final BBrush selectFg = Theme.widget().getSelectionForeground();
    static final BBrush selectBg = Theme.widget().getSelectionBackground();
    static final BBrush selAlpha = BColor.make((String)"#33666699").toBrush();
    static final double namey = 100.0 - font.getDescent();
    static final double imagew = 96.0;
    static final double imageh = 100.0 - font.getHeight() - 6.0;
    BPictureGrid grid;
    int index;
    BIFile file;
    String name;
    Thumb thumb;
    boolean paintSinceLoaded;
    boolean selected;
    static /* synthetic */ Class class$com$tridium$raster$viewer$BPicture;

    public Type getType() {
        return TYPE;
    }

    public BPicture(BPictureGrid bPictureGrid, BIFile bIFile) {
        this.grid = bPictureGrid;
        this.file = bIFile;
        this.name = bIFile.getFileName();
        this.thumb = Thumb.make(bIFile);
    }

    public void computePreferredSize() {
        this.setPreferredSize(100.0, 100.0);
    }

    public void animate() {
        if (!this.thumb.isLoaded()) {
            this.repaint();
        } else if (!this.paintSinceLoaded) {
            this.repaint();
        }
    }

    void refresh() {
        this.thumb.unload();
        this.paintSinceLoaded = false;
    }

    public void paint(Graphics graphics) {
        double d;
        double d2;
        BBrush bBrush;
        BBrush bBrush2;
        BBrush bBrush3;
        boolean bl = this.file.isPendingMove();
        if (this.selected) {
            bBrush3 = selectFg;
            bBrush2 = selectBg;
            bBrush = selectBg;
        } else {
            bBrush3 = bl ? cutFg : normalFg;
            bBrush2 = null;
            bBrush = Theme.widget().getControlAuxiliary();
        }
        if (!this.thumb.isLoaded()) {
            this.thumb.dibs();
        } else {
            this.paintSinceLoaded = true;
            BImage bImage = this.thumb.getImage();
            double d3 = 2.0 + (96.0 - bImage.getWidth()) / 2.0;
            double d4 = 2.0 + (imageh - bImage.getHeight()) / 2.0;
            if (bl) {
                graphics.drawImage(bImage.getDisabledImage(), d3, d4);
            } else {
                graphics.drawImage(bImage, d3, d4);
            }
        }
        if (this.selected) {
            graphics.setBrush(selAlpha);
            graphics.fillRect(2.0, 2.0, 96.0, imageh + 1.0);
        }
        graphics.setBrush(bBrush);
        graphics.strokeRect(1.0, 1.0, 97.0, imageh + 2.0);
        if (this.selected) {
            graphics.setBrush(selectBg);
            graphics.strokeRect(0.0, 0.0, 99.0, imageh + 4.0);
        }
        if ((d2 = (100.0 - (d = font.width(this.name))) / 2.0) < 0.0) {
            d2 = 0.0;
        }
        if (bBrush2 != null) {
            graphics.setBrush(bBrush2);
            graphics.fillRect(d2 - 2.0, imageh + 4.0, d + 4.0, 100.0 - imageh - 3.0);
        }
        graphics.setBrush(bBrush3);
        graphics.setFont(font);
        graphics.drawString(this.name, d2, namey);
    }

    public void mouseEntered(BMouseEvent bMouseEvent) {
        if (this.grid != null) {
            this.grid.mouseEntered(this, bMouseEvent);
        }
    }

    public void mouseExited(BMouseEvent bMouseEvent) {
        if (this.grid != null) {
            this.grid.mouseExited(this, bMouseEvent);
        }
    }

    public void mousePressed(BMouseEvent bMouseEvent) {
        if (this.grid != null) {
            this.grid.mousePressed(this, bMouseEvent);
        }
    }

    public void mouseReleased(BMouseEvent bMouseEvent) {
        if (this.grid != null) {
            this.grid.mouseReleased(this, bMouseEvent);
        }
    }

    public String toStatusString() {
        String string = this.name;
        if (this.thumb.isLoaded()) {
            string = string + " [" + (int)this.thumb.getOrigWidth() + "," + (int)this.thumb.getOrigHeight() + "]";
        }
        return string;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

