/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.viewer;

import com.tridium.gx.awt.BImageDecoder;
import com.tridium.raster.viewer.ImageUtil;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.colorchooser.BColorChooser;
import java.io.IOException;
import javax.baja.agent.AgentFilter;
import javax.baja.file.BIDirectory;
import javax.baja.file.BIFile;
import javax.baja.gx.BColor;
import javax.baja.gx.BFont;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.BTransform;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.IFilter;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BImageViewer
extends BWbView {
    public static final Property content = BImageViewer.newProperty((int)0, (BValue)new BEdgePane());
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$raster$viewer$BImageViewer == null ? (class$com$tridium$raster$viewer$BImageViewer = BImageViewer.class$("com.tridium.raster.viewer.BImageViewer")) : class$com$tridium$raster$viewer$BImageViewer));
    static final String FACETS_PATH = "/com/tridium/raster/viewer/rasterViewer.facets";
    static Lexicon lex = Lexicon.make((String)"raster");
    static BImage errorIcon = BImage.make((String)"module://icons/x32/error.png");
    static boolean lastFit = true;
    static BColor lastColor = BColor.NULL;
    Command prev = new PrevImage((BWidget)this);
    Command next = new NextImage((BWidget)this);
    ToggleCommand fit = new FitToWindow((BWidget)this);
    Command background = new Background((BWidget)this);
    Command rotateLeft = new RotateLeft((BWidget)this);
    Command rotateRight = new RotateRight((BWidget)this);
    Command resize = new Resize((BWidget)this);
    BImage actual;
    BLabel display = new BLabel();
    BScrollPane scrollPane = new BScrollPane();
    double lastw;
    double lasth;
    boolean firstPaint = true;
    static /* synthetic */ Class class$com$tridium$raster$viewer$BImageViewer;

    public Type getType() {
        return TYPE;
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = new BMenu(this.getType().getDisplayName(null));
        bMenu.add("prev", this.prev);
        bMenu.add("next", this.next);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add("fit", (Command)this.fit);
        bMenu.add("bg", this.background);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add("rotl", this.rotateLeft);
        bMenu.add("rotr", this.rotateRight);
        bMenu.add("resize", this.resize);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add("prev", this.prev);
        bToolBar.add("next", this.next);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add("fit", (Command)this.fit);
        bToolBar.add(null, (BValue)new BSeparator());
        bToolBar.add("rotl", this.rotateLeft);
        bToolBar.add("rotr", this.rotateRight);
        bToolBar.add("resize", this.resize);
        return bToolBar;
    }

    public void doLoadValue(BObject bObject, Context context) throws Exception {
        BIFile bIFile = (BIFile)bObject;
        BIFile bIFile2 = (BIFile)bIFile.getNavParent();
        BImage bImage = null;
        try {
            bImage = bIFile.getType().is(ImageUtil.gifFileType) ? BImage.make((BOrd)bIFile.getNavOrd()).sync() : (((BObject)bIFile).getAgents().filter(AgentFilter.is((Type)BImageDecoder.TYPE)).size() > 0 ? BImage.make((BOrd)bIFile.getNavOrd()).sync() : ImageUtil.toBImage(ImageUtil.read(bIFile)));
            this.actual = bImage;
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        boolean bl = bImage == null || bImage.getWidth() <= 0.0 || bImage.getHeight() <= 0.0;
        boolean bl2 = !bIFile.isReadonly() && !bIFile2.isReadonly() && !bl;
        this.setCommandEnabled(4, bl2);
        this.rotateLeft.setEnabled(bl2);
        this.rotateRight.setEnabled(bl2);
        this.resize.setEnabled(bl2);
        if (bl) {
            BScrollPane bScrollPane = new BScrollPane();
            String string = lex.getText("viewer.brokenImage");
            bScrollPane.setContent((BWidget)new BBorderPane((BWidget)new BLabel(errorIcon, string), 5.0, 5.0, 5.0, 5.0));
            this.setContent((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT));
            return;
        }
        this.scrollPane.setViewportBackground(lastColor.toBrush());
        this.scrollPane.setContent((BWidget)this.display);
        String string = bIFile.getLastModified().toString(null);
        String string2 = (int)bImage.getWidth() + " x " + (int)bImage.getHeight() + " (" + Math.max(1L, bIFile.getSize() / 1024L) + "kb)";
        BGridPane bGridPane = new BGridPane(1);
        bGridPane.setRowGap(2.0);
        bGridPane.setHalign(BHalign.left);
        BFont bFont = Theme.widget().getBoldText();
        BLabel bLabel = new BLabel(bIFile.getFileName(), bFont, BHalign.left);
        bGridPane.add("name", (BValue)bLabel);
        bLabel.setForeground(BColor.white.toBrush());
        bLabel = new BLabel(string, BHalign.left);
        bGridPane.add("mod", (BValue)bLabel);
        bLabel.setForeground(BColor.white.toBrush());
        bLabel = new BLabel(string2, BHalign.left);
        bGridPane.add("size", (BValue)bLabel);
        bLabel.setForeground(BColor.white.toBrush());
        BScrollPane bScrollPane = new BScrollPane();
        bScrollPane.setViewportBackground(Theme.widget().getControlShadow());
        bScrollPane.setContent((BWidget)new BBorderPane((BWidget)bGridPane));
        BEdgePane bEdgePane = (BEdgePane)this.getContent();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.scrollPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        this.updateImage();
    }

    public void doLayout(BWidget[] bWidgetArray) {
        super.doLayout(bWidgetArray);
        if (this.getWidth() != this.lastw || this.getHeight() != this.lasth) {
            this.lastw = this.getWidth();
            this.lasth = this.getHeight();
            if (this.fit.isSelected()) {
                this.updateImage();
            }
        }
    }

    public void paint(Graphics graphics) {
        if (this.firstPaint) {
            this.updateImage();
            this.firstPaint = false;
        } else {
            super.paint(graphics);
        }
    }

    void updateImage() {
        if (this.actual == null) {
            return;
        }
        BImage bImage = this.actual;
        if (this.fit.isSelected()) {
            double d = this.scrollPane.getWidth() - 10.0;
            double d2 = this.scrollPane.getHeight() - 10.0;
            if (d > 0.0 && d2 > 0.0) {
                double d3 = this.actual.getWidth();
                double d4 = this.actual.getHeight();
                if (d3 > d || d4 > d2) {
                    double d5 = d / d3;
                    double d6 = d2 / d4;
                    double d7 = Math.min(d5, d6);
                    bImage = this.actual.transform(BTransform.makeScale((double)d7, (double)d7));
                }
            }
        }
        this.display.setImage(bImage);
        this.scrollPane.relayout();
    }

    public void delete() throws IOException {
        BWbShell bWbShell = this.getWbShell();
        BIFile bIFile = (BIFile)this.getCurrentValue();
        this.advance(bWbShell, 1, true);
        bIFile.delete();
    }

    void background() {
        BColor bColor = BColorChooser.openInDialog((BWidget)this, (BColor)lastColor);
        if (bColor == null) {
            return;
        }
        lastColor = bColor;
        this.scrollPane.setViewportBackground(bColor.toBrush());
        this.scrollPane.repaint();
    }

    void rotate(int n) {
        BIFile bIFile = (BIFile)this.getCurrentValue();
        ImageUtil.process((BWidget)this, new BIFile[]{bIFile}, new ImageUtil.Rotate(n));
        this.getWbShell().getRefreshCommand().invoke();
    }

    void resize() {
        BIFile bIFile = (BIFile)this.getCurrentValue();
        ImageUtil.ResizeInput resizeInput = new ImageUtil.ResizeInput((int)this.actual.getWidth(), (int)this.actual.getHeight());
        int n = BDialog.open((BWidget)this, (String)"Resize", (Object)resizeInput.getContent(), (int)3);
        if (n != 1) {
            return;
        }
        int n2 = resizeInput.getWidth();
        int n3 = resizeInput.getHeight();
        ImageUtil.process((BWidget)this, new BIFile[]{bIFile}, new ImageUtil.Resize(n2, n3));
        this.getWbShell().getRefreshCommand().invoke();
    }

    void advance(BWbShell bWbShell, int n, boolean bl) {
        int n2;
        BIFile bIFile = (BIFile)this.getCurrentValue();
        BIDirectory bIDirectory = (BIDirectory)bIFile.getNavParent();
        Object[] objectArray = bIDirectory.listFiles();
        objectArray = (BIFile[])new Array(objectArray).filter(new IFilter(){

            public boolean accept(Object object) {
                return ((BIFile)object).getType().is(ImageUtil.imageFileType);
            }
        }).trim();
        int n3 = -1;
        for (n2 = 0; n2 < objectArray.length; ++n2) {
            if (!objectArray[n2].getFileName().equals(bIFile.getFileName())) continue;
            n3 = n2;
            break;
        }
        if (n3 < 0 || objectArray.length < 2) {
            if (!bl) {
                BDialog.error((BWidget)this, (Object)"No prev/next file found");
            }
            return;
        }
        n2 = n3 + n;
        if (n2 < 0) {
            n2 = objectArray.length - 1;
        }
        if (n2 >= objectArray.length) {
            n2 = 0;
        }
        BOrd bOrd = BOrd.make((BOrd)objectArray[n2].getAbsoluteOrd(), (String)("view:" + this.getType().toString()));
        bWbShell.hyperlink(bOrd);
    }

    public CommandArtifact invokeCommand(int n) throws Exception {
        switch (n) {
            case 4: {
                this.delete();
                return null;
            }
        }
        return super.invokeCommand(n);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Resize
    extends Command {
        public Resize(BWidget bWidget) {
            super(bWidget, lex, "resize");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.resize();
            return null;
        }
    }

    class RotateRight
    extends Command {
        public RotateRight(BWidget bWidget) {
            super(bWidget, lex, "rotateRight");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.rotate(90);
            return null;
        }
    }

    class RotateLeft
    extends Command {
        public RotateLeft(BWidget bWidget) {
            super(bWidget, lex, "rotateLeft");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.rotate(270);
            return null;
        }
    }

    class Background
    extends Command {
        Background(BWidget bWidget) {
            super(bWidget, lex, "background");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.background();
            return null;
        }
    }

    class FitToWindow
    extends ToggleCommand {
        FitToWindow(BWidget bWidget) {
            super(bWidget, lex, "fitToWindow");
            this.setSelected(lastFit);
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            lastFit = bl;
            BImageViewer.this.updateImage();
        }
    }

    class NextImage
    extends Command {
        NextImage(BWidget bWidget) {
            super(bWidget, lex, "nextImage");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.advance(BImageViewer.this.getWbShell(), 1, false);
            return null;
        }
    }

    class PrevImage
    extends Command {
        PrevImage(BWidget bWidget) {
            super(bWidget, lex, "prevImage");
        }

        public CommandArtifact doInvoke() {
            BImageViewer.this.advance(BImageViewer.this.getWbShell(), -1, false);
            return null;
        }
    }
}

