/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.codec.png;

import com.tridium.raster.codec.png.Chunk;
import com.tridium.raster.codec.png.FilterType0;
import com.tridium.raster.codec.png.FilterType1;
import com.tridium.raster.codec.png.FilterType2;
import com.tridium.raster.codec.png.FilterType3;
import com.tridium.raster.codec.png.FilterType4;
import com.tridium.raster.codec.png.ImageFormatException;
import com.tridium.raster.codec.png.Util;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DeflaterOutputStream;

public class PNGImageEncoder {
    private OutputStream output;
    private Header header = new Header();
    private int currentY = 0;

    public PNGImageEncoder(OutputStream outputStream) {
        this.output = outputStream;
    }

    public void encode(BufferedImage bufferedImage) throws ImageFormatException, IOException {
        this.header.width = bufferedImage.getWidth();
        this.header.height = bufferedImage.getHeight();
        this.header.bitDepth = (byte)8;
        this.header.colorType = (byte)(bufferedImage.getType() == 13 ? 3 : 2);
        this.header.compressMethod = 0;
        this.header.filterMethod = 0;
        this.header.interlaceMethod = 0;
        this.writeSignature();
        this.writeChunk(this.createHeaderChunk(bufferedImage));
        if (this.header.colorType == 3) {
            this.writeChunk(this.createPaletteChunk(bufferedImage));
            if (bufferedImage.getColorModel().hasAlpha()) {
                this.writeChunk(this.createTransChunk(bufferedImage));
            }
        }
        this.writeChunk(this.createDataChunk(bufferedImage));
        this.writeChunk(this.createEndChunk());
    }

    private void writeSignature() throws IOException {
        byte[] byArray = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
        this.output.write(byArray);
    }

    private void writeChunk(Chunk chunk) throws IOException {
        int n = chunk.getData() == null ? 4 : 4 + chunk.getData().length;
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[4];
        Util.IntToByte(byArray2, chunk.getLength(), 0);
        this.output.write(byArray2);
        Util.IntToByte(byArray2, chunk.getType(), 0);
        this.output.write(byArray2);
        for (int i = 0; i < 4; ++i) {
            byArray[i] = byArray2[i];
        }
        if (chunk.getData() != null) {
            byte[] byArray3 = chunk.getData();
            this.output.write(byArray3);
            for (int i = 0; i < byArray3.length; ++i) {
                byArray[4 + i] = byArray3[i];
            }
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray);
        Util.IntToByte(byArray2, (int)cRC32.getValue(), 0);
        this.output.write(byArray2);
    }

    private Chunk createHeaderChunk(BufferedImage bufferedImage) {
        byte[] byArray = new byte[13];
        Util.IntToByte(byArray, this.header.width, 0);
        Util.IntToByte(byArray, this.header.height, 4);
        byArray[8] = this.header.bitDepth;
        byArray[9] = this.header.colorType;
        byArray[10] = this.header.compressMethod;
        byArray[11] = this.header.filterMethod;
        byArray[12] = this.header.interlaceMethod;
        return new Chunk(byArray.length, 1229472850, byArray, 0);
    }

    public Chunk createPaletteChunk(BufferedImage bufferedImage) {
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        int n = indexColorModel.getMapSize();
        byte[] byArray = new byte[n];
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[n];
        indexColorModel.getReds(byArray);
        indexColorModel.getGreens(byArray2);
        indexColorModel.getBlues(byArray3);
        byte[] byArray4 = new byte[n * 3];
        for (int i = 0; i < n; ++i) {
            byArray4[i * 3] = byArray[i];
            byArray4[i * 3 + 1] = byArray2[i];
            byArray4[i * 3 + 2] = byArray3[i];
        }
        return new Chunk(byArray4.length, 1347179589, byArray4, 0);
    }

    public Chunk createTransChunk(BufferedImage bufferedImage) {
        int n;
        byte[] byArray;
        IndexColorModel indexColorModel = (IndexColorModel)bufferedImage.getColorModel();
        byte[] byArray2 = new byte[indexColorModel.getMapSize()];
        indexColorModel.getAlphas(byArray2);
        int n2 = indexColorModel.getTransparentPixel();
        if (n2 != -1) {
            byArray = new byte[n2 + 1];
            n = 0;
            while (n != n2) {
                byArray[n++] = -1;
            }
            byArray[n] = 0;
        } else {
            byArray = byArray2;
        }
        System.out.println(n2);
        System.out.println(Integer.toHexString(indexColorModel.getRGB(0)));
        if (n2 >= 0) {
            System.out.println(Integer.toHexString(indexColorModel.getRGB(n2)));
        }
        for (n = 0; n < byArray.length; ++n) {
            System.out.print(Integer.toHexString(byArray[n]) + " ");
        }
        return new Chunk(byArray.length, 1951551059, byArray, 0);
    }

    private Chunk createEndChunk() {
        return new Chunk(0, 1229278788, null, 0);
    }

    public Chunk createDataChunk(BufferedImage bufferedImage) throws IOException {
        int n = bufferedImage.getSampleModel().getNumBands();
        int[] nArray = new int[5];
        byte[] byArray = new byte[this.header.width * n];
        byte[] byArray2 = new byte[byArray.length];
        byte[] byArray3 = new byte[this.header.width * n + 1];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
        WritableRaster writableRaster = bufferedImage.getRaster();
        Arrays.fill(byArray2, (byte)0);
        for (int i = 0; i < bufferedImage.getHeight(); ++i) {
            int n2;
            int n3;
            int n4;
            int[] nArray2 = new int[n];
            for (n4 = 0; n4 <= byArray.length - n; n4 += n) {
                writableRaster.getPixel(n4 / n, this.currentY, nArray2);
                for (n3 = 0; n3 < n; ++n3) {
                    byArray[n4 + n3] = (byte)(0xFF & nArray2[n3]);
                }
            }
            byArray3 = FilterType0.filter(byArray, byArray2);
            for (n4 = 1; n4 < byArray3.length; ++n4) {
                nArray[0] = nArray[0] + Math.abs(byArray3[n4]);
            }
            byArray3 = FilterType1.filter(byArray, byArray2);
            for (n4 = 1; n4 < byArray3.length; ++n4) {
                nArray[1] = nArray[1] + Math.abs(byArray3[n4]);
            }
            byArray3 = FilterType2.filter(byArray, byArray2);
            for (n4 = 1; n4 < byArray3.length; ++n4) {
                nArray[2] = nArray[2] + Math.abs(byArray3[n4]);
            }
            byArray3 = FilterType3.filter(byArray, byArray2);
            for (n4 = 1; n4 < byArray3.length; ++n4) {
                nArray[3] = nArray[3] + Math.abs(byArray3[n4]);
            }
            byArray3 = FilterType4.filter(byArray, byArray2);
            for (n4 = 1; n4 < byArray3.length; ++n4) {
                nArray[4] = nArray[4] + Math.abs(byArray3[n4]);
            }
            n4 = 0;
            n3 = nArray[0];
            for (n2 = 1; n2 < 5; ++n2) {
                if (nArray[n2] >= n3) continue;
                n3 = nArray[n2];
                n4 = n2;
            }
            if (this.header.colorType == 3) {
                n4 = 0;
            }
            switch (n4) {
                case 0: {
                    byArray3 = FilterType0.filter(byArray, byArray2);
                    break;
                }
                case 1: {
                    byArray3 = FilterType1.filter(byArray, byArray2);
                    break;
                }
                case 2: {
                    byArray3 = FilterType2.filter(byArray, byArray2);
                    break;
                }
                case 3: {
                    byArray3 = FilterType3.filter(byArray, byArray2);
                    break;
                }
                case 4: {
                    byArray3 = FilterType4.filter(byArray, byArray2);
                }
            }
            for (n2 = 0; n2 < byArray.length; ++n2) {
                byArray2[n2] = byArray[n2];
            }
            deflaterOutputStream.write(byArray3, 0, byArray3.length);
            ++this.currentY;
        }
        deflaterOutputStream.close();
        byte[] byArray4 = byteArrayOutputStream.toByteArray();
        return new Chunk(byArray4.length, 1229209940, byArray4, 0);
    }

    private class Header {
        public int width = 0;
        public int height = 0;
        public byte bitDepth = 0;
        public byte colorType = 0;
        public byte compressMethod = 0;
        public byte filterMethod = 0;
        public byte interlaceMethod = 0;

        private Header() {
        }
    }
}

