/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.raster.codec.png;

import com.tridium.raster.codec.png.Chunk;
import com.tridium.raster.codec.png.FilterType0;
import com.tridium.raster.codec.png.FilterType1;
import com.tridium.raster.codec.png.FilterType2;
import com.tridium.raster.codec.png.FilterType3;
import com.tridium.raster.codec.png.FilterType4;
import com.tridium.raster.codec.png.ImageFormatException;
import com.tridium.raster.codec.png.Util;
import java.awt.image.BufferedImage;
import java.awt.image.IndexColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.zip.CRC32;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGImageDecoder {
    private static final int COLOR_TYPE_PALETTED = 3;
    private InputStream source;
    private Header header = new Header();
    private int currentY = 0;

    public PNGImageDecoder(InputStream inputStream) {
        this.source = inputStream;
    }

    public BufferedImage decode() throws ImageFormatException, IOException {
        BufferedImage bufferedImage = null;
        Chunk chunk = null;
        Chunk chunk2 = null;
        if (!this.isSignatureValid()) {
            throw new ImageFormatException("Invalid signature");
        }
        Chunk chunk3 = this.readChunk();
        if (chunk3.getType() != 1229472850) {
            throw new ImageFormatException("No IHDR chunk");
        }
        this.getHeaderParams(chunk3.getData());
        chunk3 = this.readChunk();
        while (chunk3.getType() != 1229278788) {
            if (chunk3.getType() == 1347179589) {
                chunk = chunk3;
            } else if (chunk3.getType() == 1951551059) {
                chunk2 = chunk3;
            } else if (chunk3.getType() == 1229209940) {
                if (this.header.colorType == 3) {
                    IndexColorModel indexColorModel = this.loadPalette(chunk, chunk2);
                    bufferedImage = new BufferedImage(this.header.width, this.header.height, 13, indexColorModel);
                } else {
                    bufferedImage = new BufferedImage(this.header.width, this.header.height, 1);
                }
                this.appendDataToImage(bufferedImage, chunk3.getData());
            } else if (chunk3.isCritical()) {
                throw new ImageFormatException("Unknown critical chunk");
            }
            chunk3 = this.readChunk();
        }
        return bufferedImage;
    }

    private boolean isSignatureValid() throws IOException {
        int[] nArray = new int[]{137, 80, 78, 71, 13, 10, 26, 10};
        byte[] byArray = new byte[nArray.length];
        this.source.read(byArray, 0, nArray.length);
        for (int i = 0; i < nArray.length; ++i) {
            if ((0xFF & byArray[i]) == nArray[i]) continue;
            return false;
        }
        return true;
    }

    private Chunk readChunk() throws IOException {
        byte[] byArray = new byte[4];
        this.source.read(byArray, 0, 4);
        int n = Util.BytesToInt(0, byArray);
        this.source.read(byArray, 0, 4);
        int n2 = Util.BytesToInt(0, byArray);
        byte[] byArray2 = new byte[n];
        this.source.read(byArray2, 0, n);
        this.source.read(byArray, 0, 4);
        int n3 = Util.BytesToInt(0, byArray);
        byte[] byArray3 = new byte[4 + n];
        Util.IntToByte(byArray3, n2, 0);
        for (int i = 0; i < n; ++i) {
            byArray3[4 + i] = byArray2[i];
        }
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray3);
        if ((int)cRC32.getValue() != n3) {
            throw new ImageFormatException("CRC corruption in: ChunkType: " + n2);
        }
        return new Chunk(n, n2, byArray2, n3);
    }

    private void getHeaderParams(byte[] byArray) {
        this.header.width = Util.BytesToInt(0, byArray);
        this.header.height = Util.BytesToInt(4, byArray);
        this.header.bitDepth = 0xFF & byArray[8];
        this.header.colorType = 0xFF & byArray[9];
        this.header.compressMethod = 0xFF & byArray[10];
        this.header.filterMethod = 0xFF & byArray[11];
        this.header.interlaceMethod = 0xFF & byArray[12];
    }

    public IndexColorModel loadPalette(Chunk chunk, Chunk chunk2) {
        int n;
        if (chunk.getLength() % 3 != 0) {
            throw new ImageFormatException("Invalid PLTE length (not divisible by 3):" + chunk.getLength());
        }
        byte[] byArray = chunk.getData();
        int n2 = chunk.getLength() / 3;
        byte[] byArray2 = chunk2 == null ? null : chunk2.getData();
        int n3 = chunk2 == null ? 0 : chunk2.getLength();
        int n4 = -1;
        byte[] byArray3 = new byte[n2];
        byte[] byArray4 = new byte[n2];
        byte[] byArray5 = new byte[n2];
        byte[] byArray6 = new byte[n2];
        Arrays.fill(byArray3, (byte)-1);
        for (n = 0; n < n2; ++n) {
            if (byArray2 != null && n < n3) {
                byArray3[n] = byArray2[n];
            }
            byArray4[n] = byArray[n * 3];
            byArray5[n] = byArray[n * 3 + 1];
            byArray6[n] = byArray[n * 3 + 2];
        }
        for (n = 0; n < n3; ++n) {
            if (byArray2[n] == 255 || n4 != -1) continue;
            if (byArray2[n] == 0) {
                n4 = n;
                continue;
            }
            n4 = -1;
            break;
        }
        if (byArray2 == null) {
            return new IndexColorModel(8, n2, byArray4, byArray5, byArray6);
        }
        if (n4 != -1) {
            return new IndexColorModel(8, n2, byArray4, byArray5, byArray6, n4);
        }
        return new IndexColorModel(8, n2, byArray4, byArray5, byArray6, byArray3);
    }

    public void appendDataToImage(BufferedImage bufferedImage, byte[] byArray) {
        Object object;
        int n = this.header.colorType == 3 ? 1 : 3;
        byte[] byArray2 = new byte[this.header.width * n + 1];
        byte[] byArray3 = new byte[this.header.width * n];
        byte[] byArray4 = new byte[(this.header.width * n + 1) * this.header.height];
        try {
            object = new Inflater();
            ((Inflater)object).setInput(byArray);
            ((Inflater)object).inflate(byArray4);
        }
        catch (DataFormatException dataFormatException) {
            throw new ImageFormatException("Corrupt image data; " + dataFormatException);
        }
        object = bufferedImage.getRaster();
        Arrays.fill(byArray3, (byte)0);
        for (int i = 0; i < byArray4.length; i += this.header.width * n + 1) {
            int n2;
            for (n2 = 0; n2 < byArray2.length; ++n2) {
                byArray2[n2] = byArray4[i + n2];
            }
            if (byArray2[0] == 0) {
                byArray3 = FilterType0.reverseFilter(byArray2, byArray3);
            } else if (byArray2[0] == 1) {
                byArray3 = FilterType1.reverseFilter(byArray2, byArray3);
            } else if (byArray2[0] == 2) {
                byArray3 = FilterType2.reverseFilter(byArray2, byArray3);
            } else if (byArray2[0] == 3) {
                byArray3 = FilterType3.reverseFilter(byArray2, byArray3);
            } else if (byArray2[0] == 4) {
                byArray3 = FilterType4.reverseFilter(byArray2, byArray3);
            } else {
                throw new ImageFormatException("Unknown filter type: " + byArray2[0]);
            }
            for (n2 = 0; n2 < byArray2.length - n; n2 += n) {
                int[] nArray;
                if (this.header.colorType == 3) {
                    nArray = new int[]{byArray3[n2]};
                    ((WritableRaster)object).setPixel(n2, this.currentY, nArray);
                    continue;
                }
                nArray = new int[]{byArray3[n2], byArray3[n2 + 1], byArray3[n2 + 2]};
                ((WritableRaster)object).setPixel(n2 / 3, this.currentY, nArray);
            }
            ++this.currentY;
        }
    }

    private class Header {
        public int width = 0;
        public int height = 0;
        public int bitDepth = 0;
        public int colorType = 0;
        public int compressMethod = 0;
        public int filterMethod = 0;
        public int interlaceMethod = 0;

        private Header() {
        }
    }
}

