/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import java.io.IOException;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BDeviceStepDetails;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.batchJob.driver.DeviceNetworkJobOp;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.log.Log;
import javax.baja.naming.SlotPath;
import javax.baja.sys.Action;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.Array;
import javax.baja.util.BFolder;

public class BForEachDeviceStage
extends BJobStage {
    public static final Property steps = BForEachDeviceStage.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property deviceStates = BForEachDeviceStage.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Action cancelDevice = BForEachDeviceStage.newAction((int)4, (BValue)BString.DEFAULT, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$driver$BForEachDeviceStage == null ? (class$javax$baja$batchJob$driver$BForEachDeviceStage = BForEachDeviceStage.class$("javax.baja.batchJob.driver.BForEachDeviceStage")) : class$javax$baja$batchJob$driver$BForEachDeviceStage));
    static /* synthetic */ Class class$javax$baja$batchJob$driver$BForEachDeviceStage;
    static /* synthetic */ Class class$javax$baja$batchJob$driver$BDeviceJobStep;

    public BFolder getSteps() {
        return (BFolder)this.get(steps);
    }

    public void setSteps(BFolder bFolder) {
        this.set(steps, (BValue)bFolder, null);
    }

    public BFolder getDeviceStates() {
        return (BFolder)this.get(deviceStates);
    }

    public void setDeviceStates(BFolder bFolder) {
        this.set(deviceStates, (BValue)bFolder, null);
    }

    public void cancelDevice(BSimple bSimple) {
        this.invoke(cancelDevice, (BValue)bSimple, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BForEachDeviceStage() {
    }

    public BForEachDeviceStage(String string) {
        super(string);
    }

    public BJobState getDeviceState(BSimple bSimple) {
        try {
            String string = SlotPath.escape((String)bSimple.encodeToString());
            Property property = this.getDeviceStates().getProperty(string);
            return property == null ? BJobState.unknown : (BJobState)this.getDeviceStates().get(property);
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public BJobState getDeviceState(BDevice bDevice) {
        return this.getDeviceState(this.getDeviceId(bDevice));
    }

    protected BSimple getDeviceId(BDevice bDevice) {
        return BNetworkBatchAgent.get(this.getNetwork(), null).getBatchDeviceId(bDevice);
    }

    public void setDeviceState(BDevice bDevice, BJobState bJobState) {
        this.setDeviceState(this.getDeviceId(bDevice), bJobState);
    }

    public void setDeviceState(BSimple bSimple, BJobState bJobState) {
        try {
            String string = SlotPath.escape((String)bSimple.encodeToString());
            Property property = this.getDeviceStates().getProperty(string);
            if (property == null) {
                this.getDeviceStates().add(string, (BValue)bJobState);
            } else {
                this.getDeviceStates().set(property, (BValue)bJobState);
            }
        }
        catch (IOException iOException) {
            throw new BajaRuntimeException((Throwable)iOException);
        }
    }

    public BDevice[] getDevices() {
        return ((BDeviceNetworkJob)this.getJob()).getDevices();
    }

    public BDeviceNetwork getNetwork() {
        return ((BDeviceNetworkJob)this.getJob()).getNetwork();
    }

    public BJobState doRun(BBatchJobService bBatchJobService, BBatchJob bBatchJob, BatchJobOp batchJobOp) {
        int n;
        DeviceNetworkJobOp deviceNetworkJobOp = (DeviceNetworkJobOp)batchJobOp;
        BDeviceJobStep[] bDeviceJobStepArray = this.getCombinedSteps(deviceNetworkJobOp);
        BDevice[] bDeviceArray = this.getDevices();
        boolean bl = false;
        boolean bl2 = false;
        for (n = 0; n < bDeviceJobStepArray.length; ++n) {
            try {
                bDeviceJobStepArray[n].doInit(bBatchJobService, deviceNetworkJobOp);
                continue;
            }
            catch (Exception exception) {
                this.getJob().log().failed("batchJob", "ForEachDeviceStage.initializationFailed", (Throwable)exception);
                return BJobState.failed;
            }
        }
        for (n = 0; n < bDeviceArray.length; ++n) {
            BDevice bDevice = bDeviceArray[n];
            if (deviceNetworkJobOp.deviceFailed(bDevice)) continue;
            BJobState bJobState = BJobState.running;
            this.setDeviceState(bDevice, bJobState);
            this.getJob().log().message("batchJob", "ForEachDeviceStage.processingDevice", bDevice.getDisplayName(null));
            for (int i = 0; i < bDeviceJobStepArray.length; ++i) {
                BDeviceStepDetails bDeviceStepDetails = bDeviceJobStepArray[i].run(bBatchJobService, bDevice, deviceNetworkJobOp);
                bJobState = bDeviceStepDetails.getState();
                if (bJobState == BJobState.failed) {
                    this.stepComplete(bBatchJobService, bDeviceStepDetails, deviceNetworkJobOp);
                    deviceNetworkJobOp.setDeviceFailed(bDevice);
                    bl = true;
                    break;
                }
                if (bJobState == BJobState.canceled || bJobState == BJobState.canceling) {
                    if (bJobState == BJobState.canceling) {
                        bJobState = BJobState.canceled;
                        bDeviceStepDetails.setState(bJobState);
                    }
                    deviceNetworkJobOp.setDeviceFailed(bDevice);
                    this.stepComplete(bBatchJobService, bDeviceStepDetails, deviceNetworkJobOp);
                    bl2 = true;
                    break;
                }
                this.stepComplete(bBatchJobService, bDeviceStepDetails, deviceNetworkJobOp);
            }
            this.setDeviceState(bDevice, bJobState);
        }
        for (n = 0; n < bDeviceJobStepArray.length; ++n) {
            try {
                bDeviceJobStepArray[n].jobComplete(deviceNetworkJobOp);
                continue;
            }
            catch (Exception exception) {
                this.getJob().log().failed("batchJob", "ForEachDeviceStage.cleanupFailed", (Throwable)exception);
            }
        }
        if (bl) {
            return BJobState.failed;
        }
        if (bl2) {
            return BJobState.canceled;
        }
        return BJobState.success;
    }

    public void addStep(BJobStep bJobStep) {
        this.getSteps().add("step?", (BValue)((BDeviceJobStep)bJobStep));
    }

    public void removeAllSteps() {
        this.getSteps().removeAll();
    }

    public BJobStep[] getAllSteps() {
        Array array = new Array(class$javax$baja$batchJob$driver$BDeviceJobStep == null ? (class$javax$baja$batchJob$driver$BDeviceJobStep = BForEachDeviceStage.class$("javax.baja.batchJob.driver.BDeviceJobStep")) : class$javax$baja$batchJob$driver$BDeviceJobStep);
        SlotCursor slotCursor = this.getSteps().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$driver$BDeviceJobStep == null ? BForEachDeviceStage.class$("javax.baja.batchJob.driver.BDeviceJobStep") : class$javax$baja$batchJob$driver$BDeviceJobStep)) {
            array.add((Object)slotCursor.get());
        }
        return (BDeviceJobStep[])array.trim();
    }

    protected BDeviceJobStep[] getCombinedSteps(DeviceNetworkJobOp deviceNetworkJobOp) {
        Array array = new Array(class$javax$baja$batchJob$driver$BDeviceJobStep == null ? (class$javax$baja$batchJob$driver$BDeviceJobStep = BForEachDeviceStage.class$("javax.baja.batchJob.driver.BDeviceJobStep")) : class$javax$baja$batchJob$driver$BDeviceJobStep);
        BDeviceJobStep bDeviceJobStep = null;
        SlotCursor slotCursor = this.getSteps().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$driver$BDeviceJobStep == null ? BForEachDeviceStage.class$("javax.baja.batchJob.driver.BDeviceJobStep") : class$javax$baja$batchJob$driver$BDeviceJobStep)) {
            BDeviceJobStep bDeviceJobStep2 = (BDeviceJobStep)slotCursor.get();
            if (bDeviceJobStep != null && bDeviceJobStep.canCombine(bDeviceJobStep2) && bDeviceJobStep2.canCombine(bDeviceJobStep2)) {
                bDeviceJobStep.combine(bDeviceJobStep2);
                continue;
            }
            array.add((Object)bDeviceJobStep2);
            bDeviceJobStep = bDeviceJobStep2;
        }
        return (BDeviceJobStep[])array.trim();
    }

    public void prepareStage(BObject bObject) throws Exception {
        SlotCursor slotCursor = this.getSteps().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$driver$BDeviceJobStep == null ? BForEachDeviceStage.class$("javax.baja.batchJob.driver.BDeviceJobStep") : class$javax$baja$batchJob$driver$BDeviceJobStep)) {
            ((BDeviceJobStep)slotCursor.get()).prepareStep(bObject);
        }
    }

    protected void stepComplete(BBatchJobService bBatchJobService, BDeviceStepDetails bDeviceStepDetails, DeviceNetworkJobOp deviceNetworkJobOp) {
        bDeviceStepDetails.getStep().stepComplete(bDeviceStepDetails, deviceNetworkJobOp);
        try {
            BBatchJobStepLogFile bBatchJobStepLogFile = BBatchJobStepLogFile.create(bDeviceStepDetails, this.getJob().getStartTime());
            if ((bDeviceStepDetails.getState() == BJobState.failed || bDeviceStepDetails.getState() == BJobState.canceled) && this.getJob().getAlertOnStepFailure()) {
                bBatchJobService.newAlert(bDeviceStepDetails.getFailureAlarmMessage(null), bBatchJobStepLogFile.getOrdInSession());
            }
            bDeviceStepDetails.resetLog();
        }
        catch (Exception exception) {
            Log.getLog((String)"batchJob").error("error persisting job step", (Throwable)exception);
        }
    }

    protected final synchronized boolean isCanceled(BSimple bSimple) {
        if (this.getJob().isCanceled()) {
            return true;
        }
        BJobState bJobState = this.getDeviceState(bSimple);
        return bJobState == BJobState.canceling || bJobState == BJobState.canceled;
    }

    protected final synchronized void checkCanceled(BSimple bSimple) {
        this.getJob().checkCanceled();
        BJobState bJobState = this.getDeviceState(bSimple);
        if (bJobState == BJobState.canceling || bJobState == BJobState.canceled) {
            throw new JobCancelException();
        }
    }

    public void doDispose(Context context) {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        BJobStepDetails[] bJobStepDetailsArray = this.getJobStepDetails();
        for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
            try {
                bJobStepDetailsArray[i].dispose();
                continue;
            }
            catch (Exception exception) {
                Log.getLog((String)"batchJob").error("Error disposing step record", (Throwable)exception);
            }
        }
    }

    public void doCancelDevice(BSimple bSimple, Context context) {
        if (this.getJob().getJobState().isRunning()) {
            BJobState bJobState = this.getDeviceState(bSimple);
            if (bJobState.isRunning()) {
                this.setDeviceState(bSimple, BJobState.canceling);
            } else if (bJobState != BJobState.success && bJobState != BJobState.failed) {
                this.setDeviceState(bSimple, BJobState.canceled);
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

