/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob.driver;

import com.tridium.batchJob.BBatchJobStepLogFile;
import java.io.IOException;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.driver.BDeviceJobStep;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BForEachDeviceStage;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.driver.BDevice;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.log.Log;
import javax.baja.naming.UnresolvedException;
import javax.baja.platform.ICancelHint;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.BTypeSpec;

public class BDeviceStepDetails
extends BJobStepDetails
implements ICancelHint {
    public static final Property deviceId = BDeviceStepDetails.newProperty((int)1, (BValue)BString.DEFAULT, null);
    public static final Property deviceType = BDeviceStepDetails.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property deviceDisplayName = BDeviceStepDetails.newProperty((int)1, (String)"", null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$driver$BDeviceStepDetails == null ? (class$javax$baja$batchJob$driver$BDeviceStepDetails = BDeviceStepDetails.class$("javax.baja.batchJob.driver.BDeviceStepDetails")) : class$javax$baja$batchJob$driver$BDeviceStepDetails));
    private BBatchJobStepLogFile logFile = null;
    static /* synthetic */ Class class$javax$baja$batchJob$driver$BDeviceStepDetails;

    public BSimple getDeviceId() {
        return (BSimple)this.get(deviceId);
    }

    public void setDeviceId(BSimple bSimple) {
        this.set(deviceId, (BValue)bSimple, null);
    }

    public BTypeSpec getDeviceType() {
        return (BTypeSpec)this.get(deviceType);
    }

    public void setDeviceType(BTypeSpec bTypeSpec) {
        this.set(deviceType, (BValue)bTypeSpec, null);
    }

    public String getDeviceDisplayName() {
        return this.getString(deviceDisplayName);
    }

    public void setDeviceDisplayName(String string) {
        this.setString(deviceDisplayName, string, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDeviceStepDetails() {
    }

    public BDeviceStepDetails(BDevice bDevice, BDeviceJobStep bDeviceJobStep) {
        super(bDeviceJobStep);
        this.setDevice(bDevice);
        this.setStepType(bDeviceJobStep.getType().getTypeSpec());
        this.setStartTime(BAbsTime.now());
        this.setStepDescription(bDeviceJobStep.toString(null));
        this.setStageName(bDeviceJobStep.getStage().getStageName());
        this.setDeviceDisplayName(bDevice.getDisplayName(null));
        this.step = bDeviceJobStep;
        this.log = new JobLog();
    }

    public void setDevice(BDevice bDevice) {
        this.setDeviceId(BNetworkBatchAgent.get(bDevice.getNetwork(), null).getBatchDeviceId(bDevice));
        this.setDeviceType(bDevice.getType().getTypeSpec());
    }

    public BDevice getDevice() {
        if (this.getStage() == null) {
            return null;
        }
        return BNetworkBatchAgent.get(this.getForEachDeviceStage().getNetwork(), null).getBatchDevice(this.getForEachDeviceStage().getNetwork(), this.getDeviceId());
    }

    public BForEachDeviceStage getForEachDeviceStage() {
        return (BForEachDeviceStage)this.getStage();
    }

    public BForEachDeviceStage getForEachDeviceStage(BDeviceNetworkJob bDeviceNetworkJob) {
        return (BForEachDeviceStage)this.getStage(bDeviceNetworkJob);
    }

    public void doCancel() {
        BJobState bJobState = this.getState();
        if (bJobState.isRunning()) {
            this.setState(BJobState.canceling);
            this.getForEachDeviceStage().cancelDevice(this.getDeviceId());
        } else if (bJobState != BJobState.success && bJobState != BJobState.failed) {
            this.setState(BJobState.canceled);
            this.getForEachDeviceStage().cancelDevice(this.getDeviceId());
        }
    }

    public void doDispose() throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of supervisor vm");
        }
        super.doDispose();
        try {
            BBatchJobStepLogFile bBatchJobStepLogFile = BBatchJobStepLogFile.find(this, null);
            try {
                Log.getLog((String)"batchJob").trace("Deleting log file " + bBatchJobStepLogFile.getFilePath().getBody());
                bBatchJobStepLogFile.delete();
            }
            catch (IOException iOException) {
                Log.getLog((String)"batchJob").error("Error deleting log file " + bBatchJobStepLogFile.getFilePath().getBody(), (Throwable)iOException);
            }
        }
        catch (UnresolvedException unresolvedException) {
            unresolvedException.printStackTrace();
            Log.getLog((String)"batchJob").trace("Log file not found", (Throwable)unresolvedException);
        }
    }

    public void success() {
        this.success("batchJob", "DeviceStepDetails.stepCompleted", new String[]{this.getDeviceId().toString()});
        this.complete(BJobState.success);
    }

    public void failed(Throwable throwable) {
        this.failed("batchJob", "DeviceStepDetails.stepFailed", new String[]{this.getStepDescription(), this.getDeviceId().toString()}, throwable);
        this.complete(BJobState.failed);
    }

    public void setLogFile(BIFile bIFile) {
        this.logFile = (BBatchJobStepLogFile)bIFile;
    }

    public BIFile getLogFile() {
        if (this.logFile == null) {
            this.logFile = BBatchJobStepLogFile.find(this, null);
        }
        return this.logFile;
    }

    public BIFile findLogFile(BObject bObject) throws Exception {
        return BBatchJobStepLogFile.find(this.getStepType(), this.getLocalStartTime(), bObject);
    }

    public BString doReadLog() {
        if (this.log == null) {
            BBatchJobStepLogFile bBatchJobStepLogFile = this.logFile;
            if (bBatchJobStepLogFile == null) {
                bBatchJobStepLogFile = (BBatchJobStepLogFile)this.getLogFile();
            }
            if (bBatchJobStepLogFile == null) {
                return BString.DEFAULT;
            }
            try {
                return bBatchJobStepLogFile.getLogContents();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException();
            }
        }
        return BString.make((String)this.log.encode());
    }

    public boolean isCanceled() {
        return this.getForEachDeviceStage().isCanceled(this.getDeviceId());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

