/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import com.tridium.batchJob.BLocalTimeUtil;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStep;
import javax.baja.file.BIFile;
import javax.baja.job.BJobState;
import javax.baja.job.JobLog;
import javax.baja.job.JobLogItem;
import javax.baja.naming.BOrd;
import javax.baja.sys.Action;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public abstract class BJobStepDetails
extends BComponent {
    public static final Property stageName = BJobStepDetails.newProperty((int)1, (String)"", null);
    public static final Property stepType = BJobStepDetails.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property stepDescription = BJobStepDetails.newProperty((int)1, (String)"", null);
    public static final Property state = BJobStepDetails.newProperty((int)1, (BValue)BJobState.running, null);
    public static final Property startTime = BJobStepDetails.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property endTime = BJobStepDetails.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Action readLog = BJobStepDetails.newAction((int)0, null);
    public static final Action cancel = BJobStepDetails.newAction((int)4, null);
    public static final Action dispose = BJobStepDetails.newAction((int)4, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$BJobStepDetails == null ? (class$javax$baja$batchJob$BJobStepDetails = BJobStepDetails.class$("javax.baja.batchJob.BJobStepDetails")) : class$javax$baja$batchJob$BJobStepDetails));
    protected BJobStep step = null;
    protected JobLog log = null;
    protected BTimeZone startTimeLocalTz = BTimeZone.NULL;
    static /* synthetic */ Class class$javax$baja$batchJob$BJobStepDetails;

    public String getStageName() {
        return this.getString(stageName);
    }

    public void setStageName(String string) {
        this.setString(stageName, string, null);
    }

    public BTypeSpec getStepType() {
        return (BTypeSpec)this.get(stepType);
    }

    public void setStepType(BTypeSpec bTypeSpec) {
        this.set(stepType, (BValue)bTypeSpec, null);
    }

    public String getStepDescription() {
        return this.getString(stepDescription);
    }

    public void setStepDescription(String string) {
        this.setString(stepDescription, string, null);
    }

    public BJobState getState() {
        return (BJobState)this.get(state);
    }

    public void setState(BJobState bJobState) {
        this.set(state, (BValue)bJobState, null);
    }

    public BAbsTime getStartTime() {
        return (BAbsTime)this.get(startTime);
    }

    public void setStartTime(BAbsTime bAbsTime) {
        this.set(startTime, (BValue)bAbsTime, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime bAbsTime) {
        this.set(endTime, (BValue)bAbsTime, null);
    }

    public BString readLog() {
        return (BString)this.invoke(readLog, null, null);
    }

    public void cancel() {
        this.invoke(cancel, null, null);
    }

    public void dispose() {
        this.invoke(dispose, null, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BJobStepDetails() {
    }

    public BJobStepDetails(BJobStep bJobStep) {
        this.setStepType(bJobStep.getType().getTypeSpec());
        this.setStartTime(BAbsTime.now());
        this.setStepDescription(bJobStep.toString(null));
        this.setStageName(bJobStep.getStage().getStageName());
        this.step = bJobStep;
        this.log = new JobLog();
    }

    public BJobStep getStep() {
        return this.step;
    }

    public BBatchJob getJob() {
        return this.step == null ? null : this.step.getJob();
    }

    public BJobStage getStage(BBatchJob bBatchJob) {
        return this.step == null ? bBatchJob.getStage(this.getStageName()) : this.step.getStage();
    }

    public BJobStage getStage() {
        return this.step == null ? null : this.step.getStage();
    }

    public abstract BString doReadLog() throws Exception;

    public abstract void doCancel() throws Exception;

    public void doDispose() throws Exception {
        BBatchJobService bBatchJobService = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        bBatchJobService.getJobSummaryManager().disposeStepSummary(this.getStepType().getResolvedType(), this.getStartTime());
    }

    public void success() {
        this.success("batchJob", "JobStepDetails.success");
        this.complete(BJobState.success);
    }

    public void failed(Throwable throwable) {
        this.failed("batchJob", "JobStepDetails.failed", this.getStepDescription(), throwable);
        this.complete(BJobState.failed);
    }

    public void canceled() {
        this.complete(BJobState.canceled);
    }

    public void complete(BJobState bJobState) {
        if (!bJobState.isComplete()) {
            throw new IllegalArgumentException("Cannot complete as " + bJobState);
        }
        this.setState(bJobState);
        this.setEndTime(Clock.time());
        try {
            BBatchJobService bBatchJobService = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
            bBatchJobService.getJobSummaryManager().write(bBatchJobService.getJobSummaryManager().makeStepSummary(this, this.getJob().getStartTime()));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public abstract void setLogFile(BIFile var1);

    public abstract BIFile getLogFile();

    public abstract BIFile findLogFile(BObject var1) throws Exception;

    public void start(String string) {
        this.log.start(string);
        this.getJob().log().start(string);
    }

    public void start(String string, String string2, String[] stringArray) {
        this.log.start(string, string2, stringArray);
        this.getJob().log().start(string, string2, stringArray);
    }

    public void start(String string, String string2, String string3) {
        this.log.start(string, string2, new String[]{string3});
        this.getJob().log().start(string, string2, new String[]{string3});
    }

    public void start(String string, String string2) {
        this.log.start(string, string2, null);
        this.getJob().log().start(string, string2, null);
    }

    public void endSuccess(String string) {
        this.log.endSuccess(string);
        this.getJob().log().endSuccess(string);
    }

    public void endSuccess(String string, String string2, String[] stringArray) {
        this.log.endSuccess(string, string2, stringArray);
        this.getJob().log().endSuccess(string, string2, stringArray);
    }

    public void endSuccess() {
        this.log.endSuccess();
        this.getJob().log().endSuccess();
    }

    public void endFailed(String string, Throwable throwable) {
        this.log.endFailed(string, throwable);
        this.getJob().log().endFailed(string, throwable);
    }

    public void endFailed(String string, String string2, String[] stringArray, Throwable throwable) {
        this.log.endFailed(string, string2, stringArray, throwable);
        this.getJob().log().endFailed(string, string2, stringArray, throwable);
    }

    public void endFailed(Throwable throwable) {
        this.log.endFailed(throwable);
        this.getJob().log().endFailed(throwable);
    }

    public void endFailed(String string) {
        this.log.endFailed(string);
        this.getJob().log().endFailed(string);
    }

    public void endFailed(String string, String string2, String[] stringArray) {
        this.log.endFailed(string, string2, stringArray);
        this.getJob().log().endFailed(string, string2, stringArray);
    }

    public void end(int n, String string, Throwable throwable) {
        this.log.end(n, string, throwable);
        this.getJob().log().end(n, string, throwable);
    }

    public void end(int n, String string, String string2, String[] stringArray, Throwable throwable) {
        this.log.end(n, string, string2, stringArray, throwable);
        this.getJob().log().end(n, string, string2, stringArray, throwable);
    }

    public void message(String string) {
        this.log.message(string);
        this.getJob().log().message(string);
    }

    public void message(String string, String string2, String[] stringArray) {
        this.log.message(string, string2, stringArray);
        this.getJob().log().message(string, string2, stringArray);
    }

    public void message(String string, String string2, String string3) {
        this.log.message(string, string2, string3);
        this.getJob().log().message(string, string2, string3);
    }

    public void message(String string, String string2) {
        this.log.message(string, string2);
        this.getJob().log().message(string, string2);
    }

    public void success(String string) {
        this.log.success(string);
        this.getJob().log().success(string);
    }

    public void success(String string, String string2, String[] stringArray) {
        this.log.success(string, string2, stringArray);
        this.getJob().log().success(string, string2, stringArray);
    }

    public void success(String string, String string2, String string3) {
        this.log.success(string, string2, string3);
        this.getJob().log().success(string, string2, string3);
    }

    public void success(String string, String string2) {
        this.log.success(string, string2);
        this.getJob().log().success(string, string2);
    }

    public void failed(String string, Throwable throwable) {
        this.log.failed(string, throwable);
        this.getJob().log().failed(string, throwable);
    }

    public void failed(String string, String string2, String[] stringArray, Throwable throwable) {
        this.log.failed(string, string2, stringArray, throwable);
        this.getJob().log().failed(string, string2, stringArray, throwable);
    }

    public void failed(String string, String string2, String string3, Throwable throwable) {
        this.log.failed(string, string2, string3, throwable);
        this.getJob().log().failed(string, string2, string3, throwable);
    }

    public void failed(String string, String string2, Throwable throwable) {
        this.log.failed(string, string2, throwable);
        this.getJob().log().failed(string, string2, throwable);
    }

    public void failed(String string) {
        this.log.failed(string);
        this.getJob().log().failed(string);
    }

    public void failed(String string, String string2, String[] stringArray) {
        this.log.failed(string, string2, stringArray);
        this.getJob().log().failed(string, string2, stringArray);
    }

    public void failed(String string, String string2, String string3) {
        this.log.failed(string, string2, string3);
        this.getJob().log().failed(string, string2, string3);
    }

    public void failed(String string, String string2) {
        this.log.failed(string, string2);
        this.getJob().log().failed(string, string2);
    }

    public void add(JobLogItem jobLogItem) {
        this.log.add(jobLogItem);
        this.getJob().log().add(jobLogItem);
    }

    public JobLog log() {
        return this.log;
    }

    public void resetLog() {
        this.log = null;
    }

    public String getFailureAlarmMessage() {
        return this.getFailureAlarmMessage(null);
    }

    public String getFailureAlarmMessage(Context context) {
        for (int i = this.log.size(); i > 0; --i) {
            JobLogItem jobLogItem = this.log.getItem(i - 1);
            if (jobLogItem.getId() != 4 && jobLogItem.getId() != 2) continue;
            return jobLogItem.toString(context);
        }
        return "";
    }

    public void setDisplayTimeZone(BTimeZone bTimeZone) {
        if (this.isMounted()) {
            throw new IllegalStateException("cannot call setDisplayTimeZone on mounted details");
        }
        if (bTimeZone == null || bTimeZone.isNull()) {
            throw new IllegalArgumentException("displayTz cannot be null");
        }
        if (this.startTimeLocalTz.isNull()) {
            this.setStartTimeLocalZone(this.getStartTime().getTimeZone());
        }
        BLocalTimeUtil.updateAbsTimeZone(this, startTime, bTimeZone);
        BLocalTimeUtil.updateAbsTimeZone(this, endTime, bTimeZone);
    }

    public void setStartTimeLocalZone(BTimeZone bTimeZone) {
        this.startTimeLocalTz = bTimeZone;
    }

    public BAbsTime getLocalStartTime() {
        if (this.startTimeLocalTz.isNull() && this.getSession() != null) {
            try {
                BComponent bComponent = (BComponent)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)this);
                bComponent.lease();
                this.setStartTimeLocalZone((BTimeZone)bComponent.get("timeZone"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.startTimeLocalTz.isNull()) {
            return this.getStartTime();
        }
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.startTimeLocalTz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

