/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobQueryManager;
import javax.baja.data.BIDataValue;
import javax.baja.file.BIFile;
import javax.baja.naming.BOrd;
import javax.baja.query.util.Predicates;
import javax.baja.retention.BIDomainRetentionPolicy;
import javax.baja.retention.BIRetentionPolicyDomain;
import javax.baja.retention.BPermanentRetentionPolicy;
import javax.baja.retention.BRetentionPolicy;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BRelTime;
import javax.baja.sys.BSimple;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;

public abstract class BBatchJobPrototype
extends BComponent
implements BIRetentionPolicyDomain {
    public static final Property retentionPolicy = BBatchJobPrototype.newProperty((int)0, (BValue)new BPermanentRetentionPolicy(), (BFacets)BFacets.make((String[])new String[]{"fieldEditor", "retainableType", "domainType"}, (BIDataValue[])new BString[]{BString.make((String)"batchJob:RetentionPolicyFE"), BString.make((String)"batchJob:BatchJob"), BString.make((String)"batchJob:BatchJobPrototype")}));
    public static final Property retentionPolicyCheckFrequency = BBatchJobPrototype.newProperty((int)0, (BValue)BRelTime.HOUR, null);
    public static final Property jobPrototype = BBatchJobPrototype.newProperty((int)4, (BValue)new BBatchJob(), null);
    public static final Action submitJob = BBatchJobPrototype.newAction((int)8, null);
    public static final Action enforceRetentionPolicy = BBatchJobPrototype.newAction((int)0, null);
    public static final Topic jobComplete = BBatchJobPrototype.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$BBatchJobPrototype == null ? (class$javax$baja$batchJob$BBatchJobPrototype = BBatchJobPrototype.class$("javax.baja.batchJob.BBatchJobPrototype")) : class$javax$baja$batchJob$BBatchJobPrototype));
    private static final BIcon icon = BIcon.std((String)"gears.png");
    private Clock.Ticket retentionCheckTicket = null;
    private boolean enforcing = false;
    static /* synthetic */ Class class$javax$baja$batchJob$BBatchJobPrototype;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public BRetentionPolicy getRetentionPolicy() {
        return (BRetentionPolicy)this.get(retentionPolicy);
    }

    public void setRetentionPolicy(BRetentionPolicy bRetentionPolicy) {
        this.set(retentionPolicy, (BValue)bRetentionPolicy, null);
    }

    public BRelTime getRetentionPolicyCheckFrequency() {
        return (BRelTime)this.get(retentionPolicyCheckFrequency);
    }

    public void setRetentionPolicyCheckFrequency(BRelTime bRelTime) {
        this.set(retentionPolicyCheckFrequency, (BValue)bRelTime, null);
    }

    public BBatchJob getJobPrototype() {
        return (BBatchJob)this.get(jobPrototype);
    }

    public void setJobPrototype(BBatchJob bBatchJob) {
        this.set(jobPrototype, (BValue)bBatchJob, null);
    }

    public BOrd submitJob() {
        return (BOrd)this.invoke(submitJob, null, null);
    }

    public void enforceRetentionPolicy() {
        this.invoke(enforceRetentionPolicy, null, null);
    }

    public void fireJobComplete(BOrd bOrd) {
        this.fire(jobComplete, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBatchJobPrototype() {
    }

    public BBatchJobPrototype(BBatchJob bBatchJob) {
        this.setJobPrototype(bBatchJob);
    }

    public BBatchJob submit() throws Exception {
        BOrd bOrd = this.submitJob();
        this.getComponentSpace().sync();
        return (BBatchJob)bOrd.get((BObject)this);
    }

    public void jobComplete(BBatchJob bBatchJob, BIFile bIFile) {
        this.enforceRetentionPolicy();
        this.fireJobComplete(bBatchJob.getHandleOrd());
    }

    public Cursor listBatchJobSummaries() {
        try {
            BBatchJobService bBatchJobService = (BBatchJobService)BOrd.make((String)"service:batchJob:BatchJobService").get((BObject)this);
            bBatchJobService.lease(1);
            BIJobQueryManager bIJobQueryManager = bBatchJobService.getJobQueryManager();
            return bIJobQueryManager.listJobSummaries(this.getJobPrototype().getType(), Predicates.eq((String)"prototypeOrd", (BSimple)this.getHandleOrd()), (BObject)this);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BOrd doSubmitJob(Context context) throws Exception {
        BBatchJob bBatchJob = this.createJobInstance(context);
        bBatchJob.submit(context);
        return bBatchJob.getHandleOrd();
    }

    protected BBatchJob createJobInstance(Context context) throws Exception {
        BBatchJob bBatchJob = (BBatchJob)this.getJobPrototype().newCopy();
        bBatchJob.setPrototypeOrd(this.getHandleOrd());
        return bBatchJob;
    }

    public void doEnforceRetentionPolicy() {
        new Thread(){

            public void run() {
                if (BBatchJobPrototype.this.enforcing) {
                    return;
                }
                BBatchJobPrototype.this.enforcing = true;
                try {
                    ((BIDomainRetentionPolicy)((Object)BBatchJobPrototype.this.getRetentionPolicy())).executePolicy(BBatchJobPrototype.this);
                    if (BBatchJobPrototype.this.retentionCheckTicket != null) {
                        BBatchJobPrototype.this.retentionCheckTicket.cancel();
                    }
                    BBatchJobPrototype.this.retentionCheckTicket = Clock.schedule((BComponent)BBatchJobPrototype.this, (BRelTime)BBatchJobPrototype.this.getRetentionPolicyCheckFrequency(), (Action)enforceRetentionPolicy, null);
                }
                finally {
                    BBatchJobPrototype.this.enforcing = false;
                }
            }
        }.start();
    }

    public Cursor getRetainables() {
        return new JobCursor(this.listBatchJobSummaries());
    }

    public void changed(Property property, Context context) {
        if (this.isRunning() && property == retentionPolicyCheckFrequency) {
            if (this.retentionCheckTicket != null) {
                this.retentionCheckTicket.cancel();
            }
            this.retentionCheckTicket = Clock.schedule((BComponent)this, (BRelTime)this.getRetentionPolicyCheckFrequency(), (Action)enforceRetentionPolicy, null);
        }
        super.changed(property, context);
    }

    public void atSteadyState() throws Exception {
        this.enforceRetentionPolicy();
    }

    public BIcon getIcon() {
        return icon;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class JobCursor
    implements Cursor {
        private BBatchJob job = null;
        private Cursor historyCursor;

        public JobCursor(Cursor cursor) {
            this.historyCursor = cursor;
        }

        public Context getContext() {
            return null;
        }

        public boolean next() {
            this.job = null;
            return this.historyCursor.next();
        }

        public boolean nextComponent() {
            return this.next(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BBatchJobPrototype.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        }

        public boolean next(Class clazz) {
            while (this.next()) {
                if (!clazz.isAssignableFrom(this.get().getClass())) continue;
                return true;
            }
            return false;
        }

        public BObject get() {
            if (this.job == null) {
                BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)this.historyCursor.get();
                try {
                    this.job = bIBatchJobSummary.getJob((BObject)BBatchJobPrototype.this);
                }
                catch (RuntimeException runtimeException) {
                    throw runtimeException;
                }
                catch (Exception exception) {
                    throw new BajaRuntimeException((Throwable)exception);
                }
            }
            return this.job;
        }
    }
}

