/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.batchJob;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BLocalTimeUtil;
import java.io.IOException;
import javax.baja.batchJob.BBatchJobPrototype;
import javax.baja.batchJob.BBatchJobService;
import javax.baja.batchJob.BJobStage;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.batchJob.BatchJobOp;
import javax.baja.batchJob.BatchJobOpImpl;
import javax.baja.batchJob.IJobDispatcher;
import javax.baja.file.BIFile;
import javax.baja.job.BJob;
import javax.baja.job.BJobService;
import javax.baja.job.BJobState;
import javax.baja.job.JobCancelException;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.naming.SlotPath;
import javax.baja.naming.UnresolvedException;
import javax.baja.retention.BILastModifiedRetainable;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Clock;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.Array;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;

public class BBatchJob
extends BJob
implements BILastModifiedRetainable {
    public static final Property submitUser = BBatchJob.newProperty((int)1, (String)"unknown", null);
    public static final Property alertOnStepFailure = BBatchJob.newProperty((int)1, (boolean)true, null);
    public static final Property alertOnJobSuccess = BBatchJob.newProperty((int)1, (boolean)false, null);
    public static final Property stages = BBatchJob.newProperty((int)1, (BValue)new BFolder(), null);
    public static final Property prototypeOrd = BBatchJob.newProperty((int)65, (BValue)BOrd.NULL, null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$batchJob$BBatchJob == null ? (class$javax$baja$batchJob$BBatchJob = BBatchJob.class$("javax.baja.batchJob.BBatchJob")) : class$javax$baja$batchJob$BBatchJob));
    private static final BIcon icon = BIcon.std((String)"provisioning.png");
    private BBatchJobLogFile jobFile = null;
    private BTimeZone startTimeLocalTz = BTimeZone.NULL;
    static /* synthetic */ Class class$javax$baja$batchJob$BBatchJob;
    static /* synthetic */ Class class$javax$baja$batchJob$BJobStage;
    static /* synthetic */ Class class$javax$baja$batchJob$BJobStepDetails;

    public String getSubmitUser() {
        return this.getString(submitUser);
    }

    public void setSubmitUser(String string) {
        this.setString(submitUser, string, null);
    }

    public boolean getAlertOnStepFailure() {
        return this.getBoolean(alertOnStepFailure);
    }

    public void setAlertOnStepFailure(boolean bl) {
        this.setBoolean(alertOnStepFailure, bl, null);
    }

    public boolean getAlertOnJobSuccess() {
        return this.getBoolean(alertOnJobSuccess);
    }

    public void setAlertOnJobSuccess(boolean bl) {
        this.setBoolean(alertOnJobSuccess, bl, null);
    }

    public BFolder getStages() {
        return (BFolder)this.get(stages);
    }

    public void setStages(BFolder bFolder) {
        this.set(stages, (BValue)bFolder, null);
    }

    public BOrd getPrototypeOrd() {
        return (BOrd)this.get(prototypeOrd);
    }

    public void setPrototypeOrd(BOrd bOrd) {
        this.set(prototypeOrd, (BValue)bOrd, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BBatchJob() {
    }

    public BBatchJob(BJobStage[] bJobStageArray) {
        for (int i = 0; i < bJobStageArray.length; ++i) {
            this.addStage(bJobStageArray[i]);
        }
    }

    public BBatchJob(BJobStage bJobStage) {
        this.addStage(bJobStage);
    }

    public static BBatchJob findMounted(BAbsTime bAbsTime, BObject bObject) {
        BJobService bJobService = (BJobService)BOrd.make((String)"service:baja:JobService").get(bObject);
        bJobService.lease(2);
        BJob[] bJobArray = bJobService.getJobs();
        for (int i = 0; i < bJobArray.length; ++i) {
            if (!(bJobArray[i] instanceof BBatchJob) || !bAbsTime.equals((Object)bJobArray[i].getStartTime())) continue;
            return (BBatchJob)bJobArray[i];
        }
        return null;
    }

    public static BBatchJob find(BAbsTime bAbsTime, BObject bObject) {
        return BBatchJob.find(null, bAbsTime, bObject);
    }

    public static BBatchJob find(Type type, BAbsTime bAbsTime, BObject bObject) {
        BBatchJob bBatchJob = BBatchJob.findMounted(bAbsTime, bObject);
        if (bBatchJob != null) {
            return bBatchJob;
        }
        try {
            BBatchJobLogFile bBatchJobLogFile = BBatchJobLogFile.find(type, bAbsTime, bObject);
            return bBatchJobLogFile.getJob();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    public BObject getOrdBase() {
        if (this.jobFile == null) {
            return this;
        }
        return this.jobFile;
    }

    public BAbsTime getLastModified() {
        return this.getEndTime().isNull() ? this.getStartTime() : this.getEndTime();
    }

    public void addStage(BJobStage bJobStage) {
        this.getStages().add(SlotPath.escape((String)bJobStage.getStageName()), (BValue)bJobStage);
    }

    public BJobStage getStage(String string) {
        Property property = this.getStages().getProperty(SlotPath.escape((String)string));
        return property == null ? null : (BJobStage)this.getStages().get(property);
    }

    public BJobStage[] getAllStages() {
        Array array = new Array(class$javax$baja$batchJob$BJobStage == null ? (class$javax$baja$batchJob$BJobStage = BBatchJob.class$("javax.baja.batchJob.BJobStage")) : class$javax$baja$batchJob$BJobStage);
        SlotCursor slotCursor = this.getStages().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$BJobStage == null ? BBatchJob.class$("javax.baja.batchJob.BJobStage") : class$javax$baja$batchJob$BJobStage)) {
            array.add((Object)slotCursor.get());
        }
        return (BJobStage[])array.trim();
    }

    public BJobStepDetails[] getJobStepDetails() {
        Array array = new Array(class$javax$baja$batchJob$BJobStepDetails == null ? (class$javax$baja$batchJob$BJobStepDetails = BBatchJob.class$("javax.baja.batchJob.BJobStepDetails")) : class$javax$baja$batchJob$BJobStepDetails);
        BJobStage[] bJobStageArray = this.getAllStages();
        for (int i = 0; i < bJobStageArray.length; ++i) {
            BJobStepDetails[] bJobStepDetailsArray = bJobStageArray[i].getJobStepDetails();
            for (int j = 0; j < bJobStepDetailsArray.length; ++j) {
                array.add((Object)bJobStepDetailsArray[j]);
            }
        }
        return (BJobStepDetails[])array.trim();
    }

    public BatchJobOp makeOp(Context context) {
        return new BatchJobOpImpl(context);
    }

    public IJobDispatcher getDispatcher() {
        BBatchJobService bBatchJobService = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        return bBatchJobService.getJobQueue();
    }

    public void prepareJob(BObject bObject) throws Exception {
        SlotCursor slotCursor = this.getStages().getProperties();
        while (slotCursor.next(class$javax$baja$batchJob$BJobStage == null ? BBatchJob.class$("javax.baja.batchJob.BJobStage") : class$javax$baja$batchJob$BJobStage)) {
            ((BJobStage)slotCursor.get()).prepareStage(bObject);
        }
    }

    public boolean isCanceled() {
        return this.getJobState() == BJobState.canceling || this.getJobState() == BJobState.canceled;
    }

    public void doSubmit(Context context) {
        if (context != null) {
            this.setSubmitUser(String.valueOf(context.getUser()));
        }
        this.setJobState(BJobState.unknown);
        this.setStartTime(Clock.time());
        this.setProgress(-1);
        this.resetLog();
        this.getDispatcher().dispatch(this, context);
    }

    public final void doCancel(Context context) throws Exception {
        if (this.getJobState().isRunning()) {
            this.setJobState(BJobState.canceling);
        } else if (this.getJobState() != BJobState.success && this.getJobState() != BJobState.failed) {
            this.complete(BJobState.canceled);
        }
        this.getDispatcher().cancel(this, context);
    }

    public void doRun(Context context) {
        BatchJobOp batchJobOp = this.makeOp(context);
        BBatchJobService bBatchJobService = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        BJobStage[] bJobStageArray = this.getAllStages();
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < bJobStageArray.length; ++i) {
            BJobState bJobState = bJobStageArray[i].doRun(bBatchJobService, this, batchJobOp);
            if (bJobState == BJobState.failed) {
                bl = true;
                continue;
            }
            if (bJobState != BJobState.canceled && bJobState != BJobState.canceling) continue;
            bl2 = true;
        }
        if (bl) {
            this.log().failed("batchJob", "BatchJob.someStepsFailed");
            this.complete(BJobState.failed);
        } else if (bl2) {
            this.log().failed("batchJob", "BatchJob.jobCanceled");
            this.complete(BJobState.canceled);
        } else {
            this.success();
        }
    }

    public void doDispose(Context context) {
        if (this.getJobState().isRunning()) {
            throw new IllegalStateException("Cannot dispose while running");
        }
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Cannot dispose outside of station vm");
        }
        BBatchJobService bBatchJobService = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        this.setJobState(BJobState.unknown);
        BJobStage[] bJobStageArray = this.getAllStages();
        for (int i = 0; i < bJobStageArray.length; ++i) {
            try {
                bJobStageArray[i].doDispose(context);
                continue;
            }
            catch (Exception exception) {
                Log.getLog((String)"batchJob").error("Error disposing stage", (Throwable)exception);
            }
        }
        try {
            BBatchJobLogFile bBatchJobLogFile = BBatchJobLogFile.find(this, null);
            try {
                Log.getLog((String)"batchJob").trace("Deleting log file " + bBatchJobLogFile.getFilePath().getBody());
                bBatchJobLogFile.delete();
            }
            catch (IOException iOException) {
                Log.getLog((String)"batchJob").error("Error deleting log file " + bBatchJobLogFile.getFilePath(), (Throwable)iOException);
            }
        }
        catch (UnresolvedException unresolvedException) {
            Log.getLog((String)"batchJob").trace("Log file not found", (Throwable)unresolvedException);
        }
        if (this.getParent() != null && this.getParent() instanceof BJobService) {
            try {
                ((BComponent)this.getParent()).remove((BComplex)this);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            bBatchJobService.getJobSummaryManager().disposeJobSummary(this.getType(), this.getStartTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        bBatchJobService.notifyDisposed(this);
    }

    public void complete(BJobState bJobState) {
        Object object;
        super.complete(bJobState);
        try {
            this.jobFile = BBatchJobLogFile.create(this);
            if (!this.getPrototypeOrd().isNull()) {
                object = (BBatchJobPrototype)this.getPrototypeOrd().get((BObject)this);
                ((BBatchJobPrototype)object).jobComplete(this, (BIFile)this.jobFile);
            }
            this.resetLog();
        }
        catch (Exception exception) {
            Log.getLog((String)"batchJob").error("error persisting job", (Throwable)exception);
        }
        object = (BBatchJobService)Sys.getService((Type)BBatchJobService.TYPE);
        if (this.getJobState() == BJobState.success && this.getAlertOnJobSuccess()) {
            ((BBatchJobService)((Object)object)).newAlert(Lexicon.make((String)"batchJob").getText("BatchJob.successAlarmMessage"), this.jobFile.getOrdInSession());
        }
        try {
            ((BBatchJobService)((Object)object)).getJobSummaryManager().write(((BBatchJobService)((Object)object)).getJobSummaryManager().makeJobSummary(this));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public BString doReadLog() {
        if (this.getJobState().isComplete()) {
            BBatchJobLogFile bBatchJobLogFile = (BBatchJobLogFile)this.getLogFile();
            if (bBatchJobLogFile == null) {
                return BString.DEFAULT;
            }
            try {
                return bBatchJobLogFile.getLogContents();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
        return super.doReadLog();
    }

    public void setLogFile(BIFile bIFile) {
        this.jobFile = (BBatchJobLogFile)bIFile;
    }

    public BIFile getLogFile() {
        if (this.jobFile == null) {
            this.jobFile = BBatchJobLogFile.find(this, null);
        }
        return this.jobFile;
    }

    public BIcon getIcon() {
        return icon;
    }

    public void checkCanceled() {
        if (this.isCanceled()) {
            throw new JobCancelException();
        }
    }

    public void setDisplayTimeZone(BTimeZone bTimeZone) {
        if (this.isMounted()) {
            throw new IllegalStateException("cannot call setDisplayTimeZone on mounted job");
        }
        if (bTimeZone == null || bTimeZone.isNull()) {
            throw new IllegalArgumentException("displayTz cannot be null");
        }
        if (this.startTimeLocalTz.isNull()) {
            this.startTimeLocalTz = this.getStartTime().getTimeZone();
        }
        BLocalTimeUtil.updateAbsTimeZone((BComponent)this, startTime, bTimeZone);
        BLocalTimeUtil.updateAbsTimeZone((BComponent)this, endTime, bTimeZone);
        BLocalTimeUtil.updateAbsTimeZone((BComponent)this, heartbeatTime, bTimeZone);
        BJobStepDetails[] bJobStepDetailsArray = this.getJobStepDetails();
        for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
            bJobStepDetailsArray[i].setDisplayTimeZone(bTimeZone);
        }
    }

    public void setStartTimeLocalZone(BTimeZone bTimeZone) {
        this.startTimeLocalTz = bTimeZone;
    }

    public BAbsTime getLocalStartTime() {
        if (this.startTimeLocalTz.isNull() && this.getSession() != null) {
            try {
                BComponent bComponent = (BComponent)BOrd.make((String)"service:platform:SystemPlatformService").get((BObject)this);
                bComponent.lease();
                this.setStartTimeLocalZone((BTimeZone)bComponent.get("timeZone"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.startTimeLocalTz.isNull()) {
            return this.getStartTime();
        }
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.startTimeLocalTz);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

