/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.ui.driver.BDeviceNodeEvent;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.ui.theme.Theme;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceFolder;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.gx.BBrush;
import javax.baja.gx.BColor;
import javax.baja.gx.BImage;
import javax.baja.gx.Graphics;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeNodeRenderer;
import javax.baja.ui.tree.TreeSelection;

public class BDeviceTree
extends BTree {
    public static final Topic nodeChecked = BDeviceTree.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$driver$BDeviceTree == null ? (class$com$tridium$batchJob$ui$driver$BDeviceTree = BDeviceTree.class$("com.tridium.batchJob.ui.driver.BDeviceTree")) : class$com$tridium$batchJob$ui$driver$BDeviceTree));
    static /* synthetic */ Class class$com$tridium$batchJob$ui$driver$BDeviceTree;

    public void fireNodeChecked(BDeviceNodeEvent bDeviceNodeEvent) {
        this.fire(nodeChecked, (BValue)bDeviceNodeEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDeviceTree() {
        throw new UnsupportedOperationException();
    }

    public BDeviceTree(BDeviceNetwork bDeviceNetwork, Set set) {
        super((TreeModel)new DeviceTreeModel(bDeviceNetwork, set), (TreeController)new DeviceTreeController());
        this.setNodeRenderer(new DeviceTreeNodeRenderer());
        this.setSelection(new TreeSelection());
    }

    public void setModel(TreeModel treeModel) {
        super.setModel((TreeModel)((DeviceTreeModel)treeModel));
    }

    public DeviceTreeModel getDeviceTreeModel() {
        return (DeviceTreeModel)this.getModel();
    }

    public void setController(TreeController treeController) {
        super.setController((TreeController)((DeviceTreeController)treeController));
    }

    public DeviceTreeController getDeviceTreeController() {
        return (DeviceTreeController)this.getController();
    }

    public DeviceTreeNodeRenderer getDeviceTreeNodeRenderer() {
        return (DeviceTreeNodeRenderer)this.getNodeRenderer();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class DeviceTreeNodeRenderer
    extends TreeNodeRenderer {
        public double getWidth(TreeNode treeNode) {
            return super.getWidth(treeNode) + 10.0 + 2.0;
        }

        public BBrush getForeground(TreeNode treeNode) {
            CheckNode checkNode = (CheckNode)treeNode;
            return checkNode.isCheckEnabled() ? super.getForeground((TreeNode)checkNode) : BColor.gray.toBrush();
        }

        public void paintNode(Graphics graphics, TreeNode treeNode, double d, double d2) {
            CheckNode checkNode = (CheckNode)treeNode;
            double d3 = d;
            double d4 = d2 + this.getHeight() / 2.0 - 5.0;
            double d5 = 10.0;
            double d6 = 10.0;
            graphics.setBrush(this.getForeground(treeNode));
            graphics.strokeRect(d3, d4, d5, d6);
            if (checkNode.isChecked()) {
                graphics.strokeLine(d3, d4, d3 + d5, d4 + d6);
                graphics.strokeLine(d3, d4 + d5, d3 + d5, d4);
            }
            super.paintNode(graphics, treeNode, d + 12.0, d2);
        }
    }

    public static class DeviceNode
    extends CheckNode {
        private BDevice device;
        private BImage enabledIcon;
        private BImage disabledIcon;

        public DeviceNode(BDevice bDevice, DeviceTreeModel deviceTreeModel) {
            super(deviceTreeModel);
            this.init(bDevice);
        }

        public DeviceNode(BDevice bDevice, FolderNode folderNode) {
            super(folderNode);
            this.init(bDevice);
        }

        private void init(BDevice bDevice) {
            this.device = bDevice;
            bDevice.lease(1);
            this.enabledIcon = BImage.make((BIcon)bDevice.getIcon());
            this.disabledIcon = this.enabledIcon.getDisabledImage();
        }

        public BDevice getDevice() {
            return this.device;
        }

        public String getText() {
            return this.device.getDisplayName(null) + " " + this.device.getStatus().toString();
        }

        public BImage getIcon() {
            return this.checkEnabled ? this.enabledIcon : this.disabledIcon;
        }

        public int getChildCount() {
            return 0;
        }

        public TreeNode getChild(int n) {
            return null;
        }
    }

    public static class FolderNode
    extends CheckNode {
        private BDeviceFolder folder;
        private ArrayList childNodes;
        private BImage enabledIcon;
        private BImage disabledIcon;

        public FolderNode(BDeviceFolder bDeviceFolder, DeviceTreeModel deviceTreeModel) {
            super(deviceTreeModel);
            this.init(bDeviceFolder);
        }

        public FolderNode(BDeviceFolder bDeviceFolder, FolderNode folderNode) {
            super(folderNode);
            this.init(bDeviceFolder);
        }

        private void init(BDeviceFolder bDeviceFolder) {
            this.folder = bDeviceFolder;
            this.enabledIcon = BImage.make((BIcon)bDeviceFolder.getIcon());
            this.disabledIcon = this.enabledIcon.getDisabledImage();
            this.childNodes = new ArrayList();
            bDeviceFolder.lease(1);
            try {
                SlotCursor slotCursor = bDeviceFolder.getProperties();
                while (slotCursor.next()) {
                    if (slotCursor.get() instanceof BDeviceFolder) {
                        this.childNodes.add(new FolderNode((BDeviceFolder)slotCursor.get(), this));
                        continue;
                    }
                    if (!(slotCursor.get() instanceof BDevice)) continue;
                    BDevice bDevice = (BDevice)slotCursor.get();
                    if (this.getDeviceTreeModel().shouldOmitDevice(bDevice)) continue;
                    this.childNodes.add(new DeviceNode(bDevice, this));
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new RuntimeException(exception);
            }
            this.setExpanded(true);
        }

        public BDeviceFolder getFolder() {
            return this.folder;
        }

        public String getText() {
            return this.folder.getDisplayName(null);
        }

        public BImage getIcon() {
            return this.checkEnabled ? this.enabledIcon : this.disabledIcon;
        }

        public int getChildCount() {
            return this.childNodes.size();
        }

        public TreeNode getChild(int n) {
            return (TreeNode)this.childNodes.get(n);
        }
    }

    public static abstract class CheckNode
    extends TreeNode {
        protected boolean checked = false;
        protected boolean checkEnabled = true;

        public CheckNode(DeviceTreeModel deviceTreeModel) {
            super((TreeModel)deviceTreeModel);
        }

        public CheckNode(FolderNode folderNode) {
            super((TreeNode)folderNode);
        }

        public boolean inCheckBox(double d, double d2) {
            double d3 = this.getX() + Theme.tree().getExpanderWidth() + 4.0;
            return d >= d3 && d <= d3 + 10.0;
        }

        public DeviceTreeModel getDeviceTreeModel() {
            return (DeviceTreeModel)this.getModel();
        }

        public boolean isChecked() {
            return this.checked;
        }

        public void setChecked(boolean bl) {
            this.setChecked(bl, BTreeCascadePolicy.never, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean bl, BTreeCascadePolicy bTreeCascadePolicy) {
            this.setChecked(bl, bTreeCascadePolicy, BTreeCascadePolicy.never, false);
        }

        public void setChecked(boolean bl, BTreeCascadePolicy bTreeCascadePolicy, BTreeCascadePolicy bTreeCascadePolicy2, boolean bl2) {
            BDeviceNodeEvent bDeviceNodeEvent = new BDeviceNodeEvent();
            this.setChecked(bl, bTreeCascadePolicy, bTreeCascadePolicy2, bDeviceNodeEvent, bl2);
            ((DeviceTreeModel)this.getModel()).fireNodeChecked(bDeviceNodeEvent);
        }

        private void setChecked(boolean bl, BTreeCascadePolicy bTreeCascadePolicy, BTreeCascadePolicy bTreeCascadePolicy2, BDeviceNodeEvent bDeviceNodeEvent, boolean bl2) {
            TreeNode treeNode;
            if (this.checked != bl && (this.isCheckEnabled() || !bl2)) {
                this.checked = bl;
                bDeviceNodeEvent.addNode(this);
            }
            if (bTreeCascadePolicy.cascade(bl)) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    if (!(this.getChild(i) instanceof CheckNode)) continue;
                    ((CheckNode)this.getChild(i)).setChecked(bl, BTreeCascadePolicy.always, BTreeCascadePolicy.never, bDeviceNodeEvent, bl2);
                }
            }
            if (bTreeCascadePolicy2.cascade(bl) && (treeNode = this.getParent()) != null && treeNode instanceof CheckNode) {
                ((CheckNode)treeNode).setChecked(bl, BTreeCascadePolicy.never, BTreeCascadePolicy.always, bDeviceNodeEvent, bl2);
            }
            this.getDeviceTreeModel().updateTree();
        }

        public boolean isCheckEnabled() {
            return this.checkEnabled;
        }

        public void setCheckEnabled(boolean bl) {
            this.setCheckEnabled(bl, false);
        }

        public void setCheckEnabled(boolean bl, boolean bl2) {
            this.checkEnabled = bl;
            if (bl2) {
                for (int i = 0; i < this.getChildCount(); ++i) {
                    ((DeviceNode)this.getChild(i)).setCheckEnabled(bl, true);
                }
            }
        }

        public void toggleChecked() {
            this.toggleChecked(BTreeCascadePolicy.never, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy bTreeCascadePolicy) {
            this.toggleChecked(bTreeCascadePolicy, BTreeCascadePolicy.never);
        }

        public void toggleChecked(BTreeCascadePolicy bTreeCascadePolicy, BTreeCascadePolicy bTreeCascadePolicy2) {
            this.setChecked(!this.isChecked(), bTreeCascadePolicy, bTreeCascadePolicy2, true);
        }
    }

    public static class DeviceTreeModel
    extends TreeModel {
        private ArrayList roots;
        public Set idsToOmit;
        public BNetworkBatchAgent batchAgent;

        public DeviceTreeModel(BDeviceNetwork bDeviceNetwork, Set set) {
            this.idsToOmit = set;
            this.roots = new ArrayList();
            this.batchAgent = BNetworkBatchAgent.get(bDeviceNetwork, null);
            bDeviceNetwork.lease(1);
            SlotCursor slotCursor = bDeviceNetwork.getProperties();
            while (slotCursor.next()) {
                BDevice bDevice;
                if (slotCursor.get() instanceof BDeviceFolder) {
                    this.roots.add(new FolderNode((BDeviceFolder)slotCursor.get(), this));
                    continue;
                }
                if (!(slotCursor.get() instanceof BDevice) || this.shouldOmitDevice(bDevice = (BDevice)slotCursor.get())) continue;
                this.roots.add(new DeviceNode(bDevice, this));
            }
        }

        public void fireNodeChecked(BDeviceNodeEvent bDeviceNodeEvent) {
            if (this.getTree() instanceof BDeviceTree) {
                ((BDeviceTree)this.getTree()).fireNodeChecked(bDeviceNodeEvent);
            }
        }

        public int getRootCount() {
            return this.roots.size();
        }

        public Iterator getCheckedDevices() {
            return this.getCheckedDevices(true);
        }

        public Iterator getCheckedDevices(boolean bl) {
            ArrayList arrayList = new ArrayList();
            for (int i = 0; i < this.roots.size(); ++i) {
                this.getCheckedDevices((CheckNode)((Object)this.roots.get(i)), bl, arrayList);
            }
            return arrayList.iterator();
        }

        private void getCheckedDevices(CheckNode checkNode, boolean bl, Collection collection) {
            if (checkNode instanceof DeviceNode && ((DeviceNode)checkNode).isChecked() == bl) {
                collection.add(((DeviceNode)checkNode).getDevice());
            }
            for (int i = 0; i < checkNode.getChildCount(); ++i) {
                this.getCheckedDevices((CheckNode)checkNode.getChild(i), bl, collection);
            }
        }

        public TreeNode getRoot(int n) {
            return (TreeNode)this.roots.get(n);
        }

        public CheckNode getCheckNode(int n) {
            return (CheckNode)this.getRoot(n);
        }

        public boolean shouldOmitDevice(BDevice bDevice) {
            return this.idsToOmit.contains(this.batchAgent.getBatchDeviceId(bDevice));
        }
    }

    public static class DeviceTreeController
    extends TreeController {
        private BTreeCascadePolicy cascadeAncestorPolicy = BTreeCascadePolicy.never;
        private BTreeCascadePolicy cascadeDescendantPolicy = BTreeCascadePolicy.always;

        public void mousePressed(BMouseEvent bMouseEvent) {
            this.getTree().requestFocus();
            double d = bMouseEvent.getX();
            double d2 = bMouseEvent.getY();
            CheckNode checkNode = (CheckNode)this.getTree().yToTreeNode(d2);
            if (checkNode != null) {
                if (checkNode.inExpander(d, d2)) {
                    this.getTree().toggleExpanded((TreeNode)checkNode);
                } else if (checkNode.inCheckBox(d, d2)) {
                    if (checkNode.isCheckEnabled()) {
                        checkNode.toggleChecked(this.getCascadeDescendantPolicy(), this.getCascadeAncestorPolicy());
                        this.getTree().relayout();
                    }
                } else if (checkNode.isSelection(d, d2)) {
                    this.mouseSelection(checkNode, bMouseEvent);
                    if (!bMouseEvent.isButton3Down() && bMouseEvent.getClickCount() == 2) {
                        this.doSelectAction(checkNode, bMouseEvent.getX(), bMouseEvent.getY());
                    }
                } else {
                    checkNode = null;
                    this.mouseSelection(null, bMouseEvent);
                }
            } else {
                this.mouseSelection(null, bMouseEvent);
            }
            if (bMouseEvent.isPopupTrigger()) {
                this.popup(bMouseEvent, checkNode);
            }
        }

        public BTreeCascadePolicy getCascadeAncestorPolicy() {
            return this.cascadeAncestorPolicy;
        }

        public void setCascadeAncestorPolicy(BTreeCascadePolicy bTreeCascadePolicy) {
            this.cascadeAncestorPolicy = bTreeCascadePolicy;
        }

        public BTreeCascadePolicy getCascadeDescendantPolicy() {
            return this.cascadeDescendantPolicy;
        }

        public void setCascadeDescendantPolicy(BTreeCascadePolicy bTreeCascadePolicy) {
            this.cascadeDescendantPolicy = bTreeCascadePolicy;
        }
    }
}

