/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui.driver;

import com.tridium.batchJob.ui.driver.BDeviceTree;
import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BButtonPane;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.BTreeCascadePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.CommandUtil;
import com.tridium.platform.ui.util.DialogCommand;
import com.tridium.ui.theme.Theme;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.baja.batchJob.BValueList;
import javax.baja.batchJob.driver.BDeviceNetworkJob;
import javax.baja.batchJob.driver.BNetworkBatchAgent;
import javax.baja.driver.BDevice;
import javax.baja.driver.BDeviceNetwork;
import javax.baja.driver.BIDeviceFolder;
import javax.baja.gx.BBrush;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BValue;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Topic;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BButtonStyle;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BScrollBarPolicy;
import javax.baja.ui.event.BFocusEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.list.BList;
import javax.baja.ui.list.ListController;
import javax.baja.ui.list.ListModel;
import javax.baja.ui.list.ListSelection;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BFlowPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.transfer.Clipboard;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Array;
import javax.baja.util.Lexicon;

public class BDeviceList
extends BList
implements CommandBindings.Support {
    public static final Topic listUpdated = BDeviceList.newTopic((int)0, null);
    public static final Topic transferWidgetFocusGained = BDeviceList.newTopic((int)0, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$ui$driver$BDeviceList == null ? (class$com$tridium$batchJob$ui$driver$BDeviceList = BDeviceList.class$("com.tridium.batchJob.ui.driver.BDeviceList")) : class$com$tridium$batchJob$ui$driver$BDeviceList));
    private BDeviceNetwork network = null;
    private BNetworkBatchAgent batchAgent = null;
    private BWidget container;
    private Model model;
    private AddDevice addDevice;
    private MoveDeviceUp moveDeviceUp;
    private MoveDeviceDown moveDeviceDown;
    private RemoveDevice removeDevice;
    public static final Lexicon lex = Lexicon.make((String)"batchJob");
    static /* synthetic */ Class class$com$tridium$batchJob$ui$driver$BDeviceList;
    static /* synthetic */ Class class$javax$baja$driver$BDevice;
    static /* synthetic */ Class class$javax$baja$sys$BSimple;

    public void fireListUpdated(BWidgetEvent bWidgetEvent) {
        this.fire(listUpdated, (BValue)bWidgetEvent, null);
    }

    public void fireTransferWidgetFocusGained(BFocusEvent bFocusEvent) {
        this.fire(transferWidgetFocusGained, (BValue)bFocusEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BDeviceList() {
        throw new UnsupportedOperationException();
    }

    public BDeviceList(String string) {
        CommandBindings commandBindings = new CommandBindings();
        commandBindings.setSupport((CommandBindings.Support)this);
        this.addDevice = new AddDevice();
        commandBindings.addCommand((Command)this.addDevice, BCommandEnablePolicy.always);
        commandBindings.addCommand((Command)new PasteFromClipboard(), BCommandEnablePolicy.always);
        this.moveDeviceUp = new MoveDeviceUp();
        commandBindings.addCommand((Command)this.moveDeviceUp, BCommandEnablePolicy.singleSelection);
        this.moveDeviceDown = new MoveDeviceDown();
        commandBindings.addCommand((Command)this.moveDeviceDown, BCommandEnablePolicy.singleSelection);
        this.removeDevice = new RemoveDevice();
        commandBindings.addCommand((Command)this.removeDevice, BCommandEnablePolicy.anySelection);
        this.setController((ListController)new Controller(commandBindings));
        this.setSelection((ListSelection)new CommandBindings.ListSelection(commandBindings));
        this.model = new Model();
        this.setModel(this.model);
        BBorderPane bBorderPane = new BBorderPane((BWidget)new BEdgePane(null, (BWidget)new BButtonPane(BButtonStyle.toolBar, new Command[]{this.addDevice, this.moveDeviceUp, this.moveDeviceDown, this.removeDevice}, false, true), null, null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)this, BBorder.inset, BInsets.DEFAULT), 4.0, 0.0, 4.0, 0.0)));
        bBorderPane.setBorder(BBorder.solid);
        bBorderPane.setLabel((BWidget)new BLabel(string));
        bBorderPane.setPadding(BInsets.make((double)4.0, (double)4.0, (double)4.0, (double)4.0));
        this.container = bBorderPane;
    }

    private BDeviceNetwork getDeviceNetwork() {
        return this.network;
    }

    public BWidget getContainer() {
        return this.container;
    }

    public BSimple[] getDeviceIds() {
        BSimple[] bSimpleArray = new BSimple[this.model.getItemCount()];
        for (int i = 0; i < bSimpleArray.length; ++i) {
            bSimpleArray[i] = this.model.getDeviceId(i);
        }
        return bSimpleArray;
    }

    public int dragOver(TransferContext transferContext) {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                if ((!(bObjectArray[i] instanceof BDevice) || !this.batchAgent.isBatchDevice((BDevice)bObjectArray[i])) && !bObjectArray[i].getType().is(this.network.getDeviceFolderType()) && !bObjectArray[i].equivalent((Object)this.network)) continue;
                return 16;
            }
        }
        return 0;
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (transferContext.isCopy() && transferContext.getEnvelope().supports(TransferFormat.mark)) {
            int n = this.getItemIndexAt(transferContext.getX(), transferContext.getY());
            Mark mark = (Mark)transferContext.getEnvelope().getData(TransferFormat.mark);
            BObject[] bObjectArray = mark.getValues();
            for (int i = 0; i < bObjectArray.length; ++i) {
                if (bObjectArray[i] instanceof BDevice && this.batchAgent.isBatchDevice((BDevice)bObjectArray[i])) {
                    if (n < 0) {
                        this.model.addItem(null, bObjectArray[i]);
                        continue;
                    }
                    this.model.insertItem(n, null, bObjectArray[i]);
                    continue;
                }
                if (!bObjectArray[i].getType().is(this.network.getDeviceFolderType()) && !bObjectArray[i].equivalent((Object)this.network)) continue;
                if (n < 0) {
                    this.model.addItem(null, bObjectArray[i]);
                    continue;
                }
                this.model.insertItem(n, null, bObjectArray[i]);
            }
        }
        return null;
    }

    public void addDevices(BSimple[] bSimpleArray) {
        for (int i = 0; i < bSimpleArray.length; ++i) {
            this.addDevice(bSimpleArray[i]);
        }
    }

    public void addDevice(BSimple bSimple) {
        BDevice bDevice = this.batchAgent.getBatchDevice(this.getDeviceNetwork(), bSimple);
        if (bDevice != null) {
            this.addDevice(bDevice);
        }
    }

    public void addDevices(BDevice[] bDeviceArray) {
        for (int i = 0; i < bDeviceArray.length; ++i) {
            this.addDevice(bDeviceArray[i]);
        }
    }

    public void addDevice(BDevice bDevice) {
        if (this.batchAgent.isBatchDevice(bDevice)) {
            this.model.addItem(null, bDevice);
        }
    }

    public void load(BDeviceNetwork bDeviceNetwork) {
        this.network = bDeviceNetwork;
        this.batchAgent = BNetworkBatchAgent.get(bDeviceNetwork, null);
        this.model.removeAllItems();
    }

    public void loadFromJob(BDeviceNetworkJob bDeviceNetworkJob) {
        this.load(bDeviceNetworkJob.getNetwork());
        this.addDevices(bDeviceNetworkJob.getDevices());
    }

    public void saveToJob(BDeviceNetworkJob bDeviceNetworkJob) {
        bDeviceNetworkJob.setDevicesToProcess(BValueList.make((BValue[])this.getDeviceIds()));
    }

    public void setBoundCommandEnabled(Command command, boolean bl) {
        if (command instanceof DeviceListCommand) {
            ((DeviceListCommand)command).checkEnabled(bl);
        } else {
            command.setEnabled(bl);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class Controller
    extends CommandBindings.ListController {
        public Controller(CommandBindings commandBindings) {
            super(commandBindings);
        }

        public void focusGained(BFocusEvent bFocusEvent) {
            BDeviceList.this.fireTransferWidgetFocusGained(bFocusEvent);
        }
    }

    private class Model
    extends ListModel {
        private Array deviceIds = new Array(class$javax$baja$sys$BSimple == null ? (class$javax$baja$sys$BSimple = BDeviceList.class$("javax.baja.sys.BSimple")) : class$javax$baja$sys$BSimple);
        private HashMap deviceById = new HashMap();

        private Model() {
        }

        public BDevice[] getAvailableDevices() {
            Array array = new Array(class$javax$baja$driver$BDevice == null ? (class$javax$baja$driver$BDevice = BDeviceList.class$("javax.baja.driver.BDevice")) : class$javax$baja$driver$BDevice);
            try {
                BDevice[] bDeviceArray = BDeviceList.this.batchAgent.listBatchDevices(BDeviceList.this.getDeviceNetwork());
                for (int i = 0; i < bDeviceArray.length; ++i) {
                    if (this.deviceById.containsKey(BDeviceList.this.batchAgent.getBatchDeviceId(bDeviceArray[i]))) continue;
                    array.add((Object)bDeviceArray[i]);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return (BDevice[])array.trim();
        }

        public synchronized void swapItems(int n, int n2) {
            this.deviceIds.swap(n, n2);
            this.updateList();
        }

        public synchronized void addDeviceFolder(BIDeviceFolder bIDeviceFolder, boolean bl) {
            BComponent bComponent = (BComponent)bIDeviceFolder;
            bComponent.lease(1);
            SlotCursor slotCursor = bComponent.getProperties();
            while (slotCursor.next()) {
                BObject bObject = slotCursor.get();
                if (bObject instanceof BIDeviceFolder) {
                    this.addDeviceFolder((BIDeviceFolder)bObject, false);
                    continue;
                }
                if (!(bObject instanceof BDevice)) continue;
                this.addDevice((BDevice)bObject, false);
            }
            if (bl) {
                this.updateList();
            }
        }

        public synchronized void addItem(BImage bImage, Object object) {
            if (object instanceof BIDeviceFolder) {
                this.addDeviceFolder((BIDeviceFolder)object, true);
            } else if (object instanceof BDevice) {
                this.addDevice((BDevice)object, true);
            }
        }

        public synchronized void addDevice(BDevice bDevice, boolean bl) {
            BSimple bSimple = BDeviceList.this.batchAgent.getBatchDeviceId(bDevice);
            if (!this.deviceById.containsKey(bSimple)) {
                this.deviceById.put(bSimple, bDevice);
                this.deviceIds.add((Object)bSimple);
                if (bl) {
                    this.updateList();
                }
            }
        }

        public synchronized int insertDeviceFolder(int n, BIDeviceFolder bIDeviceFolder, boolean bl) {
            BComponent bComponent = (BComponent)bIDeviceFolder;
            bComponent.lease(1);
            SlotCursor slotCursor = bComponent.getProperties();
            while (slotCursor.next()) {
                BObject bObject = slotCursor.get();
                if (bObject instanceof BIDeviceFolder) {
                    n = this.insertDeviceFolder(n, (BIDeviceFolder)bObject, false);
                    continue;
                }
                if (!(bObject instanceof BDevice)) continue;
                this.insertDevice(n++, (BDevice)bObject, false);
            }
            if (bl) {
                this.updateList();
            }
            return n;
        }

        public synchronized void insertItem(int n, BImage bImage, Object object) {
            if (object instanceof BDevice) {
                this.insertDevice(n, (BDevice)object, true);
            } else if (object instanceof BIDeviceFolder) {
                this.insertDeviceFolder(n, (BIDeviceFolder)object, true);
            }
        }

        public synchronized void insertDevice(int n, Object object, boolean bl) {
            BDevice bDevice = (BDevice)object;
            BSimple bSimple = BDeviceList.this.batchAgent.getBatchDeviceId(bDevice);
            if (!this.deviceById.containsKey(bSimple)) {
                this.deviceIds.add(n, (Object)bSimple);
                this.deviceById.put(bSimple, bDevice);
                if (bl) {
                    this.updateList();
                }
            }
        }

        public synchronized void removeItem(Object object) {
            BDevice bDevice = (BDevice)object;
            BSimple bSimple = BDeviceList.this.batchAgent.getBatchDeviceId(bDevice);
            this.deviceIds.remove((Object)bSimple);
            this.deviceById.remove(bSimple);
            this.updateList();
        }

        public void removeItem(int n) {
            this.removeItem(this.getDevice(n));
        }

        public synchronized void removeAllItems() {
            this.deviceById.clear();
            this.deviceIds.clear();
            this.updateList();
        }

        public int getItemCount() {
            return this.deviceIds.size();
        }

        public BImage getItemIcon(int n) {
            BDevice bDevice = this.getDevice(n);
            return bDevice == null ? null : BImage.make((BIcon)bDevice.getIcon());
        }

        public Object getItem(int n) {
            BSimple bSimple = this.getDeviceId(n);
            BDevice bDevice = BDeviceList.this.batchAgent.getBatchDevice(BDeviceList.this.getDeviceNetwork(), bSimple);
            return bDevice == null ? lex.getText("DeviceList.invalidDevice", new Object[]{bSimple}) : bDevice.getDisplayName(null);
        }

        public BSimple getDeviceId(int n) {
            return (BSimple)this.deviceIds.get(n);
        }

        public BDevice getDevice(int n) {
            return BDeviceList.this.batchAgent.getBatchDevice(BDeviceList.this.getDeviceNetwork(), this.getDeviceId(n));
        }

        public void updateList() {
            super.updateList();
            BDeviceList.this.fireListUpdated(new BWidgetEvent(1, (BWidget)this.getList()));
        }
    }

    private class PasteFromClipboard
    extends Command {
        public PasteFromClipboard() {
            super((BWidget)BDeviceList.this, (Lexicon)UiLexicon.bajaui, "commands.paste");
        }

        public synchronized boolean isEnabled() {
            TransferEnvelope transferEnvelope = Clipboard.getDefault().getContents();
            if (transferEnvelope != null && transferEnvelope.supports(TransferFormat.mark)) {
                Mark mark = (Mark)transferEnvelope.getData(TransferFormat.mark);
                BObject[] bObjectArray = mark.getValues();
                for (int i = 0; i < bObjectArray.length; ++i) {
                    if (!(bObjectArray[i] instanceof BDevice) || !BDeviceList.this.batchAgent.isBatchDevice((BDevice)bObjectArray[i])) continue;
                    return true;
                }
            }
            return false;
        }

        public CommandArtifact doInvoke() {
            TransferEnvelope transferEnvelope = Clipboard.getDefault().getContents();
            if (transferEnvelope != null && transferEnvelope.supports(TransferFormat.mark)) {
                Mark mark = (Mark)transferEnvelope.getData(TransferFormat.mark);
                BObject[] bObjectArray = mark.getValues();
                for (int i = 0; i < bObjectArray.length; ++i) {
                    if (!(bObjectArray[i] instanceof BDevice) || !BDeviceList.this.batchAgent.isBatchDevice((BDevice)bObjectArray[i])) continue;
                    BDeviceList.this.model.addItem(null, bObjectArray[i]);
                }
            }
            return null;
        }
    }

    private class RemoveDevice
    extends DeviceListCommand {
        public RemoveDevice() {
            super("DeviceList.remove");
        }

        public CommandArtifact doInvoke() {
            int[] nArray = BDeviceList.this.model.getSelection().getItems();
            for (int i = nArray.length; i > 0; --i) {
                BDeviceList.this.model.removeItem(nArray[i - 1]);
            }
            BDeviceList.this.model.getSelection().deselectAll();
            return null;
        }
    }

    private class MoveDeviceDown
    extends DeviceListCommand {
        public MoveDeviceDown() {
            super("DeviceList.moveDown");
        }

        public CommandArtifact doInvoke() {
            int n = BDeviceList.this.model.getSelection().getItems()[0];
            BDeviceList.this.model.swapItems(n, n + 1);
            BDeviceList.this.model.getSelection().select(n + 1, true);
            return null;
        }

        public void checkEnabled(boolean bl) {
            if (bl) {
                int n = BDeviceList.this.model.getSelection().getItems()[0];
                if (n == BDeviceList.this.model.getModel().getItemCount() - 1) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bl);
                }
            } else {
                this.setEnabled(bl);
            }
        }
    }

    private class MoveDeviceUp
    extends DeviceListCommand {
        public MoveDeviceUp() {
            super("DeviceList.moveUp");
        }

        public CommandArtifact doInvoke() {
            int n = BDeviceList.this.model.getSelection().getItems()[0];
            BDeviceList.this.model.swapItems(n, n - 1);
            BDeviceList.this.model.getSelection().select(n - 1, true);
            return null;
        }

        public void checkEnabled(boolean bl) {
            if (bl) {
                int n = BDeviceList.this.model.getSelection().getItems()[0];
                if (n == 0) {
                    this.setEnabled(false);
                } else {
                    this.setEnabled(bl);
                }
            } else {
                this.setEnabled(bl);
            }
        }
    }

    private class CheckAllCommand
    extends DialogCommand {
        private BDeviceTree tree;

        public CheckAllCommand(BDeviceTree bDeviceTree) {
            super((BWidget)BDeviceList.this, -1, lex, "DeviceList.add.checkAll");
            this.tree = bDeviceTree;
        }

        public CommandArtifact doInvoke() {
            try {
                int n = this.tree.getDeviceTreeModel().getRootCount();
                for (int i = 0; i < n; ++i) {
                    this.tree.getDeviceTreeModel().getCheckNode(i).setChecked(true, BTreeCascadePolicy.always);
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private class AddDevice
    extends DeviceListCommand {
        public AddDevice() {
            super("DeviceList.add");
        }

        public CommandArtifact doInvoke() {
            try {
                BDevice[] bDeviceArray = BDeviceList.this.model.getAvailableDevices();
                if (bDeviceArray.length == 0) {
                    if (BDeviceList.this.model.getItemCount() > 0) {
                        BDialog.message((BWidget)BDeviceList.this, (String)lex.getText("DeviceList.add.noMoreDevices.dlgTitle"), (Object)lex.getText("DeviceList.add.noMoreDevices.dlgMessage"));
                    } else {
                        BDialog.message((BWidget)BDeviceList.this, (String)lex.getText("DeviceList.add.noDevices.dlgTitle"), (Object)lex.getText("DeviceList.add.noDevices.dlgMessage"));
                    }
                    return null;
                }
                HashSet<BSimple> hashSet = new HashSet<BSimple>();
                for (int i = 0; i < BDeviceList.this.model.getItemCount(); ++i) {
                    hashSet.add(BDeviceList.this.model.getDeviceId(i));
                }
                BDeviceTree bDeviceTree = new BDeviceTree(BDeviceList.this.getDeviceNetwork(), hashSet);
                BBrush bBrush = Theme.scrollPane().getControlBackground();
                BScrollPane bScrollPane = new BScrollPane((BWidget)bDeviceTree);
                bScrollPane.setViewportBackground(bBrush);
                bScrollPane.setBorderPolicy(BScrollBarPolicy.asNeeded);
                BFlowPane bFlowPane = new BFlowPane(BHalign.left);
                bFlowPane.add("label", (BValue)new BLabel(lex.getText("DeviceList.add.dlgMessage")));
                if (1 == BCommandDialog.open((BWidget)BDeviceList.this, (String)lex.getText("DeviceList.add.dlgTitle"), (Object)new BBorderPane((BWidget)new BEdgePane((BWidget)bFlowPane, (BWidget)new BBox(250.0, 0.0), (BWidget)new BBox(0.0, 300.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bScrollPane, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{new CheckAllCommand(bDeviceTree), DialogCommand.makeOk((BWidget)BDeviceList.this), DialogCommand.makeCancel((BWidget)BDeviceList.this)})) {
                    Iterator iterator = bDeviceTree.getDeviceTreeModel().getCheckedDevices();
                    while (iterator.hasNext()) {
                        BDeviceList.this.model.addItem(null, (BDevice)iterator.next());
                    }
                }
            }
            catch (Throwable throwable) {
                CommandUtil.error((Command)this, (Throwable)throwable);
            }
            return null;
        }
    }

    private abstract class DeviceListCommand
    extends Command {
        public DeviceListCommand(String string) {
            super((BWidget)BDeviceList.this, lex, string);
        }

        public void checkEnabled(boolean bl) {
            this.setEnabled(bl);
        }
    }
}

