/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.ui;

import com.tridium.platform.ui.util.BBox;
import com.tridium.platform.ui.util.BCommandBoundTable;
import com.tridium.platform.ui.util.BCommandDialog;
import com.tridium.platform.ui.util.BCommandEnablePolicy;
import com.tridium.platform.ui.util.CommandBindings;
import com.tridium.platform.ui.util.DialogCommand;
import java.util.Comparator;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.ui.BJobStepFactory;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.TableModel;
import javax.baja.util.Array;
import javax.baja.util.IFilter;
import javax.baja.util.Lexicon;

public class JobStepChooser {
    private Array factories = null;
    private Type stageType;
    private static Lexicon lex = Lexicon.make((String)"batchJob");
    static /* synthetic */ Class class$javax$baja$batchJob$ui$BJobStepFactory;

    public JobStepChooser(Type type) {
        this.stageType = type;
    }

    public Type getStageType() {
        return this.stageType;
    }

    public BJobStep choose(BWidget bWidget, BBatchJob bBatchJob, BObject bObject, Context context) throws Exception {
        BJobStepFactory bJobStepFactory = this.chooseFactory(bWidget, bBatchJob, bObject, context);
        return bJobStepFactory == null ? null : bJobStepFactory.makeStep(bWidget, bBatchJob, bObject, context);
    }

    public BJobStepFactory chooseFactory(BWidget bWidget, BBatchJob bBatchJob, BObject bObject, Context context) throws Exception {
        return this.chooseFactory(bWidget, bBatchJob, bObject, this.getAllFactories().sort((Comparator)new FactoryComparator(context)), context);
    }

    public BJobStepFactory chooseFactory(BWidget bWidget, BBatchJob bBatchJob, BObject bObject, Array array, Context context) throws Exception {
        if ((array = array.filter((IFilter)new StepFilter(bBatchJob, bObject))).size() == 0) {
            BDialog.error((BWidget)bWidget, (String)lex.getText("JobStepChooser.noFactories.dlgTitle"), (Object)lex.getText("JobStepChooser.noFactories.dlgMessage"));
            return null;
        }
        CommandBindings commandBindings = new CommandBindings();
        FactoryModel factoryModel = new FactoryModel(array, context);
        BCommandBoundTable bCommandBoundTable = new BCommandBoundTable((TableModel)factoryModel, new CommandBindings.TableController(commandBindings));
        DialogCommand dialogCommand = DialogCommand.makeOk((BWidget)bCommandBoundTable);
        DialogCommand dialogCommand2 = DialogCommand.makeCancel((BWidget)bCommandBoundTable);
        commandBindings.addCommand((Command)dialogCommand, BCommandEnablePolicy.singleSelection);
        commandBindings.addCommand((Command)dialogCommand2, BCommandEnablePolicy.always);
        commandBindings.setDoubleClickCommand((Command)dialogCommand);
        BLabel bLabel = new BLabel(lex.getText("JobStepChooser.dlgMessage"));
        bLabel.setHalign(BHalign.left);
        if (1 == BCommandDialog.open((BWidget)bWidget, (String)lex.getText("JobStepChooser.dlgTitle"), (Object)new BBorderPane((BWidget)new BEdgePane((BWidget)bLabel, (BWidget)new BBox(300.0, 0.0), (BWidget)new BBox(0.0, 200.0), null, (BWidget)new BBorderPane((BWidget)new BBorderPane((BWidget)bCommandBoundTable, BBorder.inset, BInsets.DEFAULT), 10.0, 0.0, 4.0, 0.0)), 4.0, 10.0, 4.0, 10.0), (DialogCommand[])new DialogCommand[]{dialogCommand, dialogCommand2})) {
            return factoryModel.getFactoryAt(bCommandBoundTable.getSelection().getRow());
        }
        return null;
    }

    private Array getAllFactories() {
        if (this.factories == null) {
            Array array = new Array(class$javax$baja$batchJob$ui$BJobStepFactory == null ? (class$javax$baja$batchJob$ui$BJobStepFactory = JobStepChooser.class$("javax.baja.batchJob.ui.BJobStepFactory")) : class$javax$baja$batchJob$ui$BJobStepFactory);
            TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BJobStepFactory.TYPE.getTypeInfo());
            block0: for (int i = 0; i < typeInfoArray.length; ++i) {
                BJobStepFactory bJobStepFactory = (BJobStepFactory)typeInfoArray[i].getInstance();
                Type[] typeArray = bJobStepFactory.getStageTypes();
                for (int j = 0; j < typeArray.length; ++j) {
                    if (!this.stageType.is(typeArray[j])) continue;
                    array.add((Object)bJobStepFactory);
                    continue block0;
                }
            }
            this.factories = array;
        }
        return this.factories;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static class FactoryModel
    extends TableModel {
        private Array factories;
        private Context cx;

        public FactoryModel(Array array, Context context) {
            this.factories = array;
            this.cx = context;
        }

        public int getRowCount() {
            return this.factories.size();
        }

        public int getColumnCount() {
            return 2;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return lex.getText("JobStepChooser.name");
                }
                case 1: {
                    return lex.getText("JobStepChooser.summary");
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BImage getRowIcon(int n) {
            return BImage.make((BIcon)this.getFactoryAt(n).asObject().getIcon());
        }

        public Object getValueAt(int n, int n2) {
            switch (n2) {
                case 0: {
                    return this.getFactoryAt(n).getType().getDisplayName(this.cx);
                }
                case 1: {
                    return this.getFactoryAt(n).getDescription(this.cx);
                }
            }
            throw new ArrayIndexOutOfBoundsException();
        }

        public BJobStepFactory getFactoryAt(int n) {
            return (BJobStepFactory)((Object)this.factories.get(n));
        }
    }

    private static class FactoryComparator
    implements Comparator {
        private Context cx;

        public FactoryComparator(Context context) {
            this.cx = context;
        }

        public int compare(Object object, Object object2) {
            BJobStepFactory bJobStepFactory = (BJobStepFactory)((Object)object);
            BJobStepFactory bJobStepFactory2 = (BJobStepFactory)((Object)object2);
            return bJobStepFactory.getType().getDisplayName(this.cx).compareTo(bJobStepFactory2.getType().getDisplayName(this.cx));
        }
    }

    private class StepFilter
    implements IFilter {
        private BBatchJob currentBatchJob;
        private BObject jobTarget;

        public StepFilter(BBatchJob bBatchJob, BObject bObject) {
            this.currentBatchJob = bBatchJob;
            this.jobTarget = bObject;
        }

        public boolean accept(Object object) {
            try {
                return ((BJobStepFactory)((Object)object)).isValidFor(this.currentBatchJob, this.jobTarget, JobStepChooser.this.stageType, null);
            }
            catch (Exception exception) {
                exception.printStackTrace();
                return false;
            }
        }
    }
}

