/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.history;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BIBatchHistoryRecord;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.history.BHistoryRecord;
import javax.baja.job.BJobState;
import javax.baja.naming.UnresolvedException;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public abstract class BJobStepHistoryRecord
extends BHistoryRecord
implements BIJobStepSummary,
BIBatchHistoryRecord {
    public static final Property jobStartTime = BJobStepHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property detailsType = BJobStepHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property stepType = BJobStepHistoryRecord.newProperty((int)1, (BValue)BTypeSpec.NULL, null);
    public static final Property stepDescription = BJobStepHistoryRecord.newProperty((int)1, (String)"", null);
    public static final Property stepState = BJobStepHistoryRecord.newProperty((int)1, (BValue)BJobState.unknown, null);
    public static final Property endTime = BJobStepHistoryRecord.newProperty((int)1, (BValue)BAbsTime.NULL, null);
    public static final Property disposed = BJobStepHistoryRecord.newProperty((int)1, (boolean)false, null);
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$history$BJobStepHistoryRecord == null ? (class$com$tridium$batchJob$history$BJobStepHistoryRecord = BJobStepHistoryRecord.class$("com.tridium.batchJob.history.BJobStepHistoryRecord")) : class$com$tridium$batchJob$history$BJobStepHistoryRecord));
    protected BJobStepDetails stepDetails = null;
    protected BBatchJob job = null;
    protected BTimeZone localTz = BTimeZone.NULL;
    static /* synthetic */ Class class$com$tridium$batchJob$history$BJobStepHistoryRecord;

    public BAbsTime getJobStartTime() {
        return (BAbsTime)this.get(jobStartTime);
    }

    public void setJobStartTime(BAbsTime bAbsTime) {
        this.set(jobStartTime, (BValue)bAbsTime, null);
    }

    public BTypeSpec getDetailsType() {
        return (BTypeSpec)this.get(detailsType);
    }

    public void setDetailsType(BTypeSpec bTypeSpec) {
        this.set(detailsType, (BValue)bTypeSpec, null);
    }

    public BTypeSpec getStepType() {
        return (BTypeSpec)this.get(stepType);
    }

    public void setStepType(BTypeSpec bTypeSpec) {
        this.set(stepType, (BValue)bTypeSpec, null);
    }

    public String getStepDescription() {
        return this.getString(stepDescription);
    }

    public void setStepDescription(String string) {
        this.setString(stepDescription, string, null);
    }

    public BJobState getStepState() {
        return (BJobState)this.get(stepState);
    }

    public void setStepState(BJobState bJobState) {
        this.set(stepState, (BValue)bJobState, null);
    }

    public BAbsTime getEndTime() {
        return (BAbsTime)this.get(endTime);
    }

    public void setEndTime(BAbsTime bAbsTime) {
        this.set(endTime, (BValue)bAbsTime, null);
    }

    public boolean getDisposed() {
        return this.getBoolean(disposed);
    }

    public void setDisposed(boolean bl) {
        this.setBoolean(disposed, bl, null);
    }

    public Type getType() {
        return TYPE;
    }

    protected BJobStepHistoryRecord() {
    }

    protected BJobStepHistoryRecord(BJobStepDetails bJobStepDetails, BAbsTime bAbsTime) {
        this.setJobStartTime(bAbsTime);
        this.update(bJobStepDetails);
    }

    public void setStartTime(BAbsTime bAbsTime) {
        this.setTimestamp(bAbsTime);
    }

    public BAbsTime getStartTime() {
        return this.getTimestamp();
    }

    public BBatchJob getJob(BObject bObject) throws Exception {
        if (this.job == null) {
            try {
                BBatchJobLogFile bBatchJobLogFile = BBatchJobLogFile.find(this.getLocalJobStartTime(), bObject);
                this.job = bBatchJobLogFile.getJob();
                this.job.setStartTimeLocalZone(this.localTz);
                this.job.setDisplayTimeZone(this.getJobStartTime().getTimeZone());
            }
            catch (UnresolvedException unresolvedException) {
                return null;
            }
        }
        return this.job;
    }

    public void update(BJobStepDetails bJobStepDetails) {
        if (bJobStepDetails.getJob() != null) {
            this.setJobStartTime(bJobStepDetails.getJob().getStartTime());
        }
        this.setStepType(bJobStepDetails.getStepType());
        this.setDetailsType(bJobStepDetails.getType().getTypeSpec());
        if (this.getStartTime().getMillis() != bJobStepDetails.getStartTime().getMillis()) {
            this.setStartTime(bJobStepDetails.getStartTime());
        }
        this.setStepState(bJobStepDetails.getState());
        if (this.getEndTime().getMillis() != bJobStepDetails.getEndTime().getMillis()) {
            this.setEndTime(bJobStepDetails.getEndTime());
        }
        this.setStepDescription(bJobStepDetails.getStepDescription());
        this.stepDetails = bJobStepDetails;
    }

    public abstract BJobStepDetails getStepDetails(BObject var1) throws Exception;

    public void setLocalTimeZone(BTimeZone bTimeZone) {
        if (!this.localTz.equals((Object)bTimeZone)) {
            this.localTz = bTimeZone;
        }
    }

    public BAbsTime getLocalJobStartTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getJobStartTime(), this.localTz);
    }

    public BAbsTime getLocalStartTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getStartTime(), this.localTz);
    }

    public BAbsTime getLocalEndTime() {
        return BLocalTimeUtil.getAdjustedTimeZone(this.getEndTime(), this.localTz);
    }

    public boolean isFixedSize() {
        return false;
    }

    protected void doRead(DataInput dataInput) throws IOException {
        this.localTz = BTimeZone.NULL;
        this.setJobStartTime((BAbsTime)BAbsTime.DEFAULT.decodeFromString(dataInput.readUTF()));
        this.setDetailsType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(dataInput.readUTF()));
        this.setStepType((BTypeSpec)BTypeSpec.DEFAULT.decodeFromString(dataInput.readUTF()));
        this.setStepDescription(dataInput.readUTF());
        this.setStepState((BJobState)BJobState.unknown.decodeFromString(dataInput.readUTF()));
        this.setEndTime((BAbsTime)BAbsTime.DEFAULT.decodeFromString(dataInput.readUTF()));
        this.setDisposed(dataInput.readBoolean());
    }

    protected void doWrite(DataOutput dataOutput) throws IOException {
        dataOutput.writeUTF(this.getJobStartTime().encodeToString());
        dataOutput.writeUTF(this.getDetailsType().encodeToString());
        dataOutput.writeUTF(this.getStepType().encodeToString());
        dataOutput.writeUTF(this.getStepDescription());
        dataOutput.writeUTF(this.getStepState().encodeToString());
        dataOutput.writeUTF(this.getEndTime().encodeToString());
        dataOutput.writeBoolean(this.getDisposed());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

