/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob.history;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BBatchJobStepLogFile;
import com.tridium.batchJob.TZFixedHistoryCollectionsCursor;
import com.tridium.batchJob.history.BBatchJobHistoryRecord;
import com.tridium.batchJob.history.BJobStepHistoryRecord;
import com.tridium.bql.query.BBqlEngine;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeMap;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIBatchJobSummary;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BIJobSummaryManager;
import javax.baja.batchJob.BJobStep;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.collection.BICollection;
import javax.baja.file.BDirectory;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.history.BCapacity;
import javax.baja.history.BHistoryConfig;
import javax.baja.history.BHistoryId;
import javax.baja.history.BHistoryRecord;
import javax.baja.history.BHistoryService;
import javax.baja.history.BIHistory;
import javax.baja.history.BIHistoryRecordSet;
import javax.baja.history.HistoryQuery;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.query.BExpression;
import javax.baja.query.BQuery;
import javax.baja.query.util.Predicates;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BSimple;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Cursor;
import javax.baja.sys.ServiceNotFoundException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;

public class BHistoryJobSummaryManager
extends BComponent
implements BIJobSummaryManager {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$history$BHistoryJobSummaryManager == null ? (class$com$tridium$batchJob$history$BHistoryJobSummaryManager = BHistoryJobSummaryManager.class$("com.tridium.batchJob.history.BHistoryJobSummaryManager")) : class$com$tridium$batchJob$history$BHistoryJobSummaryManager));
    static /* synthetic */ Class class$com$tridium$batchJob$history$BHistoryJobSummaryManager;
    static /* synthetic */ Class class$com$tridium$batchJob$history$BJobStepHistoryRecord;
    static /* synthetic */ Class class$com$tridium$batchJob$history$BBatchJobHistoryRecord;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BIBatchJobSummary makeJobSummary(BBatchJob bBatchJob) {
        TypeInfo typeInfo = BHistoryJobSummaryManager.getJobHistoryRecordType(bBatchJob.getType().getTypeInfo());
        if (typeInfo == null) {
            return null;
        }
        BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)typeInfo.getInstance();
        bIBatchJobSummary.updateJob(bBatchJob);
        return bIBatchJobSummary;
    }

    public BIJobStepSummary makeStepSummary(BJobStepDetails bJobStepDetails, BAbsTime bAbsTime) {
        BJobStepHistoryRecord bJobStepHistoryRecord = this.makeStepRecord(bJobStepDetails);
        bJobStepHistoryRecord.setJobStartTime(bAbsTime);
        return bJobStepHistoryRecord;
    }

    public Cursor listJobSummaries(Type type, BObject bObject) throws Exception {
        return this.listJobSummaries(type, null, bObject);
    }

    public Cursor listJobSummaries(Type type, String string, BSimple bSimple, BObject bObject) throws Exception {
        return this.listJobSummaries(type, Predicates.eq((String)string, (BSimple)bSimple), bObject);
    }

    public Cursor listJobSummaries(Type type, BExpression bExpression, BObject bObject) {
        BExpression bExpression2 = Predicates.eq((String)"disposed", (BSimple)BBoolean.FALSE);
        bExpression = bExpression == null ? bExpression2 : Predicates.and((BExpression)bExpression, (BExpression)bExpression2);
        bExpression = Predicates.and((BExpression)bExpression, (BExpression)Predicates.eq((String)"jobType", (BSimple)type.getTypeSpec()));
        TypeInfo[] typeInfoArray = this.getJobHistoryRecordTypes(type.getTypeInfo());
        TZFixedHistoryCollectionsCursor.Entry[] entryArray = new TZFixedHistoryCollectionsCursor.Entry[typeInfoArray.length];
        BQuery bQuery = new BQuery().where(bExpression);
        BBqlEngine bBqlEngine = new BBqlEngine();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            BOrd bOrd = BOrd.make((BOrd)BOrd.toSession((BObject)bObject).getAbsoluteOrd(), (OrdQuery)new HistoryQuery("^" + typeInfoArray[i].getTypeName()));
            BTimeZone bTimeZone = ((BIHistory)bOrd.get()).getConfig().getTimeZone();
            entryArray[i] = new TZFixedHistoryCollectionsCursor.Entry(bTimeZone, (BICollection)bBqlEngine.compile(bQuery, bOrd).execute());
        }
        return new TZFixedHistoryCollectionsCursor(entryArray);
    }

    public Cursor listStepSummaries(Type type, BObject bObject) throws Exception {
        return this.listStepSummaries(type, null, bObject);
    }

    public Cursor listStepSummaries(Type type, String string, BSimple bSimple, BObject bObject) throws Exception {
        return this.listStepSummaries(type, Predicates.eq((String)string, (BSimple)bSimple), bObject);
    }

    public Cursor listStepSummaries(Type type, BExpression bExpression, BObject bObject) {
        BExpression bExpression2 = Predicates.eq((String)"disposed", (BSimple)BBoolean.FALSE);
        bExpression = bExpression == null ? bExpression2 : Predicates.and((BExpression)bExpression, (BExpression)bExpression2);
        bExpression = Predicates.and((BExpression)bExpression, (BExpression)Predicates.eq((String)"stepType", (BSimple)type.getTypeSpec()));
        TypeInfo[] typeInfoArray = this.getStepHistoryRecordTypes(type.getTypeInfo());
        TZFixedHistoryCollectionsCursor.Entry[] entryArray = new TZFixedHistoryCollectionsCursor.Entry[typeInfoArray.length];
        BQuery bQuery = new BQuery().where(bExpression);
        BBqlEngine bBqlEngine = new BBqlEngine();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            BOrd bOrd = BOrd.make((BOrd)BOrd.toSession((BObject)bObject).getAbsoluteOrd(), (OrdQuery)new HistoryQuery("^" + typeInfoArray[i].getTypeName()));
            BTimeZone bTimeZone = ((BIHistory)bOrd.get()).getConfig().getTimeZone();
            entryArray[i] = new TZFixedHistoryCollectionsCursor.Entry(bTimeZone, (BICollection)bBqlEngine.compile(bQuery, bOrd).execute());
        }
        return new TZFixedHistoryCollectionsCursor(entryArray);
    }

    public String batchJobServiceStarted() {
        RecordTypeInfo[] recordTypeInfoArray;
        try {
            recordTypeInfoArray = (RecordTypeInfo[])Sys.getService((Type)Sys.getType((String)"history:HistoryService"));
            recordTypeInfoArray.serviceStarted();
        }
        catch (ServiceNotFoundException serviceNotFoundException) {
            return "HistoryJobSummaryManager requires that a HistoryService be installed";
        }
        try {
            int n;
            int n2;
            recordTypeInfoArray = this.getJobRecordTypeInfo();
            RecordTypeInfo[] recordTypeInfoArray2 = this.getStepRecordTypeInfo();
            boolean bl = false;
            for (n2 = 0; n2 < recordTypeInfoArray.length; ++n2) {
                if (recordTypeInfoArray[n2].history != null) continue;
                bl = true;
                break;
            }
            if (!bl) {
                for (n2 = 0; n2 < recordTypeInfoArray2.length; ++n2) {
                    if (recordTypeInfoArray2[n2].history != null) continue;
                    bl = true;
                    break;
                }
            }
            if (!bl) {
                return null;
            }
            BHistoryService bHistoryService = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
            for (n = 0; n < recordTypeInfoArray.length; ++n) {
                if (recordTypeInfoArray[n].history == null) {
                    this.createHistory(bHistoryService, recordTypeInfoArray[n].info);
                    continue;
                }
                bHistoryService.getDatabase().clearAllRecords(recordTypeInfoArray[n].history.getId(), null);
            }
            for (n = 0; n < recordTypeInfoArray2.length; ++n) {
                if (recordTypeInfoArray2[n].history == null) {
                    this.createHistory(bHistoryService, recordTypeInfoArray2[n].info);
                    continue;
                }
                bHistoryService.getDatabase().clearAllRecords(recordTypeInfoArray2[n].history.getId(), null);
            }
            BDirectory bDirectory = (BDirectory)BFileSystem.INSTANCE.findFile(new FilePath("^batchJob/logs"));
            if (bDirectory != null) {
                BIFile[] bIFileArray = bDirectory.listFiles();
                for (int i = 0; i < bIFileArray.length; ++i) {
                    Object object;
                    if (!(bIFileArray[i] instanceof BDirectory)) continue;
                    BDirectory bDirectory2 = (BDirectory)bIFileArray[i];
                    BIFile[] bIFileArray2 = bDirectory2.listFiles();
                    TreeMap<BAbsTime, BIFile> treeMap = new TreeMap<BAbsTime, BIFile>();
                    TreeMap<BAbsTime, BIFile> treeMap2 = new TreeMap<BAbsTime, BIFile>();
                    for (int j = 0; j < bIFileArray2.length; ++j) {
                        if (bIFileArray2[j] instanceof BBatchJobLogFile) {
                            treeMap.put(((BBatchJobLogFile)bIFileArray2[j]).getFilenameTime(), bIFileArray2[j]);
                            continue;
                        }
                        if (!(bIFileArray2[j] instanceof BBatchJobStepLogFile)) continue;
                        treeMap2.put(((BBatchJobStepLogFile)bIFileArray2[j]).getFilenameTime(), bIFileArray2[j]);
                    }
                    Iterator iterator = treeMap.values().iterator();
                    while (iterator.hasNext()) {
                        object = ((BBatchJobLogFile)((Object)iterator.next())).getJob();
                        this.writeJobHistory((BBatchJob)object);
                    }
                    iterator = treeMap2.values().iterator();
                    while (iterator.hasNext()) {
                        object = ((BBatchJobStepLogFile)((Object)iterator.next())).getDetails();
                        this.writeStepHistory((BJobStepDetails)((Object)object));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return "History initialization failed";
        }
        return null;
    }

    public void importSummaries(BIJobSummaryManager bIJobSummaryManager) throws Exception {
        Cursor cursor = bIJobSummaryManager.getAllJobSummaries();
        while (cursor.next()) {
            BIBatchJobSummary bIBatchJobSummary = (BIBatchJobSummary)cursor.get();
            BBatchJob bBatchJob = bIBatchJobSummary.getJob((BObject)this);
            this.write(this.makeJobSummary(bBatchJob));
            BJobStepDetails[] bJobStepDetailsArray = bBatchJob.getJobStepDetails();
            for (int i = 0; i < bJobStepDetailsArray.length; ++i) {
                this.write(this.makeStepSummary(bJobStepDetailsArray[i], bBatchJob.getStartTime()));
            }
        }
    }

    public void performHousekeeping() throws Exception {
        BJobStepHistoryRecord bJobStepHistoryRecord;
        Cursor cursor;
        BIHistory bIHistory;
        TypeInfo typeInfo;
        int n;
        BHistoryService bHistoryService = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BBatchJob.TYPE.getTypeInfo());
        HashSet<String> hashSet = new HashSet<String>();
        block4: for (n = 0; n < typeInfoArray.length; ++n) {
            try {
                typeInfo = BHistoryJobSummaryManager.getJobHistoryRecordType(typeInfoArray[n]);
                if (typeInfo == null || (bIHistory = this.getHistory(typeInfo)) == null || hashSet.contains(bIHistory.getId().toString())) continue;
                hashSet.add(bIHistory.getId().toString());
                cursor = bIHistory.scan();
                while (cursor.next(class$com$tridium$batchJob$history$BJobStepHistoryRecord == null ? BHistoryJobSummaryManager.class$("com.tridium.batchJob.history.BJobStepHistoryRecord") : class$com$tridium$batchJob$history$BJobStepHistoryRecord)) {
                    bJobStepHistoryRecord = (BJobStepHistoryRecord)cursor.get();
                    if (bJobStepHistoryRecord.getDisposed()) continue;
                    bHistoryService.getDatabase().clearOldRecords(bIHistory.getId(), bJobStepHistoryRecord.getStartTime(), null);
                    continue block4;
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        typeInfoArray = Sys.getRegistry().getConcreteTypes(BJobStep.TYPE.getTypeInfo());
        hashSet = new HashSet();
        block6: for (n = 0; n < typeInfoArray.length; ++n) {
            try {
                typeInfo = BHistoryJobSummaryManager.getStepHistoryRecordType(typeInfoArray[n]);
                if (typeInfo == null || hashSet.contains((bIHistory = this.getHistory(typeInfo)).getId().toString())) continue;
                hashSet.add(bIHistory.getId().toString());
                cursor = bIHistory.scan();
                while (cursor.next(class$com$tridium$batchJob$history$BJobStepHistoryRecord == null ? BHistoryJobSummaryManager.class$("com.tridium.batchJob.history.BJobStepHistoryRecord") : class$com$tridium$batchJob$history$BJobStepHistoryRecord)) {
                    bJobStepHistoryRecord = (BJobStepHistoryRecord)cursor.get();
                    if (bJobStepHistoryRecord.getDisposed()) continue;
                    bHistoryService.getDatabase().clearOldRecords(bIHistory.getId(), bJobStepHistoryRecord.getStartTime(), null);
                    continue block6;
                }
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void write(BIBatchJobSummary bIBatchJobSummary) throws Exception {
        try {
            this.getHistory(bIBatchJobSummary.getType().getTypeInfo()).append((BIHistoryRecordSet)((BBatchJobHistoryRecord)bIBatchJobSummary));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void write(BIJobStepSummary bIJobStepSummary) throws Exception {
        try {
            this.getHistory(bIJobStepSummary.getType().getTypeInfo()).append((BIHistoryRecordSet)((BJobStepHistoryRecord)bIJobStepSummary));
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    public void disposeJobSummary(Type type, BAbsTime bAbsTime) throws Exception {
        TypeInfo[] typeInfoArray = this.getJobHistoryRecordTypes(type.getTypeInfo());
        for (int i = 0; i < typeInfoArray.length; ++i) {
            try {
                BBatchJobHistoryRecord bBatchJobHistoryRecord = null;
                BIHistory bIHistory = this.getHistory(typeInfoArray[i]);
                Cursor cursor = bIHistory.timeQuery(bAbsTime, bAbsTime).cursor();
                while (cursor.next(class$com$tridium$batchJob$history$BBatchJobHistoryRecord == null ? BHistoryJobSummaryManager.class$("com.tridium.batchJob.history.BBatchJobHistoryRecord") : class$com$tridium$batchJob$history$BBatchJobHistoryRecord)) {
                    BBatchJobHistoryRecord bBatchJobHistoryRecord2 = (BBatchJobHistoryRecord)((BBatchJobHistoryRecord)cursor.get()).newCopy();
                    if (bBatchJobHistoryRecord2.getTimestamp().getMillis() != bAbsTime.getMillis()) continue;
                    if (bBatchJobHistoryRecord == null) {
                        bBatchJobHistoryRecord = bBatchJobHistoryRecord2;
                        continue;
                    }
                    throw new BajaRuntimeException("Multiple records exist for start time");
                }
                if (bBatchJobHistoryRecord != null) {
                    if (!bBatchJobHistoryRecord.getDisposed()) {
                        bBatchJobHistoryRecord.setDisposed(true);
                        bIHistory.update((BHistoryRecord)bBatchJobHistoryRecord, null);
                    }
                    return;
                }
                System.out.println("history not found! " + bAbsTime.getMillis());
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    public void disposeStepSummary(Type type, BAbsTime bAbsTime) throws Exception {
        TypeInfo[] typeInfoArray = this.getStepHistoryRecordTypes(type.getTypeInfo());
        for (int i = 0; i < typeInfoArray.length; ++i) {
            try {
                BJobStepHistoryRecord bJobStepHistoryRecord = null;
                BIHistory bIHistory = this.getHistory(typeInfoArray[i]);
                Cursor cursor = bIHistory.timeQuery(bAbsTime, bAbsTime).cursor();
                while (cursor.next(class$com$tridium$batchJob$history$BJobStepHistoryRecord == null ? BHistoryJobSummaryManager.class$("com.tridium.batchJob.history.BJobStepHistoryRecord") : class$com$tridium$batchJob$history$BJobStepHistoryRecord)) {
                    if (bJobStepHistoryRecord == null) {
                        bJobStepHistoryRecord = (BJobStepHistoryRecord)((BJobStepHistoryRecord)cursor.get()).newCopy();
                        continue;
                    }
                    throw new BajaRuntimeException("Multiple records exist for start time");
                }
                if (bJobStepHistoryRecord == null) continue;
                bJobStepHistoryRecord.setDisposed(true);
                bIHistory.update((BHistoryRecord)bJobStepHistoryRecord, null);
                continue;
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }
    }

    public void removeSummaryManager() throws Exception {
        int n;
        BHistoryService bHistoryService = (BHistoryService)Sys.getService((Type)BHistoryService.TYPE);
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BBatchJobHistoryRecord.TYPE.getTypeInfo());
        for (n = 0; n < typeInfoArray.length; ++n) {
            bHistoryService.getDatabase().deleteHistory(this.getHistory(typeInfoArray[n]).getId(), null);
        }
        typeInfoArray = Sys.getRegistry().getConcreteTypes(BJobStepHistoryRecord.TYPE.getTypeInfo());
        for (n = 0; n < typeInfoArray.length; ++n) {
            bHistoryService.getDatabase().deleteHistory(this.getHistory(typeInfoArray[n]).getId(), null);
        }
    }

    public Cursor getAllJobSummaries() throws Exception {
        return new AllJobSummaries();
    }

    public static TypeInfo getJobHistoryRecordType(TypeInfo typeInfo) {
        if (!typeInfo.is(BBatchJob.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BBatchJob subtype: " + typeInfo);
        }
        AgentList agentList = Sys.getRegistry().getAgents(typeInfo).filter(AgentFilter.is((Type)BBatchJobHistoryRecord.TYPE));
        return agentList.size() == 0 ? null : agentList.getDefault().getAgentType();
    }

    public static TypeInfo getStepHistoryRecordType(TypeInfo typeInfo) {
        if (!typeInfo.is(BJobStep.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BJobStep subtype");
        }
        AgentList agentList = Sys.getRegistry().getAgents(typeInfo).filter(AgentFilter.is((Type)BJobStepHistoryRecord.TYPE));
        return agentList.size() == 0 ? null : agentList.getDefault().getAgentType();
    }

    protected BJobStepHistoryRecord makeStepRecord(BJobStepDetails bJobStepDetails) {
        BJobStepHistoryRecord bJobStepHistoryRecord = (BJobStepHistoryRecord)BHistoryJobSummaryManager.getStepHistoryRecordType(bJobStepDetails.getStepType().getTypeInfo()).getInstance();
        bJobStepHistoryRecord.update(bJobStepDetails);
        return bJobStepHistoryRecord;
    }

    protected TypeInfo[] getJobHistoryRecordTypes(TypeInfo typeInfo) {
        if (!typeInfo.is(BBatchJob.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BBatchJob subtype: " + typeInfo);
        }
        AgentInfo[] agentInfoArray = Sys.getRegistry().getAgents(typeInfo).filter(AgentFilter.is((Type)BBatchJobHistoryRecord.TYPE)).list();
        TypeInfo[] typeInfoArray = new TypeInfo[agentInfoArray.length];
        for (int i = 0; i < agentInfoArray.length; ++i) {
            typeInfoArray[i] = agentInfoArray[i].getAgentType();
        }
        return typeInfoArray;
    }

    protected TypeInfo[] getStepHistoryRecordTypes(TypeInfo typeInfo) {
        if (!typeInfo.is(BJobStep.TYPE.getTypeInfo())) {
            throw new IllegalArgumentException("Not a BJobStep subtype");
        }
        AgentInfo[] agentInfoArray = Sys.getRegistry().getAgents(typeInfo).filter(AgentFilter.is((Type)BJobStepHistoryRecord.TYPE)).list();
        TypeInfo[] typeInfoArray = new TypeInfo[agentInfoArray.length];
        for (int i = 0; i < agentInfoArray.length; ++i) {
            typeInfoArray[i] = agentInfoArray[i].getAgentType();
        }
        return typeInfoArray;
    }

    protected RecordTypeInfo[] getJobRecordTypeInfo() throws Exception {
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BBatchJob.TYPE.getTypeInfo());
        HashSet<RecordTypeInfo> hashSet = new HashSet<RecordTypeInfo>();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            TypeInfo typeInfo = BHistoryJobSummaryManager.getJobHistoryRecordType(typeInfoArray[i]);
            if (typeInfo == null) continue;
            hashSet.add(new RecordTypeInfo(typeInfo, this.getHistory(typeInfo)));
        }
        RecordTypeInfo[] recordTypeInfoArray = new RecordTypeInfo[hashSet.size()];
        hashSet.toArray(recordTypeInfoArray);
        return recordTypeInfoArray;
    }

    protected RecordTypeInfo[] getStepRecordTypeInfo() throws Exception {
        TypeInfo[] typeInfoArray = Sys.getRegistry().getConcreteTypes(BJobStep.TYPE.getTypeInfo());
        HashSet<RecordTypeInfo> hashSet = new HashSet<RecordTypeInfo>();
        for (int i = 0; i < typeInfoArray.length; ++i) {
            TypeInfo typeInfo = BHistoryJobSummaryManager.getStepHistoryRecordType(typeInfoArray[i]);
            if (typeInfo == null) continue;
            hashSet.add(new RecordTypeInfo(typeInfo, this.getHistory(typeInfo)));
        }
        RecordTypeInfo[] recordTypeInfoArray = new RecordTypeInfo[hashSet.size()];
        hashSet.toArray(recordTypeInfoArray);
        return recordTypeInfoArray;
    }

    protected void createHistory(BHistoryService bHistoryService, TypeInfo typeInfo) throws Exception {
        BHistoryId bHistoryId = BHistoryId.make((String)("/" + Sys.getStation().getStationName() + "/" + typeInfo.getTypeName()));
        BHistoryConfig bHistoryConfig = new BHistoryConfig(bHistoryId, typeInfo.getTypeSpec(), BCapacity.UNLIMITED);
        bHistoryConfig.setTimeZone(BTimeZone.getLocal());
        bHistoryService.getDatabase().createHistory(bHistoryConfig);
    }

    protected void writeJobHistory(BBatchJob bBatchJob) {
        try {
            TypeInfo typeInfo = BHistoryJobSummaryManager.getJobHistoryRecordType(bBatchJob.getType().getTypeInfo());
            if (typeInfo != null) {
                this.getHistory(typeInfo).append((BIHistoryRecordSet)((BHistoryRecord)this.makeJobSummary(bBatchJob)));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    protected void writeStepHistory(BJobStepDetails bJobStepDetails) {
        try {
            TypeInfo typeInfo = BHistoryJobSummaryManager.getStepHistoryRecordType(bJobStepDetails.getStepType().getTypeInfo());
            if (typeInfo != null) {
                this.getHistory(typeInfo).append((BIHistoryRecordSet)this.makeStepRecord(bJobStepDetails));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new BajaRuntimeException((Throwable)exception);
        }
    }

    protected BIHistory getHistory(TypeInfo typeInfo) throws Exception {
        if (Sys.getStation() == null) {
            throw new IllegalStateException("Not in a running station");
        }
        String string = Sys.getStation().getStationName();
        BHistoryService bHistoryService = (BHistoryService)BOrd.make((String)"service:history:HistoryService").get();
        BHistoryId bHistoryId = BHistoryId.make((String)("/" + string + "/" + typeInfo.getTypeName()));
        if (bHistoryService.getDatabase().exists(bHistoryId)) {
            return bHistoryService.getDatabase().resolveHistory(bHistoryId);
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    protected class AllJobSummaries
    implements Cursor {
        private TypeInfo[] types = Sys.getRegistry().getConcreteTypes(BBatchJobHistoryRecord.TYPE.getTypeInfo());
        private int typeIdx = -1;
        private Cursor innerCursor = null;

        public Context getContext() {
            return null;
        }

        public boolean next() {
            try {
                while (true) {
                    if (this.innerCursor == null) {
                        if (this.typeIdx >= this.types.length - 1) {
                            return false;
                        }
                        ++this.typeIdx;
                        this.innerCursor = BHistoryJobSummaryManager.this.getHistory(this.types[this.typeIdx++]).scan();
                        continue;
                    }
                    if (this.innerCursor.next()) {
                        return true;
                    }
                    this.innerCursor = null;
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new BajaRuntimeException((Throwable)exception);
            }
        }

        public boolean nextComponent() {
            return this.next(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BHistoryJobSummaryManager.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        }

        public boolean next(Class clazz) {
            while (this.next()) {
                if (!clazz.isAssignableFrom(this.get().getClass())) continue;
                return true;
            }
            return false;
        }

        public BObject get() {
            if (this.innerCursor == null) {
                throw new IllegalStateException("Attempt to read cursor before beginning or after end");
            }
            return this.innerCursor.get();
        }
    }

    protected static class RecordTypeInfo {
        public TypeInfo info;
        public BIHistory history;

        public RecordTypeInfo(TypeInfo typeInfo, BIHistory bIHistory) {
            this.info = typeInfo;
            this.history = bIHistory;
        }

        public boolean equals(Object object) {
            if (object instanceof RecordTypeInfo) {
                RecordTypeInfo recordTypeInfo = (RecordTypeInfo)object;
                return recordTypeInfo.info.getModuleName().equals(this.info.getModuleName()) && recordTypeInfo.info.getTypeName().equals(this.info.getTypeName());
            }
            return false;
        }

        public int hashCode() {
            return this.info.hashCode();
        }
    }
}

