/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.batchJob;

import com.tridium.batchJob.BBatchJobLogFile;
import com.tridium.batchJob.BLocalTimeUtil;
import com.tridium.batchJob.history.BHistoryJobSummaryManager;
import com.tridium.batchJob.history.BJobStepHistoryRecord;
import com.tridium.util.TimeFormat;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import javax.baja.batchJob.BBatchJob;
import javax.baja.batchJob.BIJobStepSummary;
import javax.baja.batchJob.BJobStepDetails;
import javax.baja.data.BIDataValue;
import javax.baja.file.BAbstractFile;
import javax.baja.file.BFileSystem;
import javax.baja.file.BIFile;
import javax.baja.file.BIFileStore;
import javax.baja.file.FilePath;
import javax.baja.io.ValueDocEncoder;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdQuery;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BAbsTime;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.timezone.BTimeZone;
import javax.baja.util.BTypeSpec;

public class BBatchJobStepLogFile
extends BAbstractFile {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$batchJob$BBatchJobStepLogFile == null ? (class$com$tridium$batchJob$BBatchJobStepLogFile = BBatchJobStepLogFile.class$("com.tridium.batchJob.BBatchJobStepLogFile")) : class$com$tridium$batchJob$BBatchJobStepLogFile));
    private BJobStepDetails details = null;
    private BAbsTime jobStartTime = null;
    private BString logContents = null;
    public static final String STEP_FILENAME_FORMAT = "yyyyMMdd_HHmmss.SSS.'bjsl'";
    public static final BFacets TIMESTAMP_FORMAT = BFacets.make((String[])new String[]{"timeFormat", "showDate", "showTime", "showSeconds", "showMilliseconds"}, (BIDataValue[])new BIDataValue[]{BString.make((String)"YYYYMMDD_HHmmss"), BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE, BBoolean.TRUE});
    static /* synthetic */ Class class$com$tridium$batchJob$BBatchJobStepLogFile;

    public Type getType() {
        return TYPE;
    }

    public BBatchJobStepLogFile(BIFileStore bIFileStore) {
        super(bIFileStore);
    }

    public BBatchJobStepLogFile() {
    }

    public static BBatchJobStepLogFile find(BJobStepDetails bJobStepDetails, BObject bObject) {
        return (BBatchJobStepLogFile)BOrd.make((OrdQuery)BBatchJobStepLogFile.pathFor(bJobStepDetails.getStepType(), bJobStepDetails.getLocalStartTime(), bObject)).get(bObject);
    }

    public static BBatchJobStepLogFile find(BTypeSpec bTypeSpec, BAbsTime bAbsTime, BObject bObject) {
        return (BBatchJobStepLogFile)BOrd.make((OrdQuery)BBatchJobStepLogFile.pathFor(bTypeSpec, bAbsTime, bObject)).get(bObject);
    }

    public static BBatchJobStepLogFile find(BIJobStepSummary bIJobStepSummary, BObject bObject) {
        return (BBatchJobStepLogFile)BOrd.make((OrdQuery)BBatchJobStepLogFile.pathFor(bIJobStepSummary.getStepType(), bIJobStepSummary.getLocalStartTime(), bObject)).get(bObject);
    }

    public static BBatchJobStepLogFile findLocal(BJobStepDetails bJobStepDetails) {
        return (BBatchJobStepLogFile)BOrd.make((OrdQuery)BBatchJobStepLogFile.pathFor(bJobStepDetails.getStepType(), bJobStepDetails.getLocalStartTime(), null)).get();
    }

    public static BBatchJobStepLogFile findLocal(BTypeSpec bTypeSpec, BAbsTime bAbsTime) {
        return (BBatchJobStepLogFile)BOrd.make((OrdQuery)BBatchJobStepLogFile.pathFor(bTypeSpec, bAbsTime, null)).get();
    }

    public static BBatchJobStepLogFile findLocal(BJobStepHistoryRecord bJobStepHistoryRecord) {
        return (BBatchJobStepLogFile)BOrd.make((OrdQuery)BBatchJobStepLogFile.pathFor(bJobStepHistoryRecord.getStepType(), bJobStepHistoryRecord.getLocalStartTime(), null)).get();
    }

    public static BBatchJobStepLogFile create(BJobStepDetails bJobStepDetails, BAbsTime bAbsTime) throws IOException {
        BBatchJobStepLogFile bBatchJobStepLogFile = (BBatchJobStepLogFile)BFileSystem.INSTANCE.makeFile(BBatchJobStepLogFile.pathFor(bJobStepDetails.getStepType(), bJobStepDetails.getLocalStartTime(), null));
        OutputStream outputStream = bBatchJobStepLogFile.getOutputStream();
        ValueDocEncoder valueDocEncoder = new ValueDocEncoder(outputStream);
        valueDocEncoder.setEncodeTransients(true);
        BComponent bComponent = new BComponent();
        bComponent.add("stepDetails", bJobStepDetails.newCopy());
        bComponent.add("jobStartTime", (BValue)bAbsTime);
        bComponent.add("logContents", (BValue)BString.make((String)bJobStepDetails.log().encode()));
        valueDocEncoder.setZipped(true);
        valueDocEncoder.encodeDocument((BValue)bComponent);
        valueDocEncoder.close();
        outputStream.close();
        return bBatchJobStepLogFile;
    }

    public BJobStepDetails getDetails() throws Exception {
        this.parse();
        return this.details;
    }

    public BAbsTime getJobStartTime() throws Exception {
        this.parse();
        return this.jobStartTime;
    }

    public BString getLogContents() throws Exception {
        this.parse();
        return this.logContents;
    }

    public BBatchJob getJob() throws Exception {
        return this.getJobLogFile().getJob();
    }

    public BBatchJobLogFile getJobLogFile() throws Exception {
        return BBatchJobLogFile.find(this.getJobStartTime(), (BObject)this);
    }

    public BAbsTime getFilenameTime() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(STEP_FILENAME_FORMAT);
            simpleDateFormat.setTimeZone(BTimeZone.getLocal().getJavaTimeZone());
            return BAbsTime.make((long)simpleDateFormat.parse(this.getFileName()).getTime());
        }
        catch (ParseException parseException) {
            throw new BajaRuntimeException("Invalid log file name");
        }
    }

    private void parse() throws Exception {
        if (this.details == null) {
            BComponent bComponent = (BComponent)BLocalTimeUtil.decodeBogFile((BIFile)this);
            this.details = (BJobStepDetails)bComponent.get("stepDetails");
            this.jobStartTime = (BAbsTime)bComponent.get("jobStartTime");
            this.details.setLogFile((BIFile)this);
            this.logContents = (BString)bComponent.get("logContents");
            if (this.logContents == null) {
                this.logContents = BString.DEFAULT;
            }
        }
    }

    public void setStore(BIFileStore bIFileStore) {
        super.setStore(bIFileStore);
        this.details = null;
        this.jobStartTime = null;
    }

    public String getMimeType() {
        return "application/niagara-batch-job-step-log";
    }

    public String getNavDescription(Context context) {
        return null;
    }

    public boolean hasNavChildren() {
        return false;
    }

    public BINavNode[] getNavChildren() {
        return new BINavNode[0];
    }

    public BINavNode getNavChild(String string) {
        return null;
    }

    private static FilePath pathFor(BTypeSpec bTypeSpec, BAbsTime bAbsTime, BObject bObject) {
        TypeInfo typeInfo = BHistoryJobSummaryManager.getStepHistoryRecordType(bTypeSpec.getTypeInfo());
        FilePath filePath = new FilePath("^batchJob/logs");
        filePath = filePath.merge(typeInfo.getModuleName() + "_" + typeInfo.getTypeName());
        filePath = filePath.merge(TimeFormat.format((BAbsTime)bAbsTime, (Context)TIMESTAMP_FORMAT) + ".bjsl");
        return filePath;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

