/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.px;

import com.tridium.ui.Binder;
import com.tridium.workbench.px.BWbPxMedia;
import com.tridium.workbench.shell.BErrorPanel;
import com.tridium.workbench.shell.BNiagaraWbShell;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.baja.agent.BAbstractPxView;
import javax.baja.agent.BDynamicPxView;
import javax.baja.agent.BPxView;
import javax.baja.file.BIFile;
import javax.baja.file.FileUtil;
import javax.baja.log.Log;
import javax.baja.naming.BOrd;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBinding;
import javax.baja.ui.BDialog;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.naming.BRootContainer;
import javax.baja.ui.pane.BTextEditorPane;
import javax.baja.ui.px.BPxInclude;
import javax.baja.ui.px.BPxMedia;
import javax.baja.ui.px.PxDecoder;
import javax.baja.ui.px.PxLayer;
import javax.baja.ui.px.PxProperty;
import javax.baja.ui.text.BTextEditor;
import javax.baja.ui.text.TextParser;
import javax.baja.ui.text.parsers.XmlParser;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.view.BWbView;

public class BWbPxView
extends BWbView {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$px$BWbPxView == null ? (class$javax$baja$workbench$px$BWbPxView = BWbPxView.class$("javax.baja.workbench.px.BWbPxView")) : class$javax$baja$workbench$px$BWbPxView));
    static boolean useCache = new Boolean(System.getProperty("wbPxView.useCache", "false"));
    static HashMap cache = new HashMap();
    static Log log = Log.getLog((String)"wbPxView");
    protected PxProperty[] pxProperties = null;
    protected PxLayer[] pxLayers = null;
    private final UiLexicon lex = UiLexicon.bajaui();
    private final String errTitle = this.lex.getText("pxview.error.title");
    private final String errNull = this.lex.getText("pxview.error.null");
    private final String errUnresolved = this.lex.getText("pxview.error.unresolved");
    private final String errXml = this.lex.getText("pxview.error.xml");
    private final String errCast = this.lex.getText("pxview.error.cast");
    private final BAbstractPxView agent;
    private BPxMedia media = BWbPxMedia.INSTANCE;
    private BWidget widget = null;
    private boolean fileBased = false;
    private boolean dynamic = false;
    private BIFile pxFile = null;
    private BOrd pxOrd = BOrd.NULL;
    private String pxSource = null;
    private Command cmdViewSource = new ViewSource(this);
    private Command cmdGotoSource = new GotoSource(this);
    private ToggleCommand cmdToggleMode = new ToggleMode(this);
    static /* synthetic */ Class class$javax$baja$workbench$px$BWbPxView;

    public Type getType() {
        return TYPE;
    }

    public BWbPxView(BAbstractPxView bAbstractPxView) {
        this.agent = bAbstractPxView;
    }

    public BWbPxView() {
        this(null);
    }

    public boolean isEditor() {
        return false;
    }

    public BMenu[] getViewMenus() {
        BMenu bMenu = new BMenu(this.lex.getText("menu.px.label"));
        bMenu.add(null, (Command)this.cmdToggleMode);
        bMenu.add(null, (BValue)new BSeparator());
        bMenu.add(null, this.cmdViewSource);
        bMenu.add(null, this.cmdGotoSource);
        return new BMenu[]{bMenu};
    }

    public BToolBar getViewToolBar() {
        BToolBar bToolBar = new BToolBar();
        bToolBar.add(null, (Command)this.cmdToggleMode);
        return bToolBar;
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        this.setContent((BWidget)new BRootContainer(this.loadPx(bObject, context)));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BWidget loadPx(BObject bObject, Context context) {
        String string = "";
        PxDecoder pxDecoder = null;
        TypeInfo typeInfo = null;
        try {
            if (bObject instanceof BPxInclude) {
                bObject = ((BPxInclude)bObject).getOrd().resolve(bObject).get();
            }
            if (this.agent != null) {
                BPxView bPxView;
                if (this.agent instanceof BPxView) {
                    string = this.errNull;
                    bPxView = (BPxView)this.agent;
                    this.pxOrd = bPxView.getPxFile();
                    if (this.pxOrd.isNull()) {
                        throw new Exception();
                    }
                    typeInfo = bPxView.getMedia().getTypeInfo();
                    string = this.errUnresolved;
                    this.pxFile = (BIFile)this.pxOrd.get(this.getCurrentValue());
                    pxDecoder = this.loadPxFile(context);
                } else {
                    if (!(this.agent instanceof BDynamicPxView)) throw new IllegalStateException("Don't know how to load from agent " + this.agent.getType());
                    this.dynamic = true;
                    bPxView = (BComponent)bObject;
                    BDynamicPxView bDynamicPxView = (BDynamicPxView)this.agent;
                    Property property = bDynamicPxView.getPropertyInParent();
                    String string2 = "reflectProperty:" + property.getName() + ":generateXml";
                    BString bString = (BString)bPxView.getComponentSpace().fw(109, (Object)bPxView, (Object)string2, null, (Object)context);
                    this.pxSource = bString.toString();
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.pxSource.getBytes());
                    pxDecoder = new PxDecoder(bPxView.getNavOrd(), (InputStream)byteArrayInputStream, context);
                }
            } else {
                if (!(bObject instanceof BIFile)) throw new IllegalStateException("Don't know how to load from " + bObject.getType());
                this.fileBased = true;
                this.pxFile = (BIFile)bObject;
                this.pxOrd = this.pxFile.getNavOrd();
                pxDecoder = this.loadPxFile(context);
            }
            if (this.widget != null) return this.widget;
            string = this.errXml;
            this.widget = pxDecoder.decodeDocument();
            this.pxProperties = pxDecoder.getPxProperties();
            this.pxLayers = pxDecoder.getPxLayers();
            for (int i = 0; i < this.pxProperties.length; ++i) {
                this.pxProperties[i].apply((BComponent)this.widget);
            }
            this.media = pxDecoder.getMedia() == null ? (typeInfo != null ? (BPxMedia)typeInfo.getInstance() : BWbPxMedia.INSTANCE) : (BPxMedia)pxDecoder.getMedia().getInstance();
            if (!useCache) return this.widget;
            cache.put(this.pxOrd, new CacheItem(this.widget, this.media, this.pxProperties, this.pxLayers));
            return this.widget;
        }
        catch (Exception exception) {
            this.widget = null;
            return new BErrorPanel(this.getWbShell(), this.errTitle, string, this.pxOrd, exception);
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws Exception {
        Binder binder = (Binder)this.fw(302);
        BBinding[] bBindingArray = binder.getAllBindings();
        for (int i = 0; i < bBindingArray.length; ++i) {
            bBindingArray[i].save(context);
        }
        return bObject;
    }

    PxDecoder loadPxFile(Context context) throws Exception {
        PxProperty pxProperty;
        int n;
        CacheItem cacheItem = (CacheItem)cache.get(this.pxOrd);
        if (cacheItem == null) {
            if (log.isTraceOn()) {
                log.trace("not cached: " + this.pxOrd);
            }
            return new PxDecoder(this.pxFile, context);
        }
        if (log.isTraceOn()) {
            log.trace("cached: " + this.pxOrd);
        }
        this.widget = (BWidget)cacheItem.widget.newCopy(true);
        this.media = cacheItem.media;
        this.pxProperties = new PxProperty[cacheItem.props.length];
        for (n = 0; n < this.pxProperties.length; ++n) {
            pxProperty = cacheItem.props[n];
            this.pxProperties[n] = new PxProperty(pxProperty.getName(), pxProperty.getTypeSpec(), pxProperty.getValue(), pxProperty.getTargets());
        }
        this.pxLayers = new PxLayer[cacheItem.layers.length];
        for (n = 0; n < this.pxLayers.length; ++n) {
            pxProperty = cacheItem.layers[n];
            this.pxLayers[n] = new PxLayer(pxProperty.getName());
        }
        this.setBaseOrd(cacheItem.widget, this.widget, context);
        return null;
    }

    void setBaseOrd(BWidget bWidget, BWidget bWidget2, Context context) {
        if (bWidget instanceof BPxInclude) {
            BOrd bOrd = ((BPxInclude)bWidget).getBaseOrd();
            BPxInclude bPxInclude = (BPxInclude)bWidget2;
            bPxInclude.fw(205, (Object)bOrd, (Object)context, null, null);
            bPxInclude.remove("root");
            return;
        }
        BWidget[] bWidgetArray = bWidget.getChildWidgets();
        BWidget[] bWidgetArray2 = bWidget2.getChildWidgets();
        for (int i = 0; i < bWidgetArray.length; ++i) {
            this.setBaseOrd(bWidgetArray[i], bWidgetArray2[i], context);
        }
    }

    public boolean isEditable() {
        return !this.isDynamic() && this.getPxFile() != null && !this.getPxFile().isReadonly();
    }

    public BWidget getWidget() {
        return this.widget;
    }

    public PxProperty[] getPxProperties() {
        return this.pxProperties;
    }

    public PxLayer[] getPxLayers() {
        return this.pxLayers;
    }

    public BPxMedia getMedia() {
        return this.media;
    }

    public BAbstractPxView getPxAgent() {
        return this.agent;
    }

    public void setWidget(BWidget bWidget) {
        this.widget = bWidget;
    }

    public void setMedia(BPxMedia bPxMedia) {
        this.media = bPxMedia;
    }

    public BIFile getPxFile() {
        return this.pxFile;
    }

    public boolean isFileBased() {
        return this.fileBased;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public Command getViewSource() {
        return this.cmdViewSource;
    }

    public Command getGotoSource() {
        return this.cmdGotoSource;
    }

    public ToggleCommand getToggleMode() {
        return this.cmdToggleMode;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static class CacheItem {
        BWidget widget;
        BPxMedia media;
        PxProperty[] props;
        PxLayer[] layers;

        public CacheItem(BWidget bWidget, BPxMedia bPxMedia, PxProperty[] pxPropertyArray, PxLayer[] pxLayerArray) {
            this.widget = bWidget;
            this.media = bPxMedia;
            this.props = pxPropertyArray;
            this.layers = pxLayerArray;
        }
    }

    public class ToggleMode
    extends ToggleCommand {
        public ToggleMode(BWbPxView bWbPxView2) {
            super((BWidget)bWbPxView2, (Lexicon)BWbPxView.this.lex, "commands.px.editMode");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbPxView bWbPxView = (BWbPxView)this.getOwner();
            BNiagaraWbShell bNiagaraWbShell = (BNiagaraWbShell)this.getShell();
            if (bWbPxView == null || bNiagaraWbShell == null) {
                return null;
            }
            String string = bNiagaraWbShell.tab().getViewAgent().getAgentId();
            if (bWbPxView.isEditor() && bNiagaraWbShell.getSaveCommand().isEnabled()) {
                bNiagaraWbShell.getSaveCommand().invoke();
            }
            String string2 = string.equals("workbench:WbPxView") ? "pxEditor:PxEditor" : (string.equals("pxEditor:PxEditor") ? "workbench:WbPxView" : (string.indexOf(47) > 0 ? string.substring(0, string.indexOf(47)) : string + "/editor"));
            BOrd bOrd = bNiagaraWbShell.getActiveOrd();
            bNiagaraWbShell.hyperlink(BOrd.make((BOrd)bOrd, (String)("view:" + string2)));
            return null;
        }
    }

    public class GotoSource
    extends Command {
        public GotoSource(BWbPxView bWbPxView2) {
            super((BWidget)bWbPxView2, (Lexicon)BWbPxView.this.lex, "commands.px.gotoSource");
        }

        public CommandArtifact doInvoke() throws Exception {
            BWbShell bWbShell = (BWbShell)this.getShell();
            bWbShell.hyperlink(BOrd.make((String)(BWbPxView.this.pxOrd.toString() + "|view:workbench:TextFileEditor")));
            return null;
        }
    }

    public class ViewSource
    extends Command {
        public ViewSource(BWbPxView bWbPxView2) {
            super((BWidget)bWbPxView2, (Lexicon)BWbPxView.this.lex, "commands.px.viewSource");
        }

        public CommandArtifact doInvoke() throws Exception {
            if (BWbPxView.this.pxSource == null) {
                BWbPxView.this.pxSource = FileUtil.readString((BIFile)BWbPxView.this.pxFile);
            }
            BTextEditor bTextEditor = new BTextEditor();
            bTextEditor.setEditable(false);
            bTextEditor.setParser((TextParser)new XmlParser());
            bTextEditor.setText(BWbPxView.this.pxSource);
            BTextEditorPane bTextEditorPane = new BTextEditorPane(bTextEditor, 40, 100);
            BDialog.open((BWidget)this.getOwner(), (String)this.getLabel(), (Object)bTextEditorPane, (int)1);
            return null;
        }
    }
}

