/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.sys.schema.ComponentSlotMap;
import com.tridium.workbench.nav.NavMonitor;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.BNavFileSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.virtual.BVirtualGateway;
import javax.baja.workbench.nav.tree.NavTreeModel;

public class NavTreeNode
extends TreeNode {
    private static ThreadLocal currentNodeInRefresh = new ThreadLocal();
    static BImage defaultIcon = BImage.make((String)"module://icons/x16/object.png");
    final BINavNode navNode;
    String navName;
    BOrd navOrd;
    NavTreeNode[] children;
    BIcon icon;
    BImage iconImage;
    boolean isDragOver;
    boolean performFullLoad = false;
    boolean buildChildren = false;

    public NavTreeNode(NavTreeNode navTreeNode, BINavNode bINavNode) {
        this((NavTreeModel)navTreeNode.getModel(), navTreeNode, bINavNode);
    }

    public NavTreeNode(NavTreeModel navTreeModel, NavTreeNode navTreeNode, BINavNode bINavNode) {
        super((TreeModel)navTreeModel, (TreeNode)navTreeNode);
        this.navNode = bINavNode;
        this.navName = bINavNode.getNavName();
        this.navOrd = bINavNode.getNavOrd();
        navTreeModel.add(this);
    }

    public Object getSubject() {
        return this.navNode;
    }

    public BINavNode getNavNode() {
        return this.navNode;
    }

    public String getText() {
        return this.navNode.getNavDisplayName(null);
    }

    public BImage getIcon() {
        BIcon bIcon = this.navNode.getNavIcon();
        if (bIcon != this.icon) {
            this.icon = bIcon;
            this.iconImage = BImage.make((BIcon)bIcon);
            this.iconImage.sync();
        }
        if (this.iconImage == null) {
            this.iconImage = defaultIcon;
        }
        if (this.navNode instanceof BISpaceNode && ((BISpaceNode)this.navNode).isPendingMove()) {
            return this.iconImage.getDisabledImage();
        }
        return this.iconImage;
    }

    public boolean hasChildren() {
        return this.navNode.hasNavChildren();
    }

    public int getChildCount() {
        return this.getChildren().length;
    }

    public TreeNode getChild(int n) {
        return this.getChildren()[n];
    }

    public NavTreeNode getChild(String string, boolean bl) {
        if (this.children == null && !bl) {
            return null;
        }
        NavTreeNode[] navTreeNodeArray = this.getChildren();
        for (int i = 0; i < navTreeNodeArray.length; ++i) {
            if (!string.equals(navTreeNodeArray[i].navName)) continue;
            return navTreeNodeArray[i];
        }
        return null;
    }

    public NavTreeNode getChild(BINavNode bINavNode, boolean bl) {
        if (this.children == null && !bl) {
            return null;
        }
        NavTreeNode[] navTreeNodeArray = this.getChildren();
        for (int i = 0; i < navTreeNodeArray.length; ++i) {
            if (!bINavNode.equals(navTreeNodeArray[i].navNode)) continue;
            return navTreeNodeArray[i];
        }
        return null;
    }

    public NavTreeNode[] getChildren() {
        if (this.buildChildren || this.children == null) {
            this.buildChildren = false;
            BWidgetShell bWidgetShell = this.getShell();
            if (bWidgetShell != null) {
                bWidgetShell.enterBusy();
            }
            try {
                this.children = this.buildChildren();
            }
            catch (Throwable throwable) {
                this.children = new NavTreeNode[0];
                throwable.printStackTrace();
                BDialog.error((BWidget)this.getTree(), (String)BDialog.TITLE_ERROR, (Object)"Cannot expand tree", (Throwable)throwable);
            }
            finally {
                if (bWidgetShell != null) {
                    bWidgetShell.exitBusy();
                }
            }
        }
        return this.children;
    }

    protected NavTreeNode[] buildChildren() {
        NavTreeModel navTreeModel = (NavTreeModel)this.getModel();
        BINavNode[] bINavNodeArray = this.navNode.getNavChildren();
        ArrayList<NavTreeNode> arrayList = new ArrayList<NavTreeNode>(bINavNodeArray.length);
        for (int i = 0; i < bINavNodeArray.length; ++i) {
            NavTreeNode navTreeNode = navTreeModel.makeNavTreeNode(this, bINavNodeArray[i]);
            if (navTreeNode == null) continue;
            arrayList.add(navTreeNode);
        }
        return arrayList.toArray(new NavTreeNode[arrayList.size()]);
    }

    public void addChild(NavTreeNode navTreeNode) {
        if (this.children == null) {
            return;
        }
        if (navTreeNode == null) {
            throw new NullPointerException();
        }
        NavTreeNode[] navTreeNodeArray = new NavTreeNode[this.children.length + 1];
        System.arraycopy(this.children, 0, navTreeNodeArray, 0, this.children.length);
        navTreeNodeArray[this.children.length] = navTreeNode;
        this.children = navTreeNodeArray;
        this.getModel().updateTree();
    }

    public void removeChild(NavTreeNode navTreeNode) {
        BComponent bComponent;
        ((NavTreeModel)this.getModel()).remove(navTreeNode);
        if (this.children == null || this.children.length == 0) {
            return;
        }
        if (navTreeNode == null) {
            throw new NullPointerException();
        }
        if (this.getNavNode() instanceof BComponent) {
            bComponent = (BComponent)this.getNavNode();
            if (bComponent instanceof BVirtualGateway) {
                try {
                    bComponent = ((BVirtualGateway)bComponent).getVirtualSpace().getRootComponent();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (!((ComponentSlotMap)bComponent.fw(1)).isBrokerPropsLoaded()) {
                this.performFullLoad = true;
            }
        }
        bComponent = this.children;
        NavTreeNode[] navTreeNodeArray = new NavTreeNode[((BComponent)bComponent).length - 1];
        boolean bl = false;
        int n = 0;
        for (int i = 0; i < ((BComponent)bComponent).length; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = bComponent[i] == navTreeNode;
            if (!bl2 && n >= navTreeNodeArray.length) {
                return;
            }
            if (!bl && bl2) {
                bl = true;
                continue;
            }
            navTreeNodeArray[n++] = bComponent[i];
        }
        if (bl) {
            this.children = navTreeNodeArray;
            if (this.children == null || this.children.length == 0) {
                this.getTree().setExpanded((TreeNode)this, false);
            }
            this.getModel().updateTree();
        }
    }

    public void replaceChild(NavTreeNode navTreeNode, NavTreeNode navTreeNode2) {
        ((NavTreeModel)this.getModel()).remove(navTreeNode);
        ((NavTreeModel)this.getModel()).add(navTreeNode2);
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < this.children.length; ++i) {
            if (this.children[i] != navTreeNode) continue;
            bl = true;
            this.children[i] = navTreeNode2;
        }
        if (!bl) {
            throw new IllegalStateException();
        }
        if (navTreeNode.isExpanded()) {
            navTreeNode2.setExpanded(true);
        }
        this.getModel().updateTree();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expanded() {
        NavMonitor navMonitor;
        if (this.performFullLoad) {
            this.performFullLoad = false;
            this.buildChildren = true;
        }
        if ((navMonitor = NavMonitor.get()) != null) {
            NavMonitor navMonitor2 = navMonitor;
            synchronized (navMonitor2) {
                navMonitor.notify();
            }
        }
    }

    public static boolean performingRefresh(BINavNode bINavNode) {
        if (bINavNode == null) {
            return false;
        }
        return bINavNode == currentNodeInRefresh.get();
    }

    public void refresh() {
        this.refresh(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refresh(boolean bl) {
        try {
            int n;
            BFoxSession bFoxSession;
            Object object;
            currentNodeInRefresh.set(this.navNode);
            if (bl && this.navNode instanceof BComponent) {
                object = (BComponent)this.navNode;
                if (object instanceof BVirtualGateway) {
                    try {
                        object = ((BVirtualGateway)object).getVirtualSpace().getRootComponent();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if ((bFoxSession = object.getComponentSpace()) != null) {
                    bFoxSession.update((BComponent)object, 0);
                }
            }
            if (bl && (this.navNode instanceof BNavFileSpace || this.navNode instanceof BNavFileNode)) {
                for (object = this.navNode; object != null; object = object.getNavParent()) {
                    if (!(object instanceof BFoxSession)) continue;
                    bFoxSession = (BFoxSession)object;
                    bFoxSession.loadNavFileSpace();
                    break;
                }
            }
            if (this.children == null) {
                return;
            }
            object = (NavTreeModel)this.getModel();
            bFoxSession = this.navNode.getNavChildren();
            NavTreeNode[] navTreeNodeArray = (NavTreeNode[])this.children.clone();
            ArrayList<NavTreeNode> arrayList = new ArrayList<NavTreeNode>();
            for (n = 0; n < ((BFoxSession)bFoxSession).length; ++n) {
                BFoxSession bFoxSession2 = bFoxSession[n];
                NavTreeNode navTreeNode = null;
                for (int i = 0; i < navTreeNodeArray.length; ++i) {
                    if (navTreeNodeArray[i] == null || !bFoxSession2.equals(navTreeNodeArray[i].navNode)) continue;
                    navTreeNode = navTreeNodeArray[i];
                    navTreeNode.remap();
                    navTreeNodeArray[i] = null;
                    break;
                }
                if (navTreeNode == null) {
                    navTreeNode = ((NavTreeModel)((Object)object)).makeNavTreeNode(this, (BINavNode)bFoxSession2);
                }
                if (navTreeNode == null) continue;
                arrayList.add(navTreeNode);
            }
            for (n = 0; n < navTreeNodeArray.length; ++n) {
                if (navTreeNodeArray[n] == null) continue;
                ((NavTreeModel)((Object)object)).remove(navTreeNodeArray[n]);
            }
            this.children = arrayList.toArray(new NavTreeNode[arrayList.size()]);
            this.getModel().updateTree();
        }
        finally {
            currentNodeInRefresh.set(null);
        }
    }

    void remap() {
        String string = this.navNode.getNavName();
        BOrd bOrd = this.navNode.getNavOrd();
        if (!string.equals(this.navName) || !bOrd.equals((Object)this.navOrd)) {
            NavTreeModel navTreeModel = (NavTreeModel)this.getModel();
            navTreeModel.remap(this, this.navOrd, bOrd);
            this.navName = string;
            this.navOrd = bOrd;
            if (this.children != null) {
                for (int i = 0; i < this.children.length; ++i) {
                    this.children[i].remap();
                }
            }
        }
    }
}

