/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import com.tridium.workbench.shell.WbMain;
import java.util.HashMap;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavFileNode;
import javax.baja.nav.NavEvent;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.tree.TreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;

public abstract class NavTreeModel
extends TreeModel {
    HashMap ordMap = new HashMap();

    public NavTreeNode lookup(BOrd bOrd) {
        return (NavTreeNode)((Object)this.ordMap.get(bOrd));
    }

    public void add(NavTreeNode navTreeNode) {
        NavTreeNode[] navTreeNodeArray;
        if (navTreeNode.navOrd != null) {
            this.ordMap.put(navTreeNode.navOrd, navTreeNode);
        }
        if ((navTreeNodeArray = navTreeNode.children) != null) {
            for (int i = 0; i < navTreeNodeArray.length; ++i) {
                if (navTreeNodeArray[i] == null) continue;
                this.add(navTreeNodeArray[i]);
            }
        }
    }

    public void remove(NavTreeNode navTreeNode) {
        NavTreeNode[] navTreeNodeArray;
        if (this.ordMap.get(navTreeNode.navOrd) == navTreeNode) {
            this.ordMap.remove(navTreeNode.navOrd);
        }
        if ((navTreeNodeArray = navTreeNode.children) != null) {
            for (int i = 0; i < navTreeNodeArray.length; ++i) {
                if (navTreeNodeArray[i] == null) continue;
                this.remove(navTreeNodeArray[i]);
            }
        }
    }

    void remap(NavTreeNode navTreeNode, BOrd bOrd, BOrd bOrd2) {
        this.ordMap.remove(bOrd);
        this.ordMap.put(bOrd2, navTreeNode);
    }

    public void navEvent(NavEvent navEvent) {
        switch (navEvent.getId()) {
            case 1: {
                this.added(navEvent);
                break;
            }
            case 2: {
                this.removed(navEvent);
                break;
            }
            case 3: {
                this.renamed(navEvent);
                break;
            }
            case 4: {
                this.reordered(navEvent);
                break;
            }
            case 5: {
                this.replaced(navEvent);
            }
        }
    }

    protected void added(NavEvent navEvent) {
        NavTreeNode navTreeNode;
        BINavNode bINavNode;
        NavTreeNode navTreeNode2 = this.eventToNode(navEvent);
        if (navTreeNode2 != null && (bINavNode = navTreeNode2.navNode.getNavChild(navEvent.getNewChildName())) != null && (navTreeNode = this.makeNavTreeNode(navTreeNode2, bINavNode)) != null) {
            navTreeNode2.addChild(navTreeNode);
        }
    }

    protected void removed(NavEvent navEvent) {
        NavTreeNode navTreeNode;
        NavTreeNode navTreeNode2 = this.eventToNode(navEvent);
        if (navTreeNode2 != null && (navTreeNode = navTreeNode2.getChild(navEvent.getOldChildName(), false)) != null) {
            navTreeNode2.removeChild(navTreeNode);
        }
    }

    protected void renamed(NavEvent navEvent) {
        NavTreeNode navTreeNode = this.eventToNode(navEvent);
        if (navTreeNode != null) {
            navTreeNode.refresh(false);
        }
    }

    protected void reordered(NavEvent navEvent) {
        NavTreeNode navTreeNode = this.eventToNode(navEvent);
        if (navTreeNode != null) {
            navTreeNode.refresh(false);
        }
    }

    protected void replaced(NavEvent navEvent) {
        NavTreeNode navTreeNode = this.eventToNode(navEvent);
        if (navTreeNode != null && navTreeNode.children != null) {
            NavTreeNode navTreeNode2 = navTreeNode.getChild(navEvent.getOldChildName(), false);
            BINavNode bINavNode = navTreeNode.navNode.getNavChild(navEvent.getOldChildName());
            NavTreeNode navTreeNode3 = null;
            if (bINavNode != null) {
                navTreeNode3 = this.makeNavTreeNode(navTreeNode, bINavNode);
            }
            if (navTreeNode2 != null) {
                if (navEvent.getFacets().getb("close", false)) {
                    navTreeNode2.setExpanded(false);
                }
                if (navTreeNode3 == null) {
                    navTreeNode.removeChild(navTreeNode2);
                } else {
                    navTreeNode.replaceChild(navTreeNode2, navTreeNode3);
                }
            } else if (navTreeNode3 != null) {
                navTreeNode.addChild(navTreeNode3);
            }
        }
    }

    NavTreeNode eventToNode(NavEvent navEvent) {
        NavTreeNode navTreeNode = this.lookup(navEvent.getParentOrd());
        if (navTreeNode == null) {
            return null;
        }
        if (navTreeNode.getNavNode() instanceof BNavFileNode) {
            return null;
        }
        return navTreeNode;
    }

    public NavTreeNode makeNavTreeNode(NavTreeNode navTreeNode, BINavNode bINavNode) {
        BComponent bComponent;
        if (navTreeNode != null && navTreeNode.navNode == BLocalHost.INSTANCE && !WbMain.isKioskAccessible((BOrd)(bComponent = bINavNode.getNavOrd()))) {
            return null;
        }
        if (bINavNode instanceof BComponent) {
            bComponent = (BComponent)bINavNode;
            BComplex bComplex = bComponent.getParent();
            Property property = bComponent.getPropertyInParent();
            if (bComplex != null && property != null && Flags.isHidden((BComplex)bComplex, (Slot)property)) {
                return null;
            }
        }
        return new NavTreeNode(this, navTreeNode, bINavNode);
    }

    void dumpOrdMap() {
        System.out.println("===== NavTreeModel.ordMap =====");
        Object[] objectArray = this.ordMap.keySet().toArray(new BOrd[this.ordMap.size()]);
        SortUtil.sort((Object[])objectArray);
        for (int i = 0; i < objectArray.length; ++i) {
            NavTreeNode navTreeNode = this.lookup((BOrd)objectArray[i]);
            System.out.println(" " + objectArray[i] + " -> " + navTreeNode.navName + " @  " + navTreeNode.navOrd);
        }
        System.out.println("===============================");
    }
}

