/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import javax.baja.naming.BOrd;
import javax.baja.sys.BValue;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeNode;
import javax.baja.ui.tree.TreeSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.nav.menu.NavMenuUtil;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeSubject;

public class NavTreeController
extends TreeController {
    protected void doSelectAction(TreeNode treeNode, double d, double d2) {
        this.getTree().setExpanded(treeNode, true);
        BWidgetShell bWidgetShell = this.getShell();
        NavTreeNode navTreeNode = (NavTreeNode)treeNode;
        BOrd bOrd = navTreeNode.navNode.getNavOrd();
        if (bWidgetShell instanceof BWbShell && bOrd != null) {
            ((BWbShell)bWidgetShell).hyperlink(new HyperlinkInfo(bOrd, BHyperlinkMode.DEFAULT));
        }
    }

    public void keyPressed(BKeyEvent bKeyEvent) {
        super.keyPressed(bKeyEvent);
        if (bKeyEvent.getKeyCode() == 121) {
            ((NavTreeModel)this.getModel()).dumpOrdMap();
        }
    }

    protected final BMenu makePopup(TreeSubject treeSubject) {
        return this.makePopup((NavTreeSubject)treeSubject);
    }

    protected BMenu makePopup(NavTreeSubject navTreeSubject) {
        BTree bTree = this.getTree();
        BMenu bMenu = NavMenuUtil.makeMenu((BWidget)bTree, (Subject)navTreeSubject);
        if (navTreeSubject.size() == 1) {
            if (bMenu == null) {
                bMenu = new BMenu();
            } else {
                bMenu.add(null, (BValue)new BSeparator());
            }
            bMenu.add(null, (Command)new RefreshCommand((BWidget)bTree, (NavTreeNode)navTreeSubject.getNode(0)));
        }
        return bMenu;
    }

    public void nodeDoubleClicked(BMouseEvent bMouseEvent, TreeNode treeNode) {
        BWidgetShell bWidgetShell = this.getShell();
        NavTreeNode navTreeNode = (NavTreeNode)treeNode;
        BOrd bOrd = navTreeNode.navNode.getNavOrd();
        if (bWidgetShell instanceof BWbShell && bOrd != null) {
            ((BWbShell)bWidgetShell).hyperlink(new HyperlinkInfo(bOrd, (BInputEvent)bMouseEvent));
        }
    }

    class RefreshCommand
    extends Command {
        NavTreeNode node;

        RefreshCommand(BWidget bWidget, NavTreeNode navTreeNode) {
            super(bWidget, UiLexicon.bajaui().module, "tree.refresh");
            this.node = navTreeNode;
        }

        public CommandArtifact doInvoke() throws Exception {
            this.node.refresh();
            return null;
        }
    }
}

