/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.tree;

import com.tridium.fox.sys.BFoxSession;
import com.tridium.fox.sys.file.BFoxFileSpace;
import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import java.util.ArrayList;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.nav.BNavRoot;
import javax.baja.nav.NavEvent;
import javax.baja.nav.NavListener;
import javax.baja.space.BComponentSpace;
import javax.baja.space.BISpaceNode;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BModule;
import javax.baja.sys.BObject;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.tree.BTree;
import javax.baja.ui.tree.TreeController;
import javax.baja.ui.tree.TreeModel;
import javax.baja.ui.tree.TreeNode;
import javax.baja.workbench.nav.tree.DefaultNavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeController;
import javax.baja.workbench.nav.tree.NavTreeModel;
import javax.baja.workbench.nav.tree.NavTreeNode;
import javax.baja.workbench.nav.tree.NavTreeNodeRenderer;
import javax.baja.workbench.nav.tree.NavTreeSelection;

public class BNavTree
extends BTree
implements NavListener {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$nav$tree$BNavTree == null ? (class$javax$baja$workbench$nav$tree$BNavTree = BNavTree.class$("javax.baja.workbench.nav.tree.BNavTree")) : class$javax$baja$workbench$nav$tree$BNavTree));
    NavTreeNode dragOver;
    boolean readonly = false;
    static /* synthetic */ Class class$javax$baja$workbench$nav$tree$BNavTree;

    public Type getType() {
        return TYPE;
    }

    public BNavTree(NavTreeModel navTreeModel) {
        super((TreeModel)navTreeModel, (TreeController)new NavTreeController());
        this.setNodeRenderer(new NavTreeNodeRenderer());
        this.setSelection(new NavTreeSelection());
        this.setCutEnabled(true);
        this.setCopyEnabled(true);
        this.setPasteEnabled(true);
        this.setPasteSpecialEnabled(true);
        this.setDuplicateEnabled(true);
        this.setDeleteEnabled(true);
        this.setRenameEnabled(true);
    }

    public BNavTree(BINavNode bINavNode) {
        this(new DefaultNavTreeModel(bINavNode));
    }

    public BNavTree() {
        this((BINavNode)BNavRoot.INSTANCE);
    }

    public BObject getSelectedObject() {
        NavTreeNode navTreeNode = (NavTreeNode)this.getSelection().getNode();
        if (navTreeNode != null) {
            return (BObject)navTreeNode.getNavNode();
        }
        return null;
    }

    public BObject[] getSelectedObjects() {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        BObject[] bObjectArray = new BObject[treeNodeArray.length];
        for (int i = 0; i < treeNodeArray.length; ++i) {
            bObjectArray[i] = (BObject)((NavTreeNode)treeNodeArray[i]).getNavNode();
        }
        return bObjectArray;
    }

    public BObject getSelectionParent() {
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        if (treeNodeArray == null || treeNodeArray.length == 0) {
            return null;
        }
        if (treeNodeArray[0].getParent() == null) {
            return null;
        }
        BObject bObject = (BObject)((NavTreeNode)treeNodeArray[0].getParent()).getNavNode();
        for (int i = 1; i < treeNodeArray.length; ++i) {
            BObject bObject2 = (BObject)((NavTreeNode)treeNodeArray[i].getParent()).getNavNode();
            if (bObject2 == bObject) continue;
            return null;
        }
        return bObject;
    }

    public void setReadonly(boolean bl) {
        this.readonly = bl;
    }

    public boolean getReadonly() {
        return this.readonly;
    }

    public void expandToOrd(BObject bObject, BOrd bOrd) {
        try {
            BINavNode bINavNode = (BINavNode)bOrd.resolve(bObject).get();
            this.expandToNavNode(bINavNode);
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (String)"Error", (Object)("Could not expandTo: " + bOrd), (Throwable)exception);
        }
    }

    public void expandToNavNode(BINavNode bINavNode) throws Exception {
        NavTreeNode navTreeNode;
        NavTreeModel navTreeModel = (NavTreeModel)this.getModel();
        NavTreeNode navTreeNode2 = null;
        ArrayList<BINavNode> arrayList = new ArrayList<BINavNode>();
        while (bINavNode != null) {
            for (int i = 0; i < navTreeModel.getRootCount(); ++i) {
                BINavNode bINavNode2 = ((NavTreeNode)navTreeModel.getRoot(i)).getNavNode();
                if (!bINavNode.getNavOrd().equals((Object)bINavNode2.getNavOrd())) continue;
                navTreeNode2 = (NavTreeNode)navTreeModel.getRoot(i);
                break;
            }
            if (navTreeNode2 != null) break;
            arrayList.add(0, bINavNode);
            bINavNode = bINavNode.getNavParent();
        }
        if (navTreeNode2 == null) {
            return;
        }
        if (arrayList.size() > 0) {
            navTreeNode2.setExpanded(true);
        }
        String string = "";
        for (int i = 0; i < arrayList.size() - 1; ++i) {
            bINavNode = (BINavNode)arrayList.get(i);
            if (string.equals(bINavNode.getNavName()) || bINavNode.getNavName() == null) continue;
            if (bINavNode instanceof BModule) {
                navTreeNode2 = navTreeNode2.getChild(((BModule)bINavNode).getModuleName(), true);
                ++i;
            } else {
                navTreeNode2 = navTreeNode2.getChild(bINavNode.getNavName(), true);
            }
            navTreeNode2.setExpanded(true);
            string = navTreeNode2.getNavNode().getNavName();
        }
        if (arrayList.size() > 0 && (bINavNode = (BINavNode)arrayList.get(arrayList.size() - 1)).getNavName() != null && (navTreeNode = navTreeNode2.getChild(bINavNode.getNavName(), true)) != null) {
            navTreeNode2 = navTreeNode;
        }
        this.getSelection().deselectAll();
        if (navTreeNode2 != null) {
            this.getSelection().select((TreeNode)navTreeNode2);
            this.getController().setFocus((TreeNode)navTreeNode2);
            this.scrollNodeToVisible(navTreeNode2);
        }
        this.relayout();
    }

    public void started() throws Exception {
        super.started();
        BNavRoot.INSTANCE.addNavListener((NavListener)this);
    }

    public void stopped() throws Exception {
        super.stopped();
        BNavRoot.INSTANCE.removeNavListener((NavListener)this);
    }

    public void navEvent(NavEvent navEvent) {
        ((NavTreeModel)this.getModel()).navEvent(navEvent);
    }

    public TransferEnvelope getTransferData() throws Exception {
        BObject[] bObjectArray = this.getSelectedObjects();
        if (bObjectArray == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)new Mark(bObjectArray));
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return TransferUtil.insert((BWidget)this, transferContext, this.getSelectedObject(), null);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doDuplicate() throws Exception {
        BObject[] bObjectArray = this.getSelectedObjects();
        BObject bObject = this.getSelectionParent();
        if (bObjectArray.length == 0 || bObject == null) {
            return null;
        }
        Mark mark = new Mark(bObjectArray);
        return TransferUtil.insert((BWidget)this, 16, mark, bObject, null, null);
    }

    public CommandArtifact doDelete() throws Exception {
        BObject[] bObjectArray = this.getSelectedObjects();
        if (bObjectArray.length == 0) {
            return null;
        }
        Mark mark = new Mark(bObjectArray);
        return TransferUtil.delete((BWidget)this, mark);
    }

    public CommandArtifact doRename() throws Exception {
        BObject[] bObjectArray = this.getSelectedObjects();
        if (bObjectArray.length == 0) {
            return null;
        }
        Mark mark = new Mark(bObjectArray);
        return TransferUtil.rename((BWidget)this, mark);
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        double d;
        if (this.readonly) {
            return;
        }
        double d2 = bMouseEvent.getX();
        NavTreeNode navTreeNode = this.transferNodeAt(d2, d = bMouseEvent.getY());
        if (navTreeNode == null) {
            return;
        }
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(navTreeNode.getIcon(), navTreeNode.getText());
        simpleDragRenderer.font = Theme.tree().getFont((BWidget)this);
        simpleDragRenderer.xCursorOffset = navTreeNode.getX() + Theme.tree().getExpanderWidth() + 4.0 - d2;
        simpleDragRenderer.yCursorOffset = navTreeNode.getY() - d;
        boolean bl = false;
        TreeNode[] treeNodeArray = this.getSelection().getNodes();
        TreeNode treeNode = treeNodeArray[0].getParent();
        for (int i = 1; i < treeNodeArray.length; ++i) {
            if (treeNode == treeNodeArray[i].getParent()) continue;
            bl = true;
            break;
        }
        TransferEnvelope transferEnvelope = TransferEnvelope.make((Mark)new Mark(this.getSelectedObjects()));
        if (bl) {
            this.startDrag(bMouseEvent, this.makeTransferContext(transferEnvelope), (DragRenderer)simpleDragRenderer);
        } else {
            this.startDrag(bMouseEvent, transferEnvelope, (DragRenderer)simpleDragRenderer);
        }
    }

    public int dragOver(TransferContext transferContext) {
        super.dragOver(transferContext);
        if (this.readonly) {
            return 0;
        }
        NavTreeNode navTreeNode = this.transferNodeAt(transferContext.getX(), transferContext.getY());
        if (navTreeNode != this.dragOver) {
            if (this.dragOver != null) {
                this.dragOver.isDragOver = false;
            }
            this.dragOver = navTreeNode;
            if (this.dragOver != null) {
                this.dragOver.isDragOver = true;
            }
            this.repaint();
        }
        if (navTreeNode == null) {
            return 0;
        }
        int n = 48;
        return n;
    }

    public void dragExit(TransferContext transferContext) {
        if (this.dragOver != null) {
            this.dragOver.isDragOver = false;
            this.dragOver = null;
            this.repaint();
        }
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (this.dragOver != null) {
            NavTreeNode navTreeNode = this.dragOver;
            this.dragOver.isDragOver = false;
            this.dragOver = null;
            this.repaint();
            if (navTreeNode != null) {
                if (navTreeNode.getNavNode() instanceof BComponent && navTreeNode.getNavNode() != null) {
                    ((BComponent)navTreeNode.getNavNode()).lease();
                }
                TransferUtil.insert((BWidget)this, transferContext, (BObject)navTreeNode.getNavNode(), null);
            }
        }
        return null;
    }

    NavTreeNode transferNodeAt(double d, double d2) {
        BINavNode bINavNode;
        NavTreeNode navTreeNode = (NavTreeNode)this.yToTreeNode(d2);
        if (navTreeNode != null && navTreeNode.isSelection(d, d2) && ((bINavNode = navTreeNode.getNavNode()) instanceof BISpaceNode || bINavNode instanceof BFoxSession || bINavNode instanceof BFoxFileSpace || bINavNode instanceof BComponentSpace)) {
            return navTreeNode;
        }
        return null;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

