/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.nav.menu;

import com.tridium.file.types.bog.BBogFile;
import com.tridium.util.ObjectUtil;
import com.tridium.util.PxUtil;
import com.tridium.workbench.px.PxEditorApi;
import com.tridium.workbench.shell.WbCommands;
import com.tridium.workbench.shell.WbMain;
import java.util.ArrayList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.gx.BImage;
import javax.baja.naming.BISession;
import javax.baja.naming.BLocalHost;
import javax.baja.naming.BOrd;
import javax.baja.nav.BINavNode;
import javax.baja.registry.TypeInfo;
import javax.baja.security.BIProtected;
import javax.baja.security.BPermissions;
import javax.baja.space.BISpaceNode;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.ui.BActionMenuItem;
import javax.baja.ui.BHyperlinkMode;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.CommandEvent;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.commands.HyperlinkCommand;
import javax.baja.ui.commands.InvokeActionCommand;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BFolder;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbLocatorBar;
import javax.baja.workbench.BWbProfile;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.WbSys;
import javax.baja.workbench.nav.menu.BNavMenuAgent;

public class NavMenuUtil {
    static TypeInfo pxEditor = null;
    static boolean disable;
    static BImage viewIcon;

    public static BMenu makeMenu(BWidget bWidget, BObject bObject) {
        return BNavMenuAgent.makeFor(bObject).makeMenu(bWidget, bObject);
    }

    public static BMenu makeMenu(BWidget bWidget, Subject subject) {
        subject.lease();
        BMenu bMenu = null;
        for (int i = 0; i < subject.size(); ++i) {
            Object object = subject.get(i);
            if (!(object instanceof BObject)) {
                return null;
            }
            BObject bObject = (BObject)object;
            BMenu bMenu2 = BNavMenuAgent.makeFor(bObject).makeMenu(bWidget, bObject);
            if (bMenu2 == null) {
                return null;
            }
            if (bMenu == null) {
                bMenu = bMenu2;
                continue;
            }
            if ((bMenu = NavMenuUtil.merge(bMenu, bMenu2)) != null) continue;
            return null;
        }
        return bMenu;
    }

    public static BMenu merge(BMenu bMenu, BMenu bMenu2) {
        if (bMenu == null || bMenu2 == null) {
            return null;
        }
        BMenu bMenu3 = new BMenu();
        boolean bl = false;
        BComponent[] bComponentArray = bMenu.getChildComponents();
        for (int i = 0; i < bComponentArray.length; ++i) {
            Command command;
            String string = bComponentArray[i].getName();
            BValue bValue = bMenu2.get(string);
            if (!(bValue instanceof BComponent)) continue;
            BComponent bComponent = bComponentArray[i];
            BComponent bComponent2 = (BComponent)bValue;
            if (bComponent.getClass() != bComponent2.getClass()) continue;
            if (bComponent instanceof BSeparator) {
                bMenu3.add(string, (BValue)new BSeparator());
                continue;
            }
            if (!(bComponent instanceof BActionMenuItem)) continue;
            Command command2 = ((BActionMenuItem)bComponent).getCommand();
            Command command3 = ((BActionMenuItem)bComponent2).getCommand();
            if (command2 == null || command3 == null || (command = command2.merge(command3)) == null) continue;
            bMenu3.add(string, (BValue)new BActionMenuItem(command));
            bl = true;
        }
        if (!bl) {
            return null;
        }
        bMenu3.removeConsecutiveSeparators();
        return bMenu3;
    }

    public static BMenu makeViewsMenu(BWidget bWidget, BObject bObject) {
        BINavNode bINavNode = (BINavNode)bObject;
        BOrd bOrd = bINavNode.getNavOrd();
        return NavMenuUtil.makeViewsMenu(bWidget, bObject, bOrd);
    }

    public static BMenu makeViewsMenu(BWidget bWidget, BObject bObject, BOrd bOrd) {
        UiLexicon uiLexicon = UiLexicon.bajaui();
        String string = uiLexicon.getText("menu.views.label");
        BPermissions bPermissions = BPermissions.all;
        if (bObject instanceof BIProtected) {
            bPermissions = ((BIProtected)bObject).getPermissions(null);
        }
        boolean bl = bObject instanceof BComponent;
        BWbProfile bWbProfile = null;
        BWidgetShell bWidgetShell = bWidget.getShell();
        if (bWidgetShell instanceof BWbShell) {
            bWbProfile = ((BWbShell)bWidgetShell).getProfile();
        }
        if (bWbProfile == null) {
            bWbProfile = (BWbProfile)WbMain.defaultProfileType.getInstance();
        }
        AgentFilter agentFilter = WbSys.getViewsFilter(bWidget, bObject);
        if (disable) {
            agentFilter = AgentFilter.and((AgentFilter)agentFilter, (BPermissions)bPermissions);
        }
        AgentList agentList = bWbProfile.getAgents(bObject).filter(agentFilter);
        AgentInfo[] agentInfoArray = agentList.list();
        BMenu bMenu = new BMenu(string);
        try {
            Object object;
            Object object2;
            int n;
            boolean bl2 = false;
            ArrayList<AgentInfo> arrayList = null;
            for (n = 0; n < agentInfoArray.length; ++n) {
                AgentInfo agentInfo = agentInfoArray[n];
                if (agentInfo instanceof PxUtil.PxEditor) {
                    if (arrayList == null) {
                        arrayList = new ArrayList<AgentInfo>();
                    }
                    arrayList.add(agentInfo);
                    continue;
                }
                if (bl && pxEditor != null && agentInfo.getAgentType().is(pxEditor)) {
                    bl2 = true;
                    continue;
                }
                bMenu.add("v" + n, NavMenuUtil.makeHyperlinkCommand(bWidget, bOrd, agentInfo));
            }
            if (bl2) {
                BComponent bComponent = (BComponent)bObject;
                bMenu.add("sep0", (BValue)new BSeparator());
                bMenu.add("newView", (Command)new PxEditorApi.NewViewCommand(bWidget, bComponent));
                for (int i = 0; arrayList != null && i < arrayList.size(); ++i) {
                    bMenu.add("edit" + i, NavMenuUtil.makeHyperlinkCommand(bWidget, bOrd, (AgentInfo)arrayList.get(i)));
                }
            }
            if (bObject instanceof BBogFile) {
                BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)"bog:|slot:/");
                BFolder bFolder = new BFolder();
                object2 = bFolder.getAgents().filter(WbSys.getViewsFilter(bWidget, (BObject)bFolder)).list();
                bMenu.add("sep1", (BValue)new BSeparator());
                for (int i = 0; i < ((AgentInfo[])object2).length; ++i) {
                    AgentInfo agentInfo = object2[i];
                    if (pxEditor != null && agentInfo.getAgentType().is(pxEditor)) continue;
                    bMenu.add("bog" + i, NavMenuUtil.makeHyperlinkCommand(bWidget, bOrd2, agentInfo));
                }
            }
            n = 0;
            for (object = bWidget; object != null; object = object.getParentWidget()) {
                if (!(object instanceof BWbLocatorBar)) continue;
                n = 1;
                break;
            }
            if (n == 0) {
                bMenu.add("sep2", (BValue)new BSeparator());
                object = new WbCommands.HelpCommand(bWidget, "menu.views.guide", ObjectUtil.getGuideHelpOrd((BObject)bObject));
                object2 = new WbCommands.HelpCommand(bWidget, "menu.views.bajadoc", ObjectUtil.getReferenceHelpOrd((BObject)bObject));
                bMenu.add("helpGuide", (BValue)new BActionMenuItem((Command)object), null);
                bMenu.add("helpRef", (BValue)new BActionMenuItem((Command)object2), null);
                if (bPermissions.hasAdminRead() || !disable) {
                    BISession bISession;
                    bMenu.add("spyLocal", (Command)new SpyLocalCommand(bWidget, bObject));
                    if (bObject instanceof BISpaceNode && (bISession = ((BISpaceNode)bObject).getSession()) != null && bISession != BLocalHost.INSTANCE) {
                        bMenu.add("spyRemote", (Command)new SpyRemoteCommand(bWidget, bObject));
                    }
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return bMenu;
    }

    static Command makeHyperlinkCommand(BWidget bWidget, BOrd bOrd, AgentInfo agentInfo) {
        String string = agentInfo.getDisplayName(null);
        BImage bImage = BImage.make((BIcon)agentInfo.getIcon(null));
        if (bImage == null) {
            bImage = viewIcon;
        }
        String string2 = agentInfo.getAgentId();
        BOrd bOrd2 = BOrd.make((BOrd)bOrd, (String)("view:" + string2));
        return new HyperlinkCommand(bWidget, bImage, string, bOrd2);
    }

    public static BMenu makeActionsMenu(BWidget bWidget, BComponent bComponent) {
        UiLexicon uiLexicon = UiLexicon.bajaui();
        String string = uiLexicon.getText("menu.actions.label");
        BPermissions bPermissions = BPermissions.all;
        if (bComponent instanceof BIProtected) {
            bPermissions = bComponent.getPermissions(null);
        }
        bComponent.loadSlots();
        Slot[] slotArray = bComponent.getSlotsArray();
        BMenu bMenu = new BMenu(string);
        boolean bl = true;
        for (int i = 0; i < slotArray.length; ++i) {
            int n;
            Slot slot = slotArray[i];
            if (!slot.isAction()) continue;
            Action action = (Action)slot;
            if (disable && (((n = bComponent.getFlags((Slot)action)) & 4) != 0 || ((n & 0x100) != 0 ? !bPermissions.has(4) : !bPermissions.has(64)))) continue;
            InvokeActionCommand invokeActionCommand = new InvokeActionCommand(bWidget, bComponent, action);
            bMenu.add("a" + i, (BValue)new BActionMenuItem((Command)invokeActionCommand), null);
            bl = false;
        }
        if (bl) {
            bMenu.setEnabled(false);
        }
        return bMenu;
    }

    static {
        try {
            pxEditor = Sys.getRegistry().getType("pxEditor:PxEditor");
        }
        catch (Exception exception) {
            // empty catch block
        }
        disable = System.getProperty("workbench.disableIfNoPermission", "true").equals("true");
        viewIcon = BImage.make((String)"module://icons/x16/views/view.png");
    }

    static class SpyRemoteCommand
    extends Command {
        BObject target;

        SpyRemoteCommand(BWidget bWidget, BObject bObject) {
            super(bWidget, (Lexicon)UiLexicon.bajaui(), "commands.spyRemote");
            this.target = bObject;
        }

        public CommandArtifact doInvoke(CommandEvent commandEvent) {
            BWbShell bWbShell = (BWbShell)this.getShell();
            BOrd bOrd = ObjectUtil.toSpyRemote((BObject)this.target);
            if (bOrd != null) {
                BHyperlinkMode bHyperlinkMode = BHyperlinkMode.replace;
                if (commandEvent != null) {
                    bHyperlinkMode = commandEvent.isControlDown() ? BHyperlinkMode.newTab : BHyperlinkMode.replace;
                }
                bWbShell.hyperlink(new HyperlinkInfo(bOrd, bHyperlinkMode));
            }
            return null;
        }
    }

    static class SpyLocalCommand
    extends Command {
        BObject target;

        SpyLocalCommand(BWidget bWidget, BObject bObject) {
            super(bWidget, (Lexicon)UiLexicon.bajaui(), "commands.spyLocal");
            this.target = bObject;
        }

        public CommandArtifact doInvoke(CommandEvent commandEvent) {
            BWbShell bWbShell = (BWbShell)this.getShell();
            BOrd bOrd = ObjectUtil.toSpyLocal((BObject)this.target);
            if (bOrd != null) {
                BHyperlinkMode bHyperlinkMode = BHyperlinkMode.replace;
                if (commandEvent != null) {
                    bHyperlinkMode = commandEvent.isControlDown() ? BHyperlinkMode.newTab : BHyperlinkMode.replace;
                }
                bWbShell.hyperlink(new HyperlinkInfo(bOrd, bHyperlinkMode));
            }
            return null;
        }
    }
}

