/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import javax.baja.agent.AgentInfo;
import javax.baja.gx.BImage;
import javax.baja.naming.SlotPath;
import javax.baja.registry.TypeInfo;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.util.TextUtil;

public abstract class MgrTypeInfo {
    public static MgrTypeInfo[] makeArray(TypeInfo[] typeInfoArray) {
        MgrTypeInfo[] mgrTypeInfoArray = new MgrTypeInfo[typeInfoArray.length];
        for (int i = 0; i < mgrTypeInfoArray.length; ++i) {
            mgrTypeInfoArray[i] = MgrTypeInfo.make(typeInfoArray[i]);
        }
        return MgrTypeInfo.sort(mgrTypeInfoArray);
    }

    public static MgrTypeInfo[] makeArray(TypeInfo typeInfo) {
        return MgrTypeInfo.makeArray(Sys.getRegistry().getConcreteTypes(typeInfo));
    }

    public static MgrTypeInfo[] makeArray(Type type) {
        return MgrTypeInfo.makeArray(type.getTypeInfo());
    }

    public static MgrTypeInfo[] makeArray(AgentInfo[] agentInfoArray) {
        MgrTypeInfo[] mgrTypeInfoArray = new MgrTypeInfo[agentInfoArray.length];
        for (int i = 0; i < mgrTypeInfoArray.length; ++i) {
            mgrTypeInfoArray[i] = MgrTypeInfo.make(agentInfoArray[i]);
        }
        return MgrTypeInfo.sort(mgrTypeInfoArray);
    }

    public static MgrTypeInfo make(TypeInfo typeInfo) {
        return new TypeInfoImpl(typeInfo);
    }

    public static MgrTypeInfo make(AgentInfo agentInfo) {
        return new AgentInfoImpl(agentInfo);
    }

    public static MgrTypeInfo make(Type type) {
        return MgrTypeInfo.make(type.getTypeInfo());
    }

    public static MgrTypeInfo make(BComponent bComponent) {
        return new ProtoImpl(bComponent);
    }

    public abstract String getDisplayName();

    public abstract BImage getIcon();

    public abstract BComponent newInstance() throws Exception;

    public abstract boolean isMatchable(BComponent var1);

    public boolean equals(Object object) {
        if (object instanceof MgrTypeInfo) {
            MgrTypeInfo mgrTypeInfo = (MgrTypeInfo)object;
            return this.getCompareString().equals(mgrTypeInfo.getCompareString());
        }
        return false;
    }

    protected String getCompareString() {
        return this.getDisplayName();
    }

    public String toSlotName() {
        return SlotPath.escape((String)TextUtil.replace((String)this.getDisplayName(), (String)" ", (String)""));
    }

    public String toString() {
        return this.getDisplayName();
    }

    public static void markDuplicates(MgrTypeInfo[] mgrTypeInfoArray) {
        int n;
        if (mgrTypeInfoArray == null || mgrTypeInfoArray.length == 0) {
            return;
        }
        String[] stringArray = new String[mgrTypeInfoArray.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray[n] = mgrTypeInfoArray[n].getDisplayName();
        }
        for (n = 0; n < stringArray.length; ++n) {
            String string = stringArray[n];
            for (int i = n + 1; i < stringArray.length; ++i) {
                if (!string.equals(stringArray[i])) continue;
                if (mgrTypeInfoArray[n] instanceof TypeInfoImpl) {
                    ((TypeInfoImpl)mgrTypeInfoArray[n]).duplicate = true;
                }
                if (!(mgrTypeInfoArray[i] instanceof TypeInfoImpl)) continue;
                ((TypeInfoImpl)mgrTypeInfoArray[i]).duplicate = true;
            }
        }
    }

    static MgrTypeInfo[] sort(MgrTypeInfo[] mgrTypeInfoArray) {
        int n;
        if (mgrTypeInfoArray.length == 0) {
            return mgrTypeInfoArray;
        }
        int n2 = mgrTypeInfoArray.length;
        String[] stringArray = new String[n2];
        for (n = 0; n < n2; ++n) {
            stringArray[n] = mgrTypeInfoArray[n].getDisplayName();
        }
        for (n = n2 / 2; n >= 1; n /= 2) {
            for (int i = n; i < n2; ++i) {
                String string = stringArray[i];
                MgrTypeInfo mgrTypeInfo = mgrTypeInfoArray[i];
                for (int j = i; j >= n && string.compareTo(stringArray[j - n]) < 0; j -= n) {
                    stringArray[j] = stringArray[j - n];
                    mgrTypeInfoArray[j] = mgrTypeInfoArray[j - n];
                }
                stringArray[j] = string;
                mgrTypeInfoArray[j] = mgrTypeInfo;
            }
        }
        return mgrTypeInfoArray;
    }

    static class ProtoImpl
    extends MgrTypeInfo {
        BComponent proto;

        ProtoImpl(BComponent bComponent) {
            this.proto = bComponent;
        }

        public String getDisplayName() {
            return this.proto.getType().getDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.proto.getIcon());
        }

        public BComponent newInstance() {
            return (BComponent)this.proto.newCopy(true);
        }

        public boolean isMatchable(BComponent bComponent) {
            return bComponent.getType().is(this.proto.getType());
        }

        protected String getCompareString() {
            return this.proto.getType().getTypeInfo().toString();
        }
    }

    static class AgentInfoImpl
    extends MgrTypeInfo {
        AgentInfo ai;

        AgentInfoImpl(AgentInfo agentInfo) {
            this.ai = agentInfo;
        }

        public String getDisplayName() {
            return this.ai.getDisplayName(null);
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ai.getIcon(null));
        }

        public BComponent newInstance() {
            return (BComponent)this.ai.getInstance();
        }

        public boolean isMatchable(BComponent bComponent) {
            return bComponent.getType().is(this.ai.getAgentType());
        }

        protected String getCompareString() {
            return this.ai.getAgentType().toString();
        }
    }

    static class TypeInfoImpl
    extends MgrTypeInfo {
        boolean duplicate = false;
        TypeInfo ti;

        TypeInfoImpl(TypeInfo typeInfo) {
            this.ti = typeInfo;
        }

        public String toSlotName() {
            return SlotPath.escape((String)TextUtil.replace((String)this.ti.getDisplayName(null), (String)" ", (String)""));
        }

        public String getDisplayName() {
            if (!this.duplicate) {
                return this.ti.getDisplayName(null);
            }
            return this.ti.getDisplayName(null) + "(" + this.ti.getModuleName() + ")";
        }

        public BImage getIcon() {
            return BImage.make((BIcon)this.ti.getIcon(null));
        }

        public BComponent newInstance() {
            return (BComponent)this.ti.getInstance();
        }

        public boolean isMatchable(BComponent bComponent) {
            return bComponent.getType().is(this.ti);
        }

        protected String getCompareString() {
            return this.ti.toString();
        }
    }
}

