/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import java.util.BitSet;
import java.util.HashMap;
import javax.baja.naming.BOrd;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.treetable.DynamicTreeTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;

public class MgrState {
    static HashMap cache = new HashMap();
    BOrd lastSaveOrd;
    boolean isLearnMode;
    BitSet modelColumns;
    BitSet learnColumns;

    public static String toKey(BAbstractManager bAbstractManager) {
        return bAbstractManager.getType().toString();
    }

    public static MgrState getCached(String string) {
        return (MgrState)cache.get(string);
    }

    public static void cache(String string, MgrState mgrState) {
        cache.put(string, mgrState);
    }

    public void restore(BAbstractManager bAbstractManager) {
        this.restoreForType(bAbstractManager);
        if (bAbstractManager.getWbShell() != null) {
            BOrd bOrd = bAbstractManager.getWbShell().getActiveOrd();
            if (this.lastSaveOrd != null && this.lastSaveOrd.equals((Object)bOrd)) {
                this.restoreForOrd(bAbstractManager);
            }
        }
    }

    protected void restoreForType(BAbstractManager bAbstractManager) {
        MgrController mgrController = bAbstractManager.getController();
        MgrLearn mgrLearn = bAbstractManager.getLearn();
        this.restoreColumns(bAbstractManager.getModel().getTable().dynamicModel, this.modelColumns);
        if (mgrLearn != null) {
            mgrController.learnMode.setSelected(this.isLearnMode);
            this.restoreColumns(mgrLearn.getTable().dynamicModel, this.learnColumns);
        }
    }

    protected void restoreForOrd(BAbstractManager bAbstractManager) {
    }

    public void save(BAbstractManager bAbstractManager) {
        this.lastSaveOrd = bAbstractManager.getWbShell().getActiveOrd();
        this.saveForType(bAbstractManager);
        this.saveForOrd(bAbstractManager);
    }

    protected void saveForType(BAbstractManager bAbstractManager) {
        MgrController mgrController = bAbstractManager.getController();
        MgrLearn mgrLearn = bAbstractManager.getLearn();
        MgrModel mgrModel = bAbstractManager.getModel();
        this.modelColumns = this.saveColumns(mgrModel.getTable().dynamicModel);
        if (mgrLearn != null) {
            this.isLearnMode = mgrController.learnMode.isSelected();
            this.learnColumns = this.saveColumns(mgrLearn.getTable().dynamicModel);
        }
    }

    protected void saveForOrd(BAbstractManager bAbstractManager) {
    }

    BitSet saveColumns(DynamicTableModel dynamicTableModel) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < dynamicTableModel.getRootColumnCount(); ++i) {
            if (dynamicTableModel.showColumn(i)) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    void restoreColumns(DynamicTableModel dynamicTableModel, BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        for (int i = 0; i < dynamicTableModel.getRootColumnCount(); ++i) {
            dynamicTableModel.setShowColumn(i, bitSet.get(i));
        }
    }

    BitSet saveColumns(DynamicTreeTableModel dynamicTreeTableModel) {
        BitSet bitSet = new BitSet();
        for (int i = 0; i < dynamicTreeTableModel.getRootColumnCount(); ++i) {
            if (dynamicTreeTableModel.showColumn(i)) {
                bitSet.set(i);
                continue;
            }
            bitSet.clear(i);
        }
        return bitSet;
    }

    void restoreColumns(DynamicTreeTableModel dynamicTreeTableModel, BitSet bitSet) {
        if (bitSet == null) {
            return;
        }
        for (int i = 0; i < dynamicTreeTableModel.getRootColumnCount(); ++i) {
            dynamicTreeTableModel.setShowColumn(i, bitSet.get(i));
        }
    }
}

