/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import java.util.ArrayList;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.nre.util.Array;
import javax.baja.space.Mark;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.table.BTable;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.BMixinMgrAgent;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrModel
extends MgrSupport {
    boolean built;
    MgrColumn[] cols;
    MgrColumn[] editable;
    BMgrTable table;

    public MgrModel(BAbstractManager bAbstractManager) {
        super(bAbstractManager);
    }

    public void init() {
        this.cols = (MgrColumn[])this.makeColumns().clone();
        this.columnsModified();
    }

    public final BMgrTable getTable() {
        return this.table;
    }

    public final MgrColumn[] getColumns() {
        return (MgrColumn[])this.cols.clone();
    }

    public final void setColumns(MgrColumn[] mgrColumnArray) {
        this.cols = mgrColumnArray;
    }

    public final int getColumnCount() {
        return this.cols.length;
    }

    public final MgrColumn getColumn(int n) {
        return this.cols[n];
    }

    public final MgrColumn[] getEditableColumns() {
        return (MgrColumn[])this.editable.clone();
    }

    public final void columnsModified() {
        ArrayList<MgrColumn> arrayList = new ArrayList<MgrColumn>();
        for (int i = 0; i < this.cols.length; ++i) {
            MgrColumn mgrColumn = this.cols[i];
            mgrColumn.init(this.manager);
            if (!mgrColumn.isEditable()) continue;
            arrayList.add(mgrColumn);
        }
        this.editable = arrayList.toArray(new MgrColumn[arrayList.size()]);
        BMgrTable bMgrTable = this.getTable();
        if (bMgrTable != null) {
            bMgrTable.columnsModified();
        }
    }

    public BWidget makePane() {
        this.table = this.makeTable();
        this.manager.attach(this.table);
        this.manager.setTransferWidget((BTransferWidget)this.table);
        return BTitlePane.makePane((String)this.makeTableTitle(), (BTable)this.table);
    }

    protected BMgrTable makeTable() {
        return new BMgrTable(this);
    }

    protected String makeTableTitle() {
        return this.manager.lexDatabaseObjects;
    }

    public MgrTypeInfo[] getNewTypes() {
        return null;
    }

    public MgrTypeInfo toType(BComponent bComponent) {
        return MgrTypeInfo.make(bComponent);
    }

    public BComponent newInstance(MgrTypeInfo mgrTypeInfo) throws Exception {
        return mgrTypeInfo.newInstance();
    }

    public CommandArtifact addInstances(MgrEditRow[] mgrEditRowArray, Context context) throws Exception {
        String[] stringArray = new String[mgrEditRowArray.length];
        BComponent[] bComponentArray = new BComponent[mgrEditRowArray.length];
        for (int i = 0; i < mgrEditRowArray.length; ++i) {
            stringArray[i] = mgrEditRowArray[i].getName();
            bComponentArray[i] = mgrEditRowArray[i].getTarget();
        }
        Mark mark = new Mark((BObject[])bComponentArray, stringArray);
        BComponent bComponent = mgrEditRowArray[0].getEdit().getAddContainer();
        mark.moveTo((BObject)bComponent, null);
        return null;
    }

    protected MgrColumn[] makeColumns() {
        return new MgrColumn[]{new MgrColumn.Name(), new MgrColumn.Type()};
    }

    public MgrColumn[] appendMixInColumns(MgrColumn[] mgrColumnArray, Type type) {
        try {
            Type[] typeArray = this.manager.target.getComponentSpace().getEnabledMixIns();
            Array array = new Array((Object[])mgrColumnArray);
            for (int i = 0; i < typeArray.length; ++i) {
                Type type2 = typeArray[i];
                if (!Sys.getRegistry().isAgent(type2.getTypeInfo(), type.getTypeInfo())) continue;
                AgentList agentList = Sys.getRegistry().getAgents(type2.getTypeInfo());
                agentList = agentList.filter(AgentFilter.is((Type)BMixinMgrAgent.TYPE));
                agentList = agentList.filter(new AgentFilter(){

                    public boolean include(AgentInfo agentInfo) {
                        return !agentInfo.getAgentType().isInterface() && !agentInfo.getAgentType().isAbstract();
                    }
                });
                for (int j = 0; j < agentList.size(); ++j) {
                    BMixinMgrAgent bMixinMgrAgent = (BMixinMgrAgent)agentList.get(j).getInstance();
                    if (bMixinMgrAgent.requireExactTypeMatch()) {
                        boolean bl = Sys.getRegistry().isSpecificAgent(bMixinMgrAgent.getType().getTypeInfo(), type2.getTypeInfo());
                        if (!bl) continue;
                        array.addAll((Object[])bMixinMgrAgent.getColumns());
                        continue;
                    }
                    array.addAll((Object[])bMixinMgrAgent.getColumns());
                }
            }
            return (MgrColumn[])array.trim();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return mgrColumnArray;
        }
    }

    public void load(BComponent bComponent) {
        super.load(bComponent);
        this.table.reload();
    }

    public Type[] getIncludeTypes() {
        return new Type[]{BComponent.TYPE};
    }

    public boolean accept(BComponent bComponent) {
        return true;
    }

    public int getSubscribeDepth() {
        return 1;
    }
}

