/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.job.BJobBar;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.job.BJob;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.ui.BBorder;
import javax.baja.ui.BWidget;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.util.BTitlePane;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;

public abstract class MgrLearn
extends MgrSupport {
    BLearnTable table;
    BWidget jobBar;
    BJob job;
    MgrColumn[] cols;
    Object[] roots = new Object[0];
    boolean jobComplete;

    public MgrLearn(BAbstractManager bAbstractManager) {
        super(bAbstractManager);
    }

    public void init() {
        this.updateColumns();
    }

    public final BLearnTable getTable() {
        return this.table;
    }

    public final BWidget getJobBar() {
        return this.jobBar;
    }

    public final MgrColumn[] getColumns() {
        if (this.cols == null) {
            // empty if block
        }
        return (MgrColumn[])this.cols.clone();
    }

    public void updateTable() {
        this.table.getSelection().deselectAll();
        if (this.hasDynamicColumns()) {
            this.updateColumns();
            this.table.updateColumns();
        }
        this.table.treeTableModel.updateTreeTable(true);
    }

    void updateColumns() {
        this.cols = (MgrColumn[])this.makeColumns().clone();
        for (int i = 0; i < this.cols.length; ++i) {
            this.cols[i].init(this.manager);
        }
    }

    public final int getRootCount() {
        return this.roots.length;
    }

    public final Object getRoot(int n) {
        return this.roots[n];
    }

    public final Object[] getRoots() {
        return (Object[])this.roots.clone();
    }

    public final void updateRoots(Object[] objectArray) {
        this.roots = (Object[])objectArray.clone();
        this.updateTable();
    }

    public BWidget makePane() {
        String string = this.makeTableTitle();
        this.table = this.makeTable();
        this.jobBar = this.makeJobBar();
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)BTitlePane.makePane((String)string, (BTable)this.table));
        if (this.jobBar != null) {
            if (this.jobBar instanceof BJobBar) {
                this.manager.attach((BJobBar)this.jobBar);
                BBorderPane bBorderPane = new BBorderPane(this.jobBar, BBorder.solid, BInsets.make((double)0.0, (double)5.0, (double)0.0, (double)5.0));
                bBorderPane.setFill(Theme.widget().getWindowBackground());
                bBorderPane = new BBorderPane((BWidget)bBorderPane, BBorder.inset, BInsets.DEFAULT);
                bEdgePane.setTop((BWidget)new BBorderPane((BWidget)bBorderPane, BInsets.make((double)0.0, (double)0.0, (double)5.0, (double)0.0)));
            } else {
                bEdgePane.setTop((BWidget)new BBorderPane(this.jobBar, 0.0, 0.0, 5.0, 0.0));
            }
        }
        return bEdgePane;
    }

    public String makeTableTitle() {
        return this.manager.lexDiscoveryObjects;
    }

    protected BLearnTable makeTable() {
        return new BLearnTable(this);
    }

    protected BWidget makeJobBar() {
        return new BJobBar();
    }

    protected boolean hasDynamicColumns() {
        return false;
    }

    protected abstract MgrColumn[] makeColumns();

    public boolean isDepthExpandable(int n) {
        return false;
    }

    public boolean isGroup(Object object) {
        return false;
    }

    public boolean hasChildren(Object object) {
        return true;
    }

    public Object[] getChildren(Object object) {
        return new Object[0];
    }

    public BImage getIcon(Object object) {
        return null;
    }

    public BComponent getExisting(Object object) {
        ComponentTableModel componentTableModel = this.getManager().getModel().getTable().getComponentModel();
        for (int i = 0; i < componentTableModel.getRowCount(); ++i) {
            BComponent bComponent = componentTableModel.getComponentAt(i);
            if (!this.isExisting(object, bComponent)) continue;
            return bComponent;
        }
        return null;
    }

    public boolean isExisting(Object object, BComponent bComponent) {
        return false;
    }

    public BJob getJob() {
        return this.job;
    }

    public void setJob(BJob bJob) {
        this.job = bJob;
        this.jobComplete = false;
        if (this.jobBar instanceof BJobBar) {
            this.getManager().registerForComponentEvents((BComponent)bJob);
            ((BJobBar)this.jobBar).load(bJob);
        }
        if (bJob != null && bJob.getJobState().isComplete() && !this.jobComplete) {
            this.jobComplete = true;
            if (this.getManager() != null && this.getManager().isRegisteredForComponentEvents((BComponent)bJob)) {
                this.getManager().registerForComponentEvents((BComponent)bJob, Integer.MAX_VALUE);
            }
            this.jobComplete(bJob);
        }
    }

    public void setJob(BOrd bOrd) throws Exception {
        BComponent bComponent = (BComponent)this.getManager().getCurrentValue();
        bComponent.getComponentSpace().sync();
        BJob bJob = (BJob)bOrd.get((BObject)bComponent);
        this.setJob(bJob);
    }

    public void jobComplete(BJob bJob) {
    }

    public boolean isMatchable(Object object, BComponent bComponent) {
        try {
            MgrTypeInfo[] mgrTypeInfoArray = this.toTypes(object);
            for (int i = 0; i < mgrTypeInfoArray.length; ++i) {
                if (!mgrTypeInfoArray[i].isMatchable(bComponent)) continue;
                return true;
            }
            return false;
        }
        catch (Exception exception) {
            System.out.println(exception);
            return false;
        }
    }

    public abstract MgrTypeInfo[] toTypes(Object var1) throws Exception;

    public abstract void toRow(Object var1, MgrEditRow var2) throws Exception;
}

