/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import javax.baja.data.BIDataValue;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrEditRow {
    BComponent target;
    Object discovery;
    MgrTypeInfo[] types;
    MgrEdit edit;
    int nameColumn = -1;
    int typeColumn = -1;
    BValue[] cells;
    String userDefinedName;

    public MgrEditRow(BComponent bComponent, Object object, MgrTypeInfo[] mgrTypeInfoArray) {
        this.target = bComponent;
        this.discovery = object;
        this.types = mgrTypeInfoArray;
    }

    public final BAbstractManager getManager() {
        if (this.edit != null) {
            return this.edit.manager;
        }
        return null;
    }

    public final MgrModel getModel() {
        return this.getManager().model;
    }

    public final MgrLearn getLearn() {
        return this.getManager().getLearn();
    }

    public MgrEdit getEdit() {
        return this.edit;
    }

    public BComponent getTarget() {
        return this.target;
    }

    public BComponent getTargetParent() {
        BComponent bComponent = (BComponent)this.target.getParent();
        if (bComponent != null) {
            return bComponent;
        }
        return this.edit.getAddContainer();
    }

    public Object getDiscovery() {
        return this.discovery;
    }

    public MgrTypeInfo[] getAvailableTypes() {
        return this.types;
    }

    public int getNameColumnIndex() {
        return this.nameColumn;
    }

    public String getName() {
        if (this.nameColumn < 0) {
            return null;
        }
        BValue bValue = this.getCell(this.nameColumn);
        if (bValue == null) {
            return null;
        }
        String string = bValue.toString();
        if (string.length() == 0) {
            return null;
        }
        return string;
    }

    public void setName(String string) {
        if (this.nameColumn < 0) {
            return;
        }
        this.setCell(this.nameColumn, (BValue)BString.make((String)string));
    }

    public void setDefaultName(String string) {
        if (this.nameColumn < 0) {
            return;
        }
        if (this.getName() == null) {
            this.setName(this.getEdit().getUniqueName(this, string));
        }
    }

    public int getTypeColumnIndex() {
        return this.typeColumn;
    }

    public MgrTypeInfo getType() {
        if (this.typeColumn < 0) {
            return null;
        }
        BFacets bFacets = (BFacets)this.getCell(this.typeColumn);
        return (MgrTypeInfo)bFacets.getPickle();
    }

    public void setType(MgrTypeInfo mgrTypeInfo) throws Exception {
        if (this.typeColumn < 0) {
            return;
        }
        BFacets bFacets = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BBoolean.TRUE), (Object)mgrTypeInfo);
        this.setCell(this.typeColumn, (BValue)bFacets);
        if (this.target.isMounted()) {
            throw new IllegalStateException("Cannot change type of mounted component");
        }
        this.target = this.getManager().getModel().newInstance(mgrTypeInfo);
        this.loadCells();
        if (this.discovery != null) {
            this.getLearn().toRow(this.discovery, this);
        }
        if (this.userDefinedName != null) {
            this.setName(this.userDefinedName);
        } else if (this.getName() == null) {
            this.setName(this.edit.getUniqueName(this));
        }
    }

    public final MgrColumn[] getColumns() {
        return this.edit.getColumns();
    }

    public final int getColumnIndex(MgrColumn mgrColumn) {
        MgrColumn[] mgrColumnArray = this.getColumns();
        for (int i = 0; i < mgrColumnArray.length; ++i) {
            if (mgrColumn != mgrColumnArray[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("MgrColumn not found in getManager().getEditableColumns()");
    }

    public BValue getCell(int n) {
        return this.cells[n];
    }

    public BValue getCell(MgrColumn mgrColumn) {
        return this.cells[this.getColumnIndex(mgrColumn)];
    }

    public void setCell(int n, BValue bValue) {
        this.cells[n] = bValue;
    }

    public void setCell(MgrColumn mgrColumn, BValue bValue) {
        this.setCell(this.getColumnIndex(mgrColumn), bValue);
    }

    public void loadCells() throws Exception {
        MgrColumn[] mgrColumnArray = this.getColumns();
        this.nameColumn = -1;
        this.typeColumn = -1;
        this.cells = new BValue[mgrColumnArray.length];
        for (int i = 0; i < this.cells.length; ++i) {
            MgrColumn mgrColumn = mgrColumnArray[i];
            if (mgrColumn instanceof MgrColumn.Name) {
                this.nameColumn = i;
            }
            if (mgrColumn instanceof MgrColumn.Type) {
                this.typeColumn = i;
            }
            this.cells[i] = mgrColumn.load(this);
        }
    }

    public void saveCells(Context context) throws Exception {
        MgrColumn[] mgrColumnArray = this.getColumns();
        for (int i = 0; i < mgrColumnArray.length; ++i) {
            mgrColumnArray[i].save(this, this.cells[i], context);
        }
    }

    public void commit(Context context) throws Exception {
        this.saveCells((Context)(this.target.isMounted() ? context : null));
        BComponent bComponent = this.getTargetParent();
        String string = this.getName();
        if (this.target.isMounted() && string != null && !string.equals(this.target.getName())) {
            bComponent.rename(this.target.getPropertyInParent(), string, context);
        }
    }

    public void dumpCells() {
        System.out.println("MgrEditRow " + this.target.getType());
        MgrColumn[] mgrColumnArray = this.getColumns();
        for (int i = 0; i < this.cells.length; ++i) {
            System.out.println("  " + mgrColumnArray[i].getDisplayName() + " = " + this.cells[i].toString());
        }
    }
}

