/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.util.ObjectUtil;
import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BMgrEditDialog;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrEdit
extends TableModel {
    private static MgrTypeInfo[] noTypes = new MgrTypeInfo[0];
    BAbstractManager manager;
    String title;
    MgrColumn[] cols;
    ArrayList rows;
    boolean selectAll;

    public MgrEdit(BAbstractManager bAbstractManager, String string) {
        this.manager = bAbstractManager;
        this.title = string;
        this.cols = this.makeColumns();
        this.rows = new ArrayList();
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public String getTitle() {
        return this.title;
    }

    public BComponent getAddContainer() {
        return this.manager.target;
    }

    public final MgrColumn[] getColumns() {
        return (MgrColumn[])this.cols.clone();
    }

    protected MgrColumn[] makeColumns() {
        return this.manager.getModel().getEditableColumns();
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getColumnCount() {
        return this.cols.length;
    }

    public String getColumnName(int n) {
        return this.cols[n].getDisplayName();
    }

    public Object getValueAt(int n, int n2) {
        MgrEditRow mgrEditRow = this.getRow(n);
        MgrColumn mgrColumn = this.cols[n2];
        try {
            return mgrColumn.toDisplayString(mgrEditRow.target, mgrEditRow.getCell(n2), this.manager.getCurrentContext());
        }
        catch (Exception exception) {
            System.out.println("ERROR: row=" + n + " col=" + mgrColumn.getDisplayName());
            exception.printStackTrace();
            return "";
        }
    }

    public Object getSubject(int n) {
        return this.getRow(n);
    }

    public BImage getRowIcon(int n) {
        return BImage.make((BIcon)this.getRow(n).getTarget().getIcon());
    }

    public MgrEditRow[] getRows() {
        return this.rows.toArray(new MgrEditRow[this.rows.size()]);
    }

    public MgrEditRow getRow(int n) {
        return (MgrEditRow)this.rows.get(n);
    }

    public int indexOf(MgrEditRow mgrEditRow) {
        for (int i = 0; i < this.rows.size(); ++i) {
            if (this.rows.get(i) != mgrEditRow) continue;
            return i;
        }
        return -1;
    }

    public MgrEditRow addRow(int n, MgrEditRow mgrEditRow) throws Exception {
        if (mgrEditRow.edit != null) {
            throw new IllegalArgumentException("Row is already in another table");
        }
        this.rows.add(n, mgrEditRow);
        mgrEditRow.edit = this;
        mgrEditRow.loadCells();
        return mgrEditRow;
    }

    public MgrEditRow addRow(MgrEditRow mgrEditRow) throws Exception {
        return this.addRow(this.getRowCount(), mgrEditRow);
    }

    public MgrEditRow addRow(BComponent bComponent) throws Exception {
        return this.addRow(this.makeRow(bComponent, null, null));
    }

    public MgrEditRow addRow(Object object, MgrTypeInfo[] mgrTypeInfoArray) throws Exception {
        return this.addRow(this.makeRow(this.getManager().getModel().newInstance(mgrTypeInfoArray[0]), object, mgrTypeInfoArray));
    }

    protected MgrEditRow makeRow(BComponent bComponent, Object object, MgrTypeInfo[] mgrTypeInfoArray) throws Exception {
        return new MgrEditRow(bComponent, object, mgrTypeInfoArray);
    }

    public void remove(MgrEditRow mgrEditRow) throws Exception {
        int n = this.indexOf(mgrEditRow);
        if (n < 0) {
            throw new IllegalArgumentException("Row not in this table");
        }
        this.rows.remove(n);
        mgrEditRow.edit = null;
    }

    public void checkTargetNames() {
        MgrEditRow[] mgrEditRowArray = this.getRows();
        if (mgrEditRowArray.length == 0 || mgrEditRowArray[0].getNameColumnIndex() < 0) {
            return;
        }
        for (int i = 0; i < mgrEditRowArray.length; ++i) {
            MgrEditRow mgrEditRow = mgrEditRowArray[i];
            String string = mgrEditRow.getName();
            if (string != null) continue;
            mgrEditRow.setName(this.getUniqueName(mgrEditRow));
        }
    }

    public String getUniqueName(MgrEditRow mgrEditRow) {
        String string = this.manager.getModel().toType(mgrEditRow.getTarget()).toSlotName();
        return this.getUniqueName(mgrEditRow, string);
    }

    public String getUniqueName(MgrEditRow mgrEditRow, String string) {
        return ObjectUtil.generateUniqueSlotName((String)string, (ObjectUtil.NameContainer)new NameContainerImpl(mgrEditRow));
    }

    public boolean isNameUnique(MgrEditRow mgrEditRow, String string) {
        BComponent bComponent = mgrEditRow.getTargetParent();
        BValue bValue = bComponent.get(string);
        if (bValue != null && bValue != mgrEditRow.getTarget()) {
            return false;
        }
        for (int i = 0; i < this.rows.size(); ++i) {
            MgrEditRow mgrEditRow2 = this.getRow(i);
            if (bComponent != mgrEditRow2.getTargetParent()) continue;
            String string2 = mgrEditRow2.getName();
            if (mgrEditRow2 == mgrEditRow || string2 == null || !string2.equals(string)) continue;
            return false;
        }
        return true;
    }

    public static MgrTypeInfo[] getTypeIntersection(MgrEditRow[] mgrEditRowArray) {
        if (mgrEditRowArray == null || mgrEditRowArray.length == 0) {
            return noTypes;
        }
        MgrTypeInfo[] mgrTypeInfoArray = mgrEditRowArray[0].getAvailableTypes();
        if (mgrTypeInfoArray == null) {
            mgrTypeInfoArray = noTypes;
        }
        for (int i = 1; i < mgrEditRowArray.length; ++i) {
            mgrTypeInfoArray = MgrEdit.intersect(mgrTypeInfoArray, mgrEditRowArray[i].getAvailableTypes());
        }
        return mgrTypeInfoArray;
    }

    private static MgrTypeInfo[] intersect(MgrTypeInfo[] mgrTypeInfoArray, MgrTypeInfo[] mgrTypeInfoArray2) {
        if (mgrTypeInfoArray == null || mgrTypeInfoArray.length == 0 || mgrTypeInfoArray2 == null || mgrTypeInfoArray2.length == 0) {
            return noTypes;
        }
        ArrayList<MgrTypeInfo> arrayList = new ArrayList<MgrTypeInfo>();
        int n = mgrTypeInfoArray.length;
        int n2 = mgrTypeInfoArray2.length;
        block0: for (int i = 0; i < n; ++i) {
            MgrTypeInfo mgrTypeInfo = mgrTypeInfoArray[i];
            for (int j = 0; j < n2; ++j) {
                if (!mgrTypeInfo.equals(mgrTypeInfoArray2[j])) continue;
                arrayList.add(mgrTypeInfo);
                continue block0;
            }
        }
        if (arrayList.size() == 0) {
            return noTypes;
        }
        return arrayList.toArray(new MgrTypeInfo[arrayList.size()]);
    }

    public boolean getSelectAll() {
        return this.selectAll;
    }

    public void setSelectAll(boolean bl) {
        this.selectAll = bl;
    }

    public CommandArtifact invoke(Context context) throws Exception {
        if (this.rows.size() == 0) {
            return null;
        }
        this.checkTargetNames();
        if (context != MgrController.quickContext && !this.prompt()) {
            return null;
        }
        return this.commit();
    }

    public boolean prompt() throws Exception {
        BMgrEditDialog bMgrEditDialog = new BMgrEditDialog(this, this.getSelectAll());
        bMgrEditDialog.setScreenSizeToPreferredSize();
        bMgrEditDialog.setBoundsCenteredOnOwner();
        bMgrEditDialog.open();
        return bMgrEditDialog.getResult() == 1;
    }

    public void validate(MgrEditRow[] mgrEditRowArray) throws Exception {
    }

    public CommandArtifact commit() throws Exception {
        int n;
        MgrEditRow[] mgrEditRowArray = this.getRows();
        if (mgrEditRowArray.length == 0) {
            return null;
        }
        BComponent bComponent = this.getAddContainer();
        Context context = Transaction.start((BComponent)bComponent, null);
        for (n = 0; n < mgrEditRowArray.length; ++n) {
            mgrEditRowArray[n].commit(context);
        }
        Transaction.end((BComponent)bComponent, (Context)context);
        int n2 = n = !mgrEditRowArray[0].target.isMounted() ? 1 : 0;
        if (n != 0) {
            return this.manager.getModel().addInstances(mgrEditRowArray, null);
        }
        return null;
    }

    public boolean isReadonly(MgrEditRow[] mgrEditRowArray, MgrColumn mgrColumn) {
        return mgrColumn.isReadonly();
    }

    private class NameContainerImpl
    implements ObjectUtil.NameContainer {
        MgrEditRow row;

        NameContainerImpl(MgrEditRow mgrEditRow) {
            this.row = mgrEditRow;
        }

        public boolean contains(String string) {
            return !MgrEdit.this.isNameUnique(this.row, string);
        }
    }
}

