/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import javax.baja.job.BJob;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BComponent;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.ui.BAbstractButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BListDropDown;
import javax.baja.ui.BMenu;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BTextField;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.ToggleCommand;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferFormat;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.BLearnTable;
import javax.baja.workbench.mgr.BMgrTable;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrSupport;
import javax.baja.workbench.mgr.MgrTypeInfo;

public class MgrController
extends MgrSupport {
    public static final int MENU_BAR = 1;
    public static final int TOOL_BAR = 2;
    public static final int ACTION_BAR = 4;
    public static final int POPUP = 8;
    public static final int LEARN_POPUP = 16;
    public static final int BARS = 7;
    static final int[] emptySelection = new int[0];
    static final BComponent[] emptyComponentTable = new BComponent[0];
    static final Context quickContext = new BasicContext();
    final Lexicon lex = Lexicon.make((Class)(class$javax$baja$workbench$mgr$MgrController == null ? (class$javax$baja$workbench$mgr$MgrController = MgrController.class$("javax.baja.workbench.mgr.MgrController")) : class$javax$baja$workbench$mgr$MgrController));
    IMgrCommand[] commands;
    public final MgrCommand newCommand;
    public final MgrCommand edit;
    public final MgrToggleCommand learnMode;
    public final MgrCommand discover;
    public final MgrCommand cancel;
    public final MgrCommand add;
    public final MgrCommand match;
    public final MgrCommand quickAdd;
    public final MgrCommand quickMatch;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$MgrController;

    public MgrController(BAbstractManager bAbstractManager) {
        super(bAbstractManager);
        this.newCommand = new New(bAbstractManager);
        this.edit = new Edit(bAbstractManager);
        this.learnMode = new LearnMode(bAbstractManager);
        this.discover = new Discover(bAbstractManager);
        this.cancel = new Cancel(bAbstractManager);
        this.add = new Add(bAbstractManager);
        this.match = new Match(bAbstractManager);
        this.quickAdd = new QuickAdd(bAbstractManager);
        this.quickMatch = new QuickMatch(bAbstractManager);
        this.newCommand.setFlags(15);
        this.edit.setFlags(15);
        if (bAbstractManager.isLearnable()) {
            this.learnMode.setFlags(3);
            this.discover.setFlags(7);
            this.cancel.setFlags(7);
            this.add.setFlags(23);
            this.quickAdd.setFlags(1);
            this.match.setFlags(23);
            this.quickMatch.setFlags(1);
        }
    }

    public void init() {
        this.updateCommands();
    }

    public BToolBar makeToolBar() {
        BToolBar bToolBar = new BToolBar();
        IMgrCommand[] iMgrCommandArray = this.getCommands();
        for (int i = 0; i < iMgrCommandArray.length; ++i) {
            IMgrCommand iMgrCommand = iMgrCommandArray[i];
            if ((iMgrCommand.getFlags() & 2) == 0) continue;
            String string = "cmd" + i;
            bToolBar.add(string, (Command)iMgrCommand);
            BAbstractButton bAbstractButton = (BAbstractButton)bToolBar.get(string);
            IMgrCommand[] iMgrCommandArray2 = this.getDropDownCommands(iMgrCommand);
            if (iMgrCommandArray2 == null || iMgrCommandArray2.length <= 0) continue;
            bAbstractButton.setMenuController((BAbstractButton.MenuController)new MenuController());
        }
        return bToolBar;
    }

    public BMenu[] makeMenus() {
        BMenu bMenu = new BMenu(this.lex.getText("manager"));
        IMgrCommand[] iMgrCommandArray = this.getCommands();
        for (int i = 0; i < iMgrCommandArray.length; ++i) {
            if ((iMgrCommandArray[i].getFlags() & 1) == 0) continue;
            bMenu.add("cmd" + i, (Command)iMgrCommandArray[i]);
        }
        return new BMenu[]{bMenu};
    }

    public BWidget makeActionBar() {
        return this.makeActionPane(this.getCommands());
    }

    protected BWidget makeActionPane(IMgrCommand[] iMgrCommandArray) {
        if (iMgrCommandArray.length == 0) {
            return new BNullWidget();
        }
        int n = 0;
        BGridPane bGridPane = new BGridPane();
        for (int i = 0; i < iMgrCommandArray.length; ++i) {
            IMgrCommand iMgrCommand = iMgrCommandArray[i];
            if ((iMgrCommand.getFlags() & 4) == 0) continue;
            BAbstractButton bAbstractButton = BAbstractButton.make((Command)((Command)iMgrCommand));
            IMgrCommand[] iMgrCommandArray2 = this.getDropDownCommands(iMgrCommand);
            if (iMgrCommandArray2 != null && iMgrCommandArray2.length > 0) {
                bAbstractButton.setMenuController((BAbstractButton.MenuController)new MenuController());
            }
            bGridPane.add("cmd" + i, (BValue)bAbstractButton);
            ++n;
        }
        bGridPane.setColumnCount(n);
        return bGridPane;
    }

    public IMgrCommand[] getDropDownCommands(IMgrCommand iMgrCommand) {
        return null;
    }

    public final IMgrCommand[] getCommands() {
        if (this.commands == null) {
            this.commands = this.makeCommands();
        }
        return (IMgrCommand[])this.commands.clone();
    }

    public final int getCommandCount() {
        return this.commands.length;
    }

    public final IMgrCommand getCommand(int n) {
        if (this.commands == null) {
            this.commands = this.makeCommands();
        }
        return this.commands[n];
    }

    protected IMgrCommand[] makeCommands() {
        return new IMgrCommand[]{this.newCommand, this.edit, this.learnMode, this.discover, this.cancel, this.add, this.quickAdd, this.match, this.quickMatch};
    }

    public static IMgrCommand[] append(IMgrCommand[] iMgrCommandArray, IMgrCommand[] iMgrCommandArray2) {
        IMgrCommand[] iMgrCommandArray3 = new IMgrCommand[iMgrCommandArray.length + iMgrCommandArray2.length];
        System.arraycopy(iMgrCommandArray, 0, iMgrCommandArray3, 0, iMgrCommandArray.length);
        System.arraycopy(iMgrCommandArray2, 0, iMgrCommandArray3, iMgrCommandArray.length, iMgrCommandArray2.length);
        return iMgrCommandArray3;
    }

    public void updateCommands() {
        Object object;
        int[] nArray = this.getSelectedRows();
        this.edit.setEnabled(nArray.length > 0);
        if (this.manager.learn != null) {
            object = this.manager.learn.getJob();
            this.discover.setEnabled(object == null || !object.getJobState().isRunning());
            this.cancel.setEnabled(object != null && object.getJobState().isRunning());
        } else {
            this.discover.setEnabled(false);
            this.cancel.setEnabled(false);
        }
        if (this.learnMode.isSelected()) {
            object = this.getLearnSelectedRows();
            this.add.setEnabled(((BJob)object).length > 0);
            this.match.setEnabled(this.checkMatch((int[])object, nArray));
            this.quickAdd.setEnabled(this.add.isEnabled());
            this.quickMatch.setEnabled(this.match.isEnabled());
        } else {
            this.add.setEnabled(false);
            this.match.setEnabled(false);
            this.quickAdd.setEnabled(false);
            this.quickMatch.setEnabled(false);
        }
    }

    private boolean checkMatch(int[] nArray, int[] nArray2) {
        try {
            if (nArray.length == 1 && nArray2.length == 1) {
                Object object = this.getLearnTable().getObjectAt(nArray[0]);
                BComponent bComponent = this.getTable().getComponentModel().getComponentAt(nArray2[0]);
                return this.manager.getLearn().isMatchable(object, bComponent);
            }
            return false;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return false;
        }
    }

    public MgrEdit makeEdit(String string) {
        return new MgrEdit(this.getManager(), string);
    }

    public final BMgrTable getTable() {
        return this.manager.model.table;
    }

    public final BLearnTable getLearnTable() {
        if (this.manager.learn == null) {
            return null;
        }
        return this.manager.learn.table;
    }

    public final int[] getSelectedRows() {
        BMgrTable bMgrTable = this.getTable();
        if (bMgrTable == null) {
            return emptySelection;
        }
        return bMgrTable.getSelection().getRows();
    }

    public int[] getLearnSelectedRows() {
        BLearnTable bLearnTable = this.getLearnTable();
        if (bLearnTable == null) {
            return emptySelection;
        }
        return bLearnTable.getSelection().getRows();
    }

    public final BComponent[] getSelectedComponents() {
        BMgrTable bMgrTable = this.getTable();
        if (bMgrTable == null) {
            return emptyComponentTable;
        }
        return bMgrTable.getSelectedComponents();
    }

    public BMenu makePopup(BMgrTable bMgrTable, ComponentTableSubject componentTableSubject, BMenu bMenu) {
        if (bMenu == null) {
            bMenu = new BMenu();
        }
        bMenu.add(null, (BValue)new BSeparator());
        IMgrCommand[] iMgrCommandArray = this.getCommands();
        for (int i = 0; i < iMgrCommandArray.length; ++i) {
            IMgrCommand iMgrCommand = iMgrCommandArray[i];
            if ((iMgrCommand.getFlags() & 8) == 0) continue;
            bMenu.add("mgr_" + iMgrCommand.getName(), (Command)iMgrCommand);
        }
        return bMenu;
    }

    public BMenu makePopup(BLearnTable bLearnTable, TreeTableSubject treeTableSubject, BMenu bMenu) {
        if (bMenu == null) {
            bMenu = new BMenu();
        }
        IMgrCommand[] iMgrCommandArray = this.getCommands();
        for (int i = 0; i < iMgrCommandArray.length; ++i) {
            IMgrCommand iMgrCommand = iMgrCommandArray[i];
            if ((iMgrCommand.getFlags() & 0x10) == 0) continue;
            bMenu.add("mgr_" + iMgrCommand.getName(), (Command)iMgrCommand);
        }
        if (treeTableSubject.size() == 1) {
            BComponent bComponent = this.getManager().getLearn().getExisting(treeTableSubject.get(0));
            bMenu.add("existing", (Command)new ShowExisting((BWidget)bLearnTable, bComponent));
        }
        bMenu.add("selectAll", (Command)new SelectAll(bLearnTable));
        return bMenu;
    }

    public void cellDoubleClicked(BMgrTable bMgrTable, BMouseEvent bMouseEvent, int n, int n2) {
        if (this.edit.isEnabled()) {
            this.edit.invoke();
        }
    }

    public void cellDoubleClicked(BLearnTable bLearnTable, BMouseEvent bMouseEvent, int n, int n2) {
        if (this.add.isEnabled()) {
            this.add.invoke();
        }
    }

    public BMenu makeOptionsMenu(BMgrTable bMgrTable, BMenu bMenu) {
        return bMenu;
    }

    public BMenu makeOptionsMenu(BLearnTable bLearnTable, BMenu bMenu) {
        return bMenu;
    }

    public CommandArtifact drop(BMgrTable bMgrTable, TransferContext transferContext) throws Exception {
        try {
            BAbstractManager bAbstractManager = this.getManager();
            String string = (String)transferContext.getEnvelope().getData(TransferFormat.string);
            if (string.equals("dragFromLearn:" + bAbstractManager.hashCode())) {
                return this.add.doInvoke();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bMgrTable.superDrop(transferContext);
    }

    public void doLearnMode(boolean bl) {
        if (this.manager.learnPane != null) {
            this.manager.learnPane.setVisible(bl);
            this.manager.learnPane.getParentWidget().relayout();
        }
        this.updateCommands();
    }

    public CommandArtifact doDiscover(Context context) throws Exception {
        this.learnMode.setSelected(true);
        return null;
    }

    public CommandArtifact doCancel(Context context) throws Exception {
        BJob bJob;
        if (this.manager.getLearn() != null && (bJob = this.manager.getLearn().getJob()) != null) {
            bJob.cancel();
        }
        return null;
    }

    public CommandArtifact doNew(Context context) throws Exception {
        MgrEdit mgrEdit = this.promptForNew(context);
        if (mgrEdit == null) {
            return null;
        }
        return mgrEdit.invoke(null);
    }

    public MgrEdit promptForNew(Context context) throws Exception {
        MgrModel mgrModel = this.manager.getModel();
        MgrTypeInfo[] mgrTypeInfoArray = mgrModel.getNewTypes();
        if (mgrTypeInfoArray == null) {
            BDialog.error((BWidget)this.manager, (Object)"Must override BAbstractManager.getNewTypes()");
            return null;
        }
        MgrTypeInfo.markDuplicates(mgrTypeInfoArray);
        BListDropDown bListDropDown = new BListDropDown();
        for (int i = 0; i < mgrTypeInfoArray.length; ++i) {
            bListDropDown.getList().addItem(mgrTypeInfoArray[i].getIcon(), (Object)mgrTypeInfoArray[i]);
        }
        bListDropDown.setSelectedIndex(0);
        BTextField bTextField = new BTextField("1", 6);
        BGridPane bGridPane = new BGridPane(2);
        bGridPane.add(null, (BValue)new BLabel(this.lex.getText("add.type")));
        bGridPane.add(null, (BValue)bListDropDown);
        bGridPane.add(null, (BValue)new BLabel(this.lex.getText("add.count")));
        bGridPane.add(null, (BValue)bTextField);
        String string = this.newCommand.getLabel();
        int n = BDialog.open((BWidget)this.manager, (String)string, (Object)bGridPane, (int)3);
        if (n == 2) {
            return null;
        }
        MgrTypeInfo mgrTypeInfo = (MgrTypeInfo)bListDropDown.getSelectedItem();
        int n2 = Integer.parseInt(bTextField.getText());
        MgrEdit mgrEdit = this.makeEdit(string);
        for (int i = 0; i < n2; ++i) {
            mgrEdit.addRow(mgrEdit.makeRow(mgrModel.newInstance(mgrTypeInfo), null, mgrTypeInfoArray));
        }
        return mgrEdit;
    }

    public CommandArtifact doEdit(Context context) throws Exception {
        BComponent[] bComponentArray = this.getSelectedComponents();
        if (bComponentArray.length == 0) {
            return null;
        }
        MgrEdit mgrEdit = this.makeEdit(this.edit.getLabel());
        for (int i = 0; i < bComponentArray.length; ++i) {
            mgrEdit.addRow(bComponentArray[i]);
        }
        mgrEdit.setSelectAll(true);
        return mgrEdit.invoke(context);
    }

    public CommandArtifact doAdd(Context context) throws Exception {
        Object[] objectArray;
        if (this.manager.getLearn() != null && (objectArray = this.getLearnTable().getSelectedObjects()).length > 0) {
            return this.doAdd(objectArray, context);
        }
        return null;
    }

    protected CommandArtifact doAdd(Object[] objectArray, Context context) throws Exception {
        MgrEdit mgrEdit = this.makeEdit(this.add.getLabel());
        for (int i = 0; i < objectArray.length; ++i) {
            Object object = objectArray[i];
            MgrTypeInfo[] mgrTypeInfoArray = this.manager.getLearn().toTypes(object);
            if (mgrTypeInfoArray == null || mgrTypeInfoArray.length == 0) continue;
            MgrEditRow mgrEditRow = mgrEdit.addRow(object, mgrTypeInfoArray);
            this.manager.getLearn().toRow(object, mgrEditRow);
        }
        return mgrEdit.invoke(context);
    }

    public CommandArtifact doMatch(Context context) throws Exception {
        if (!this.manager.isLearnable()) {
            return null;
        }
        Object object = this.getLearnTable().getSelectedObject();
        if (object == null) {
            return null;
        }
        BComponent bComponent = this.getTable().getSelectedComponent();
        if (bComponent == null) {
            return null;
        }
        return this.doMatch(object, bComponent, context);
    }

    protected CommandArtifact doMatch(Object object, BComponent bComponent, Context context) throws Exception {
        MgrEdit mgrEdit = this.makeEdit(this.match.getLabel());
        MgrEditRow mgrEditRow = mgrEdit.addRow(bComponent);
        this.manager.getLearn().toRow(object, mgrEditRow);
        return mgrEdit.invoke(context);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static class MgrToggleCommand
    extends ToggleCommand
    implements IMgrCommand {
        private String name;
        private int flags;

        public MgrToggleCommand(BWidget bWidget, Lexicon lexicon, String string) {
            super(bWidget, lexicon, string);
            this.name = SlotPath.escape((String)string);
        }

        public MgrToggleCommand(BWidget bWidget, String string) {
            super(bWidget, string);
            this.name = SlotPath.escape((String)string);
        }

        public String getName() {
            return this.name;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int n) {
            this.flags = n;
        }
    }

    public static class MgrCommand
    extends Command
    implements IMgrCommand {
        private String name;
        private int flags;

        public MgrCommand(BWidget bWidget, Lexicon lexicon, String string) {
            super(bWidget, lexicon, string);
            this.name = SlotPath.escape((String)string);
        }

        public MgrCommand(BWidget bWidget, String string) {
            super(bWidget, string);
            this.name = SlotPath.escape((String)string);
        }

        public String getName() {
            return this.name;
        }

        public int getFlags() {
            return this.flags;
        }

        public void setFlags(int n) {
            this.flags = n;
        }
    }

    public static interface IMgrCommand {
        public String getName();

        public int getFlags();

        public void setFlags(int var1);
    }

    class SelectAll
    extends MgrCommand {
        SelectAll(BLearnTable bLearnTable) {
            super((BWidget)bLearnTable, (Lexicon)UiLexicon.bajaui(), "commands.selectAll");
        }

        public CommandArtifact doInvoke() throws Exception {
            ((BLearnTable)this.getOwner()).getSelection().selectAll();
            return null;
        }
    }

    class ShowExisting
    extends MgrCommand {
        BComponent existing;

        ShowExisting(BWidget bWidget, BComponent bComponent) {
            super(bWidget, MgrController.this.lex, "showExisting");
            this.existing = bComponent;
            this.setEnabled(bComponent != null);
        }

        public CommandArtifact doInvoke() throws Exception {
            BDialog.message((BWidget)this.getOwner(), (String)this.getLabel(), (Object)this.existing.toDisplayPathString(null));
            return null;
        }
    }

    class QuickMatch
    extends MgrCommand {
        QuickMatch(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "quickMatch");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doMatch(quickContext);
        }

        public Command doMerge(Command command) {
            return this;
        }
    }

    class Match
    extends MgrCommand {
        Match(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "match");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doMatch(null);
        }

        public Command doMerge(Command command) {
            return this;
        }
    }

    class QuickAdd
    extends MgrCommand {
        QuickAdd(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "quickAdd");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doAdd(quickContext);
        }

        public Command doMerge(Command command) {
            return this;
        }
    }

    class Add
    extends MgrCommand {
        Add(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "add");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doAdd(null);
        }

        public Command doMerge(Command command) {
            return this;
        }
    }

    class Edit
    extends MgrCommand {
        Edit(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "edit");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doEdit(MgrController.this.manager.getCurrentContext());
        }

        public Command doMerge(Command command) {
            return this;
        }
    }

    class New
    extends MgrCommand {
        New(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "new");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doNew(null);
        }

        public Command doMerge(Command command) {
            return this;
        }
    }

    class Cancel
    extends MgrCommand {
        Cancel(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "cancel");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doCancel(null);
        }
    }

    class Discover
    extends MgrCommand {
        Discover(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "discover");
        }

        public CommandArtifact doInvoke() throws Exception {
            return MgrController.this.doDiscover(null);
        }
    }

    class LearnMode
    extends MgrToggleCommand {
        LearnMode(BWidget bWidget) {
            super(bWidget, MgrController.this.lex, "learnMode");
        }

        public void setSelected(boolean bl) {
            super.setSelected(bl);
            MgrController.this.doLearnMode(bl);
        }
    }

    class MenuController
    implements BAbstractButton.MenuController {
        MenuController() {
        }

        public boolean isMenuDistinct() {
            return true;
        }

        public BMenu getMenu(BAbstractButton bAbstractButton) {
            IMgrCommand[] iMgrCommandArray = MgrController.this.getDropDownCommands((IMgrCommand)bAbstractButton.getCommand());
            BMenu bMenu = new BMenu();
            for (int i = 0; i < iMgrCommandArray.length; ++i) {
                bMenu.add(null, (Command)iMgrCommandArray[i]);
            }
            return bMenu;
        }
    }
}

