/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.workbench.fieldeditors.BStringFE;
import com.tridium.workbench.fieldeditors.BStringMgrColFE;
import javax.baja.data.BIDataValue;
import javax.baja.naming.SlotPath;
import javax.baja.sys.BBoolean;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BDynamicEnum;
import javax.baja.sys.BEnumRange;
import javax.baja.sys.BFacets;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BInteger;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;
import javax.baja.workbench.mgr.MgrTypeInfo;

public abstract class MgrColumn {
    public static final int EDITABLE = 1;
    public static final int UNSEEN = 2;
    public static final int READONLY = 4;
    BAbstractManager manager;
    String displayName;
    int flags;

    protected MgrColumn(String string) {
        this(string, 0);
    }

    protected MgrColumn(String string, int n) {
        this.displayName = string;
        this.flags = n;
    }

    void init(BAbstractManager bAbstractManager) {
        if (this.manager != null && this.manager != bAbstractManager) {
            throw new IllegalStateException("MgrColumns cannot shared between manager instances");
        }
        this.manager = bAbstractManager;
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public abstract Object get(Object var1);

    public Object toSortKey(Object object) {
        return this.get(object);
    }

    public String toDisplayString(Object object, Object object2, Context context) {
        if (object2 instanceof BObject) {
            return ((BObject)object2).toString(this.manager.getCurrentContext());
        }
        return String.valueOf(object2);
    }

    public TableCellRenderer getCellRenderer() {
        return null;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int n) {
        this.flags = n;
    }

    public boolean isEditable() {
        return (this.flags & 1) != 0;
    }

    public boolean isUnseen() {
        return (this.flags & 2) != 0;
    }

    public boolean isReadonly() {
        return (this.flags & 4) != 0;
    }

    public void setHidden() {
        this.flags = (this.flags | 2) & 0xFFFFFFFE;
    }

    public void setReadOnly() {
        this.flags |= 4;
    }

    public String toString() {
        return this.displayName + "[" + this.getClass().getName() + "]";
    }

    public BValue load(MgrEditRow mgrEditRow) throws Exception {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) throws Exception {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
        return null;
    }

    public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public static BWbFieldEditor toFieldEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor, Property[] propertyArray) {
        BWbFieldEditor bWbFieldEditor;
        BValue bValue = mgrEditRowArray[0].getCell(n);
        for (int i = 1; i < mgrEditRowArray.length; ++i) {
            if (mgrEditRowArray[i].getCell(n).getClass() == bValue.getClass()) continue;
            return null;
        }
        BFacets bFacets = mgrEditRowArray.length == 1 && propertyArray.length == 1 ? mgrEditRowArray[0].getTarget().getSlotFacets((Slot)propertyArray[0]) : propertyArray[propertyArray.length - 1].getFacets();
        Context context = mgrEditRowArray[0].getManager().getCurrentContext();
        if (!bFacets.isNull()) {
            context = new BasicContext(context, bFacets);
        }
        if ((bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue, context)) instanceof BStringFE) {
            bWbFieldEditor = new BStringMgrColFE(n);
        }
        if (bWbEditor != null && ((Object)((Object)bWbEditor)).getClass() == ((Object)((Object)bWbFieldEditor)).getClass()) {
            bWbFieldEditor = (BWbFieldEditor)bWbEditor;
        }
        bWbFieldEditor.loadValue((BObject)bValue, context);
        return bWbFieldEditor;
    }

    public static BWbFieldEditor toFieldEditor(javax.baja.sys.Type type, MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor, Property[] propertyArray) {
        BWbFieldEditor bWbFieldEditor;
        BValue bValue = mgrEditRowArray[0].getCell(n);
        for (int i = 1; i < mgrEditRowArray.length; ++i) {
            if (mgrEditRowArray[i].getCell(n).getClass() == bValue.getClass()) continue;
            return null;
        }
        BFacets bFacets = mgrEditRowArray.length == 1 && propertyArray.length == 1 ? ((BComponent)mgrEditRowArray[0].getTarget().getMixIn(type)).getSlotFacets((Slot)propertyArray[0]) : propertyArray[propertyArray.length - 1].getFacets();
        Context context = mgrEditRowArray[0].getManager().getCurrentContext();
        if (!bFacets.isNull()) {
            context = new BasicContext(context, bFacets);
        }
        if ((bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bValue, context)) instanceof BStringFE) {
            bWbFieldEditor = new BStringMgrColFE(n);
        }
        if (bWbEditor != null && ((Object)((Object)bWbEditor)).getClass() == ((Object)((Object)bWbFieldEditor)).getClass()) {
            bWbFieldEditor = (BWbFieldEditor)bWbEditor;
        }
        bWbFieldEditor.loadValue((BObject)bValue, context);
        return bWbFieldEditor;
    }

    public static void fromFieldEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor, Property[] propertyArray) throws Exception {
        BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
        BValue bValue = (BValue)bWbFieldEditor.saveValue();
        for (int i = 0; i < mgrEditRowArray.length; ++i) {
            mgrEditRowArray[i].setCell(n, bValue);
        }
    }

    public static class MixIn
    extends MgrColumn {
        javax.baja.sys.Type type;

        public MixIn(javax.baja.sys.Type type) {
            super(((BIMixIn)type.getInstance()).getDisplayNameInParent(null), 1);
            this.type = type;
        }

        public Object get(Object object) {
            BComponent bComponent = (BComponent)object;
            return bComponent.getMixIn(this.type);
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            return object2 == null ? "-" : object2.toString();
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BValue bValue = mgrEditRow.getTarget().getMixIn(this.type);
            if (bValue == null) {
                bValue = (BValue)this.type.getInstance();
            }
            return bValue;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            String string;
            BComponent bComponent = mgrEditRow.getTarget();
            Property property = bComponent.getProperty(string = this.type.toString().replace(':', '_'));
            if (property == null) {
                bComponent.add(string, bValue, context);
            } else {
                bComponent.set(property, bValue, context);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            BComponent bComponent;
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            if (bWbFieldEditor == null) {
                bWbFieldEditor = BWbFieldEditor.makeFor(this.type.getInstance());
            }
            BValue bValue = null;
            for (int i = 0; i < mgrEditRowArray.length && (bValue = (bComponent = mgrEditRowArray[i].getTarget()).getMixIn(this.type)) == null; ++i) {
            }
            if (bValue == null) {
                bValue = (BValue)this.type.getInstance();
            }
            bWbFieldEditor.loadValue((BObject)bValue.newCopy());
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BValue bValue = (BValue)bWbFieldEditor.saveValue();
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                mgrEditRowArray[i].setCell(n, bValue.newCopy());
            }
        }
    }

    public static class MixinProp
    extends PropPath {
        javax.baja.sys.Type mixinType;

        public MixinProp(javax.baja.sys.Type type, String string, Property property, int n) {
            this(type, string, new Property[]{property}, n);
        }

        public MixinProp(javax.baja.sys.Type type, String string, Property[] propertyArray, int n) {
            super(string, propertyArray, n);
            this.mixinType = type;
        }

        public MixinProp(javax.baja.sys.Type type, Property property, int n) {
            this(type, new Property[]{property}, n);
        }

        public MixinProp(javax.baja.sys.Type type, Property[] propertyArray, int n) {
            this(type, propertyArray[propertyArray.length - 1].getDefaultDisplayName(null), propertyArray, n);
        }

        public MixinProp(javax.baja.sys.Type type, Property property) {
            this(type, new Property[]{property});
        }

        public MixinProp(javax.baja.sys.Type type, Property[] propertyArray) {
            this(type, propertyArray, 0);
        }

        protected BComplex getRowBase(Object object) {
            BComponent bComponent = (BComponent)object;
            return (BComplex)bComponent.getMixIn(this.mixinType);
        }

        protected BComplex getTargetBase(MgrEditRow mgrEditRow) {
            BComponent bComponent = mgrEditRow.getTarget();
            BComplex bComplex = (BComplex)bComponent.getMixIn(this.mixinType);
            if (bComplex == null) {
                bComplex = (BComplex)this.mixinType.getInstance();
                bComponent.add(this.mixinType.toString().replace(':', '_'), (BValue)bComplex);
            }
            return bComplex;
        }
    }

    public static class PropPath
    extends MgrColumn {
        Property[] props;

        public PropPath(String string, Property[] propertyArray, int n) {
            super(string, n);
            this.props = propertyArray;
        }

        public PropPath(Property[] propertyArray, int n) {
            this(propertyArray[propertyArray.length - 1].getDefaultDisplayName(null), propertyArray, n);
        }

        public PropPath(Property[] propertyArray) {
            this(propertyArray, 0);
        }

        protected BComplex getRowBase(Object object) {
            return (BComplex)object;
        }

        public Object get(Object object) {
            BComplex bComplex = this.getRowBase(object);
            for (int i = 0; i < this.props.length - 1; ++i) {
                bComplex = (BComplex)bComplex.get(this.props[i]);
            }
            Property property = this.props[this.props.length - 1];
            return bComplex.get(property);
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            BComplex bComplex = this.getRowBase(object);
            for (int i = 0; i < this.props.length - 1; ++i) {
                bComplex = (BComplex)bComplex.get(this.props[i]);
            }
            Property property = this.props[this.props.length - 1];
            BFacets bFacets = bComplex.getSlotFacets((Slot)property);
            if (!bFacets.isNull()) {
                context = new BasicContext(context, bFacets);
            }
            return ((BObject)object2).toString(context);
        }

        protected BComplex getTargetBase(MgrEditRow mgrEditRow) {
            return mgrEditRow.getTarget();
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BComplex bComplex = this.getTargetBase(mgrEditRow);
            for (int i = 0; i < this.props.length; ++i) {
                bComplex = bComplex.get(this.props[i]);
            }
            return bComplex.newCopy();
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComplex bComplex = this.getTargetBase(mgrEditRow);
            int n = this.props.length;
            for (int i = 0; i < n - 1; ++i) {
                bComplex = (BComplex)bComplex.get(this.props[i]);
            }
            Property property = this.props[n - 1];
            BValue bValue2 = bComplex.get(property);
            if (!bValue2.equivalent((Object)bValue)) {
                bComplex.set(property, bValue.newCopy(), context);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            return PropPath.toFieldEditor(mgrEditRowArray, n, bWbEditor, this.props);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            PropPath.fromFieldEditor(mgrEditRowArray, n, bWbEditor, this.props);
        }
    }

    public static class Prop
    extends MgrColumn {
        protected Property prop;
        protected Property[] props;

        public Prop(String string, Property property, int n) {
            super(string, n);
            this.prop = property;
            this.props = new Property[]{property};
        }

        public Prop(Property property, int n) {
            this(property.getDefaultDisplayName(null), property, n);
        }

        public Prop(Property property) {
            this(property, 0);
        }

        public Object get(Object object) {
            BComplex bComplex = (BComplex)object;
            return bComplex.get(this.prop);
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            BComplex bComplex = (BComplex)object;
            BFacets bFacets = bComplex.getSlotFacets((Slot)this.prop);
            if (!bFacets.isNull()) {
                context = new BasicContext(context, bFacets);
            }
            return ((BObject)object2).toString(context);
        }

        public BValue load(MgrEditRow mgrEditRow) {
            return mgrEditRow.getTarget().get(this.prop).newCopy();
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
            BComponent bComponent = mgrEditRow.getTarget();
            BValue bValue2 = bComponent.get(this.prop);
            if (!bValue2.equivalent((Object)bValue)) {
                bComponent.set(this.prop, bValue.newCopy(), context);
            }
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            return Prop.toFieldEditor(mgrEditRowArray, n, bWbEditor, this.props);
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            Prop.fromFieldEditor(mgrEditRowArray, n, bWbEditor, this.props);
        }
    }

    public static class ToString
    extends MgrColumn {
        public ToString(String string, int n) {
            super(string, n);
        }

        public Object get(Object object) {
            return ((BComponent)object).toString(null);
        }
    }

    public static class Path
    extends MgrColumn {
        public Path(int n) {
            super(UiLexicon.bajaui().getText("path"), n);
        }

        public Object get(Object object) {
            return ((BComponent)object).getSlotPath().toDisplayString();
        }
    }

    public static class Type
    extends MgrColumn {
        public Type() {
            super(UiLexicon.bajaui().getText("type"), 1);
        }

        public Type(int n) {
            super(UiLexicon.bajaui().getText("type"), n);
        }

        public Object get(Object object) {
            return this.getManager().getModel().toType((BComponent)object);
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            if (object2 instanceof BFacets) {
                BFacets bFacets = (BFacets)object2;
                return bFacets.getPickle().toString();
            }
            return String.valueOf(object2);
        }

        public BValue load(MgrEditRow mgrEditRow) {
            BComponent bComponent = mgrEditRow.getTarget();
            MgrTypeInfo mgrTypeInfo = bComponent != null ? this.getManager().getModel().toType(bComponent) : mgrEditRow.getAvailableTypes()[0];
            BFacets bFacets = BFacets.makePickle((BFacets)BFacets.make((String)"x", (BIDataValue)BBoolean.TRUE), (Object)mgrTypeInfo);
            return bFacets;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            int n2;
            String[] stringArray;
            MgrTypeInfo[] mgrTypeInfoArray = MgrEdit.getTypeIntersection(mgrEditRowArray);
            if (mgrTypeInfoArray.length == 0) {
                return null;
            }
            int n3 = 0;
            if (mgrEditRowArray.length > 0) {
                stringArray = mgrEditRowArray[0].getType();
                for (n2 = 0; n2 < mgrTypeInfoArray.length; ++n2) {
                    if (!stringArray.equals(mgrTypeInfoArray[n2])) continue;
                    n3 = n2;
                    break;
                }
            }
            stringArray = new String[mgrTypeInfoArray.length];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray[n2] = SlotPath.escape((String)mgrTypeInfoArray[n2].getDisplayName());
            }
            BDynamicEnum bDynamicEnum = BDynamicEnum.make((int)n3, (BEnumRange)BEnumRange.make((String[])stringArray));
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            if (bWbFieldEditor == null) {
                bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bDynamicEnum);
            }
            bWbFieldEditor.loadValue((BObject)bDynamicEnum);
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BDynamicEnum bDynamicEnum = (BDynamicEnum)bWbFieldEditor.saveValue();
            String string = bDynamicEnum.getDisplayTag(null);
            MgrTypeInfo[] mgrTypeInfoArray = MgrEdit.getTypeIntersection(mgrEditRowArray);
            for (int i = 0; i < mgrTypeInfoArray.length; ++i) {
                if (!mgrTypeInfoArray[i].getDisplayName().equals(string)) continue;
                for (int j = 0; j < mgrEditRowArray.length; ++j) {
                    mgrEditRowArray[j].setType(mgrTypeInfoArray[i]);
                }
                return;
            }
            throw new IllegalStateException();
        }
    }

    public static class Name
    extends MgrColumn {
        public Name() {
            super(UiLexicon.bajaui().getText("name"), 1);
        }

        public Name(int n) {
            super(UiLexicon.bajaui().getText("name"), n);
        }

        public Object get(Object object) {
            return ((BComponent)object).getDisplayName(null);
        }

        public String toDisplayString(Object object, Object object2, Context context) {
            try {
                return SlotPath.unescape((String)object2.toString());
            }
            catch (Exception exception) {
                return String.valueOf(object2);
            }
        }

        public BValue load(MgrEditRow mgrEditRow) {
            String string = mgrEditRow.getTarget().getName();
            if (string != null) {
                return BString.make((String)string);
            }
            return BString.DEFAULT;
        }

        public void save(MgrEditRow mgrEditRow, BValue bValue, Context context) {
        }

        public BWbEditor toEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) {
            if (mgrEditRowArray.length != 1) {
                return null;
            }
            BString bString = (BString)mgrEditRowArray[0].getCell(n);
            BString bString2 = BString.make((String)SlotPath.unescape((String)bString.toString()));
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            if (bWbFieldEditor == null) {
                bWbFieldEditor = BWbFieldEditor.makeFor((BObject)bString2);
            }
            BFacets bFacets = BFacets.make((String)"fieldWidth", (BIDataValue)BInteger.make((int)30));
            bWbFieldEditor.loadValue((BObject)bString2, (Context)bFacets);
            return bWbFieldEditor;
        }

        public void fromEditor(MgrEditRow[] mgrEditRowArray, int n, BWbEditor bWbEditor) throws Exception {
            BWbFieldEditor bWbFieldEditor = (BWbFieldEditor)bWbEditor;
            BString bString = (BString)bWbFieldEditor.saveValue();
            BString bString2 = BString.make((String)SlotPath.escape((String)bString.toString()));
            for (int i = 0; i < mgrEditRowArray.length; ++i) {
                mgrEditRowArray[i].setCell(n, (BValue)bString2);
                mgrEditRowArray[i].userDefinedName = bString2.toString();
            }
        }
    }
}

