/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.HashMap;
import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.gx.BBrush;
import javax.baja.gx.Graphics;
import javax.baja.naming.BOrd;
import javax.baja.naming.BatchResolve;
import javax.baja.nre.util.Array;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Flags;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.DynamicTableModel;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.component.table.ComponentTableController;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.component.table.ComponentTableSelection;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.folder.FolderModel;

public class BMgrTable
extends BComponentTable {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$mgr$BMgrTable == null ? (class$javax$baja$workbench$mgr$BMgrTable = BMgrTable.class$("javax.baja.workbench.mgr.BMgrTable")) : class$javax$baja$workbench$mgr$BMgrTable));
    BAbstractManager manager;
    MgrModel model;
    FolderModel folderModel;
    ComponentTableModel componentModel;
    DynamicTableModel dynamicModel;
    Type[] includes;
    HashMap subscription = new HashMap();
    static /* synthetic */ Class class$javax$baja$workbench$mgr$BMgrTable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BMgrTable() {
    }

    public BMgrTable(MgrModel mgrModel) {
        this.manager = mgrModel.getManager();
        this.model = mgrModel;
        this.componentModel = new Model();
        this.dynamicModel = new DynamicTableModel((TableModel)this.componentModel);
        this.folderModel = mgrModel instanceof FolderModel ? (FolderModel)mgrModel : null;
        this.setModel((TableModel)this.dynamicModel);
        this.setController(new Controller());
        this.setSelection(new Selection());
        this.setCellRenderer(new CellRenderer());
        this.columnsModified();
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrColumn columnIndexToMgrColumn(int n) {
        return this.model.cols[this.dynamicModel.toRootColumnIndex(n)];
    }

    protected final boolean include(BComponent bComponent) {
        for (int i = 0; i < this.includes.length; ++i) {
            if (!bComponent.getType().is(this.includes[i])) continue;
            return true;
        }
        return false;
    }

    public void reload() {
        BAbstractManager bAbstractManager = this.manager;
        this.setContainer(bAbstractManager.target);
        this.includes = this.model.getIncludeTypes();
        BComponent[] bComponentArray = this.resolve();
        this.subscribe(bComponentArray);
        Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BMgrTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent, bComponentArray.length);
        for (int i = 0; i < bComponentArray.length; ++i) {
            if (!this.model.accept(bComponentArray[i])) continue;
            array.add((Object)bComponentArray[i]);
        }
        bComponentArray = (BComponent[])array.trim();
        this.getSelection().deselectAll();
        this.componentModel.setRows(bComponentArray);
    }

    private BComponent[] resolve() {
        if (this.folderModel == null || !this.folderModel.isAllDescendants()) {
            return this.resolveFlat();
        }
        return this.resolveDeep();
    }

    private BComponent[] resolveFlat() {
        BComponent bComponent = this.manager.target;
        Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BMgrTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        SlotCursor slotCursor = bComponent.getProperties();
        while (slotCursor.nextComponent()) {
            Property property = slotCursor.property();
            BComponent bComponent2 = (BComponent)slotCursor.get();
            if (Flags.isHidden((BComplex)bComponent, (Slot)property) || !this.include(bComponent2)) continue;
            array.add((Object)bComponent2);
        }
        return (BComponent[])array.trim();
    }

    private BComponent[] resolveDeep() {
        BComponent bComponent = this.manager.target;
        String string = "bql:select slotPath from ";
        for (int i = 0; i < this.includes.length; ++i) {
            if (i > 0) {
                string = string + ", ";
            }
            string = string + this.includes[i];
        }
        BITable bITable = (BITable)BOrd.make((String)string).get((BObject)bComponent);
        BOrd[] bOrdArray = new BOrd[bITable.size()];
        Column column = bITable.getColumns().get(0);
        for (int i = 0; i < bOrdArray.length; ++i) {
            bOrdArray[i] = BOrd.make((String)bITable.get(i, column).toString());
        }
        return new BatchResolve(bOrdArray).resolve((BObject)bComponent).getTargetComponents();
    }

    private void subscribe(BComponent[] bComponentArray) {
        BAbstractManager bAbstractManager = this.manager;
        BComponent bComponent = bAbstractManager.target;
        Array array = new Array(class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BMgrTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent);
        if (this.subscription.get(bComponent) == null && bComponent != null) {
            array.add((Object)bComponent);
            this.subscription.put(bComponent, bComponent);
        }
        for (int i = 0; i < bComponentArray.length; ++i) {
            BComponent bComponent2 = (BComponent)bComponentArray[i].getParent();
            if (this.subscription.get(bComponent2) != null || bComponent2 == null) continue;
            array.add((Object)bComponent2);
            this.subscription.put(bComponent2, bComponent2);
        }
        if (array.size() == 0) {
            return;
        }
        BComponent[] bComponentArray2 = (BComponent[])array.trim();
        int n = this.model.getSubscribeDepth();
        bAbstractManager.registerForComponentEvents(bComponentArray2, n);
    }

    public void columnsModified() {
        int n;
        ComponentTableModel.Column[] columnArray = new MgrColumnWrapper[this.model.cols.length];
        for (n = 0; n < columnArray.length; ++n) {
            columnArray[n] = new MgrColumnWrapper(this.model.cols[n]);
        }
        this.componentModel.setColumns(columnArray);
        for (n = 0; n < columnArray.length; ++n) {
            this.dynamicModel.setShowColumn(n, !this.model.cols[n].isUnseen());
        }
        this.dynamicModel.columnsModified();
        this.sizeColumnsToFit();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        boolean bl = false;
        BValue bValue = null;
        switch (bComponentEvent.getId()) {
            case 1: {
                bValue = bComponentEvent.getValue();
                if (bValue == null || !(bValue instanceof BComponent) || this.manager.getLearn() != null && this.manager.getLearn().getJob() != null && !this.manager.getLearn().jobComplete && this.manager.getLearn().getJob() == bComponentEvent.getSourceComponent()) break;
                int n = this.model.getSubscribeDepth() - 1;
                WbViewEventWorker.getInstance().registerForComponentEventsLater(this.manager, bValue.asComponent(), n);
                bl = true;
                break;
            }
            case 0: 
            case 2: {
                bValue = bComponentEvent.getValue();
                if (bValue == null || !(bValue instanceof BComponent)) break;
                bl = true;
                break;
            }
            case 4: {
                bl = true;
            }
        }
        if (bl) {
            WbViewEventWorker.getInstance().reloadLater(this);
        }
        this.repaint();
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        this.dropActive = false;
        return this.getManager().getController().drop(this, transferContext);
    }

    CommandArtifact superDrop(TransferContext transferContext) throws Exception {
        return super.drop(transferContext);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Selection
    extends ComponentTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BMgrTable.this.manager.controller.updateCommands();
        }
    }

    class Controller
    extends ComponentTableController {
        Controller() {
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BMgrTable.this.getManager().getController().cellDoubleClicked(BMgrTable.this, bMouseEvent, n, n2);
        }

        public BMenu makePopup(ComponentTableSubject componentTableSubject) {
            BMenu bMenu = super.makePopup(componentTableSubject);
            return BMgrTable.this.getManager().getController().makePopup(BMgrTable.this, componentTableSubject, bMenu);
        }

        public BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            return BMgrTable.this.getManager().getController().makeOptionsMenu(BMgrTable.this, bMenu);
        }
    }

    public class CellRenderer
    extends ComponentTableCellRenderer {
        public BBrush getBackground(TableCellRenderer.Cell cell) {
            BComponent bComponent;
            if (BMgrTable.this.folderModel != null && (bComponent = BMgrTable.this.getComponentAt(cell.row)).getType().is(BMgrTable.this.folderModel.getFolderType())) {
                return Theme.table().getGridBrush();
            }
            return super.getBackground(cell);
        }

        public double getPreferredCellWidth(TableCellRenderer.Cell cell) {
            TableCellRenderer tableCellRenderer = BMgrTable.this.columnIndexToMgrColumn(cell.column).getCellRenderer();
            if (tableCellRenderer != null) {
                return tableCellRenderer.getPreferredCellWidth(cell);
            }
            return super.getPreferredCellWidth(cell);
        }

        public void paintCell(Graphics graphics, TableCellRenderer.Cell cell) {
            TableCellRenderer tableCellRenderer = BMgrTable.this.columnIndexToMgrColumn(cell.column).getCellRenderer();
            if (tableCellRenderer != null) {
                tableCellRenderer.paintCell(graphics, cell);
            } else {
                super.paintCell(graphics, cell);
            }
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                BComponent bComponent = this.getComponentTable().getComponentModel().getComponentAt(cell.row);
                MgrColumn mgrColumn = BMgrTable.this.columnIndexToMgrColumn(cell.column);
                return mgrColumn.toDisplayString(bComponent, cell.value, BMgrTable.this.manager.getCurrentContext());
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    class Model
    extends ComponentTableModel {
        Model() {
        }

        public synchronized void sortByColumn(int n, boolean bl) {
            MgrColumn mgrColumn = BMgrTable.this.model.cols[n];
            Object[] objectArray = this.getRows();
            Object[] objectArray2 = new Object[objectArray.length];
            for (int i = 0; i < objectArray2.length; ++i) {
                try {
                    objectArray2[i] = mgrColumn.toSortKey(objectArray[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            SortUtil.sort((Object[])objectArray2, (Object[])objectArray, (boolean)bl);
            this.setRows((BComponent[])objectArray);
        }
    }

    static class MgrColumnWrapper
    implements ComponentTableModel.Column {
        MgrColumn mgrCol;

        MgrColumnWrapper(MgrColumn mgrColumn) {
            this.mgrCol = mgrColumn;
        }

        public String getName() {
            return this.mgrCol.getDisplayName();
        }

        public Object getValue(BComponent bComponent) {
            try {
                return this.mgrCol.get(bComponent);
            }
            catch (Exception exception) {
                return "";
            }
        }
    }
}

