/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.UiEnv;
import com.tridium.ui.awt.AwtShellManager;
import com.tridium.ui.theme.Theme;
import java.awt.event.KeyEvent;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.gx.IRectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BLink;
import javax.baja.sys.BValue;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BBorder;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BLabel;
import javax.baja.ui.BTextField;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BWidgetEvent;
import javax.baja.ui.event.BWindowEvent;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BScrollPane;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.Lexicon;
import javax.baja.workbench.BWbEditor;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrEdit;
import javax.baja.workbench.mgr.MgrEditRow;

public class BMgrEditDialog
extends BDialog {
    public static final Action editorModified = BMgrEditDialog.newAction((int)0, (BValue)new BWidgetEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$mgr$BMgrEditDialog == null ? (class$javax$baja$workbench$mgr$BMgrEditDialog = BMgrEditDialog.class$("javax.baja.workbench.mgr.BMgrEditDialog")) : class$javax$baja$workbench$mgr$BMgrEditDialog));
    static BImage objectIcon = BImage.make((String)"module://icons/x16/object.png");
    static BImage disabledIcon = objectIcon.getDisabledImage();
    static BImage highlightedIcon = objectIcon.getHighlightedImage();
    Lexicon lex = Lexicon.make((Class)(class$javax$baja$workbench$mgr$BMgrEditDialog == null ? (class$javax$baja$workbench$mgr$BMgrEditDialog = BMgrEditDialog.class$("javax.baja.workbench.mgr.BMgrEditDialog")) : class$javax$baja$workbench$mgr$BMgrEditDialog));
    String lexCannotEdit = this.lex.getText("mgr.cannotEdit");
    BAbstractManager manager;
    Command ok;
    Command cancel;
    MgrEdit edit;
    BTable table;
    BGridPane inputPane;
    ColumnInput[] inputs;
    MgrEditRow[] oldSelection;
    int result;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$BMgrEditDialog;

    public void editorModified(BWidgetEvent bWidgetEvent) {
        this.invoke(editorModified, (BValue)bWidgetEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BMgrEditDialog() {
        throw new IllegalStateException();
    }

    public BMgrEditDialog(MgrEdit mgrEdit, boolean bl) throws Exception {
        super((BWidget)mgrEdit.getManager(), mgrEdit.getTitle(), true);
        this.manager = mgrEdit.manager;
        this.edit = mgrEdit;
        this.table = new BTable((TableModel)mgrEdit, (TableController)new Controller());
        this.table.setSelection((TableSelection)new Selection());
        this.makeInputPane();
        this.ok = new Ok((BWidget)this);
        this.cancel = new Cancel((BWidget)this);
        BGridPane bGridPane = new BGridPane();
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setUniformColumnWidth(true);
        bGridPane.add(null, (BValue)new BButton(this.ok));
        bGridPane.add(null, (BValue)new BButton(this.cancel));
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.table, BBorder.inset, BInsets.make((double)0.0, (double)0.0, (double)0.0, (double)0.0)));
        bEdgePane.setBottom((BWidget)new BBorderPane((BWidget)this.inputPane, 10.0, 5.0, 5.0, 5.0));
        BScrollPane bScrollPane = new BScrollPane((BWidget)bEdgePane);
        bScrollPane.setViewportBackground(Theme.widget().getControlBackground());
        BEdgePane bEdgePane2 = new BEdgePane();
        bEdgePane2.setCenter((BWidget)new BBorderPane((BWidget)bScrollPane));
        bEdgePane2.setBottom((BWidget)new BBorderPane((BWidget)bGridPane, 0.0, 10.0, 10.0, 10.0));
        this.setContent((BWidget)bEdgePane2);
        this.setupKeyEvents();
        if (bl) {
            this.table.getSelection().selectAll();
        }
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrEdit getEdit() {
        return this.edit;
    }

    public int getResult() {
        return this.result;
    }

    public MgrEditRow[] getSelectedRows() {
        int[] nArray = this.table.getSelection().getRows();
        MgrEditRow[] mgrEditRowArray = new MgrEditRow[nArray.length];
        for (int i = 0; i < mgrEditRowArray.length; ++i) {
            mgrEditRowArray[i] = this.edit.getRow(nArray[i]);
        }
        return mgrEditRowArray;
    }

    private void makeInputPane() throws Exception {
        int n;
        MgrEditRow[] mgrEditRowArray = new MgrEditRow[]{this.edit.getRow(0)};
        MgrColumn[] mgrColumnArray = this.edit.getColumns();
        this.inputs = new ColumnInput[mgrColumnArray.length];
        for (n = 0; n < this.inputs.length; ++n) {
            this.inputs[n] = new ColumnInput(mgrColumnArray[n], n);
        }
        this.inputPane = new BGridPane(2);
        this.inputPane.setColumnGap(10.0);
        this.inputPane.setHalign(BHalign.left);
        for (n = 0; n < this.inputs.length; ++n) {
            ColumnInput columnInput = this.inputs[n];
            columnInput.installLabel();
            columnInput.installEditor(mgrColumnArray[n].toEditor(mgrEditRowArray, n, null), mgrEditRowArray);
        }
    }

    public boolean syncInputPane() {
        try {
            this.saveInputPane(this.oldSelection);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.isShowing()) {
                BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)"Cannot save to table", (Throwable)throwable);
            }
            return false;
        }
        MgrEditRow[] mgrEditRowArray = this.getSelectedRows();
        try {
            this.loadInputPane(mgrEditRowArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            if (this.isShowing()) {
                BDialog.error((BWidget)this, (String)"Cannot load from table", (Object)throwable);
            }
            return false;
        }
        this.oldSelection = mgrEditRowArray;
        this.table.repaint();
        return true;
    }

    protected void loadInputPane(MgrEditRow[] mgrEditRowArray) throws Exception {
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i].load(mgrEditRowArray);
        }
    }

    protected void saveInputPane(MgrEditRow[] mgrEditRowArray) throws Exception {
        if (mgrEditRowArray == null || mgrEditRowArray.length == 0) {
            return;
        }
        for (int i = 0; i < this.inputs.length; ++i) {
            this.inputs[i].save(mgrEditRowArray);
        }
        this.edit.validate(mgrEditRowArray);
    }

    public void doEditorModified(BWidgetEvent bWidgetEvent) {
        String string = bWidgetEvent.getWidget().getName();
        int n = Integer.parseInt(string.substring("editor".length()));
        this.inputs[n].modified(this.getSelectedRows());
    }

    void typeChanged() throws Exception {
        MgrEditRow[] mgrEditRowArray = this.getSelectedRows();
        for (int i = 0; i < this.inputs.length; ++i) {
            ColumnInput columnInput = this.inputs[i];
            if (columnInput.col instanceof MgrColumn.Type) continue;
            columnInput.load(mgrEditRowArray);
        }
    }

    public boolean checkNames() {
        MgrEditRow[] mgrEditRowArray = this.edit.getRows();
        for (int i = 0; i < mgrEditRowArray.length; ++i) {
            String string = mgrEditRowArray[i].getName();
            if (string == null || this.edit.isNameUnique(mgrEditRowArray[i], string)) continue;
            String string2 = this.lex.getText("mgr.duplicateName", new Object[]{string});
            BDialog.error((BWidget)this, (Object)string2);
            return false;
        }
        return true;
    }

    public void computePreferredSize() {
        super.computePreferredSize();
        double d = this.getPreferredWidth() + 20.0;
        double d2 = this.getPreferredHeight() + 20.0;
        IRectGeom iRectGeom = UiEnv.get().getScreenBounds((BWidget)this);
        double d3 = iRectGeom.width() - 50.0;
        double d4 = iRectGeom.height() - 50.0;
        if (d > d3) {
            d = d3;
        }
        if (d2 > d4) {
            d2 = d4;
        }
        this.setPreferredSize(d, d2);
    }

    public void handleEnter() {
        this.syncInputPane();
    }

    static boolean hasSelectionChanged(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return true;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return true;
        }
        return false;
    }

    private void setupKeyEvents() {
        AwtShellManager awtShellManager = (AwtShellManager)this.widgetSupport(null);
        awtShellManager.addKeyListener((java.awt.event.KeyListener)new KeyListener());
    }

    void updateTableSelection(KeyEvent keyEvent, int n) {
        BKeyEvent bKeyEvent = new BKeyEvent(401, (BWidget)this.table, keyEvent.getModifiers(), n, keyEvent.getKeyChar());
        this.table.getController().keyPressed(bKeyEvent);
        BWidget bWidget = this.getCurrentFocus();
        if (bWidget instanceof BTextField) {
            ((BTextField)bWidget).getSelection().selectAll();
        }
    }

    public void windowClosing(BWindowEvent bWindowEvent) {
        super.windowClosing(bWindowEvent);
        this.cancel.invoke();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Cancel
    extends Command {
        Cancel(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().getText("dialog.cancel"));
        }

        public CommandArtifact doInvoke() {
            BMgrEditDialog.this.result = 2;
            BMgrEditDialog.this.close();
            return null;
        }
    }

    class Ok
    extends Command {
        Ok(BWidget bWidget) {
            super(bWidget, UiLexicon.bajaui().getText("dialog.ok"));
        }

        public CommandArtifact doInvoke() {
            if (!BMgrEditDialog.this.syncInputPane()) {
                return null;
            }
            if (!BMgrEditDialog.this.checkNames()) {
                return null;
            }
            BMgrEditDialog.this.result = 1;
            BMgrEditDialog.this.close();
            return null;
        }
    }

    class KeyListener
    implements java.awt.event.KeyListener {
        KeyListener() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (BMgrEditDialog.this.getCurrentFocus() == BMgrEditDialog.this.table) {
                return;
            }
            if (keyEvent.isConsumed()) {
                return;
            }
            int n = keyEvent.getKeyCode();
            switch (n) {
                case 33: 
                case 34: 
                case 38: 
                case 40: {
                    BMgrEditDialog.this.updateTableSelection(keyEvent, n);
                    break;
                }
                case 10: {
                    if (keyEvent.isControlDown()) {
                        BMgrEditDialog.this.ok.invoke();
                        break;
                    }
                    BMgrEditDialog.this.updateTableSelection(keyEvent, 40);
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
        }

        public void keyTyped(KeyEvent keyEvent) {
        }
    }

    class Selection
    extends TableSelection {
        int[] oldSel = new int[0];

        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            int[] nArray = this.getRows();
            if (BMgrEditDialog.hasSelectionChanged(nArray, this.oldSel)) {
                this.oldSel = nArray;
                BMgrEditDialog.this.syncInputPane();
            }
        }
    }

    class Controller
    extends TableController {
        Controller() {
        }
    }

    class ColumnInput {
        MgrColumn col;
        int colIndex;
        String labelKey;
        String editorKey;
        BLabel label;
        BWbEditor editor;
        BLink linkFromEditor;

        ColumnInput(MgrColumn mgrColumn, int n) {
            this.col = mgrColumn;
            this.colIndex = n;
            this.labelKey = "label" + n;
            this.editorKey = "editor" + n;
            this.label = new BLabel(objectIcon, mgrColumn.getDisplayName());
            this.label.setFont(Theme.widget().getBoldText());
        }

        void installLabel() {
            BMgrEditDialog.this.inputPane.add(this.labelKey, (BValue)this.label);
        }

        void installEditor(BWbEditor bWbEditor, MgrEditRow[] mgrEditRowArray) {
            Property property;
            BWbEditor bWbEditor2;
            BWbEditor bWbEditor3 = this.editor;
            this.editor = bWbEditor;
            if (bWbEditor == null) {
                this.label.setImage(disabledIcon);
                this.label.setEnabled(false);
            } else {
                this.label.setImage(objectIcon);
                this.label.setEnabled(true);
            }
            this.label.repaint();
            if (bWbEditor != null) {
                bWbEditor2 = bWbEditor;
                bWbEditor.setReadonly(BMgrEditDialog.this.edit.isReadonly(mgrEditRowArray, this.col));
            } else if (bWbEditor3 != null) {
                bWbEditor2 = bWbEditor3;
                bWbEditor3.setReadonly(true);
            } else {
                bWbEditor2 = new BLabel(BMgrEditDialog.this.lexCannotEdit);
            }
            if (this.linkFromEditor != null) {
                BMgrEditDialog.this.remove((BComplex)this.linkFromEditor);
            }
            if (bWbEditor != null) {
                BMgrEditDialog.this.linkTo((BComponent)bWbEditor, (Slot)BWbEditor.pluginModified, (Slot)editorModified);
            }
            if ((property = BMgrEditDialog.this.inputPane.getProperty(this.editorKey)) == null) {
                BMgrEditDialog.this.inputPane.add(this.editorKey, (BValue)bWbEditor2);
            } else if (BMgrEditDialog.this.inputPane.get(property) != bWbEditor2) {
                BMgrEditDialog.this.inputPane.set(property, (BValue)bWbEditor2);
            }
        }

        void load(MgrEditRow[] mgrEditRowArray) throws Exception {
            if (mgrEditRowArray == null || mgrEditRowArray.length == 0) {
                this.installEditor(null, new MgrEditRow[0]);
            } else {
                this.installEditor(this.col.toEditor(mgrEditRowArray, this.colIndex, this.editor), mgrEditRowArray);
            }
        }

        void save(MgrEditRow[] mgrEditRowArray) throws Exception {
            if (this.editor != null && this.editor.isModified()) {
                this.col.fromEditor(mgrEditRowArray, this.colIndex, this.editor);
                if (this.col instanceof MgrColumn.Type) {
                    BMgrEditDialog.this.typeChanged();
                }
            }
        }

        void modified(MgrEditRow[] mgrEditRowArray) {
            BLabel bLabel = (BLabel)BMgrEditDialog.this.inputPane.get(this.labelKey);
            try {
                if (mgrEditRowArray != null && mgrEditRowArray.length > 0) {
                    this.save(mgrEditRowArray);
                    bLabel.setImage(objectIcon);
                    BMgrEditDialog.this.repaint();
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            bLabel.setImage(highlightedIcon);
            bLabel.repaint();
        }
    }
}

