/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableCellRenderer;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.TableSelection;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.ui.treetable.BTreeTable;
import javax.baja.ui.treetable.DynamicTreeTableModel;
import javax.baja.ui.treetable.TreeTableCellRenderer;
import javax.baja.ui.treetable.TreeTableController;
import javax.baja.ui.treetable.TreeTableModel;
import javax.baja.ui.treetable.TreeTableNode;
import javax.baja.ui.treetable.TreeTableSelection;
import javax.baja.ui.treetable.TreeTableSubject;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.mgr.BAbstractManager;
import javax.baja.workbench.mgr.MgrColumn;
import javax.baja.workbench.mgr.MgrLearn;

public class BLearnTable
extends BTreeTable {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$mgr$BLearnTable == null ? (class$javax$baja$workbench$mgr$BLearnTable = BLearnTable.class$("javax.baja.workbench.mgr.BLearnTable")) : class$javax$baja$workbench$mgr$BLearnTable));
    BAbstractManager manager;
    MgrColumn[] cols;
    MgrLearn learn;
    DynamicTreeTableModel dynamicModel;
    Model treeTableModel;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$BLearnTable;

    public Type getType() {
        return TYPE;
    }

    public BLearnTable() {
        throw new IllegalStateException();
    }

    public BLearnTable(MgrLearn mgrLearn) {
        this.manager = mgrLearn.getManager();
        this.learn = mgrLearn;
        this.treeTableModel = new Model();
        this.dynamicModel = new DynamicTreeTableModel((TreeTableModel)this.treeTableModel);
        this.updateColumns();
        this.setModel((TableModel)this.dynamicModel);
        this.setSelection((TableSelection)new Selection());
        this.setController((TableController)new Controller());
        this.setCellRenderer((TableCellRenderer)new Renderer());
    }

    public BAbstractManager getManager() {
        return this.manager;
    }

    public MgrColumn columnIndexToMgrColumn(int n) {
        return this.learn.cols[this.dynamicModel.toRootColumnIndex(n)];
    }

    public Object getObjectAt(int n) {
        Node node = (Node)this.treeTableModel.rowToNode(n);
        if (node != null) {
            return node.discovery;
        }
        return null;
    }

    public Object getSelectedObject() {
        int n = this.getSelection().getRow();
        if (n < 0) {
            return null;
        }
        return this.getObjectAt(n);
    }

    public Object[] getSelectedObjects() {
        int[] nArray = this.getSelection().getRows();
        Object[] objectArray = new Object[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            objectArray[i] = this.getObjectAt(nArray[i]);
        }
        return objectArray;
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        int[] nArray = this.getSelection().getRows();
        if (nArray.length == 0) {
            return;
        }
        int n = this.getRowAt(bMouseEvent.getY());
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        BImage[] bImageArray = new BImage[nArray.length];
        String[] stringArray = new String[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int n2 = nArray[i];
            Node node = (Node)this.treeTableModel.rowToNode(n2);
            bImageArray[i] = node.getIcon();
            stringArray[i] = "" + node.getValueAt(0);
        }
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(bImageArray, stringArray);
        simpleDragRenderer.font = Theme.table().getCellFont();
        String string = "dragFromLearn:" + this.getManager().hashCode();
        this.startDrag(bMouseEvent, TransferEnvelope.make((String)string), (DragRenderer)simpleDragRenderer);
    }

    void updateColumns() {
        this.cols = this.learn.getColumns();
        for (int i = 0; i < this.cols.length; ++i) {
            this.dynamicModel.setShowColumn(i, !this.cols[i].isUnseen());
        }
    }

    void resetIcons() {
        Node[] nodeArray = this.treeTableModel.roots;
        for (int i = 0; i < nodeArray.length; ++i) {
            this.resetIcons(nodeArray[i]);
        }
        this.repaint();
    }

    void resetIcons(Node node) {
        node.icon = null;
        if (node.children != null) {
            for (int i = 0; i < node.children.length; ++i) {
                this.resetIcons(node.children[i]);
            }
        }
    }

    static Node[] sort(Node[] nodeArray, int n, boolean bl) {
        Node[] nodeArray2 = (Node[])nodeArray.clone();
        Object[] objectArray = new Object[nodeArray2.length];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = nodeArray2[i].getValueAt(n);
        }
        SortUtil.sort((Object[])objectArray, (Object[])nodeArray2, (boolean)bl);
        return nodeArray2;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    class Node
    extends TreeTableNode {
        Object discovery;
        Node[] children;
        BImage icon;

        Node(Model model, Object object) {
            super((TreeTableModel)model);
            this.discovery = object;
        }

        Node(Node node, Object object) {
            super((TreeTableNode)node);
            this.discovery = object;
        }

        public Object getSubject() {
            return this.discovery;
        }

        public boolean isGroup() {
            return BLearnTable.this.learn.isGroup(this.discovery);
        }

        public boolean hasChildren() {
            return BLearnTable.this.learn.hasChildren(this.discovery);
        }

        public int getChildCount() {
            return this.getChildren().length;
        }

        public TreeTableNode getChild(int n) {
            return this.getChildren()[n];
        }

        TreeTableNode[] getChildren() {
            if (this.children == null) {
                Object[] objectArray = BLearnTable.this.learn.getChildren(this.discovery);
                Node[] nodeArray = new Node[objectArray.length];
                for (int i = 0; i < nodeArray.length; ++i) {
                    nodeArray[i] = new Node(this, objectArray[i]);
                }
                this.children = nodeArray;
            }
            return this.children;
        }

        public Object getValueAt(int n) {
            return BLearnTable.this.cols[n].get(this.discovery);
        }

        public BImage getIcon() {
            if (this.icon == null) {
                this.icon = BLearnTable.this.learn.getIcon(this.discovery);
                if (BLearnTable.this.learn.getExisting(this.discovery) != null && this.icon != null) {
                    this.icon = this.icon.getDisabledImage();
                }
            }
            return this.icon;
        }
    }

    class Renderer
    extends TreeTableCellRenderer {
        Renderer() {
        }

        public String getCellText(TableCellRenderer.Cell cell) {
            try {
                Object object = BLearnTable.this.getObjectAt(cell.row);
                MgrColumn mgrColumn = BLearnTable.this.columnIndexToMgrColumn(cell.column);
                return mgrColumn.toDisplayString(object, cell.value, BLearnTable.this.manager.getCurrentContext());
            }
            catch (Exception exception) {
                return "";
            }
        }
    }

    class Model
    extends TreeTableModel {
        Node[] roots = new Node[0];

        Model() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void updateTreeTable(boolean bl) {
            BWbShell bWbShell = BLearnTable.this.getManager().getWbShell();
            bWbShell.enterBusy();
            try {
                int n;
                Object[] objectArray = BLearnTable.this.learn.getRoots();
                Node[] nodeArray = new Node[objectArray.length];
                for (n = 0; n < nodeArray.length; ++n) {
                    Node node = this.discoveryToRoot(objectArray[n]);
                    if (node == null) {
                        node = new Node(this, objectArray[n]);
                    }
                    nodeArray[n] = node;
                }
                n = BLearnTable.this.dynamicModel.toRootColumnIndex(BLearnTable.this.getSortColumn());
                if (n >= 0) {
                    nodeArray = BLearnTable.sort(nodeArray, n, BLearnTable.this.isSortAscending());
                }
                this.roots = nodeArray;
                super.updateTreeTable(bl);
            }
            finally {
                bWbShell.exitBusy();
            }
        }

        public int getRootCount() {
            return this.roots.length;
        }

        public TreeTableNode getRoot(int n) {
            return this.roots[n];
        }

        public boolean isDepthExpandable(int n) {
            return BLearnTable.this.learn.isDepthExpandable(n);
        }

        public int getColumnCount() {
            return BLearnTable.this.cols.length;
        }

        public String getColumnName(int n) {
            return BLearnTable.this.cols[n].getDisplayName();
        }

        public boolean isColumnSortable(int n) {
            return true;
        }

        public void sortByColumn(int n, boolean bl) {
            this.getSelection().deselectAll();
            this.roots = BLearnTable.sort(this.roots, n, bl);
            super.updateTreeTable(false);
        }

        Node discoveryToRoot(Object object) {
            Node[] nodeArray = this.roots;
            for (int i = 0; i < nodeArray.length; ++i) {
                if (nodeArray[i].discovery != object) continue;
                return nodeArray[i];
            }
            return null;
        }
    }

    class Controller
    extends TreeTableController {
        Controller() {
        }

        public void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
            BLearnTable.this.getManager().getController().cellDoubleClicked(BLearnTable.this, bMouseEvent, n, n2);
        }

        protected BMenu makePopup(TreeTableSubject treeTableSubject) {
            BMenu bMenu = super.makePopup(treeTableSubject);
            return BLearnTable.this.manager.getController().makePopup(BLearnTable.this, treeTableSubject, bMenu);
        }

        public BMenu makeOptionsMenu() {
            BMenu bMenu = super.makeOptionsMenu();
            return BLearnTable.this.getManager().getController().makeOptionsMenu(BLearnTable.this, bMenu);
        }
    }

    class Selection
    extends TreeTableSelection {
        Selection() {
        }

        public void updateTable() {
            super.updateTable();
            BLearnTable.this.manager.controller.updateCommands();
        }
    }
}

