/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.mgr;

import com.tridium.workbench.util.WbViewEventWorker;
import javax.baja.job.BJob;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BMenu;
import javax.baja.ui.BToolBar;
import javax.baja.ui.BWidget;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BSplitPane;
import javax.baja.ui.table.BTable;
import javax.baja.util.Lexicon;
import javax.baja.workbench.mgr.MgrController;
import javax.baja.workbench.mgr.MgrLearn;
import javax.baja.workbench.mgr.MgrModel;
import javax.baja.workbench.mgr.MgrState;
import javax.baja.workbench.view.BIExportableTableView;
import javax.baja.workbench.view.BWbComponentView;

public abstract class BAbstractManager
extends BWbComponentView
implements BIExportableTableView {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$mgr$BAbstractManager == null ? (class$javax$baja$workbench$mgr$BAbstractManager = BAbstractManager.class$("javax.baja.workbench.mgr.BAbstractManager")) : class$javax$baja$workbench$mgr$BAbstractManager));
    Lexicon lex = Lexicon.make((Class)(class$javax$baja$workbench$mgr$BAbstractManager == null ? (class$javax$baja$workbench$mgr$BAbstractManager = BAbstractManager.class$("javax.baja.workbench.mgr.BAbstractManager")) : class$javax$baja$workbench$mgr$BAbstractManager));
    String lexDiscoveryObjects = this.lex.getText("discovery.objects");
    String lexDatabaseObjects = this.lex.getText("database.objects");
    boolean initialized;
    MgrModel model;
    MgrController controller;
    MgrLearn learn;
    BComponent target;
    BWidget tablePane;
    BWidget learnPane;
    static /* synthetic */ Class class$javax$baja$workbench$mgr$BAbstractManager;

    public Type getType() {
        return TYPE;
    }

    protected BAbstractManager() {
        this.autoRegisterForComponentEvents = false;
    }

    protected void init() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        this.model = this.makeModel();
        this.learn = this.makeLearn();
        this.controller = this.makeController();
        this.model.init();
        if (this.learn != null) {
            this.learn.init();
        }
        this.controller.init();
        this.tablePane = this.model.makePane();
        if (this.learn != null) {
            this.learnPane = this.learn.makePane();
            this.learnPane.setVisible(this.controller.learnMode.isSelected());
        }
        BWidget bWidget = this.controller.makeActionBar();
        BEdgePane bEdgePane = new BEdgePane();
        if (this.learnPane != null) {
            BSplitPane bSplitPane = new BSplitPane(BOrientation.vertical, 50.0);
            bSplitPane.setWidget1(this.learnPane);
            bSplitPane.setWidget2(this.tablePane);
            bEdgePane.setCenter((BWidget)bSplitPane);
        } else {
            bEdgePane.setCenter(this.tablePane);
        }
        if (bWidget != null && !bWidget.isNull()) {
            bEdgePane.setBottom((BWidget)new BBorderPane(bWidget, 5.0, 5.0, 0.0, 5.0));
        }
        this.setContent((BWidget)bEdgePane);
    }

    public final MgrModel getModel() {
        return this.model;
    }

    protected MgrModel makeModel() {
        return new MgrModel(this);
    }

    public final MgrController getController() {
        return this.controller;
    }

    protected MgrController makeController() {
        return new MgrController(this);
    }

    public final boolean isLearnable() {
        return this.learn != null;
    }

    public final MgrLearn getLearn() {
        return this.learn;
    }

    protected MgrLearn makeLearn() {
        return null;
    }

    public BToolBar getViewToolBar() {
        this.init();
        return this.controller.makeToolBar();
    }

    public BMenu[] getViewMenus() {
        this.init();
        return this.controller.makeMenus();
    }

    public BTable getExportTable() {
        return this.model.getTable();
    }

    public void doLoadValue(BObject bObject, Context context) {
        this.target = (BComponent)bObject;
        this.init();
        this.model.load(this.target);
        this.controller.load(this.target);
        if (this.learn != null) {
            this.learn.load(this.target);
        }
        try {
            this.restoreState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void deactivated() {
        super.deactivated();
        try {
            this.saveState();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void restoreState() {
        MgrState mgrState = MgrState.getCached(MgrState.toKey(this));
        if (mgrState != null) {
            mgrState.restore(this);
        }
    }

    public void saveState() {
        MgrState mgrState = this.makeState();
        if (mgrState != null) {
            mgrState.save(this);
            MgrState.cache(MgrState.toKey(this), mgrState);
        }
    }

    protected MgrState makeState() {
        return new MgrState();
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        super.handleComponentEvent(bComponentEvent);
        this.controller.updateCommands();
        if (this.learn != null) {
            BJob bJob;
            if (this.learn.getTable() != null) {
                this.learn.getTable().resetIcons();
            }
            if (this.learn.getJob() == bComponentEvent.getSourceComponent() && (bJob = (BJob)bComponentEvent.getSourceComponent()).getJobState().isComplete() && !this.learn.jobComplete) {
                this.learn.jobComplete = true;
                WbViewEventWorker.getInstance().invokeLater(new Runnable(){

                    public void run() {
                        if (BAbstractManager.this.isRegisteredForComponentEvents((BComponent)bJob)) {
                            BAbstractManager.this.registerForComponentEvents((BComponent)bJob, Integer.MAX_VALUE);
                        }
                        BAbstractManager.this.learn.jobComplete(bJob);
                    }
                });
            }
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

