/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.component.table;

import java.util.ArrayList;
import javax.baja.gx.BImage;
import javax.baja.nre.util.SortUtil;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIcon;
import javax.baja.sys.Property;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.util.UiLexicon;

public class ComponentTableModel
extends TableModel {
    ArrayList rows = new ArrayList();
    Column[] columns = new Column[0];

    public ComponentTableModel(Column[] columnArray) {
        this.columns = columnArray;
    }

    public ComponentTableModel() {
        this.columns = new Column[]{new DisplayNameColumn()};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BComponent getComponentAt(int n) {
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            return ((Row)this.rows.get((int)n)).component;
        }
    }

    public BComponent[] getRows() {
        int n = this.rows.size();
        BComponent[] bComponentArray = new BComponent[n];
        for (int i = 0; i < n; ++i) {
            bComponentArray[i] = this.getComponentAt(i);
        }
        return bComponentArray;
    }

    public int getRowByName(String string) {
        return this.getRowsByName(new String[]{string})[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getRowsByName(String[] stringArray) {
        int n;
        int[] nArray = new int[this.rows.size()];
        for (n = 0; n < nArray.length; ++n) {
            nArray[n] = -1;
        }
        n = 0;
        Object object = this;
        synchronized (object) {
            block4: for (int i = 0; i < this.rows.size(); ++i) {
                BComponent bComponent = ((Row)this.rows.get((int)i)).component;
                for (int j = 0; j < stringArray.length; ++j) {
                    if (!bComponent.getName().equals(stringArray[j])) continue;
                    nArray[n++] = i;
                    continue block4;
                }
            }
        }
        object = new int[n];
        System.arraycopy(nArray, 0, object, 0, n);
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRow(BComponent bComponent) {
        boolean bl = this.rows.size() == 0;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.rows.add(new Row(bComponent));
        }
        this.updateTable(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addRows(BComponent[] bComponentArray) {
        boolean bl = this.rows.size() == 0;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            for (int i = 0; i < bComponentArray.length; ++i) {
                this.rows.add(new Row(bComponentArray[i]));
            }
        }
        this.updateTable(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRow(String string) {
        boolean bl = false;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            for (int i = 0; i < this.rows.size(); ++i) {
                Row row = (Row)this.rows.get(i);
                if (!row.name.equals(string)) continue;
                this.rows.remove(i);
                bl = true;
                break;
            }
        }
        if (bl) {
            this.updateTable();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeRow(BComponent bComponent) {
        boolean bl = false;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            for (int i = 0; i < this.rows.size(); ++i) {
                Row row = (Row)this.rows.get(i);
                if (row.component != bComponent) continue;
                this.rows.remove(i);
                bl = true;
                break;
            }
        }
        if (bl) {
            this.updateTable();
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllRows() {
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.rows = new ArrayList();
        }
        this.updateTable();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRows(BComponent[] bComponentArray) {
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.rows = new ArrayList(Math.max(bComponentArray.length * 2, 10));
            for (int i = 0; i < bComponentArray.length; ++i) {
                this.rows.add(new Row(bComponentArray[i]));
            }
        }
        this.updateTable(true);
    }

    public synchronized boolean renameRow(String string, String string2) {
        boolean bl = false;
        for (int i = 0; i < this.rows.size(); ++i) {
            Row row = (Row)this.rows.get(i);
            if (!row.name.equals(string)) continue;
            row.name = string2;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setColumns(Column[] columnArray) {
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            this.columns = columnArray;
        }
        this.updateTable();
    }

    public void reorderRows(int[] nArray) {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = this.rows;
        if (nArray.length != arrayList2.size()) {
            throw new IllegalArgumentException("invalid length");
        }
        for (int i = 0; i < nArray.length; ++i) {
            arrayList.add(arrayList2.get(nArray[i]));
        }
        this.rows = arrayList;
        this.updateTable();
    }

    public synchronized int getRowCount() {
        return this.rows.size();
    }

    public synchronized int getColumnCount() {
        try {
            return this.columns.length;
        }
        catch (NullPointerException nullPointerException) {
            return 0;
        }
    }

    public synchronized String getColumnName(int n) {
        return this.columns[n].getName();
    }

    public synchronized BImage getRowIcon(int n) {
        return ((Row)this.rows.get(n)).getIcon();
    }

    public Object getSubject(int n) {
        return this.getComponentAt(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getValueAt(int n, int n2) {
        BComponent bComponent = null;
        ComponentTableModel componentTableModel = this;
        synchronized (componentTableModel) {
            bComponent = ((Row)this.rows.get((int)n)).component;
        }
        return this.columns[n2].getValue(bComponent);
    }

    public boolean isColumnSortable(int n) {
        return true;
    }

    public synchronized void sortByColumn(int n, boolean bl) {
        Object[] objectArray = this.getColumnValues(n);
        Object[] objectArray2 = this.rows.toArray(new Row[this.rows.size()]);
        SortUtil.sort((Object[])objectArray, (Object[])objectArray2, (boolean)bl);
        this.rows = new ArrayList();
        for (int i = 0; i < objectArray2.length; ++i) {
            this.rows.add(objectArray2[i]);
        }
    }

    static class Row {
        String name;
        BImage icon;
        BComponent component;

        Row(BComponent bComponent) {
            this.component = bComponent;
            this.name = bComponent.getName();
            this.icon = BImage.make((BIcon)bComponent.getIcon());
        }

        BImage getIcon() {
            if (this.component.isPendingMove()) {
                return this.icon.getDisabledImage();
            }
            return this.icon;
        }
    }

    public static class PropertyColumn
    implements Column {
        protected String name;
        protected Property prop;

        public PropertyColumn(Property property) {
            this(property.getDefaultDisplayName(null), property);
        }

        public PropertyColumn(String string, Property property) {
            this.name = string;
            this.prop = property;
        }

        public String getName() {
            return this.name;
        }

        public Object getValue(BComponent bComponent) {
            return bComponent.get(this.prop);
        }
    }

    public static class DisplayNameColumn
    implements Column {
        String name = UiLexicon.bajaui().getText("name");

        public String getName() {
            return this.name;
        }

        public Object getValue(BComponent bComponent) {
            return bComponent.getDisplayName(null);
        }
    }

    public static interface Column {
        public String getName();

        public Object getValue(BComponent var1);
    }
}

