/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.component.table;

import com.tridium.workbench.commands.PasteSpecialCommand;
import javax.baja.naming.BOrd;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.ui.BMenu;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.BWidgetShell;
import javax.baja.ui.Command;
import javax.baja.ui.HyperlinkInfo;
import javax.baja.ui.Subject;
import javax.baja.ui.commands.CopyCommand;
import javax.baja.ui.commands.CutCommand;
import javax.baja.ui.commands.DeleteCommand;
import javax.baja.ui.commands.DuplicateCommand;
import javax.baja.ui.commands.PasteCommand;
import javax.baja.ui.commands.RenameCommand;
import javax.baja.ui.event.BInputEvent;
import javax.baja.ui.event.BKeyEvent;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.TableController;
import javax.baja.ui.table.TableSubject;
import javax.baja.ui.transfer.BTransferWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.commands.ComponentReorderCommand;
import javax.baja.workbench.component.table.BComponentTable;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.component.table.ComponentTableSubject;
import javax.baja.workbench.nav.menu.NavMenuUtil;

public class ComponentTableController
extends TableController {
    private boolean hyperlinkOnDoubleClick = true;

    public boolean isHyperlinkOnDoubleClick() {
        return this.hyperlinkOnDoubleClick;
    }

    public void setHyperlinkOnDoubleClick(boolean bl) {
        this.hyperlinkOnDoubleClick = bl;
    }

    protected void handleEnter(BKeyEvent bKeyEvent) {
        super.handleEnter(bKeyEvent);
        if (this.hyperlinkOnDoubleClick) {
            ComponentTableModel componentTableModel = ((BComponentTable)this.getTable()).getComponentModel();
            int n = this.getSelection().getRow();
            BComponent bComponent = componentTableModel.getComponentAt(n);
            BOrd bOrd = bComponent.getNavOrd();
            BWidgetShell bWidgetShell = this.getTable().getShell();
            if (bOrd != null && bWidgetShell instanceof BWbShell) {
                ((BWbShell)bWidgetShell).hyperlink(bOrd);
            }
        }
    }

    protected void cellDoubleClicked(BMouseEvent bMouseEvent, int n, int n2) {
        super.cellDoubleClicked(bMouseEvent, n, n2);
        if (this.hyperlinkOnDoubleClick) {
            ComponentTableModel componentTableModel = ((BComponentTable)this.getTable()).getComponentModel();
            BComponent bComponent = componentTableModel.getComponentAt(n);
            BOrd bOrd = bComponent.getNavOrd();
            BWidgetShell bWidgetShell = this.getTable().getShell();
            if (bOrd != null && bWidgetShell instanceof BWbShell) {
                ((BWbShell)bWidgetShell).hyperlink(new HyperlinkInfo(bOrd, (BInputEvent)bMouseEvent));
            }
        }
    }

    public final BMenu makePopup(TableSubject tableSubject) {
        return this.makePopup((ComponentTableSubject)tableSubject);
    }

    public BMenu makePopup(ComponentTableSubject componentTableSubject) {
        BComponentTable bComponentTable = (BComponentTable)this.getTable();
        BComponent bComponent = bComponentTable.getContainer();
        if (componentTableSubject.size() > 1) {
            return NavMenuUtil.makeMenu((BWidget)bComponentTable, (Subject)componentTableSubject);
        }
        BComponent bComponent2 = (BComponent)componentTableSubject.getActive();
        if (bComponent2 != null) {
            return NavMenuUtil.makeMenu((BWidget)bComponentTable, (BObject)bComponent2);
        }
        BMenu bMenu = new BMenu();
        bMenu.add("copy", (Command)new CopyCommand((BTransferWidget)bComponentTable));
        bMenu.add("cut", (Command)new CutCommand((BTransferWidget)bComponentTable));
        bMenu.add("paste", (Command)new PasteCommand((BTransferWidget)bComponentTable));
        bMenu.add("pasteSpecial", (Command)new PasteSpecialCommand((BTransferWidget)bComponentTable, bComponent));
        bMenu.add("duplicate", (Command)new DuplicateCommand((BTransferWidget)bComponentTable));
        bMenu.add("sep1", (BValue)new BSeparator());
        bMenu.add("delete", (Command)new DeleteCommand((BTransferWidget)bComponentTable));
        bMenu.add("sep2", (BValue)new BSeparator());
        bMenu.add("rename", (Command)new RenameCommand((BTransferWidget)bComponentTable));
        bMenu.add("reorder", (Command)new ComponentReorderCommand((BWidget)bComponentTable, bComponent));
        return bMenu;
    }
}

