/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.component.table;

import com.tridium.ui.theme.Theme;
import com.tridium.workbench.transfer.TransferUtil;
import com.tridium.workbench.util.WbViewEventWorker;
import java.util.ArrayList;
import javax.baja.space.Mark;
import javax.baja.sys.BComplex;
import javax.baja.sys.BComponent;
import javax.baja.sys.BComponentEvent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Flags;
import javax.baja.sys.Slot;
import javax.baja.sys.SlotCursor;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BWidget;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.ui.table.BTable;
import javax.baja.ui.table.TableModel;
import javax.baja.ui.table.WrapperTableModel;
import javax.baja.ui.transfer.DragRenderer;
import javax.baja.ui.transfer.SimpleDragRenderer;
import javax.baja.ui.transfer.TransferContext;
import javax.baja.ui.transfer.TransferEnvelope;
import javax.baja.workbench.component.table.ComponentTableCellRenderer;
import javax.baja.workbench.component.table.ComponentTableController;
import javax.baja.workbench.component.table.ComponentTableHeaderRenderer;
import javax.baja.workbench.component.table.ComponentTableModel;
import javax.baja.workbench.component.table.ComponentTableSelection;
import javax.baja.workbench.view.BWbComponentView;

public class BComponentTable
extends BTable
implements BWbComponentView.Attachable {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$component$table$BComponentTable == null ? (class$javax$baja$workbench$component$table$BComponentTable = BComponentTable.class$("javax.baja.workbench.component.table.BComponentTable")) : class$javax$baja$workbench$component$table$BComponentTable));
    BComponent container;
    BWbComponentView view;
    Class[] loadClasses = new Class[]{class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BComponentTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent};
    int loadDepth = 0;
    Context context;
    protected boolean dropActive;
    ComponentTableModel model;
    static /* synthetic */ Class class$javax$baja$workbench$component$table$BComponentTable;
    static /* synthetic */ Class class$javax$baja$sys$BComponent;

    public Type getType() {
        return TYPE;
    }

    public BComponentTable() {
        this(new ComponentTableModel(null));
    }

    public BComponentTable(ComponentTableModel.Column[] columnArray) {
        this(new ComponentTableModel(columnArray));
    }

    public BComponentTable(ComponentTableModel componentTableModel) {
        super((TableModel)componentTableModel);
        this.setController(new ComponentTableController());
        this.setHeaderRenderer(new ComponentTableHeaderRenderer());
        this.setCellRenderer(new ComponentTableCellRenderer());
        this.setSelection(new ComponentTableSelection());
        this.setCutEnabled(true);
        this.setCopyEnabled(true);
        this.setPasteEnabled(true);
        this.setPasteSpecialEnabled(true);
        this.setDuplicateEnabled(true);
        this.setDeleteEnabled(true);
        this.setRenameEnabled(true);
    }

    public void setModel(TableModel tableModel) {
        super.setModel(tableModel);
        while (tableModel instanceof WrapperTableModel) {
            tableModel = ((WrapperTableModel)tableModel).getRootModel();
        }
        this.model = (ComponentTableModel)tableModel;
    }

    public final ComponentTableModel getComponentModel() {
        return this.model;
    }

    public void attached(BWbComponentView bWbComponentView) {
        this.view = bWbComponentView;
    }

    public void detached(BWbComponentView bWbComponentView) {
        this.view = null;
    }

    public void handleComponentEvent(BComponentEvent bComponentEvent) {
        if (this.container == null) {
            return;
        }
        ComponentTableModel componentTableModel = this.getComponentModel();
        int n = bComponentEvent.getId();
        Object object = this.container.getHandle();
        Object object2 = bComponentEvent.getSourceComponent().getHandle();
        String string = bComponentEvent.getSlotName();
        if (object.equals(object2)) {
            switch (n) {
                case 1: {
                    this.container.loadSlots();
                    BValue bValue = this.container.get(string);
                    if (bValue == null || !bValue.isComponent()) break;
                    BComponent bComponent = bValue.asComponent();
                    if (!this.include(bComponent)) {
                        return;
                    }
                    WbViewEventWorker.getInstance().registerForComponentEventsLater(this.view, bComponent, Math.max(this.loadDepth - 1, 0));
                    componentTableModel.addRow(bComponent);
                    this.getSelection().deselectAll();
                    break;
                }
                case 2: {
                    if (!componentTableModel.removeRow(string)) break;
                    this.getSelection().deselectAll();
                    break;
                }
                case 3: {
                    String string2 = bComponentEvent.getValue().toString();
                    componentTableModel.renameRow(string2, string);
                    break;
                }
                case 4: {
                    this.handleReorder();
                }
            }
        }
        this.repaint();
    }

    private void handleReorder() {
        ComponentTableModel componentTableModel = this.getComponentModel();
        int[] nArray = new int[componentTableModel.getRowCount()];
        int n = 0;
        SlotCursor slotCursor = this.container.getProperties();
        while (slotCursor.nextComponent()) {
            int n2 = componentTableModel.getRowByName(slotCursor.property().getName());
            if (n2 == -1) continue;
            nArray[n++] = n2;
        }
        componentTableModel.reorderRows(nArray);
    }

    public BComponent getContainer() {
        return this.container;
    }

    public void setContainer(BComponent bComponent) {
        this.container = bComponent;
    }

    public Context getCurrentContext() {
        return this.context;
    }

    public final void load(BComponent bComponent, Context context) {
        this.load(bComponent, new Class[]{class$javax$baja$sys$BComponent == null ? (class$javax$baja$sys$BComponent = BComponentTable.class$("javax.baja.sys.BComponent")) : class$javax$baja$sys$BComponent}, context);
    }

    public final void load(BComponent bComponent, Class clazz, Context context) {
        this.load(bComponent, new Class[]{clazz}, 1, context);
    }

    public final void load(BComponent bComponent, Class[] classArray, Context context) {
        this.load(bComponent, classArray, 1, context);
    }

    public final void load(BComponent bComponent, Class clazz, int n, Context context) {
        this.load(bComponent, new Class[]{clazz}, n, context);
    }

    public void load(BComponent bComponent, Class[] classArray, int n, Context context) {
        Object object;
        if (this.view == null) {
            throw new IllegalStateException("Use BWbComponentEvent.addComponentEventListener() before calling load()");
        }
        this.setContainer(bComponent);
        this.loadClasses = classArray;
        this.loadDepth = n;
        this.context = context;
        this.view.registerForComponentEvents(bComponent, n);
        ArrayList<Object> arrayList = new ArrayList<Object>();
        bComponent.loadSlots();
        BComponent[] bComponentArray = bComponent.getChildComponents();
        for (int i = 0; i < bComponentArray.length; ++i) {
            object = bComponentArray[i];
            if (Flags.isHidden((BComplex)bComponent, (Slot)object.getPropertyInParent()) || !this.include((BComponent)object)) continue;
            object.loadSlots();
            arrayList.add(object);
        }
        BComponent[] bComponentArray2 = arrayList.toArray(new BComponent[arrayList.size()]);
        object = this.getComponentModel();
        ((ComponentTableModel)((Object)object)).setRows(bComponentArray2);
    }

    public void reload() {
        if (this.view == null) {
            throw new IllegalStateException("Must call load before calling reload.");
        }
        this.getSelection().deselectAll();
        this.view.unregisterForAllComponentEvents();
        this.load(this.container, this.loadClasses, this.loadDepth, this.context);
    }

    public BComponent getComponentAt(int n) {
        return this.getComponentModel().getComponentAt(n);
    }

    public BComponent getSelectedComponent() {
        int n = this.getSelection().getRow();
        if (n == -1) {
            return null;
        }
        return this.getComponentModel().getComponentAt(n);
    }

    public BComponent[] getSelectedComponents() {
        int[] nArray = this.getSelection().getRows();
        BComponent[] bComponentArray = new BComponent[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            bComponentArray[i] = this.getComponentModel().getComponentAt(nArray[i]);
        }
        return bComponentArray;
    }

    public Mark getSelectedComponentsAsMark() {
        BComponent[] bComponentArray = this.getSelectedComponents();
        if (bComponentArray.length == 0) {
            return null;
        }
        return new Mark((BObject[])bComponentArray);
    }

    public void selectByName(String string) {
        this.selectByName(new String[]{string});
    }

    public void selectByName(String[] stringArray) {
        ComponentTableModel componentTableModel = this.getComponentModel();
        int[] nArray = componentTableModel.getRowsByName(stringArray);
        this.getSelection().select(nArray);
        if (nArray.length > 0) {
            this.ensureRowIsVisible(nArray[nArray.length - 1]);
        }
    }

    public TransferEnvelope getTransferData() throws Exception {
        Mark mark = this.getSelectedComponentsAsMark();
        if (mark == null) {
            return null;
        }
        return TransferEnvelope.make((Mark)mark);
    }

    public CommandArtifact insertTransferData(TransferContext transferContext) throws Exception {
        return TransferUtil.insert((BWidget)this, transferContext, (BObject)this.container, null);
    }

    public CommandArtifact removeTransferData(TransferContext transferContext) throws Exception {
        return null;
    }

    public CommandArtifact doDelete() throws Exception {
        if (this.container == null) {
            return null;
        }
        BComponent[] bComponentArray = this.getSelectedComponents();
        if (bComponentArray.length == 0) {
            return null;
        }
        Mark mark = new Mark((BObject[])bComponentArray);
        return TransferUtil.delete((BWidget)this, mark);
    }

    public CommandArtifact doRename() throws Exception {
        if (this.container == null) {
            return null;
        }
        BComponent[] bComponentArray = this.getSelectedComponents();
        if (bComponentArray.length == 0) {
            return null;
        }
        Mark mark = new Mark((BObject[])bComponentArray);
        return TransferUtil.rename((BWidget)this, mark);
    }

    public void mouseDragStarted(BMouseEvent bMouseEvent) {
        int[] nArray = this.getSelection().getRows();
        BComponent[] bComponentArray = this.getSelectedComponents();
        if (bComponentArray.length == 0) {
            return;
        }
        int n = this.getRowAt(bMouseEvent.getY());
        boolean bl = false;
        for (int i = 0; i < nArray.length; ++i) {
            if (n != nArray[i]) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return;
        }
        SimpleDragRenderer simpleDragRenderer = new SimpleDragRenderer(bComponentArray);
        simpleDragRenderer.font = Theme.table().getCellFont();
        this.startDrag(bMouseEvent, TransferEnvelope.make((Mark)new Mark((BObject[])bComponentArray)), (DragRenderer)simpleDragRenderer);
    }

    public void dragEnter(TransferContext transferContext) {
        if (this.container == null) {
            return;
        }
        this.dropActive = true;
        this.repaint();
    }

    public int dragOver(TransferContext transferContext) {
        if (this.container == null) {
            return 0;
        }
        int n = 48;
        return n;
    }

    public void dragExit(TransferContext transferContext) {
        if (this.container == null) {
            return;
        }
        this.dropActive = false;
        this.repaint();
    }

    public CommandArtifact drop(TransferContext transferContext) throws Exception {
        if (this.container == null) {
            return null;
        }
        this.dropActive = false;
        this.repaint();
        return this.insertTransferData(transferContext);
    }

    protected boolean include(BComponent bComponent) {
        for (int i = 0; i < this.loadClasses.length; ++i) {
            if (!this.loadClasses[i].isInstance(bComponent)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

