/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.commands;

import com.tridium.ui.BOptionDialog;
import com.tridium.workbench.util.WbUtil;
import javax.baja.file.BFileSpace;
import javax.baja.file.BIFile;
import javax.baja.file.FilePath;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class FileRenameCommand
extends Command {
    final UiLexicon lex = UiLexicon.bajaui();
    final String lexTitle = this.lex.getText("commands.rename.label");
    BIFile[] files;
    String[] oldNames;
    String[] newNames;

    public FileRenameCommand(BWidget bWidget, BIFile[] bIFileArray, String[] stringArray) {
        super(bWidget, UiLexicon.bajaui().module, "commands.rename");
        if (stringArray != null) {
            if (bIFileArray.length != stringArray.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.files = bIFileArray;
        this.newNames = stringArray;
    }

    public FileRenameCommand(BWidget bWidget, BIFile[] bIFileArray) {
        this(bWidget, bIFileArray, null);
    }

    public FileRenameCommand(BWidget bWidget, BIFile bIFile, String string) {
        this(bWidget, new BIFile[]{bIFile}, new String[]{string});
    }

    public FileRenameCommand(BWidget bWidget, BIFile bIFile) {
        this(bWidget, new BIFile[]{bIFile}, null);
    }

    public CommandArtifact doInvoke() throws Exception {
        int n;
        BFileSpace bFileSpace = this.files[0].getFileSpace();
        int n2 = this.files.length;
        this.oldNames = new String[n2];
        for (n = 0; n < n2; ++n) {
            this.oldNames[n] = this.files[n].getFileName();
        }
        if (this.newNames == null) {
            if (this.files.length == 1) {
                this.promptSingle();
            } else {
                this.promptList();
            }
            if (this.newNames == null) {
                return null;
            }
        }
        for (n = 0; n < n2; ++n) {
            this.newNames[n] = this.newNames[n].trim();
            FilePath.verifyValidName((String)this.newNames[n]);
        }
        for (n = 0; n < n2; ++n) {
            FilePath filePath = this.files[n].getFilePath();
            FilePath filePath2 = new FilePath(this.newNames[n]);
            bFileSpace.move(filePath, filePath2);
        }
        return null;
    }

    void promptSingle() {
        String string = BOptionDialog.promptFileName((BWidget)this.getShell(), (String)this.getLabel(), (String)this.oldNames[0]);
        if (string == null) {
            return;
        }
        this.newNames = new String[]{string};
    }

    void promptList() {
        WbUtil.BatchReplace batchReplace = new WbUtil.BatchReplace(this.getOwner(), this.oldNames);
        this.newNames = batchReplace.prompt(this.lexTitle);
    }
}

