/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.commands;

import com.tridium.workbench.util.WbUtil;
import javax.baja.naming.SlotPath;
import javax.baja.sync.Transaction;
import javax.baja.sys.BComponent;
import javax.baja.sys.BIMixIn;
import javax.baja.sys.BIPropertyContainer;
import javax.baja.sys.BLink;
import javax.baja.sys.BObject;
import javax.baja.sys.BString;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Knob;
import javax.baja.sys.Property;
import javax.baja.sys.Slot;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.util.UiLexicon;

public class ComponentRenameCommand
extends Command {
    final UiLexicon lex;
    final String lexTitle;
    BIPropertyContainer[] components;
    Slot[] slots;
    String[] oldNames;
    String[] oldDisplay;
    String[] newNames;

    public ComponentRenameCommand(BWidget bWidget, BComponent bComponent) {
        this(bWidget, bComponent, (String)null);
    }

    public ComponentRenameCommand(BWidget bWidget, BComponent bComponent, String string) {
        this(bWidget, (BComponent)bComponent.getParent(), bComponent.getPropertyInParent(), string);
    }

    public ComponentRenameCommand(BWidget bWidget, BComponent bComponent, Property property) {
        this(bWidget, bComponent, property, null);
    }

    public ComponentRenameCommand(BWidget bWidget, BComponent bComponent, Property property, String string) {
        String[] stringArray;
        BIPropertyContainer[] bIPropertyContainerArray = new BIPropertyContainer[]{bComponent};
        Property[] propertyArray = new Property[]{property};
        if (string == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = string;
        }
        this(bWidget, bIPropertyContainerArray, propertyArray, stringArray);
    }

    public ComponentRenameCommand(BWidget bWidget, BComponent[] bComponentArray, Property[] propertyArray, String[] stringArray) {
        this(bWidget, (BIPropertyContainer[])bComponentArray, propertyArray, stringArray);
    }

    public ComponentRenameCommand(BWidget bWidget, BIPropertyContainer[] bIPropertyContainerArray, Property[] propertyArray, String[] stringArray) {
        super(bWidget, UiLexicon.bajaui().module, "commands.rename");
        this.lex = UiLexicon.bajaui();
        this.lexTitle = this.lex.getText("commands.rename.label");
        if (bIPropertyContainerArray.length != propertyArray.length) {
            throw new IllegalArgumentException();
        }
        if (stringArray != null) {
            if (bIPropertyContainerArray.length != stringArray.length) {
                throw new IllegalArgumentException();
            }
            for (int i = 0; i < stringArray.length; ++i) {
                if (stringArray[i] != null) continue;
                throw new IllegalArgumentException();
            }
        }
        this.components = bIPropertyContainerArray;
        this.slots = propertyArray;
        this.newNames = stringArray;
    }

    public CommandArtifact doInvoke() throws Exception {
        int n;
        int n2 = this.components.length;
        this.oldNames = new String[n2];
        this.oldDisplay = new String[n2];
        for (n = 0; n < n2; ++n) {
            String string;
            this.oldNames[n] = string = this.slots[n].getName();
            this.oldDisplay[n] = SlotPath.unescape((String)string);
            BValue bValue = this.components[n].get(string);
            if (!(bValue instanceof BIMixIn)) continue;
            BDialog.error((BWidget)this.getShell(), (String)this.getLabel(), (Object)UiLexicon.bajaui().getText("commands.rename.errorMixIn"));
            return null;
        }
        if (this.newNames == null) {
            if (this.components.length == 1) {
                this.promptSingle();
            } else {
                this.promptList();
            }
            if (this.newNames == null) {
                return null;
            }
            for (n = 0; n < n2; ++n) {
                this.newNames[n] = SlotPath.escape((String)this.newNames[n].trim());
            }
        }
        Artifact artifact = new Artifact();
        artifact.redo();
        return artifact;
    }

    void promptSingle() {
        String string = BDialog.prompt((BWidget)this.getShell(), (String)this.getLabel(), (String)this.oldDisplay[0], (int)40);
        if (string == null) {
            return;
        }
        this.newNames = new String[]{string};
    }

    void promptList() {
        WbUtil.BatchReplace batchReplace = new WbUtil.BatchReplace(this.getOwner(), this.oldDisplay);
        this.newNames = batchReplace.prompt(this.lexTitle);
    }

    static void fixLinks(BComponent bComponent, Property property, BString bString, Context context) {
        BLink[] bLinkArray = bComponent.getLinks((Slot)property);
        for (int i = 0; i < bLinkArray.length; ++i) {
            BLink bLink = bLinkArray[i];
            try {
                bLink.set(BLink.targetSlotName, (BValue)bString, context);
                continue;
            }
            catch (Exception exception) {
                System.out.println("ERROR: Cannot fix link: " + bLink);
                exception.printStackTrace();
            }
        }
        Knob[] knobArray = bComponent.getKnobs((Slot)property);
        block5: for (int i = 0; i < knobArray.length; ++i) {
            Knob knob = knobArray[i];
            try {
                BComponent bComponent2 = (BComponent)knob.getTargetOrd().get((BObject)bComponent);
                bComponent2.lease();
                Property property2 = bComponent2.getProperty(knob.getTargetSlotName());
                BLink[] bLinkArray2 = bComponent2.getLinks((Slot)property2);
                for (int j = 0; j < bLinkArray2.length; ++j) {
                    BLink bLink = bLinkArray2[j];
                    if (!ComponentRenameCommand.isMatch(knob, bLink)) continue;
                    bLink.set(BLink.sourceSlotName, (BValue)bString, context);
                    continue block5;
                }
                continue;
            }
            catch (Exception exception) {
                System.out.println("ERROR: Cannot fix knob: " + knob);
                exception.printStackTrace();
            }
        }
    }

    static boolean isMatch(Knob knob, BLink bLink) {
        return bLink.getSourceOrd().equals((Object)knob.getSourceOrd()) && bLink.getSourceSlotName().equals(knob.getSourceSlotName());
    }

    class Artifact
    implements CommandArtifact {
        Artifact() {
        }

        public void undo() throws Exception {
            this.rename(ComponentRenameCommand.this.newNames, ComponentRenameCommand.this.oldNames);
        }

        public void redo() throws Exception {
            this.rename(ComponentRenameCommand.this.oldNames, ComponentRenameCommand.this.newNames);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void rename(String[] stringArray, String[] stringArray2) throws Exception {
            ComponentRenameCommand.this.getShell().enterBusy();
            try {
                boolean bl = ComponentRenameCommand.this.components[0] instanceof BComponent;
                Context context = bl ? Transaction.start((BComponent)((BComponent)ComponentRenameCommand.this.components[0]), null) : null;
                for (int i = 0; i < ComponentRenameCommand.this.components.length; ++i) {
                    BIPropertyContainer bIPropertyContainer = ComponentRenameCommand.this.components[i];
                    String string = stringArray[i];
                    String string2 = stringArray2[i];
                    Property property = bIPropertyContainer.getProperty(string);
                    if (bIPropertyContainer instanceof BComponent) {
                        ComponentRenameCommand.fixLinks((BComponent)bIPropertyContainer, property, BString.make((String)string2), context);
                    }
                    bIPropertyContainer.rename(property, string2, context);
                }
                if (bl) {
                    Transaction.end((BComponent)((BComponent)ComponentRenameCommand.this.components[0]), (Context)context);
                }
            }
            finally {
                ComponentRenameCommand.this.getShell().exitBusy();
            }
        }
    }
}

