/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.celleditor;

import com.tridium.ui.theme.Theme;
import javax.baja.gx.BFont;
import javax.baja.gx.Graphics;
import javax.baja.gx.IGeom;
import javax.baja.gx.Point;
import javax.baja.gx.RectGeom;
import javax.baja.sys.Action;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Slot;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BWidget;
import javax.baja.ui.event.BMouseEvent;
import javax.baja.util.Lexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.celleditor.BWbCellEditor;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;

public abstract class BButtonCE
extends BWbCellEditor {
    public static final Action buttonMouseEvent = BButtonCE.newAction((int)0, (BValue)new BMouseEvent(), null);
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$celleditor$BButtonCE == null ? (class$javax$baja$workbench$celleditor$BButtonCE = BButtonCE.class$("javax.baja.workbench.celleditor.BButtonCE")) : class$javax$baja$workbench$celleditor$BButtonCE));
    private static Lexicon lexicon = Lexicon.make((String)"wbutil");
    private static BFont FONT = Theme.widget().getTextFont();
    private BButton button = new BButton();
    private boolean isPressed = false;
    private RectGeom textClip;
    static /* synthetic */ Class class$javax$baja$workbench$celleditor$BButtonCE;

    public void buttonMouseEvent(BMouseEvent bMouseEvent) {
        this.invoke(buttonMouseEvent, (BValue)bMouseEvent, null);
    }

    public Type getType() {
        return TYPE;
    }

    public BButtonCE() {
        this.add("btn", (BValue)this.button);
        this.linkTo("lk1", (BComponent)this.button, (Slot)BButton.mouseEvent, (Slot)buttonMouseEvent);
    }

    protected void doSetReadonly(boolean bl) {
        this.button.setEnabled(!bl);
        this.relayout();
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        return this.value;
    }

    public void paint(Graphics graphics) {
        this.paintBackground(graphics);
        this.paintButton(graphics);
        if (this.value != null) {
            this.drawString(graphics, this.value.toString());
        }
    }

    public void doLayout(BWidget[] bWidgetArray) {
        double d = this.getWidth();
        double d2 = this.getHeight();
        if (this.isReadonly()) {
            this.button.setBounds(0.0, 0.0, 0.0, 0.0);
            this.textClip = new RectGeom(0.0, 0.0, d - 1.0, d2);
        } else {
            this.button.setBounds(d - d2 - 2.0, 2.0, d2, d2 - 4.0);
            this.textClip = new RectGeom(0.0, 0.0, d - d2 - 5.0, d2);
        }
    }

    public final void mousePressed(BMouseEvent bMouseEvent) {
        this.requestFocus();
        this.cellSelected();
        if (this.button.isEnabled()) {
            if (bMouseEvent.isButton1Down()) {
                this.buttonPressed();
            } else if (bMouseEvent.isButton3Down()) {
                this.cellPopup(bMouseEvent);
            }
        }
    }

    public final void buttonPressed() {
        if (this.isReadonly()) {
            return;
        }
        try {
            BObject bObject = this.dialog();
            if (bObject != null) {
                this.value = bObject;
                this.setModified();
            }
        }
        catch (Exception exception) {
            BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)BButtonCE.text("buttonCE.dialogError"), (Throwable)exception);
        }
    }

    protected final void drawString(Graphics graphics, String string) {
        graphics.push();
        try {
            graphics.clip((IGeom)this.textClip);
            graphics.setBrush(Theme.widget().getTextBrush());
            graphics.setFont(FONT);
            graphics.drawString(string, 3.0, FONT.getAscent() + 3.0);
        }
        finally {
            graphics.pop();
        }
    }

    protected void paintButton(Graphics graphics) {
        if (this.isReadonly()) {
            return;
        }
        this.paintChild(graphics, (BWidget)this.button);
        double d = this.button.getX() + 3.0;
        double d2 = this.button.getY() + 7.0;
        if (this.isPressed) {
            Point point = new Point(1.0, 1.0);
            d += point.x;
            d2 += point.y;
        }
        if (this.button.getEnabled()) {
            graphics.setBrush(Theme.widget().getControlForeground());
        } else {
            graphics.setBrush(Theme.widget().getControlShadow());
        }
        for (int i = 0; i < 3; ++i) {
            graphics.fillRect(d + (double)(i * 4), d2, 2.0, 2.0);
        }
    }

    protected BObject dialog() throws Exception {
        return BWbFieldEditor.dialog(this, this.getPropertyName(), this.value, this.getCurrentContext());
    }

    public void doButtonMouseEvent(BMouseEvent bMouseEvent) {
        if (bMouseEvent.getId() == 501) {
            this.mousePressed(bMouseEvent);
            this.isPressed = true;
        } else if (bMouseEvent.getId() == 502) {
            this.isPressed = false;
        }
    }

    public static String text(String string) {
        return lexicon.getText(string);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

