/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.bql.table;

import javax.baja.collection.BICollection;
import javax.baja.collection.BITable;
import javax.baja.collection.ColumnList;
import javax.baja.gx.BImage;
import javax.baja.naming.BOrd;
import javax.baja.sys.BObject;
import javax.baja.sys.BajaRuntimeException;
import javax.baja.ui.table.TableModel;
import javax.baja.workbench.bql.table.BBqlTable;
import javax.baja.workbench.bql.table.BqlTableColumn;

public class BqlTableModel
extends TableModel {
    private BObject base;
    private BOrd prefix;
    private BOrd ord;
    private BITable resultTable;
    private ColumnList resultColumns;
    private String predicate;
    private String extent = "baja:Component";
    private BqlTableColumn[] columns;
    private BqlTableColumn.Status statusColumn;
    private BqlTableColumn.Icon iconColumn;
    private BqlTableColumn.Nav navColumn;
    private Object loadLock = new Object();
    private boolean loading = false;
    private boolean loaded = false;

    public BqlTableModel() {
        this.columns = new BqlTableColumn[0];
    }

    public BqlTableModel(BqlTableColumn[] bqlTableColumnArray) {
        this.setColumns(bqlTableColumnArray);
    }

    public BObject getBase() {
        return this.base;
    }

    public void setBase(BObject bObject) {
        this.setBase(bObject, (BOrd)null);
    }

    public void setBase(BObject bObject, BOrd bOrd) {
        this.base = bObject;
        this.prefix = bOrd;
    }

    public void setBase(BObject bObject, String string) {
        this.setBase(bObject, BOrd.make((String)string));
    }

    public String getExtent() {
        return this.extent;
    }

    public void setExtent(String string) {
        this.extent = string;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String string) {
        this.predicate = string;
    }

    public BOrd getOrd() {
        if (this.ord == null) {
            this.updateOrd();
        }
        return this.ord;
    }

    public BqlTableColumn.Status getStatusColumn() {
        return this.statusColumn;
    }

    public BqlTableColumn.Icon getIconColumn() {
        return this.iconColumn;
    }

    public BqlTableColumn.Nav getNavColumn() {
        return this.navColumn;
    }

    public void setColumns(BqlTableColumn[] bqlTableColumnArray) {
        this.columns = new BqlTableColumn[bqlTableColumnArray.length];
        System.arraycopy(bqlTableColumnArray, 0, this.columns, 0, bqlTableColumnArray.length);
        this.statusColumn = null;
        this.iconColumn = null;
        for (int i = 0; i < bqlTableColumnArray.length; ++i) {
            if (bqlTableColumnArray[i] instanceof BqlTableColumn.Status) {
                this.statusColumn = (BqlTableColumn.Status)bqlTableColumnArray[i];
                continue;
            }
            if (bqlTableColumnArray[i] instanceof BqlTableColumn.Icon) {
                this.iconColumn = (BqlTableColumn.Icon)bqlTableColumnArray[i];
                continue;
            }
            if (!(bqlTableColumnArray[i] instanceof BqlTableColumn.Nav)) continue;
            this.navColumn = (BqlTableColumn.Nav)bqlTableColumnArray[i];
        }
    }

    public int getBqlColumnCount() {
        return this.columns.length;
    }

    public BqlTableColumn getBqlColumn(int n) {
        return this.columns[n];
    }

    public int getRowCount() {
        if (!this.loaded) {
            return 0;
        }
        return this.resultTable.size();
    }

    public int getColumnCount() {
        if (this.columns == null) {
            return 0;
        }
        return this.columns.length;
    }

    public String getColumnName(int n) {
        return this.resultColumns.get(n).getDisplayName(null);
    }

    public Object getValueAt(int n, int n2) {
        return this.columns[n2].getValueAt(n);
    }

    public BImage getRowIcon(int n) {
        if (this.iconColumn == null) {
            return null;
        }
        return (BImage)this.iconColumn.getValueAt(n);
    }

    private BOrd updateOrd() {
        StringBuffer stringBuffer = new StringBuffer(128);
        stringBuffer.append("bql:select ");
        int n = this.columns.length;
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.columns[i].getProjection());
        }
        if (this.extent != null) {
            stringBuffer.append(" from ").append(this.extent);
        }
        if (this.predicate != null) {
            stringBuffer.append(" where ").append(this.predicate);
        }
        this.ord = BOrd.make((BOrd)this.prefix, (String)stringBuffer.toString());
        return this.ord;
    }

    private void reset() {
        this.resultTable = null;
        this.resultColumns = null;
        this.loaded = false;
        this.updateTable();
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        Object object = this.loadLock;
        synchronized (object) {
            if (this.loading) {
                return;
            }
            this.loading = true;
        }
        try {
            if (this.ord == null) {
                this.ord = this.updateOrd();
            }
            if (!((object = this.ord.resolve(this.base).get()) instanceof BICollection)) {
                throw new BajaRuntimeException("Ord does not resolve to a collection.");
            }
            this.resultTable = ((BICollection)object).toTable();
            this.resultColumns = this.resultTable.getColumns();
            int n = this.resultColumns.size();
            for (int i = 0; i < n; ++i) {
                this.columns[i].load(this.resultTable, this.resultColumns.get(i));
            }
            this.updateTable();
            Object object2 = this.loadLock;
            synchronized (object2) {
                this.loaded = true;
                this.loading = false;
            }
            this.notifyTable();
        }
        catch (RuntimeException runtimeException) {
            Object object3 = this.loadLock;
            synchronized (object3) {
                this.loaded = true;
                this.loading = false;
            }
            this.notifyTable();
            throw runtimeException;
        }
    }

    private void notifyTable() {
        BBqlTable bBqlTable = (BBqlTable)this.getTable();
        if (bBqlTable == null) {
            return;
        }
        bBqlTable.queryComplete();
    }
}

