/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench.bql.table;

import javax.baja.collection.BITable;
import javax.baja.collection.Column;
import javax.baja.gx.BImage;
import javax.baja.status.BStatus;
import javax.baja.sys.BIcon;
import javax.baja.sys.BSimple;

public class BqlTableColumn {
    public static final int HIDDEN = 1;
    public static final int UNSEEN = 2;
    public static final int UNESCAPE = 4;
    protected String name;
    protected String displayName;
    protected int flags = 0;
    protected BITable table;
    protected Column column;

    public BqlTableColumn(String string) {
        this(string, null, 0);
    }

    public BqlTableColumn(String string, String string2, int n) {
        this.name = string;
        this.displayName = string2;
        this.flags = n;
    }

    public void load(BITable bITable, Column column) {
        this.table = bITable;
        this.column = column;
    }

    public String getName() {
        return this.name;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public int getFlags() {
        return this.flags;
    }

    public String getProjection() {
        if (this.displayName == null || this.displayName.length() == 0) {
            return this.name;
        }
        return this.name + " as '" + this.displayName + "'";
    }

    public Object getValueAt(int n) {
        return this.table.get(n, this.column);
    }

    public static class Nav
    extends BqlTableColumn {
        public Nav() {
            this("ordInSession");
        }

        public Nav(String string) {
            super(string, null, 2);
        }

        public Nav(String string, String string2, int n) {
            super(string, string2, n);
        }
    }

    public static class Icon
    extends Simple {
        public Icon() {
            this("icon");
        }

        public Icon(String string) {
            super(string, null, 1, (BSimple)BIcon.DEFAULT);
        }

        public Icon(String string, String string2, int n) {
            super(string, string2, n, (BSimple)BIcon.DEFAULT);
        }

        public BSimple parse(String string) {
            BIcon bIcon = (BIcon)super.parse(string);
            return BImage.make((BIcon)bIcon);
        }
    }

    public static class Status
    extends Simple {
        public Status() {
            this("status");
        }

        public Status(int n) {
            this("status");
        }

        public Status(String string) {
            this(string, "%lexicon(workbench:bqlTable.status)%", 0);
        }

        public Status(String string, String string2, int n) {
            super(string, string2, n, (BSimple)BStatus.DEFAULT);
        }
    }

    public static class Simple
    extends BqlTableColumn {
        BSimple def;
        BSimple[] columnValues;

        public Simple(String string, BSimple bSimple) {
            super(string);
            this.def = bSimple;
        }

        public Simple(String string, String string2, int n, BSimple bSimple) {
            super(string, string2, n);
            this.def = bSimple;
        }

        public String getProjection() {
            if (this.displayName == null || this.displayName.length() == 0) {
                return this.name + ".encodeToString as '" + this.name + "'";
            }
            return this.name + ".encodeToString as '" + this.displayName + "'";
        }

        public void load(BITable bITable, Column column) {
            super.load(bITable, column);
            int n = bITable.size();
            this.columnValues = new BSimple[n];
            for (int i = 0; i < n; ++i) {
                this.columnValues[i] = this.parse(bITable.getString(i, column));
            }
        }

        protected BSimple parse(String string) {
            try {
                return (BSimple)this.def.decodeFromString(string);
            }
            catch (Exception exception) {
                return this.def;
            }
        }

        public Object getValueAt(int n) {
            return this.columnValues[n];
        }
    }
}

