/*
 * Decompiled with CFR 0.152.
 */
package javax.baja.workbench;

import com.tridium.ui.theme.custom.nss.StyleUtils;
import java.util.ArrayList;
import javax.baja.naming.BHost;
import javax.baja.naming.BISession;
import javax.baja.naming.BOrd;
import javax.baja.space.BSpace;
import javax.baja.sys.BComponent;
import javax.baja.sys.BFacets;
import javax.baja.sys.BObject;
import javax.baja.sys.BasicContext;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableException;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BLabel;
import javax.baja.ui.BWidget;
import javax.baja.ui.style.IStylable;
import javax.baja.ui.util.UiLexicon;
import javax.baja.util.BIValidator;
import javax.baja.util.BTypeSpec;
import javax.baja.util.CannotValidateException;
import javax.baja.workbench.BWbPlugin;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.fieldeditor.BWbFieldEditor;
import javax.baja.workbench.view.BWbComponentView;

public class BWbEditor
extends BWbPlugin {
    public static final Type TYPE = Sys.loadType((Class)(class$javax$baja$workbench$BWbEditor == null ? (class$javax$baja$workbench$BWbEditor = BWbEditor.class$("javax.baja.workbench.BWbEditor")) : class$javax$baja$workbench$BWbEditor));
    private BObject value;
    private Context context;
    private BIValidator[] validators = new BIValidator[0];
    private boolean readonly;
    private Throwable loadError;
    static /* synthetic */ Class class$javax$baja$workbench$BWbEditor;

    public Type getType() {
        return TYPE;
    }

    public final boolean isReadonly() {
        return this.readonly;
    }

    public final void setReadonly(boolean bl) {
        if (this.readonly == bl) {
            return;
        }
        this.readonly = bl;
        this.doSetReadonly(bl);
        if (bl) {
            StyleUtils.addStyleClass((IStylable)this, (String)"readonly");
        } else {
            StyleUtils.removeStyleClass((IStylable)this, (String)"readonly");
        }
    }

    protected void doSetReadonly(boolean bl) {
    }

    public final BObject getCurrentValue() {
        return this.value;
    }

    public final Context getCurrentContext() {
        return this.context;
    }

    public BHost getCurrentValueHost() {
        BObject bObject = this.getCurrentValue();
        BHost bHost = BOrd.toHost((BObject)bObject);
        if (bHost != null) {
            return bHost;
        }
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell != null && (bHost = BOrd.toHost((BObject)(bObject = bWbShell.getActiveOrdTarget().get()))) != null) {
            return bHost;
        }
        return null;
    }

    public BISession getCurrentValueSession() {
        BObject bObject = this.getCurrentValue();
        BISession bISession = BOrd.toSession((BObject)bObject);
        if (bISession != null) {
            return bISession;
        }
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell != null && (bISession = BOrd.toSession((BObject)(bObject = bWbShell.getActiveOrdTarget().get()))) != null) {
            return bISession;
        }
        return null;
    }

    public BSpace getCurrentValueSpace() {
        BObject bObject = this.getCurrentValue();
        BSpace bSpace = BOrd.toSpace((BObject)bObject);
        if (bSpace != null) {
            return bSpace;
        }
        BWbShell bWbShell = this.getWbShell();
        if (bWbShell != null) {
            bObject = bWbShell.getActiveOrdTarget().get();
            bSpace = BOrd.toSpace((BObject)bObject);
            if (bSpace != null) {
                return bSpace;
            }
        } else {
            System.out.println("drat!");
        }
        return null;
    }

    public Throwable getLoadError() {
        return this.loadError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void loadValue(BObject bObject, Context context) {
        Object object = this.monitor;
        synchronized (object) {
            this.loadError = null;
            BObject bObject2 = this.value;
            this.lockModifiedState();
            this.value = bObject;
            this.context = context;
            try {
                BWbComponentView bWbComponentView;
                if (bObject instanceof BComponent && this instanceof BWbComponentView && (bWbComponentView = (BWbComponentView)this).isAutoRegisterForComponentEvents()) {
                    bWbComponentView.registerForComponentEvents((BComponent)bObject);
                }
                this.loadValidators();
                this.doLoadValue(this.value, context);
            }
            catch (Throwable throwable) {
                this.loadError = throwable;
                throwable.printStackTrace();
                String string = UiLexicon.bajaui().getText("plugin.load.error");
                if (throwable instanceof LocalizableException) {
                    string = string + "\n" + ((LocalizableException)throwable).toString(null);
                }
                if (throwable instanceof LocalizableRuntimeException) {
                    string = string + "\n" + ((LocalizableRuntimeException)throwable).toString(null);
                }
                this.setContent((BWidget)new BLabel(string));
            }
            this.unlockModifiedState();
            this.modified = false;
        }
    }

    public final void loadValue(BObject bObject) {
        this.loadValue(bObject, null);
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final BObject saveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        Object object = this.monitor;
        synchronized (object) {
            if (!this.isModified()) {
                return bObject;
            }
            BObject bObject2 = null;
            try {
                bObject2 = this.doSaveValue(bObject, context);
                this.doValidation(bObject2, context);
            }
            catch (CannotValidateException cannotValidateException) {
                throw new CannotSaveException(cannotValidateException.getMessage(), cannotValidateException);
            }
            if (bObject != null && !bObject.isSimple() && bObject.getType() == bObject2.getType() && bObject != bObject2) {
                throw new IllegalStateException("Complex editors must support edit-by-ref semantics");
            }
            this.modified = false;
            this.value = bObject2;
            return this.value;
        }
    }

    public final BObject saveValue(Context context) throws CannotSaveException, Exception {
        return this.saveValue(this.value, context);
    }

    public final BObject saveValue() throws CannotSaveException, Exception {
        return this.saveValue(this.value, null);
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        return bObject;
    }

    private void loadValidators() {
        ArrayList<BObject> arrayList = new ArrayList<BObject>();
        if (this.context != null && this instanceof BWbFieldEditor) {
            String[] stringArray = this.context.getFacets().list();
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("validator")) continue;
                String string = this.context.getFacets().gets(stringArray[i], "");
                BObject bObject = null;
                try {
                    bObject = BTypeSpec.make((String)string).getInstance();
                }
                catch (Exception exception) {
                    throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "wbEditor.badValidatorSpec", new Object[]{stringArray[i], string}, (Throwable)exception);
                }
                if (!bObject.getType().is(BIValidator.TYPE)) {
                    throw new LocalizableRuntimeException(TYPE.getModule().getModuleName(), "wbEditor.badValidatorType", new Object[]{stringArray[i], string});
                }
                arrayList.add(bObject);
            }
        }
        this.validators = arrayList.toArray(new BIValidator[arrayList.size()]);
    }

    private void doValidation(BObject bObject, Context context) throws Exception {
        BFacets bFacets;
        BFacets bFacets2 = bFacets = this.context == null ? BFacets.NULL : this.context.getFacets();
        if (context != null) {
            bFacets = BFacets.make((BFacets)bFacets, (BFacets)context.getFacets());
        }
        BasicContext basicContext = new BasicContext(context, bFacets);
        for (int i = 0; i < this.validators.length; ++i) {
            this.validators[i].validate(bObject, (Context)basicContext);
        }
        if (this instanceof BWbFieldEditor && this instanceof BIValidator) {
            ((BIValidator)this).validate(bObject, (Context)basicContext);
        }
        if (bObject instanceof BIValidator) {
            ((BIValidator)bObject).validate(bObject, (Context)basicContext);
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

