/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.wizard.step;

import com.tridium.ui.Binder;
import com.tridium.ui.wizard.step.CannotCommitException;
import com.tridium.ui.wizard.step.ICommitLog;
import com.tridium.ui.wizard.step.IWidgetWizardView;
import com.tridium.ui.wizard.step.IWizardView;
import com.tridium.ui.wizard.step.StepArtifact;
import com.tridium.ui.wizard.step.StepModel;
import com.tridium.ui.wizard.step.WizardStep;
import com.tridium.workbench.shell.BErrorPanel;
import javax.baja.agent.AgentFilter;
import javax.baja.agent.AgentInfo;
import javax.baja.agent.AgentList;
import javax.baja.agent.BAbstractPxView;
import javax.baja.naming.BOrd;
import javax.baja.naming.OrdTarget;
import javax.baja.naming.ViewQuery;
import javax.baja.sys.BComponent;
import javax.baja.sys.BObject;
import javax.baja.sys.Context;
import javax.baja.sys.LocalizableRuntimeException;
import javax.baja.sys.Type;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BWidget;
import javax.baja.workbench.BWbShell;
import javax.baja.workbench.px.BWbPxView;
import javax.baja.workbench.view.BWbView;

public final class WbViewUiHandler
implements WizardStep.IUiHandler {
    private OrdTarget target;
    private static final AgentFilter viewFilter = AgentFilter.or((AgentFilter)AgentFilter.is((Type)BWbView.TYPE), (AgentFilter)AgentFilter.is((Type)BAbstractPxView.TYPE));
    public static final WizardStep.ICommit commit = new WbViewCommit();

    public WbViewUiHandler(OrdTarget ordTarget) {
        this.target = ordTarget;
    }

    public WbViewUiHandler(BOrd bOrd, BObject bObject) {
        this(bOrd.resolve(bObject));
    }

    public WbViewUiHandler(BComponent bComponent) {
        this(bComponent.getNavOrd().resolve());
    }

    public StepArtifact create(WizardStep wizardStep, StepModel stepModel, IWizardView iWizardView, Context context) {
        IWidgetWizardView iWidgetWizardView = (IWidgetWizardView)iWizardView;
        BWbView bWbView = null;
        try {
            BComponent bComponent = this.target.getComponent();
            bComponent.lease();
            AgentList agentList = bComponent.getAgents().filter(viewFilter);
            String string = null;
            ViewQuery viewQuery = this.target.getViewQuery();
            if (viewQuery != null) {
                string = viewQuery.getViewId();
            }
            AgentInfo agentInfo = null;
            agentInfo = string == null && agentList.size() > 0 ? agentList.getDefault() : agentList.get(string);
            BObject bObject = agentInfo.getInstance();
            if (bObject instanceof BWbView) {
                bWbView = (BWbView)bObject;
            } else if (bObject instanceof BAbstractPxView) {
                bWbView = new BWbPxView((BAbstractPxView)bObject);
            } else {
                throw new LocalizableRuntimeException("bajaui", "errorPanel.notWbView");
            }
            iWidgetWizardView.setWizardContent((BWidget)bWbView);
            bWbView.fw(401);
            bWbView.activated();
            bWbView.fw(403);
            bWbView.loadValue(this.target.get(), context);
            if (bWbView.getLoadError() != null) {
                throw bWbView.getLoadError();
            }
            bWbView.prime();
            Binder binder = (Binder)bWbView.fw(302);
            if (binder != null) {
                binder.start(this.target, context);
            }
        }
        catch (Throwable throwable) {
            BWbShell bWbShell = BWbShell.getWbShell(iWidgetWizardView.getOwner());
            if (bWbShell != null) {
                String string = throwable.getMessage();
                if (string == null) {
                    string = BDialog.TITLE_ERROR;
                }
                iWidgetWizardView.setWizardContent((BWidget)new BErrorPanel(bWbShell, string, this.target.getOrd(), throwable));
            }
            System.out.println("Error loading Workbench View in Wizard: " + this.target.getOrd() + "...");
            throwable.printStackTrace();
        }
        return new WbViewStepArtifact(wizardStep, this.target, bWbView);
    }

    public void detach(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        IWidgetWizardView iWidgetWizardView = (IWidgetWizardView)iWizardView;
        BWidget bWidget = iWidgetWizardView.getWizardContent();
        if (bWidget instanceof BWbView) {
            BWbView bWbView = (BWbView)bWidget;
            if (bWbView.fw(302) != null) {
                bWbView.fw(402);
            }
            bWbView.deactivated();
        }
        iWidgetWizardView.setWizardContent((BWidget)new BNullWidget());
    }

    public StepArtifact updateStepArtifact(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        return stepArtifact;
    }

    public boolean restoreFromNext(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        return false;
    }

    public boolean restoreFromBack(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, Context context) {
        return false;
    }

    public OrdTarget getTarget() {
        return this.target;
    }

    private static final class WbViewCommit
    implements WizardStep.ICommit {
        private WbViewCommit() {
        }

        public void commit(StepArtifact stepArtifact, StepModel stepModel, IWizardView iWizardView, ICommitLog iCommitLog, Context context) throws CannotCommitException {
            try {
                WbViewStepArtifact wbViewStepArtifact = (WbViewStepArtifact)stepArtifact;
                if (wbViewStepArtifact.getWbView() != null) {
                    wbViewStepArtifact.getWbView().saveValue();
                }
            }
            catch (Exception exception) {
                System.out.println("Error in saving WbViewCommit...");
                exception.printStackTrace();
                throw new CannotCommitException((Throwable)exception);
            }
        }
    }

    public static final class WbViewStepArtifact
    extends StepArtifact {
        private OrdTarget target;
        private BWbView wbView;

        private WbViewStepArtifact(WizardStep wizardStep, OrdTarget ordTarget, BWbView bWbView) {
            super(wizardStep);
            this.target = ordTarget;
            this.wbView = bWbView;
        }

        public BWbView getWbView() {
            return this.wbView;
        }

        public OrdTarget getTarget() {
            return this.target;
        }
    }
}

