/*
 * Decompiled with CFR 0.152.
 */
package com.tridium.workbench.wizard;

import com.tridium.ui.wizard.step.BWizardButtonMode;
import javax.baja.gx.BImage;
import javax.baja.gx.BInsets;
import javax.baja.sys.BObject;
import javax.baja.sys.BValue;
import javax.baja.sys.Context;
import javax.baja.sys.Sys;
import javax.baja.sys.Type;
import javax.baja.ui.BButton;
import javax.baja.ui.BDialog;
import javax.baja.ui.BNullWidget;
import javax.baja.ui.BSeparator;
import javax.baja.ui.BWidget;
import javax.baja.ui.Command;
import javax.baja.ui.CommandArtifact;
import javax.baja.ui.enums.BHalign;
import javax.baja.ui.enums.BOrientation;
import javax.baja.ui.pane.BBorderPane;
import javax.baja.ui.pane.BEdgePane;
import javax.baja.ui.pane.BGridPane;
import javax.baja.ui.pane.BPane;
import javax.baja.ui.util.UiLexicon;
import javax.baja.workbench.CannotSaveException;
import javax.baja.workbench.view.BWbComponentView;

public class BWizardView
extends BWbComponentView {
    public static final Type TYPE = Sys.loadType((Class)(class$com$tridium$workbench$wizard$BWizardView == null ? (class$com$tridium$workbench$wizard$BWizardView = BWizardView.class$("com.tridium.workbench.wizard.BWizardView")) : class$com$tridium$workbench$wizard$BWizardView));
    private WizardViewModel model;
    protected BEdgePane content = new BEdgePane();
    protected BPane wizardContentPane;
    protected BPane buttonPaneFooter;
    protected BButton back;
    protected BButton next;
    protected BButton finish;
    protected BButton cancel;
    private BackCommand backCommand = new BackCommand();
    private NextCommand nextCommand = new NextCommand();
    private FinishCommand finishCommand = new FinishCommand();
    private CancelCommand cancelCommand = new CancelCommand();
    private static final UiLexicon uiLex = UiLexicon.bajaui();
    static /* synthetic */ Class class$com$tridium$workbench$wizard$BWizardView;

    public Type getType() {
        return TYPE;
    }

    public BWizardView() {
        this.wizardContentPane = this.makeWizardContentPane();
        this.content.setCenter((BWidget)this.wizardContentPane);
        this.buttonPaneFooter = this.makeButtonPaneFooter();
        this.content.setBottom((BWidget)this.buttonPaneFooter);
        this.setContent((BWidget)this.content);
    }

    public void init(WizardViewModel wizardViewModel) {
        this.model = wizardViewModel;
        if (this.model == null) {
            throw new NullPointerException("Wizard View Model can't be null!");
        }
        this.model.view = this;
        this.model.init();
    }

    protected void doLoadValue(BObject bObject, Context context) throws Exception {
        if (this.model == null) {
            this.init(this.makeViewModel());
        }
    }

    protected BObject doSaveValue(BObject bObject, Context context) throws CannotSaveException, Exception {
        return this.model.saveValue(bObject, context);
    }

    public void deactivated() {
        this.model.deactivated();
    }

    public void setWizardContent(BWidget bWidget) {
        this.wizardContentPane.set("content", (BValue)bWidget);
        this.relayout();
    }

    public BWidget getWizardContent() {
        return (BWidget)this.wizardContentPane.get("content");
    }

    public void setWizardHeader(BWidget bWidget) {
        this.content.setTop(bWidget);
        this.relayout();
    }

    public BWidget getWizardHeader() {
        return this.content.getTop();
    }

    public BWidget getWizardFooter() {
        return this.content.getBottom();
    }

    public void setWizardFooter(BWidget bWidget) {
        this.content.setBottom(bWidget);
    }

    public final Command getBackCommand() {
        return this.backCommand;
    }

    public void setBackVisible(boolean bl) {
        this.back.setVisible(bl);
        this.relayout();
    }

    public boolean isBackVisible() {
        return this.back.isVisible();
    }

    public void setBackEnabled(boolean bl) {
        this.back.setEnabled(bl);
    }

    public void setBackAsDefault() {
        this.setDefaultButton(this.back);
        this.back.requestFocus();
    }

    public final Command getNextCommand() {
        return this.nextCommand;
    }

    public void setNextVisible(boolean bl) {
        this.next.setVisible(bl);
        this.relayout();
    }

    public boolean isNextVisible() {
        return this.next.isVisible();
    }

    public void setNextEnabled(boolean bl) {
        this.next.setEnabled(bl);
    }

    public void setNextAsDefault() {
        this.setDefaultButton(this.next);
        this.next.requestFocus();
    }

    public final Command getCancelCommand() {
        return this.cancelCommand;
    }

    public void setCancelVisible(boolean bl) {
        this.cancel.setVisible(bl);
        this.relayout();
    }

    public boolean isCancelVisible() {
        return this.cancel.isVisible();
    }

    public void setCancelEnabled(boolean bl) {
        this.cancel.setEnabled(bl);
    }

    public void setCancelAsDefault() {
        this.setDefaultButton(this.cancel);
    }

    public final Command getFinishCommand() {
        return this.finishCommand;
    }

    public void setFinishVisible(boolean bl) {
        this.finish.setVisible(bl);
        this.relayout();
    }

    public boolean isFinishVisible() {
        return this.finish.isVisible();
    }

    public void setFinishEnabled(boolean bl) {
        this.finish.setEnabled(bl);
    }

    public void setFinishAsDefault() {
        this.setDefaultButton(this.finish);
        this.finish.requestFocus();
    }

    public void convertCancelToClose() {
        this.cancel.setText(UiLexicon.bajaui().get("commands.close.label"));
        this.cancel.setImage(BImage.make((String)UiLexicon.bajaui().get("commands.close.icon")));
        this.relayout();
    }

    public void setDefaultButton(BButton bButton) {
        this.getShell().setDefaultButton(bButton);
    }

    public void handleError(Throwable throwable) {
        BDialog.error((BWidget)this, (String)BDialog.TITLE_ERROR, (Object)throwable.getMessage(), (Throwable)throwable);
    }

    public final WizardViewModel getModel() {
        return this.model;
    }

    protected WizardViewModel makeViewModel() {
        return this.model;
    }

    protected BButton makeBackButton() {
        return new BButton((Command)this.backCommand);
    }

    protected BButton makeNextButton() {
        return new BButton((Command)this.nextCommand);
    }

    protected BButton makeCancelButton() {
        return new BButton((Command)this.cancelCommand);
    }

    protected BButton makeFinishButton() {
        return new BButton((Command)this.finishCommand);
    }

    protected BPane makeButtonPane() {
        BGridPane bGridPane = new BGridPane(4);
        bGridPane.setColumnAlign(BHalign.fill);
        bGridPane.setHalign(BHalign.right);
        this.back = this.makeBackButton();
        bGridPane.add("back", (BValue)this.back);
        this.next = this.makeNextButton();
        bGridPane.add("next", (BValue)this.next);
        this.finish = this.makeFinishButton();
        bGridPane.add("finish", (BValue)this.finish);
        this.cancel = this.makeCancelButton();
        bGridPane.add("cancel", (BValue)this.cancel);
        return bGridPane;
    }

    protected BPane makeButtonPaneFooter() {
        BEdgePane bEdgePane = new BEdgePane();
        bEdgePane.setTop((BWidget)new BSeparator(BOrientation.horizontal));
        bEdgePane.setCenter((BWidget)new BBorderPane((BWidget)this.makeButtonPane()));
        return bEdgePane;
    }

    protected BPane makeWizardContentPane() {
        return new BBorderPane((BWidget)new BNullWidget(), BInsets.DEFAULT);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public static abstract class WizardViewModel {
        private BWizardView view;

        public final BWizardView getView() {
            return this.view;
        }

        public abstract void init();

        public abstract BObject saveValue(BObject var1, Context var2) throws CannotSaveException, Exception;

        public abstract void deactivated();

        public abstract void back();

        public abstract void next();

        public abstract void finish();

        public abstract void cancel();

        public void update(BWizardButtonMode bWizardButtonMode) {
            this.view.setBackEnabled(bWizardButtonMode.canBack());
            this.view.setNextEnabled(bWizardButtonMode.canNext());
            this.view.setFinishEnabled(bWizardButtonMode.canFinish());
            this.view.setCancelEnabled(bWizardButtonMode.canCancel());
        }
    }

    private class CancelCommand
    extends Command {
        private CancelCommand() {
            super((BWidget)BWizardView.this, uiLex.module, "wizard.cancel");
        }

        public CommandArtifact doInvoke() {
            BWizardView.this.model.cancel();
            return null;
        }
    }

    private class FinishCommand
    extends Command {
        private FinishCommand() {
            super((BWidget)BWizardView.this, uiLex.module, "wizard.finish");
        }

        public CommandArtifact doInvoke() {
            BWizardView.this.model.finish();
            return null;
        }
    }

    private class NextCommand
    extends Command {
        private NextCommand() {
            super((BWidget)BWizardView.this, uiLex.module, "wizard.next");
        }

        public CommandArtifact doInvoke() {
            BWizardView.this.model.next();
            return null;
        }
    }

    private class BackCommand
    extends Command {
        private BackCommand() {
            super((BWidget)BWizardView.this, uiLex.module, "wizard.back");
        }

        public CommandArtifact doInvoke() {
            BWizardView.this.model.back();
            return null;
        }
    }
}

